/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;

public final class FileUtils {
    private static final FileAttribute<?>[] POSIX_TMP_DIR_PERMISSIONS = new FileAttribute[]{PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE))};

    private FileUtils() {
    }

    public static void recreateTempDirectoryIfNeeded(Path tmpDir) throws IOException {
        if (tmpDir.getFileSystem().supportedFileAttributeViews().contains("posix")) {
            Files.createDirectories(tmpDir, POSIX_TMP_DIR_PERMISSIONS);
        } else {
            Files.createDirectories(tmpDir, new FileAttribute[0]);
        }
    }
}

