/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.siv.org.bouncycastle.pqc.crypto.picnic;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import org.cryptomator.siv.org.bouncycastle.pqc.crypto.picnic.KMatrices;
import org.cryptomator.siv.org.bouncycastle.pqc.crypto.picnic.LowmcConstants;
import org.cryptomator.siv.org.bouncycastle.util.Exceptions;

public class LowmcConstantsL3
extends LowmcConstants {
    LowmcConstantsL3() {
        try {
            DataInputStream dataInputStream = new DataInputStream(new GZIPInputStream(LowmcConstants.class.getResourceAsStream("lowmcL3.bin.properties")));
            this.linearMatrices = LowmcConstantsL3.readArray(dataInputStream);
            this.roundConstants = LowmcConstantsL3.readArray(dataInputStream);
            this.keyMatrices = LowmcConstantsL3.readArray(dataInputStream);
            this.linearMatrices_full = LowmcConstantsL3.readArray(dataInputStream);
            this.keyMatrices_full = LowmcConstantsL3.readArray(dataInputStream);
            this.keyMatrices_inv = LowmcConstantsL3.readArray(dataInputStream);
            this.linearMatrices_inv = LowmcConstantsL3.readArray(dataInputStream);
            this.roundConstants_full = LowmcConstantsL3.readArray(dataInputStream);
        }
        catch (IOException iOException) {
            throw Exceptions.illegalStateException("unable to load Picnic properties: " + iOException.getMessage(), iOException);
        }
        this.LMatrix = new KMatrices(30, 192, 6, this.linearMatrices);
        this.KMatrix = new KMatrices(31, 192, 6, this.keyMatrices);
        this.RConstants = new KMatrices(30, 1, 6, this.roundConstants);
        this.LMatrix_full = new KMatrices(4, 192, 6, this.linearMatrices_full);
        this.LMatrix_inv = new KMatrices(4, 192, 6, this.linearMatrices_inv);
        this.KMatrix_full = new KMatrices(5, 192, 6, this.keyMatrices_full);
        this.KMatrix_inv = new KMatrices(1, 192, 6, this.keyMatrices_inv);
        this.RConstants_full = new KMatrices(4, 1, 6, this.roundConstants_full);
    }
}

