/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.NoopCircuitBreaker;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.aggregation.GroupingAggregator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.LuceneCountOperator;
import org.elasticsearch.compute.lucene.LuceneSourceOperator;
import org.elasticsearch.compute.lucene.LuceneTopNSourceOperator;
import org.elasticsearch.compute.lucene.TimeSeriesSortedSourceOperatorFactory;
import org.elasticsearch.compute.lucene.ValuesSourceReaderOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.compute.operator.OrdinalsGroupingOperator;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NestedLookup;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.search.NestedHelper;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.core.type.MultiTypeEsField;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.FieldExtractExec;
import org.elasticsearch.xpack.esql.planner.AbstractPhysicalOperationProviders;
import org.elasticsearch.xpack.esql.planner.Layout;
import org.elasticsearch.xpack.esql.planner.LocalExecutionPlanner;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public class EsPhysicalOperationProviders
extends AbstractPhysicalOperationProviders {
    private final List<ShardContext> shardContexts;

    public EsPhysicalOperationProviders(List<ShardContext> shardContexts) {
        this.shardContexts = shardContexts;
    }

    @Override
    public final LocalExecutionPlanner.PhysicalOperation fieldExtractPhysicalOperation(FieldExtractExec fieldExtractExec, LocalExecutionPlanner.PhysicalOperation source) {
        Layout.Builder layout = source.layout.builder();
        Attribute sourceAttr = fieldExtractExec.sourceAttribute();
        List<ValuesSourceReaderOperator.ShardContext> readers = this.shardContexts.stream().map(s -> new ValuesSourceReaderOperator.ShardContext(s.searcher().getIndexReader(), s::newSourceLoader)).toList();
        ArrayList<ValuesSourceReaderOperator.FieldInfo> fields = new ArrayList<ValuesSourceReaderOperator.FieldInfo>();
        int docChannel = source.layout.get(sourceAttr.id()).channel();
        Set<Attribute> docValuesAttrs = fieldExtractExec.docValuesAttributes();
        for (Attribute attr : fieldExtractExec.attributesToExtract()) {
            String string;
            layout.append((NamedExpression)attr);
            MultiTypeEsField unionTypes = this.findUnionTypes(attr);
            DataType dataType = attr.dataType();
            MappedFieldType.FieldExtractPreference fieldExtractPreference = PlannerUtils.extractPreference(docValuesAttrs.contains(attr));
            ElementType elementType = PlannerUtils.toElementType(dataType, fieldExtractPreference);
            if (attr instanceof FieldAttribute) {
                FieldAttribute fa = (FieldAttribute)attr;
                string = fa.fieldName();
            } else {
                string = attr.name();
            }
            String fieldName = string;
            boolean isUnsupported = dataType == DataType.UNSUPPORTED;
            IntFunction<BlockLoader> loader = s -> this.getBlockLoaderFor(s, fieldName, isUnsupported, fieldExtractPreference, unionTypes);
            fields.add(new ValuesSourceReaderOperator.FieldInfo(fieldName, elementType, loader));
        }
        return source.with((Operator.OperatorFactory)new ValuesSourceReaderOperator.Factory(fields, readers, docChannel), layout.build());
    }

    private BlockLoader getBlockLoaderFor(int shardId, String fieldName, boolean isUnsupported, MappedFieldType.FieldExtractPreference fieldExtractPreference, MultiTypeEsField unionTypes) {
        DefaultShardContext shardContext = (DefaultShardContext)this.shardContexts.get(shardId);
        BlockLoader blockLoader = shardContext.blockLoader(fieldName, isUnsupported, fieldExtractPreference);
        if (unionTypes != null) {
            String indexName = shardContext.ctx.index().getName();
            Expression conversion = unionTypes.getConversionExpressionForIndex(indexName);
            return conversion == null ? BlockLoader.CONSTANT_NULLS : new TypeConvertingBlockLoader(blockLoader, (AbstractConvertFunction)conversion);
        }
        return blockLoader;
    }

    private MultiTypeEsField findUnionTypes(Attribute attr) {
        FieldAttribute fa;
        EsField esField;
        if (attr instanceof FieldAttribute && (esField = (fa = (FieldAttribute)attr).field()) instanceof MultiTypeEsField) {
            MultiTypeEsField multiTypeEsField = (MultiTypeEsField)esField;
            return multiTypeEsField;
        }
        return null;
    }

    public Function<org.elasticsearch.compute.lucene.ShardContext, Query> querySupplier(QueryBuilder builder) {
        MatchAllQueryBuilder qb = builder == null ? QueryBuilders.matchAllQuery() : builder;
        return arg_0 -> this.lambda$querySupplier$2((QueryBuilder)qb, arg_0);
    }

    @Override
    public final LocalExecutionPlanner.PhysicalOperation sourcePhysicalOperation(EsQueryExec esQueryExec, LocalExecutionPlanner.LocalExecutionPlannerContext context) {
        Object luceneFactory;
        int limit;
        List<EsQueryExec.Sort> sorts = esQueryExec.sorts();
        assert (esQueryExec.estimatedRowSize() != null) : "estimated row size not initialized";
        int rowEstimatedSize = esQueryExec.estimatedRowSize();
        int n = limit = esQueryExec.limit() != null ? (Integer)esQueryExec.limit().fold() : Integer.MAX_VALUE;
        if (sorts != null && !sorts.isEmpty()) {
            ArrayList sortBuilders = new ArrayList(sorts.size());
            for (EsQueryExec.Sort sort : sorts) {
                sortBuilders.add(sort.sortBuilder());
            }
            luceneFactory = new LuceneTopNSourceOperator.Factory(this.shardContexts, this.querySupplier(esQueryExec.query()), context.queryPragmas().dataPartitioning(), context.queryPragmas().taskConcurrency(), context.pageSize(rowEstimatedSize), limit, sortBuilders);
        } else {
            luceneFactory = esQueryExec.indexMode() == IndexMode.TIME_SERIES ? TimeSeriesSortedSourceOperatorFactory.create((int)limit, (int)context.pageSize(rowEstimatedSize), (int)context.queryPragmas().taskConcurrency(), this.shardContexts, this.querySupplier(esQueryExec.query())) : new LuceneSourceOperator.Factory(this.shardContexts, this.querySupplier(esQueryExec.query()), context.queryPragmas().dataPartitioning(), context.queryPragmas().taskConcurrency(), context.pageSize(rowEstimatedSize), limit);
        }
        Layout.Builder layout = new Layout.Builder();
        layout.append(esQueryExec.output());
        int instanceCount = Math.max(1, luceneFactory.taskConcurrency());
        context.driverParallelism(new LocalExecutionPlanner.DriverParallelism(LocalExecutionPlanner.DriverParallelism.Type.DATA_PARALLELISM, instanceCount));
        return LocalExecutionPlanner.PhysicalOperation.fromSource((SourceOperator.SourceOperatorFactory)luceneFactory, layout.build());
    }

    public LuceneCountOperator.Factory countSource(LocalExecutionPlanner.LocalExecutionPlannerContext context, QueryBuilder queryBuilder, Expression limit) {
        return new LuceneCountOperator.Factory(this.shardContexts, this.querySupplier(queryBuilder), context.queryPragmas().dataPartitioning(), context.queryPragmas().taskConcurrency(), limit == null ? Integer.MAX_VALUE : (Integer)limit.fold());
    }

    @Override
    public final Operator.OperatorFactory ordinalGroupingOperatorFactory(LocalExecutionPlanner.PhysicalOperation source, AggregateExec aggregateExec, List<GroupingAggregator.Factory> aggregatorFactories, Attribute attrSource, ElementType groupElementType, LocalExecutionPlanner.LocalExecutionPlannerContext context) {
        String string;
        Attribute sourceAttribute = FieldExtractExec.extractSourceAttributesFrom(aggregateExec.child());
        int docChannel = source.layout.get(sourceAttribute.id()).channel();
        List<ValuesSourceReaderOperator.ShardContext> vsShardContexts = this.shardContexts.stream().map(s -> new ValuesSourceReaderOperator.ShardContext(s.searcher().getIndexReader(), s::newSourceLoader)).toList();
        boolean isUnsupported = attrSource.dataType() == DataType.UNSUPPORTED;
        MultiTypeEsField unionTypes = this.findUnionTypes(attrSource);
        if (attrSource instanceof FieldAttribute) {
            FieldAttribute fa = (FieldAttribute)attrSource;
            string = fa.fieldName();
        } else {
            string = attrSource.name();
        }
        String fieldName = string;
        return new OrdinalsGroupingOperator.OrdinalsGroupingOperatorFactory(shardIdx -> this.getBlockLoaderFor(shardIdx, fieldName, isUnsupported, MappedFieldType.FieldExtractPreference.NONE, unionTypes), vsShardContexts, groupElementType, docChannel, attrSource.name(), aggregatorFactories, context.pageSize(aggregateExec.estimatedRowSize()));
    }

    private /* synthetic */ Query lambda$querySupplier$2(QueryBuilder qb, org.elasticsearch.compute.lucene.ShardContext ctx) {
        return this.shardContexts.get(ctx.index()).toQuery(qb);
    }

    public static class DefaultShardContext
    implements ShardContext {
        private final int index;
        private final SearchExecutionContext ctx;
        private final AliasFilter aliasFilter;

        public DefaultShardContext(int index, SearchExecutionContext ctx, AliasFilter aliasFilter) {
            this.index = index;
            this.ctx = ctx;
            this.aliasFilter = aliasFilter;
        }

        public int index() {
            return this.index;
        }

        public IndexSearcher searcher() {
            return this.ctx.searcher();
        }

        public Optional<SortAndFormats> buildSort(List<SortBuilder<?>> sorts) throws IOException {
            return SortBuilder.buildSort(sorts, (SearchExecutionContext)this.ctx);
        }

        public String shardIdentifier() {
            return this.ctx.getFullyQualifiedIndex().getName() + ":" + this.ctx.getShardId();
        }

        @Override
        public SourceLoader newSourceLoader() {
            return this.ctx.newSourceLoader(false);
        }

        @Override
        public Query toQuery(QueryBuilder queryBuilder) {
            Query query = this.ctx.toQuery(queryBuilder).query();
            NestedLookup nestedLookup = this.ctx.nestedLookup();
            if (nestedLookup != NestedLookup.EMPTY) {
                NestedHelper nestedHelper = new NestedHelper(nestedLookup, arg_0 -> ((SearchExecutionContext)this.ctx).isFieldMapped(arg_0));
                if (nestedHelper.mightMatchNestedDocs(query)) {
                    query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add(Queries.newNonNestedFilter((IndexVersion)this.ctx.indexVersionCreated()), BooleanClause.Occur.FILTER).build();
                }
            }
            if (this.aliasFilter != AliasFilter.EMPTY) {
                Query filterQuery = this.ctx.toQuery(this.aliasFilter.getQueryBuilder()).query();
                query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add(filterQuery, BooleanClause.Occur.FILTER).build();
            }
            return query;
        }

        @Override
        public BlockLoader blockLoader(String name, boolean asUnsupportedSource, final MappedFieldType.FieldExtractPreference fieldExtractPreference) {
            if (asUnsupportedSource) {
                return BlockLoader.CONSTANT_NULLS;
            }
            MappedFieldType fieldType = this.ctx.getFieldType(name);
            if (fieldType == null) {
                return BlockLoader.CONSTANT_NULLS;
            }
            BlockLoader loader = fieldType.blockLoader(new MappedFieldType.BlockLoaderContext(){

                public String indexName() {
                    return ctx.getFullyQualifiedIndex().getName();
                }

                public IndexSettings indexSettings() {
                    return ctx.getIndexSettings();
                }

                public MappedFieldType.FieldExtractPreference fieldExtractPreference() {
                    return fieldExtractPreference;
                }

                public SearchLookup lookup() {
                    boolean syntheticSource = SourceFieldMapper.isSynthetic((IndexSettings)this.indexSettings());
                    SearchLookup searchLookup = ctx.lookup();
                    if (syntheticSource) {
                        searchLookup = searchLookup.swapSourceProvider(ctx.createSourceProvider());
                    }
                    return searchLookup;
                }

                public Set<String> sourcePaths(String name) {
                    return ctx.sourcePath(name);
                }

                public String parentField(String field) {
                    return ctx.parentPath(field);
                }

                public FieldNamesFieldMapper.FieldNamesFieldType fieldNames() {
                    return (FieldNamesFieldMapper.FieldNamesFieldType)ctx.lookup().fieldType("_field_names");
                }
            });
            if (loader == null) {
                HeaderWarning.addWarning((String)"Field [{}] cannot be retrieved, it is unsupported or not indexed; returning null", (Object[])new Object[]{name});
                return BlockLoader.CONSTANT_NULLS;
            }
            return loader;
        }
    }

    static class TypeConvertingBlockLoader
    implements BlockLoader {
        protected final BlockLoader delegate;
        private final EvalOperator.ExpressionEvaluator convertEvaluator;

        protected TypeConvertingBlockLoader(BlockLoader delegate, AbstractConvertFunction convertFunction) {
            this.delegate = delegate;
            DriverContext driverContext1 = new DriverContext(BigArrays.NON_RECYCLING_INSTANCE, new BlockFactory((CircuitBreaker)new NoopCircuitBreaker("request"), BigArrays.NON_RECYCLING_INSTANCE));
            this.convertEvaluator = convertFunction.toEvaluator(e -> driverContext -> new EvalOperator.ExpressionEvaluator(){

                public Block eval(Page page) {
                    return page.getBlock(0);
                }

                public void close() {
                }
            }).get(driverContext1);
        }

        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return this.delegate.builder(factory, expectedCount);
        }

        public BlockLoader.Block convert(BlockLoader.Block block) {
            Page page = new Page(new Block[]{(Block)block});
            return this.convertEvaluator.eval(page);
        }

        public BlockLoader.ColumnAtATimeReader columnAtATimeReader(LeafReaderContext context) throws IOException {
            final BlockLoader.ColumnAtATimeReader reader = this.delegate.columnAtATimeReader(context);
            if (reader == null) {
                return null;
            }
            return new BlockLoader.ColumnAtATimeReader(){

                public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs) throws IOException {
                    BlockLoader.Block block = reader.read(factory, docs);
                    Page page = new Page(new Block[]{(Block)block});
                    Block converted = convertEvaluator.eval(page);
                    return converted;
                }

                public boolean canReuse(int startingDocID) {
                    return reader.canReuse(startingDocID);
                }

                public String toString() {
                    return reader.toString();
                }
            };
        }

        public BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context) throws IOException {
            return this.delegate.rowStrideReader(context);
        }

        public StoredFieldsSpec rowStrideStoredFieldSpec() {
            return this.delegate.rowStrideStoredFieldSpec();
        }

        public boolean supportsOrdinals() {
            return false;
        }

        public SortedSetDocValues ordinals(LeafReaderContext context) {
            throw new IllegalArgumentException("Ordinals are not supported for type conversion");
        }

        public final String toString() {
            return "TypeConvertingBlockLoader[delegate=" + String.valueOf(this.delegate) + ", convertEvaluator=" + String.valueOf(this.convertEvaluator) + "]";
        }
    }

    public static interface ShardContext
    extends org.elasticsearch.compute.lucene.ShardContext {
        public SourceLoader newSourceLoader();

        public Query toQuery(QueryBuilder var1);

        public BlockLoader blockLoader(String var1, boolean var2, MappedFieldType.FieldExtractPreference var3);
    }
}

