/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.physical.LeafExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public class RowExec
extends LeafExec {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(PhysicalPlan.class, "RowExec", RowExec::new);
    private final List<Alias> fields;

    public RowExec(Source source, List<Alias> fields) {
        super(source);
        this.fields = fields;
    }

    private RowExec(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), in.readCollectionAsList(Alias::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeCollection(this.fields());
    }

    public String getWriteableName() {
        return RowExec.ENTRY.name;
    }

    public List<Alias> fields() {
        return this.fields;
    }

    @Override
    public List<Attribute> output() {
        return Expressions.asAttributes(this.fields);
    }

    protected NodeInfo<? extends PhysicalPlan> info() {
        return NodeInfo.create((Node)this, RowExec::new, this.fields);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        RowExec constant = (RowExec)((Object)o);
        return Objects.equals(this.fields, constant.fields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fields);
    }
}

