/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.core.capabilities.Unresolvable;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.plan.TableIdentifier;
import org.elasticsearch.xpack.esql.plan.logical.LeafPlan;

public class UnresolvedRelation
extends LeafPlan
implements Unresolvable {
    private final TableIdentifier table;
    private final boolean frozen;
    private final List<Attribute> metadataFields;
    private final IndexMode indexMode;
    private final String unresolvedMsg;
    private final String commandName;

    public UnresolvedRelation(Source source, TableIdentifier table, boolean frozen, List<Attribute> metadataFields, IndexMode indexMode, String unresolvedMessage, String commandName) {
        super(source);
        this.table = table;
        this.frozen = frozen;
        this.metadataFields = metadataFields;
        this.indexMode = indexMode;
        this.unresolvedMsg = unresolvedMessage == null ? "Unknown index [" + table.index() + "]" : unresolvedMessage;
        this.commandName = commandName;
    }

    public void writeTo(StreamOutput out) {
        throw new UnsupportedOperationException("not serialized");
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("not serialized");
    }

    protected NodeInfo<UnresolvedRelation> info() {
        return NodeInfo.create((Node)this, UnresolvedRelation::new, (Object)this.table, (Object)this.frozen, this.metadataFields, (Object)this.indexMode, (Object)this.unresolvedMsg, (Object)this.commandName);
    }

    public TableIdentifier table() {
        return this.table;
    }

    public boolean frozen() {
        return this.frozen;
    }

    @Override
    public boolean resolved() {
        return false;
    }

    @Override
    public String commandName() {
        return this.commandName;
    }

    @Override
    public boolean expressionsResolved() {
        return false;
    }

    @Override
    public List<Attribute> output() {
        return Collections.emptyList();
    }

    public List<Attribute> metadataFields() {
        return this.metadataFields;
    }

    public IndexMode indexMode() {
        return this.indexMode;
    }

    public String unresolvedMessage() {
        return this.unresolvedMsg;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.source(), this.table, this.metadataFields, this.indexMode, this.unresolvedMsg);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        UnresolvedRelation other = (UnresolvedRelation)((Object)obj);
        return Objects.equals(this.table, other.table) && Objects.equals(this.frozen, other.frozen) && Objects.equals(this.metadataFields, other.metadataFields) && this.indexMode == other.indexMode && Objects.equals(this.unresolvedMsg, other.unresolvedMsg);
    }

    public List<Object> nodeProperties() {
        return Collections.singletonList(this.table);
    }

    public String toString() {
        return "?" + this.table.index();
    }
}

