/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical.local;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.optimizer.LocalLogicalOptimizerContext;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.RegexExtract;
import org.elasticsearch.xpack.esql.plan.logical.TopN;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;
import org.elasticsearch.xpack.esql.rule.ParameterizedRule;
import org.elasticsearch.xpack.esql.stats.SearchStats;

public class ReplaceMissingFieldWithNull
extends ParameterizedRule<LogicalPlan, LogicalPlan, LocalLogicalOptimizerContext> {
    @Override
    public LogicalPlan apply(LogicalPlan plan, LocalLogicalOptimizerContext localLogicalOptimizerContext) {
        return (LogicalPlan)plan.transformUp(p -> this.missingToNull((LogicalPlan)((Object)p), localLogicalOptimizerContext.searchStats()));
    }

    /*
     * WARNING - void declaration
     */
    private LogicalPlan missingToNull(LogicalPlan plan, SearchStats stats) {
        if (plan instanceof EsRelation || plan instanceof LocalRelation) {
            return plan;
        }
        if (plan instanceof Aggregate) {
            Aggregate a = (Aggregate)plan;
            return a;
        }
        if (plan instanceof Project) {
            Project project = (Project)plan;
            List<? extends NamedExpression> projections = project.projections();
            ArrayList<void> newProjections = new ArrayList<void>(projections.size());
            LinkedHashMap nullLiteral = Maps.newLinkedHashMapWithExpectedSize((int)DataType.types().size());
            for (NamedExpression namedExpression : projections) {
                void var9_9;
                FieldAttribute f2;
                if (namedExpression instanceof FieldAttribute && !stats.exists((f2 = (FieldAttribute)namedExpression).fieldName())) {
                    DataType dt = f2.dataType();
                    Alias nullAlias = (Alias)nullLiteral.get(f2.dataType());
                    if (nullAlias == null) {
                        Alias alias = new Alias(f2.source(), f2.name(), (Expression)Literal.of((Expression)f2, null), f2.id());
                        nullLiteral.put(dt, alias);
                        Attribute attribute = alias.toAttribute();
                    } else {
                        Alias alias = new Alias(f2.source(), f2.name(), (Expression)nullAlias.toAttribute(), f2.id());
                    }
                }
                newProjections.add(var9_9);
            }
            if (nullLiteral.size() > 0) {
                plan = new Eval(project.source(), project.child(), new ArrayList<Alias>(nullLiteral.values()));
                plan = new Project(project.source(), plan, newProjections);
            }
        } else if (plan instanceof Eval || plan instanceof Filter || plan instanceof OrderBy || plan instanceof RegexExtract || plan instanceof TopN) {
            plan = (LogicalPlan)((Object)plan.transformExpressionsOnlyUp(FieldAttribute.class, f -> stats.exists(f.fieldName()) ? f : Literal.of((Expression)f, null)));
        }
        return plan;
    }
}

