/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.RegexExtract;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;

public final class PruneOrderByBeforeStats
extends OptimizerRules.OptimizerRule<Aggregate> {
    @Override
    protected LogicalPlan rule(Aggregate agg) {
        OrderBy order = PruneOrderByBeforeStats.findPullableOrderBy(agg.child());
        LogicalPlan p = agg;
        if (order != null) {
            p = (LogicalPlan)agg.transformDown(OrderBy.class, o -> o == order ? order.child() : o);
        }
        return p;
    }

    private static OrderBy findPullableOrderBy(LogicalPlan plan) {
        OrderBy pullable = null;
        if (plan instanceof OrderBy) {
            OrderBy o;
            pullable = o = (OrderBy)plan;
        } else if (plan instanceof Eval || plan instanceof Filter || plan instanceof Project || plan instanceof RegexExtract || plan instanceof Enrich) {
            pullable = PruneOrderByBeforeStats.findPullableOrderBy(((UnaryPlan)plan).child());
        }
        return pullable;
    }
}

