/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.join.InlineJoin;
import org.elasticsearch.xpack.esql.plan.logical.join.StubRelation;

public class PropagateInlineEvals
extends OptimizerRules.OptimizerRule<InlineJoin> {
    @Override
    protected LogicalPlan rule(InlineJoin plan) {
        LogicalPlan left = plan.left();
        LogicalPlan right = plan.right();
        ArrayList<Alias> groupingAlias = new ArrayList<Alias>();
        LinkedHashMap groupingRefs = new LinkedHashMap();
        right = (LogicalPlan)right.transformDown(p -> {
            if (p instanceof Aggregate) {
                Aggregate aggregate = (Aggregate)((Object)p);
                for (Expression g : aggregate.groupings()) {
                    if (!(g instanceof ReferenceAttribute)) continue;
                    ReferenceAttribute ref = (ReferenceAttribute)g;
                    groupingRefs.put(ref.name(), ref);
                }
            }
            if (p instanceof Eval) {
                Eval eval = (Eval)p;
                if (groupingRefs.size() > 0) {
                    List<Alias> fields = eval.fields();
                    ArrayList<Alias> remainingEvals = new ArrayList<Alias>(fields.size());
                    for (Alias f : fields) {
                        if (groupingRefs.remove(f.name()) != null) {
                            groupingAlias.add(f);
                            continue;
                        }
                        remainingEvals.add(f);
                    }
                    if (remainingEvals.size() != fields.size()) {
                        p = remainingEvals.size() == 0 ? eval.child() : new Eval(eval.source(), eval.child(), remainingEvals);
                    }
                }
            }
            return p;
        });
        if (groupingAlias.size() > 0) {
            left = new Eval(plan.source(), plan.left(), groupingAlias);
        }
        return plan.replaceChildren(left, InlineJoin.replaceStub(new StubRelation(right.source(), left.output()), right));
    }
}

