/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.util.function.Function;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.rule.Rule;

public final class PropagateEvalFoldables
extends Rule<LogicalPlan, LogicalPlan> {
    @Override
    public LogicalPlan apply(LogicalPlan plan) {
        AttributeMap collectRefs = new AttributeMap();
        Function<ReferenceAttribute, Expression> replaceReference = r -> (Expression)collectRefs.resolve(r, r);
        plan.forEachExpressionUp(Alias.class, a -> {
            Expression c = a.child();
            boolean shouldCollect = c.foldable();
            if (!shouldCollect) {
                c = (Expression)c.transformUp(ReferenceAttribute.class, replaceReference);
                shouldCollect = c.foldable();
            }
            if (shouldCollect) {
                collectRefs.put(a.toAttribute(), (Object)Literal.of((Expression)c));
            }
        });
        if (collectRefs.isEmpty()) {
            return plan;
        }
        plan = (LogicalPlan)plan.transformUp(p -> {
            if (p instanceof Filter || p instanceof Eval) {
                p = (LogicalPlan)((Object)((Object)p.transformExpressionsOnly(ReferenceAttribute.class, replaceReference)));
            }
            return p;
        });
        return plan;
    }
}

