/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.function.Function;
import org.elasticsearch.xpack.esql.core.expression.predicate.logical.Not;
import org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;

public final class BooleanFunctionEqualsElimination
extends OptimizerRules.OptimizerExpressionRule<BinaryComparison> {
    public BooleanFunctionEqualsElimination() {
        super(OptimizerRules.TransformDirection.UP);
    }

    @Override
    public Expression rule(BinaryComparison bc) {
        if ((bc instanceof Equals || bc instanceof NotEquals) && bc.left() instanceof Function) {
            if (Literal.TRUE.equals((Object)bc.right())) {
                return bc instanceof Equals ? bc.left() : new Not(bc.left().source(), bc.left());
            }
            if (Literal.FALSE.equals((Object)bc.right())) {
                return bc instanceof Equals ? new Not(bc.left().source(), bc.left()) : bc.left();
            }
        }
        return bc;
    }
}

