/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.util.ReflectionUtils;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.rule.ParameterizedRule;
import org.elasticsearch.xpack.esql.rule.Rule;

public class PhysicalOptimizerRules {

    public static abstract class OptimizerExpressionRule<E extends Expression>
    extends Rule<PhysicalPlan, PhysicalPlan> {
        private final OptimizerRules.TransformDirection direction;
        private final Class<E> expressionTypeToken = ReflectionUtils.detectSuperTypeForRuleLike(this.getClass());

        public OptimizerExpressionRule(OptimizerRules.TransformDirection direction) {
            this.direction = direction;
        }

        @Override
        public final PhysicalPlan apply(PhysicalPlan plan) {
            return this.direction == OptimizerRules.TransformDirection.DOWN ? (PhysicalPlan)((Object)plan.transformExpressionsDown(this.expressionTypeToken, this::rule)) : (PhysicalPlan)((Object)plan.transformExpressionsUp(this.expressionTypeToken, this::rule));
        }

        protected PhysicalPlan rule(PhysicalPlan plan) {
            return plan;
        }

        protected abstract Expression rule(E var1);

        public Class<E> expressionToken() {
            return this.expressionTypeToken;
        }
    }

    public static abstract class OptimizerRule<SubPlan extends PhysicalPlan>
    extends Rule<SubPlan, PhysicalPlan> {
        private final OptimizerRules.TransformDirection direction;

        public OptimizerRule() {
            this(OptimizerRules.TransformDirection.DOWN);
        }

        protected OptimizerRule(OptimizerRules.TransformDirection direction) {
            this.direction = direction;
        }

        @Override
        public final PhysicalPlan apply(PhysicalPlan plan) {
            return this.direction == OptimizerRules.TransformDirection.DOWN ? (PhysicalPlan)plan.transformDown(this.typeToken(), this::rule) : (PhysicalPlan)plan.transformUp(this.typeToken(), this::rule);
        }

        protected abstract PhysicalPlan rule(SubPlan var1);
    }

    public static abstract class ParameterizedOptimizerRule<SubPlan extends PhysicalPlan, P>
    extends ParameterizedRule<SubPlan, PhysicalPlan, P> {
        private final OptimizerRules.TransformDirection direction;

        public ParameterizedOptimizerRule() {
            this(OptimizerRules.TransformDirection.DOWN);
        }

        protected ParameterizedOptimizerRule(OptimizerRules.TransformDirection direction) {
            this.direction = direction;
        }

        @Override
        public final PhysicalPlan apply(PhysicalPlan plan, P context) {
            return this.direction == OptimizerRules.TransformDirection.DOWN ? (PhysicalPlan)plan.transformDown(this.typeToken(), t -> this.rule(t, context)) : (PhysicalPlan)plan.transformUp(this.typeToken(), t -> this.rule(t, context));
        }

        protected abstract PhysicalPlan rule(SubPlan var1, P var2);
    }
}

