/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.geo.XYGeometry;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.LuceneGeometriesUtils;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.ShapeType;
import org.elasticsearch.index.mapper.GeoShapeIndexer;
import org.elasticsearch.index.mapper.ShapeIndexer;
import org.elasticsearch.lucene.spatial.CartesianShapeIndexer;
import org.elasticsearch.lucene.spatial.CentroidCalculator;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.lucene.spatial.GeometryDocValueReader;
import org.elasticsearch.lucene.spatial.GeometryDocValueWriter;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Foldables;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.BinarySpatialFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.LuceneComponent2DUtils;

public class SpatialRelatesUtils {
    static Component2D asLuceneComponent2D(BinarySpatialFunction.SpatialCrsType crsType, Expression expression) {
        return SpatialRelatesUtils.asLuceneComponent2D(crsType, SpatialRelatesUtils.makeGeometryFromLiteral(expression));
    }

    static Component2D asLuceneComponent2D(BinarySpatialFunction.SpatialCrsType crsType, Geometry geometry) {
        if (crsType == BinarySpatialFunction.SpatialCrsType.GEO) {
            LatLonGeometry[] luceneGeometries = LuceneGeometriesUtils.toLatLonGeometry((Geometry)geometry, (boolean)true, t -> {});
            return LatLonGeometry.create((LatLonGeometry[])luceneGeometries);
        }
        XYGeometry[] luceneGeometries = LuceneGeometriesUtils.toXYGeometry((Geometry)geometry, t -> {});
        return XYGeometry.create((XYGeometry[])luceneGeometries);
    }

    static Component2D asLuceneComponent2D(BinarySpatialFunction.SpatialCrsType type, BytesRefBlock valueBlock, int position) {
        return SpatialRelatesUtils.asLuceneComponent2D(type, SpatialRelatesUtils.asGeometry(valueBlock, position));
    }

    static Component2D[] asLuceneComponent2Ds(BinarySpatialFunction.SpatialCrsType crsType, Expression expression) {
        return SpatialRelatesUtils.asLuceneComponent2Ds(crsType, SpatialRelatesUtils.makeGeometryFromLiteral(expression));
    }

    static Component2D[] asLuceneComponent2Ds(BinarySpatialFunction.SpatialCrsType crsType, Geometry geometry) {
        if (crsType == BinarySpatialFunction.SpatialCrsType.GEO) {
            LatLonGeometry[] luceneGeometries = LuceneGeometriesUtils.toLatLonGeometry((Geometry)geometry, (boolean)true, t -> {});
            return LuceneComponent2DUtils.createLatLonComponents(luceneGeometries);
        }
        XYGeometry[] luceneGeometries = LuceneGeometriesUtils.toXYGeometry((Geometry)geometry, t -> {});
        return LuceneComponent2DUtils.createXYComponents(luceneGeometries);
    }

    static Component2D[] asLuceneComponent2Ds(BinarySpatialFunction.SpatialCrsType type, BytesRefBlock valueBlock, int position) {
        return SpatialRelatesUtils.asLuceneComponent2Ds(type, SpatialRelatesUtils.asGeometry(valueBlock, position));
    }

    static GeometryDocValueReader asGeometryDocValueReader(BinarySpatialFunction.SpatialCrsType crsType, Expression expression) throws IOException {
        Geometry geometry = SpatialRelatesUtils.makeGeometryFromLiteral(expression);
        if (crsType == BinarySpatialFunction.SpatialCrsType.GEO) {
            return SpatialRelatesUtils.asGeometryDocValueReader(CoordinateEncoder.GEO, (ShapeIndexer)new GeoShapeIndexer(Orientation.CCW, "SpatialRelatesFunction"), geometry);
        }
        return SpatialRelatesUtils.asGeometryDocValueReader(CoordinateEncoder.CARTESIAN, (ShapeIndexer)new CartesianShapeIndexer("SpatialRelatesFunction"), geometry);
    }

    static GeometryDocValueReader asGeometryDocValueReader(CoordinateEncoder encoder, ShapeIndexer shapeIndexer, Geometry geometry) throws IOException {
        GeometryDocValueReader reader = new GeometryDocValueReader();
        CentroidCalculator centroidCalculator = new CentroidCalculator();
        if (geometry instanceof Circle) {
            throw new IllegalArgumentException(String.valueOf(ShapeType.CIRCLE) + " geometry is not supported");
        }
        centroidCalculator.add(geometry);
        reader.reset(GeometryDocValueWriter.write((List)shapeIndexer.indexShape(geometry), (CoordinateEncoder)encoder, (CentroidCalculator)centroidCalculator));
        return reader;
    }

    static GeometryDocValueReader asGeometryDocValueReader(CoordinateEncoder encoder, ShapeIndexer shapeIndexer, LongBlock valueBlock, int position, Function<Long, Point> decoder) throws IOException {
        int firstValueIndex = valueBlock.getFirstValueIndex(position);
        int valueCount = valueBlock.getValueCount(position);
        if (valueCount == 1) {
            return SpatialRelatesUtils.asGeometryDocValueReader(encoder, shapeIndexer, (Geometry)decoder.apply(valueBlock.getLong(firstValueIndex)));
        }
        ArrayList<Point> points = new ArrayList<Point>(valueCount);
        for (int i = 0; i < valueCount; ++i) {
            points.add(decoder.apply(valueBlock.getLong(firstValueIndex + i)));
        }
        return SpatialRelatesUtils.asGeometryDocValueReader(encoder, shapeIndexer, (Geometry)new MultiPoint(points));
    }

    static GeometryDocValueReader asGeometryDocValueReader(CoordinateEncoder encoder, ShapeIndexer shapeIndexer, BytesRefBlock valueBlock, int position) throws IOException {
        return SpatialRelatesUtils.asGeometryDocValueReader(encoder, shapeIndexer, SpatialRelatesUtils.asGeometry(valueBlock, position));
    }

    private static Geometry asGeometry(BytesRefBlock valueBlock, int position) {
        BytesRef scratch = new BytesRef();
        int firstValueIndex = valueBlock.getFirstValueIndex(position);
        int valueCount = valueBlock.getValueCount(position);
        if (valueCount == 1) {
            return SpatialCoordinateTypes.UNSPECIFIED.wkbToGeometry(valueBlock.getBytesRef(firstValueIndex, scratch));
        }
        ArrayList<Geometry> geometries = new ArrayList<Geometry>(valueCount);
        for (int i = 0; i < valueCount; ++i) {
            geometries.add(SpatialCoordinateTypes.UNSPECIFIED.wkbToGeometry(valueBlock.getBytesRef(firstValueIndex + i, scratch)));
        }
        return new GeometryCollection(geometries);
    }

    public static Geometry makeGeometryFromLiteral(Expression expr) {
        return SpatialRelatesUtils.makeGeometryFromLiteralValue(Foldables.valueOf((Expression)expr), expr.dataType());
    }

    private static Geometry makeGeometryFromLiteralValue(Object value, DataType dataType) {
        if (value instanceof BytesRef) {
            BytesRef bytesRef = (BytesRef)value;
            return SpatialCoordinateTypes.UNSPECIFIED.wkbToGeometry(bytesRef);
        }
        if (value instanceof List) {
            List bytesRefList = (List)value;
            ArrayList<Geometry> geometries = new ArrayList<Geometry>();
            for (Object obj : bytesRefList) {
                geometries.add(SpatialRelatesUtils.makeGeometryFromLiteralValue(obj, dataType));
            }
            return new GeometryCollection(geometries);
        }
        throw new IllegalArgumentException("Unsupported combination of literal [" + value.getClass().getSimpleName() + "] of type [" + String.valueOf(dataType) + "]");
    }
}

