/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLong;

public final class ToLongFromIntEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    public ToLongFromIntEvaluator(EvalOperator.ExpressionEvaluator field, Source source, DriverContext driverContext) {
        super(driverContext, field, source);
    }

    @Override
    public String name() {
        return "ToLongFromInt";
    }

    @Override
    public Block evalVector(Vector v) {
        IntVector vector = (IntVector)v;
        int positionCount = v.getPositionCount();
        if (vector.isConstant()) {
            return this.driverContext.blockFactory().newConstantLongBlockWith(ToLongFromIntEvaluator.evalValue(vector, 0), positionCount);
        }
        try (LongBlock.Builder builder = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                builder.appendLong(ToLongFromIntEvaluator.evalValue(vector, p));
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    private static long evalValue(IntVector container, int index) {
        int value = container.getInt(index);
        return ToLong.fromInt(value);
    }

    @Override
    public Block evalBlock(Block b) {
        IntBlock block = (IntBlock)b;
        int positionCount = block.getPositionCount();
        try (LongBlock.Builder builder = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    long value = ToLongFromIntEvaluator.evalValue(block, i);
                    if (!positionOpened && valueCount > 1) {
                        builder.beginPositionEntry();
                        positionOpened = true;
                    }
                    builder.appendLong(value);
                    valuesAppended = true;
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    private static long evalValue(IntBlock container, int index) {
        int value = container.getInt(index);
        return ToLong.fromInt(value);
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field, Source source) {
            this.field = field;
            this.source = source;
        }

        public ToLongFromIntEvaluator get(DriverContext context) {
            return new ToLongFromIntEvaluator(this.field.get(context), this.source, context);
        }

        public String toString() {
            return "ToLongFromIntEvaluator[field=" + String.valueOf(this.field) + "]";
        }
    }
}

