/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.spatial.SpatialCentroidCartesianPointDocValuesAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.spatial.SpatialCentroidCartesianPointSourceValuesAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.spatial.SpatialCentroidGeoPointDocValuesAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.spatial.SpatialCentroidGeoPointSourceValuesAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.SpatialAggregateFunction;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class SpatialCentroid
extends SpatialAggregateFunction
implements ToAggregator {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "SpatialCentroid", SpatialCentroid::new);

    @FunctionInfo(returnType={"geo_point", "cartesian_point"}, description="Calculate the spatial centroid over a field with spatial point geometry type.", isAggregation=true, examples={@Example(file="spatial", tag="st_centroid_agg-airports")})
    public SpatialCentroid(Source source, @Param(name="field", type={"geo_point", "cartesian_point"}) Expression field) {
        this(source, field, (Expression)Literal.TRUE, false);
    }

    private SpatialCentroid(Source source, Expression field, Expression filter, boolean useDocValues) {
        super(source, field, filter, useDocValues);
    }

    private SpatialCentroid(StreamInput in) throws IOException {
        super(in, false);
    }

    public String getWriteableName() {
        return SpatialCentroid.ENTRY.name;
    }

    @Override
    public SpatialCentroid withFilter(Expression filter) {
        return new SpatialCentroid(this.source(), this.field(), filter, this.useDocValues);
    }

    @Override
    public SpatialCentroid withDocValues() {
        return new SpatialCentroid(this.source(), this.field(), this.filter(), true);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return EsqlTypeResolutions.isSpatialPoint(this.field(), this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
    }

    public DataType dataType() {
        return this.field().dataType();
    }

    protected NodeInfo<SpatialCentroid> info() {
        return NodeInfo.create((Node)this, SpatialCentroid::new, (Object)this.field());
    }

    public SpatialCentroid replaceChildren(List<Expression> newChildren) {
        return new SpatialCentroid(this.source(), newChildren.get(0));
    }

    @Override
    public AggregatorFunctionSupplier supplier(List<Integer> inputChannels) {
        DataType type = this.field().dataType();
        if (this.useDocValues) {
            if (type == DataType.GEO_POINT) {
                return new SpatialCentroidGeoPointDocValuesAggregatorFunctionSupplier(inputChannels);
            }
            if (type == DataType.CARTESIAN_POINT) {
                return new SpatialCentroidCartesianPointDocValuesAggregatorFunctionSupplier(inputChannels);
            }
        } else {
            if (type == DataType.GEO_POINT) {
                return new SpatialCentroidGeoPointSourceValuesAggregatorFunctionSupplier(inputChannels);
            }
            if (type == DataType.CARTESIAN_POINT) {
                return new SpatialCentroidCartesianPointSourceValuesAggregatorFunctionSupplier(inputChannels);
            }
        }
        throw EsqlIllegalArgumentException.illegalDataType(type);
    }
}

