/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.analysis;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.esql.action.EsqlCapabilities;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.core.capabilities.Unresolvable;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.predicate.BinaryOperator;
import org.elasticsearch.xpack.esql.core.expression.predicate.logical.BinaryLogic;
import org.elasticsearch.xpack.esql.core.expression.predicate.logical.Not;
import org.elasticsearch.xpack.esql.core.expression.predicate.logical.Or;
import org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.UnsupportedAttribute;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.FilteredExpression;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Rate;
import org.elasticsearch.xpack.esql.expression.function.fulltext.FullTextFunction;
import org.elasticsearch.xpack.esql.expression.function.fulltext.Match;
import org.elasticsearch.xpack.esql.expression.function.fulltext.QueryString;
import org.elasticsearch.xpack.esql.expression.function.grouping.Categorize;
import org.elasticsearch.xpack.esql.expression.function.grouping.GroupingFunction;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Neg;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Lookup;
import org.elasticsearch.xpack.esql.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.RegexExtract;
import org.elasticsearch.xpack.esql.plan.logical.Row;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.join.LookupJoin;
import org.elasticsearch.xpack.esql.stats.FeatureMetric;
import org.elasticsearch.xpack.esql.stats.Metrics;

public class Verifier {
    private final Metrics metrics;
    private final XPackLicenseState licenseState;

    public Verifier(Metrics metrics, XPackLicenseState licenseState) {
        this.metrics = metrics;
        this.licenseState = licenseState;
    }

    Collection<Failure> verify(LogicalPlan plan, BitSet partialMetrics) {
        assert (partialMetrics != null);
        LinkedHashSet<Failure> failures = new LinkedHashSet<Failure>();
        AttributeMap aliases = new AttributeMap();
        plan.forEachUp(p -> {
            if (!p.childrenResolved()) {
                return;
            }
            if (p instanceof Unresolvable) {
                Unresolvable u = (Unresolvable)p;
                failures.add(Failure.fail(p, u.unresolvedMessage(), new Object[0]));
            } else if (p.resolved()) {
                p.forEachExpressionUp(Alias.class, a -> aliases.put(a.toAttribute(), (Object)a.child()));
                return;
            }
            Consumer<Expression> unresolvedExpressions = e -> {
                if (e.resolved()) {
                    return;
                }
                e.forEachUp(ae -> {
                    if (p instanceof Project) {
                        Alias as;
                        Expression patt6610$temp;
                        if (ae instanceof Alias && (patt6610$temp = (as = (Alias)ae).child()) instanceof UnsupportedAttribute) {
                            UnsupportedAttribute ua = (UnsupportedAttribute)patt6610$temp;
                            failures.add(Failure.fail(ae, ua.unresolvedMessage(), new Object[0]));
                        }
                        if (ae instanceof UnsupportedAttribute) {
                            return;
                        }
                    }
                    if (!ae.childrenResolved()) {
                        return;
                    }
                    if (ae instanceof Unresolvable) {
                        Unresolvable u = (Unresolvable)ae;
                        failures.add(Failure.fail(ae, u.unresolvedMessage(), new Object[0]));
                    }
                    if (ae.typeResolved().unresolved()) {
                        failures.add(Failure.fail(ae, ae.typeResolved().message(), new Object[0]));
                    }
                });
            };
            if (p instanceof Aggregate) {
                Aggregate agg = (Aggregate)((Object)p);
                List<Expression> groupings = agg.groupings();
                groupings.forEach(unresolvedExpressions);
                List<? extends NamedExpression> aggs = agg.aggregates();
                int size = aggs.size() - groupings.size();
                aggs.subList(0, size).forEach(unresolvedExpressions);
            } else if (p instanceof Lookup) {
                Lookup lookup = (Lookup)p;
                Expression tableName = lookup.tableName();
                if (tableName instanceof Unresolvable) {
                    Unresolvable u = (Unresolvable)tableName;
                    failures.add(Failure.fail(tableName, u.unresolvedMessage(), new Object[0]));
                } else {
                    lookup.matchFields().forEach(unresolvedExpressions);
                }
            } else if (p instanceof LookupJoin) {
                LookupJoin lj = (LookupJoin)p;
                lj.right().forEachUp(EsRelation.class, r -> {
                    if (r.indexMode() != IndexMode.LOOKUP) {
                        failures.add(Failure.fail(r, "LOOKUP JOIN right side [{}] must be a lookup index (index_mode=lookup, not [{}]", r.index().name(), r.indexMode().getName()));
                    }
                });
            } else {
                p.forEachExpression(unresolvedExpressions);
            }
        });
        if (!failures.isEmpty()) {
            return failures;
        }
        plan.forEachDown(p -> {
            if (!p.childrenResolved()) {
                return;
            }
            Verifier.checkFilterConditionType(p, failures);
            Verifier.checkAggregate(p, failures);
            Verifier.checkRegexExtractOnlyOnStrings(p, failures);
            Verifier.checkRow(p, failures);
            Verifier.checkEvalFields(p, failures);
            Verifier.checkOperationsOnUnsignedLong(p, failures);
            Verifier.checkBinaryComparison(p, failures);
            Verifier.checkForSortableDataTypes(p, failures);
            this.checkSort((LogicalPlan)((Object)p), (Set<Failure>)failures);
            Verifier.checkFullTextQueryFunctions(p, failures);
        });
        Verifier.checkRemoteEnrich(plan, failures);
        if (failures.isEmpty()) {
            this.checkLicense(plan, this.licenseState, failures);
        }
        if (failures.isEmpty()) {
            this.gatherMetrics(plan, partialMetrics);
        }
        return failures;
    }

    private void checkSort(LogicalPlan p, Set<Failure> failures) {
        if (p instanceof OrderBy) {
            OrderBy ob = (OrderBy)p;
            ob.order().forEach(o -> o.forEachDown(org.elasticsearch.xpack.esql.core.expression.function.Function.class, f -> {
                if (f instanceof AggregateFunction) {
                    failures.add(Failure.fail(f, "Aggregate functions are not allowed in SORT [{}]", new Object[]{f.functionName()}));
                }
            }));
        }
    }

    private static void checkFilterConditionType(LogicalPlan p, Set<Failure> localFailures) {
        Filter f;
        Expression condition;
        if (p instanceof Filter && (condition = (f = (Filter)p).condition()).dataType() != DataType.BOOLEAN) {
            localFailures.add(Failure.fail(condition, "Condition expression needs to be boolean, found [{}]", new Object[]{condition.dataType()}));
        }
    }

    private static void checkAggregate(LogicalPlan p, Set<Failure> failures) {
        if (p instanceof Aggregate) {
            Aggregate agg = (Aggregate)p;
            List<Expression> groupings = agg.groupings();
            AttributeSet groupRefs = new AttributeSet();
            groupings.forEach(e -> {
                FieldAttribute f;
                e.forEachUp(g -> {
                    if (g instanceof AggregateFunction) {
                        AggregateFunction af = (AggregateFunction)((Object)((Object)g));
                        failures.add(Failure.fail(g, "cannot use an aggregate [{}] for grouping", new Object[]{af}));
                    } else if (g instanceof GroupingFunction) {
                        GroupingFunction gf = (GroupingFunction)g;
                        gf.children().forEach(c -> c.forEachDown(GroupingFunction.class, inner -> failures.add(Failure.fail(inner, "cannot nest grouping functions; found [{}] inside [{}]", new Object[]{inner.sourceText(), gf.sourceText()}))));
                    }
                });
                Attribute attr = Expressions.attribute((Expression)e);
                if (attr != null) {
                    groupRefs.add(attr);
                }
                if (e instanceof FieldAttribute && (f = (FieldAttribute)e).dataType().isCounter()) {
                    failures.add(Failure.fail(e, "cannot group by on [{}] type for grouping [{}]", new Object[]{f.dataType().typeName(), e.sourceText()}));
                }
            });
            List<? extends NamedExpression> aggs = agg.aggregates();
            aggs.subList(0, aggs.size() - groupings.size()).forEach(e -> {
                Expression exp = Alias.unwrap((Expression)e);
                if (exp.foldable()) {
                    failures.add(Failure.fail(exp, "expected an aggregate function but found [{}]", new Object[]{exp.sourceText()}));
                }
                Verifier.checkInvalidNamedExpressionUsage(exp, groupings, groupRefs, failures, 0);
            });
            if (agg.aggregateType() == Aggregate.AggregateType.METRICS) {
                aggs.forEach(a -> Verifier.checkRateAggregates((Expression)a, 0, failures));
            } else {
                agg.forEachExpression(Rate.class, r -> failures.add(Failure.fail(r, "the rate aggregate[{}] can only be used within the metrics command", new Object[]{r.sourceText()})));
            }
            Verifier.checkCategorizeGrouping(agg, failures);
        } else {
            p.forEachExpression(GroupingFunction.class, gf -> failures.add(Failure.fail(gf, "cannot use grouping function [{}] outside of a STATS command", new Object[]{gf.sourceText()})));
        }
    }

    private static void checkCategorizeGrouping(Aggregate agg, Set<Failure> failures) {
        if (agg.groupings().size() > 1) {
            agg.groupings().forEach(g -> g.forEachDown(Categorize.class, categorize -> failures.add(Failure.fail(categorize, "cannot use CATEGORIZE grouping function [{}] with multiple groupings", new Object[]{categorize.sourceText()}))));
        }
        agg.groupings().forEach(g -> Alias.unwrap((Expression)g).children().forEach(child -> child.forEachDown(Categorize.class, c -> failures.add(Failure.fail(c, "CATEGORIZE grouping function [{}] can't be used within other expressions", new Object[]{c.sourceText()})))));
        agg.aggregates().forEach(a -> a.forEachDown(Categorize.class, categorize -> failures.add(Failure.fail(categorize, "cannot use CATEGORIZE grouping function [{}] within the aggregations", new Object[]{categorize.sourceText()}))));
        HashMap categorizeByAliasId = new HashMap();
        agg.groupings().forEach(g -> g.forEachDown(Alias.class, alias -> {
            Expression patt16733$temp = alias.child();
            if (patt16733$temp instanceof Categorize) {
                Categorize categorize = (Categorize)patt16733$temp;
                categorizeByAliasId.put(alias.id(), categorize);
            }
        }));
        agg.aggregates().forEach(a -> a.forEachDown(AggregateFunction.class, aggregate -> aggregate.forEachDown(Attribute.class, attribute -> {
            Categorize categorize = (Categorize)categorizeByAliasId.get(attribute.id());
            if (categorize != null) {
                failures.add(Failure.fail(attribute, "cannot reference CATEGORIZE grouping function [{}] within the aggregations", new Object[]{attribute.sourceText()}));
            }
        })));
    }

    private static void checkRateAggregates(Expression expr, int nestedLevel, Set<Failure> failures) {
        if (expr instanceof AggregateFunction) {
            ++nestedLevel;
        }
        if (expr instanceof Rate) {
            Rate r = (Rate)expr;
            if (nestedLevel != 2) {
                failures.add(Failure.fail(expr, "the rate aggregate [{}] can only be used within the metrics command and inside another aggregate", new Object[]{r.sourceText()}));
            }
        }
        for (Expression child : expr.children()) {
            Verifier.checkRateAggregates(child, nestedLevel, failures);
        }
    }

    private static void checkInvalidNamedExpressionUsage(Expression e, List<Expression> groups, AttributeSet groupRefs, Set<Failure> failures, int level) {
        block13: {
            block14: {
                GroupingFunction gf;
                block15: {
                    block12: {
                        if (e instanceof FilteredExpression) {
                            Expression f2;
                            FilteredExpression fe = (FilteredExpression)e;
                            e = fe.delegate();
                            if (!e.anyMatch(AggregateFunction.class::isInstance)) {
                                Expression filter = fe.filter();
                                failures.add(Failure.fail(filter, "WHERE clause allowed only for aggregate functions, none found in [{}]", new Object[]{fe.sourceText()}));
                            }
                            if ((f2 = fe.filter()).dataType() != DataType.NULL && f2.dataType() != DataType.BOOLEAN) {
                                failures.add(Failure.fail(f2, "Condition expression needs to be boolean, found [{}]", new Object[]{f2.dataType()}));
                            }
                            fe.filter().forEachDown(c -> {
                                GroupingFunction gf;
                                if (c instanceof AggregateFunction) {
                                    AggregateFunction af = (AggregateFunction)((Object)c);
                                    failures.add(Failure.fail(af, "cannot use aggregate function [{}] in aggregate WHERE clause [{}]", new Object[]{af.sourceText(), fe.sourceText()}));
                                } else if (c instanceof GroupingFunction && !Expressions.anyMatch((List)groups, arg_0 -> Verifier.lambda$checkInvalidNamedExpressionUsage$28(gf = (GroupingFunction)c, arg_0))) {
                                    failures.add(Failure.fail(gf, "can only use grouping function [{}] part of the BY clause", new Object[]{gf.sourceText()}));
                                }
                            });
                        }
                        if (!(e instanceof AggregateFunction)) break block12;
                        AggregateFunction af = (AggregateFunction)e;
                        af.field().forEachDown(AggregateFunction.class, f -> {
                            if (!(f instanceof Rate)) {
                                failures.add(Failure.fail(f, "nested aggregations [{}] not allowed inside other aggregations [{}]", new Object[]{f, af}));
                            }
                        });
                        break block13;
                    }
                    if (!(e instanceof GroupingFunction)) break block14;
                    gf = (GroupingFunction)e;
                    if (Expressions.anyMatch(groups, ex -> {
                        Alias a;
                        return ex instanceof Alias && (a = (Alias)ex).child().semanticEquals((Expression)gf);
                    })) break block15;
                    failures.add(Failure.fail(gf, "can only use grouping function [{}] part of the BY clause", new Object[]{gf.sourceText()}));
                    break block13;
                }
                if (level != 0) break block13;
                Verifier.addFailureOnGroupingUsedNakedInAggs(failures, (Expression)gf, "function");
                break block13;
            }
            if (!e.foldable()) {
                if (groups.contains(e) || groupRefs.contains((Object)e)) {
                    if (level == 0) {
                        Verifier.addFailureOnGroupingUsedNakedInAggs(failures, e, "key");
                    }
                } else if (e instanceof NamedExpression) {
                    NamedExpression ne = (NamedExpression)e;
                    boolean foundInGrouping = false;
                    for (Expression g : groups) {
                        if (!g.anyMatch(se -> se.semanticEquals((Expression)ne))) continue;
                        foundInGrouping = true;
                        failures.add(Failure.fail(e, "column [{}] cannot be used as an aggregate once declared in the STATS BY grouping key [{}]", new Object[]{ne.name(), g.sourceText()}));
                        break;
                    }
                    if (!foundInGrouping) {
                        failures.add(Failure.fail(e, "column [{}] must appear in the STATS BY clause or be used in an aggregate function", new Object[]{ne.name()}));
                    }
                } else {
                    for (Expression child : e.children()) {
                        Verifier.checkInvalidNamedExpressionUsage(child, groups, groupRefs, failures, level + 1);
                    }
                }
            }
        }
    }

    private static void addFailureOnGroupingUsedNakedInAggs(Set<Failure> failures, Expression e, String element) {
        failures.add(Failure.fail(e, "grouping {} [{}] cannot be used as an aggregate once declared in the STATS BY clause", new Object[]{element, e.sourceText()}));
    }

    private static void checkRegexExtractOnlyOnStrings(LogicalPlan p, Set<Failure> failures) {
        RegexExtract re;
        Expression expr;
        DataType type;
        if (p instanceof RegexExtract && !DataType.isString((DataType)(type = (expr = (re = (RegexExtract)p).input()).dataType()))) {
            failures.add(Failure.fail(expr, "{} only supports KEYWORD or TEXT values, found expression [{}] type [{}]", new Object[]{re.getClass().getSimpleName(), expr.sourceText(), type}));
        }
    }

    private static void checkRow(LogicalPlan p, Set<Failure> failures) {
        if (p instanceof Row) {
            Row row = (Row)p;
            row.fields().forEach(a -> {
                if (!DataType.isRepresentable((DataType)a.dataType())) {
                    failures.add(Failure.fail(a, "cannot use [{}] directly in a row assignment", new Object[]{a.child().sourceText()}));
                }
            });
        }
    }

    private static void checkEvalFields(LogicalPlan p, Set<Failure> failures) {
        if (p instanceof Eval) {
            Eval eval = (Eval)p;
            eval.fields().forEach(field -> {
                DataType dataType = field.dataType();
                if (!DataType.isRepresentable((DataType)dataType)) {
                    failures.add(Failure.fail(field, "EVAL does not support type [{}] as the return data type of expression [{}]", new Object[]{dataType.typeName(), field.child().sourceText()}));
                }
                field.forEachDown(AggregateFunction.class, af -> {
                    if (af instanceof Rate) {
                        failures.add(Failure.fail(af, "aggregate function [{}] not allowed outside METRICS command", new Object[]{af.sourceText()}));
                    } else {
                        failures.add(Failure.fail(af, "aggregate function [{}] not allowed outside STATS command", new Object[]{af.sourceText()}));
                    }
                });
            });
        }
    }

    private static void checkOperationsOnUnsignedLong(LogicalPlan p, Set<Failure> failures) {
        p.forEachExpression(e -> {
            Failure f = null;
            if (e instanceof BinaryOperator) {
                BinaryOperator bo = (BinaryOperator)e;
                f = Verifier.validateUnsignedLongOperator(bo);
            } else if (e instanceof Neg) {
                Neg neg = (Neg)e;
                f = Verifier.validateUnsignedLongNegation(neg);
            }
            if (f != null) {
                failures.add(f);
            }
        });
    }

    private static void checkBinaryComparison(LogicalPlan p, Set<Failure> failures) {
        p.forEachExpression(BinaryComparison.class, bc -> {
            Failure f = Verifier.validateBinaryComparison(bc);
            if (f != null) {
                failures.add(f);
            }
        });
    }

    private void checkLicense(LogicalPlan plan, XPackLicenseState licenseState, Set<Failure> failures) {
        plan.forEachExpressionDown(org.elasticsearch.xpack.esql.core.expression.function.Function.class, p -> {
            if (!p.checkLicense(licenseState)) {
                failures.add(new Failure((Node<?>)p, "current license is non-compliant for function [" + p.sourceText() + "]"));
            }
        });
    }

    private void gatherMetrics(LogicalPlan plan, BitSet b) {
        plan.forEachDown(p -> FeatureMetric.set(p, b));
        int i = b.nextSetBit(0);
        while (i >= 0) {
            this.metrics.inc(FeatureMetric.values()[i]);
            i = b.nextSetBit(i + 1);
        }
        HashSet functions = new HashSet();
        plan.forEachExpressionDown(org.elasticsearch.xpack.esql.core.expression.function.Function.class, p -> functions.add(p.getClass()));
        functions.forEach(f -> this.metrics.incFunctionMetric((Class<?>)f));
    }

    public static Failure validateBinaryComparison(BinaryComparison bc) {
        if (bc.left().dataType().isNumeric()) {
            if (!bc.right().dataType().isNumeric()) {
                return Failure.fail(bc, "first argument of [{}] is [numeric] so second argument must also be [numeric] but was [{}]", new Object[]{bc.sourceText(), bc.right().dataType().typeName()});
            }
            return null;
        }
        ArrayList<DataType> allowed = new ArrayList<DataType>();
        allowed.add(DataType.KEYWORD);
        allowed.add(DataType.TEXT);
        if (EsqlCapabilities.Cap.SEMANTIC_TEXT_TYPE.isEnabled()) {
            allowed.add(DataType.SEMANTIC_TEXT);
        }
        allowed.add(DataType.IP);
        allowed.add(DataType.DATETIME);
        allowed.add(DataType.DATE_NANOS);
        allowed.add(DataType.VERSION);
        allowed.add(DataType.GEO_POINT);
        allowed.add(DataType.GEO_SHAPE);
        allowed.add(DataType.CARTESIAN_POINT);
        allowed.add(DataType.CARTESIAN_SHAPE);
        if (bc instanceof Equals || bc instanceof NotEquals) {
            allowed.add(DataType.BOOLEAN);
        }
        Expression.TypeResolution r = TypeResolutions.isType((Expression)bc.left(), allowed::contains, (String)bc.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])((String[])Stream.concat(Stream.of("numeric"), allowed.stream().map(DataType::typeName)).toArray(String[]::new)));
        if (!r.resolved()) {
            return Failure.fail(bc, r.message(), new Object[0]);
        }
        if (DataType.isString((DataType)bc.left().dataType()) && DataType.isString((DataType)bc.right().dataType())) {
            return null;
        }
        if (bc.left().dataType() != bc.right().dataType()) {
            return Failure.fail(bc, "first argument of [{}] is [{}] so second argument must also be [{}] but was [{}]", new Object[]{bc.sourceText(), bc.left().dataType().typeName(), bc.left().dataType().typeName(), bc.right().dataType().typeName()});
        }
        return null;
    }

    public static Failure validateUnsignedLongOperator(BinaryOperator<?, ?, ?, ?> bo) {
        DataType leftType = bo.left().dataType();
        DataType rightType = bo.right().dataType();
        if ((leftType == DataType.UNSIGNED_LONG || rightType == DataType.UNSIGNED_LONG) && leftType != rightType) {
            return Failure.fail(bo, "first argument of [{}] is [{}] and second is [{}]. [{}] can only be operated on together with another [{}]", new Object[]{bo.sourceText(), leftType.typeName(), rightType.typeName(), DataType.UNSIGNED_LONG.typeName(), DataType.UNSIGNED_LONG.typeName()});
        }
        return null;
    }

    private static Failure validateUnsignedLongNegation(Neg neg) {
        DataType childExpressionType = neg.field().dataType();
        if (childExpressionType.equals((Object)DataType.UNSIGNED_LONG)) {
            return Failure.fail(neg, "negation unsupported for arguments of type [{}] in expression [{}]", new Object[]{childExpressionType.typeName(), neg.sourceText()});
        }
        return null;
    }

    private static void checkForSortableDataTypes(LogicalPlan p, Set<Failure> localFailures) {
        if (p instanceof OrderBy) {
            OrderBy ob = (OrderBy)p;
            ob.order().forEach(order -> {
                if (!DataType.isSortable((DataType)order.dataType())) {
                    localFailures.add(Failure.fail(order, "cannot sort on " + order.dataType().typeName(), new Object[0]));
                }
            });
        }
    }

    private static void checkRemoteEnrich(LogicalPlan plan, Set<Failure> failures) {
        boolean[] agg = new boolean[]{false};
        boolean[] enrichCoord = new boolean[]{false};
        plan.forEachUp(UnaryPlan.class, u -> {
            Enrich enrich;
            if (u instanceof Aggregate) {
                agg[0] = true;
            } else if (u instanceof Enrich && (enrich = (Enrich)u).mode() == Enrich.Mode.COORDINATOR) {
                enrichCoord[0] = true;
            }
            if (u instanceof Enrich && (enrich = (Enrich)u).mode() == Enrich.Mode.REMOTE) {
                if (agg[0]) {
                    failures.add(Failure.fail(enrich, "ENRICH with remote policy can't be executed after STATS", new Object[0]));
                }
                if (enrichCoord[0]) {
                    failures.add(Failure.fail(enrich, "ENRICH with remote policy can't be executed after another ENRICH with coordinator policy", new Object[0]));
                }
            }
        });
    }

    private static void checkNotPresentInDisjunctions(Expression condition, Function<FullTextFunction, String> typeNameProvider, Set<Failure> failures) {
        condition.forEachUp(Or.class, or -> {
            Verifier.checkNotPresentInDisjunctions(or.left(), or, typeNameProvider, failures);
            Verifier.checkNotPresentInDisjunctions(or.right(), or, typeNameProvider, failures);
        });
    }

    private static void checkNotPresentInDisjunctions(Expression parentExpression, Or or, Function<FullTextFunction, String> elementName, Set<Failure> failures) {
        parentExpression.forEachDown(FullTextFunction.class, ftp -> failures.add(Failure.fail(or, "Invalid condition [{}]. {} can't be used as part of an or condition", new Object[]{or.sourceText(), elementName.apply((FullTextFunction)((Object)ftp))})));
    }

    private static void checkFullTextQueryFunctions(LogicalPlan plan, Set<Failure> failures) {
        if (plan instanceof Filter) {
            Filter f = (Filter)plan;
            Expression condition = f.condition();
            Verifier.checkCommandsBeforeExpression(plan, condition, QueryString.class, lp -> lp instanceof Filter || lp instanceof OrderBy || lp instanceof EsRelation, qsf -> "[" + qsf.functionName() + "] " + qsf.functionType(), failures);
            Verifier.checkCommandsBeforeExpression(plan, condition, Match.class, lp -> !(lp instanceof Limit) && !(lp instanceof Aggregate), m -> "[" + m.functionName() + "] " + m.functionType(), failures);
            Verifier.checkNotPresentInDisjunctions(condition, ftf -> "[" + ftf.functionName() + "] " + ftf.functionType(), failures);
            Verifier.checkFullTextFunctionsParents(condition, failures);
        } else {
            plan.forEachExpression(FullTextFunction.class, ftf -> failures.add(Failure.fail(ftf, "[{}] {} is only supported in WHERE commands", new Object[]{ftf.functionName(), ftf.functionType()})));
        }
    }

    private static <E extends Expression> void checkCommandsBeforeExpression(LogicalPlan plan, Expression condition, Class<E> typeToken, Predicate<LogicalPlan> commandCheck, Function<E, String> typeErrorMsgProvider, Set<Failure> failures) {
        condition.forEachDown(typeToken, exp -> plan.forEachDown(LogicalPlan.class, lp -> {
            if (!commandCheck.test((LogicalPlan)((Object)lp))) {
                failures.add(Failure.fail(plan, "{} cannot be used after {}", typeErrorMsgProvider.apply(exp), lp.sourceText().split(" ")[0].toUpperCase(Locale.ROOT)));
            }
        }));
    }

    private static void checkFullTextFunctionsParents(Expression condition, Set<Failure> failures) {
        Verifier.forEachFullTextFunctionParent(condition, (ftf, parent) -> {
            if (!(parent instanceof FullTextFunction || parent instanceof BinaryLogic || parent instanceof Not)) {
                failures.add(Failure.fail(condition, "Invalid condition [{}]. [{}] {} can't be used with {}", new Object[]{condition.sourceText(), ftf.functionName(), ftf.functionType(), ((org.elasticsearch.xpack.esql.core.expression.function.Function)parent).functionName()}));
            }
        });
    }

    private static FullTextFunction forEachFullTextFunctionParent(Expression condition, BiConsumer<FullTextFunction, Expression> action) {
        if (condition instanceof FullTextFunction) {
            FullTextFunction ftf = (FullTextFunction)condition;
            return ftf;
        }
        for (Expression child : condition.children()) {
            FullTextFunction foundMatchingChild = Verifier.forEachFullTextFunctionParent(child, action);
            if (foundMatchingChild == null) continue;
            action.accept(foundMatchingChild, condition);
            return foundMatchingChild;
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$checkInvalidNamedExpressionUsage$28(GroupingFunction gf, Expression ex) {
        Alias a;
        return ex instanceof Alias && (a = (Alias)ex).child().semanticEquals((Expression)gf);
    }
}

