/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.bridge;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.elasticsearch.entitlement.bridge.EntitlementChecker;

public class EntitlementCheckerHandle {
    public static EntitlementChecker instance() {
        return Holder.instance;
    }

    private EntitlementCheckerHandle() {
    }

    private static class Holder {
        private static final EntitlementChecker instance;

        private Holder() {
        }

        static {
            Method checkerMethod;
            Class<?> clazz;
            String initClazz = "org.elasticsearch.entitlement.initialization.EntitlementInitialization";
            try {
                clazz = ClassLoader.getSystemClassLoader().loadClass(initClazz);
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError("java.base cannot find entitlement initialziation", e);
            }
            try {
                checkerMethod = clazz.getMethod("checker", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError("EntitlementInitialization is missing checker() method", e);
            }
            try {
                instance = (EntitlementChecker)checkerMethod.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

