/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.telemetry;

import java.util.HashMap;
import java.util.Objects;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.telemetry.metric.LongCounter;
import org.elasticsearch.telemetry.metric.MeterRegistry;
import org.elasticsearch.xpack.inference.telemetry.InferenceStats;

public class ApmInferenceStats
implements InferenceStats {
    private final LongCounter inferenceAPMRequestCounter;

    public ApmInferenceStats(LongCounter inferenceAPMRequestCounter) {
        this.inferenceAPMRequestCounter = Objects.requireNonNull(inferenceAPMRequestCounter);
    }

    @Override
    public void incrementRequestCount(Model model) {
        String service = model.getConfigurations().getService();
        TaskType taskType = model.getTaskType();
        String modelId = model.getServiceSettings().modelId();
        HashMap<String, String> attributes = new HashMap<String, String>(5);
        attributes.put("service", service);
        attributes.put("task_type", taskType.toString());
        if (modelId != null) {
            attributes.put("model_id", modelId);
        }
        this.inferenceAPMRequestCounter.incrementBy(1L, attributes);
    }

    public static ApmInferenceStats create(MeterRegistry meterRegistry) {
        return new ApmInferenceStats(meterRegistry.registerLongCounter("es.inference.requests.count.total", "Inference API request counts for a particular service, task type, model ID", "operations"));
    }
}

