/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.response.cohere;

import java.util.Map;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorMessage;

public class CohereErrorResponseEntity
implements ErrorMessage {
    private final String errorMessage;

    private CohereErrorResponseEntity(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CohereErrorResponseEntity fromResponse(HttpResult response) {
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, response.body());){
            Map responseMap = jsonParser.map();
            String message = (String)responseMap.get("message");
            if (message == null) return null;
            CohereErrorResponseEntity cohereErrorResponseEntity = new CohereErrorResponseEntity(message);
            return cohereErrorResponseEntity;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

