/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.googlevertexai;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Collections;
import java.util.List;
import org.apache.http.client.methods.HttpPost;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiSecretSettings;

public interface GoogleVertexAiRequest
extends Request {
    public static final List<String> AUTH_SCOPE = Collections.singletonList("https://www.googleapis.com/auth/cloud-platform");

    public static void decorateWithBearerToken(HttpPost httpPost, GoogleVertexAiSecretSettings secretSettings) {
        SpecialPermission.check();
        try {
            AccessController.doPrivileged(() -> {
                GoogleCredentials credentials = ServiceAccountCredentials.fromStream((InputStream)new ByteArrayInputStream(secretSettings.serviceAccountJson().toString().getBytes(StandardCharsets.UTF_8))).createScoped(AUTH_SCOPE);
                credentials.refreshIfExpired();
                httpPost.setHeader(RequestUtils.createAuthBearerHeader(new SecureString(credentials.getAccessToken().getTokenValue().toCharArray())));
                return null;
            });
        }
        catch (Exception e) {
            throw new ElasticsearchStatusException(e.getMessage(), RestStatus.FORBIDDEN, (Throwable)e, new Object[0]);
        }
    }
}

