/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.action.elastic;

import java.util.Objects;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.action.elastic.ElasticInferenceServiceActionVisitor;
import org.elasticsearch.xpack.inference.external.http.sender.ElasticInferenceServiceSparseEmbeddingsRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceSparseEmbeddingsModel;

public class ElasticInferenceServiceActionCreator
implements ElasticInferenceServiceActionVisitor {
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public ElasticInferenceServiceActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(ElasticInferenceServiceSparseEmbeddingsModel model) {
        ElasticInferenceServiceSparseEmbeddingsRequestManager requestManager = new ElasticInferenceServiceSparseEmbeddingsRequestManager(model, this.serviceComponents);
        String errorMessage = ActionUtils.constructFailedToSendRequestMessage(model.uri(), "Elastic Inference Service sparse embeddings");
        return new SenderExecutableAction(this.sender, requestManager, errorMessage);
    }
}

