/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.application.connector.ConnectorConfiguration;
import org.elasticsearch.xpack.application.connector.action.ConnectorActionRequest;
import org.elasticsearch.xpack.application.connector.action.ConnectorUpdateActionResponse;

public class UpdateConnectorConfigurationAction {
    public static final String NAME = "indices:data/write/xpack/connector/update_configuration";
    public static final ActionType<ConnectorUpdateActionResponse> INSTANCE = new ActionType("indices:data/write/xpack/connector/update_configuration");

    private UpdateConnectorConfigurationAction() {
    }

    public static class Request
    extends ConnectorActionRequest
    implements ToXContentObject {
        private final String connectorId;
        private final Map<String, ConnectorConfiguration> configuration;
        private final Map<String, Object> configurationValues;
        private static final ParseField VALUES_FIELD = new ParseField("values", new String[0]);
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("connector_update_configuration_request", false, (args, connectorId) -> new Request((String)connectorId, (Map)args[0], (Map)args[1]));

        public Request(String connectorId, Map<String, ConnectorConfiguration> configuration, Map<String, Object> configurationValues) {
            this.connectorId = connectorId;
            this.configuration = configuration;
            this.configurationValues = configurationValues;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.connectorId = in.readString();
            this.configuration = in.readMap(ConnectorConfiguration::new);
            this.configurationValues = in.readGenericMap();
        }

        public String getConnectorId() {
            return this.connectorId;
        }

        public Map<String, ConnectorConfiguration> getConfiguration() {
            return this.configuration;
        }

        public Map<String, Map<String, Object>> getConfigurationAsMap() {
            return this.configuration.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ConnectorConfiguration)entry.getValue()).toMap()));
        }

        public Map<String, Object> getConfigurationValues() {
            return this.configurationValues;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.connectorId)) {
                validationException = ValidateActions.addValidationError((String)"[connector_id] cannot be [null] or [\"\"].", validationException);
            }
            if (this.configuration == null && this.configurationValues == null) {
                validationException = ValidateActions.addValidationError((String)"[configuration] and [values] cannot both be null.", (ActionRequestValidationException)validationException);
            }
            if (this.configuration != null && this.configurationValues != null) {
                validationException = ValidateActions.addValidationError((String)"[configuration] and [values] cannot both be provided in the same request.", (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public static Request fromXContent(XContentParser parser, String connectorId) throws IOException {
            return (Request)((Object)PARSER.parse(parser, (Object)connectorId));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Connector.CONFIGURATION_FIELD.getPreferredName(), this.configuration);
            builder.field(VALUES_FIELD.getPreferredName(), this.configurationValues);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.connectorId);
            out.writeMap(this.configuration, StreamOutput::writeWriteable);
            out.writeGenericMap(this.configurationValues);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.connectorId, request.connectorId) && Objects.equals(this.configuration, request.configuration) && Objects.equals(this.configurationValues, request.configurationValues);
        }

        public int hashCode() {
            return Objects.hash(this.connectorId, this.configuration, this.configurationValues);
        }

        static {
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(HashMap::new, ConnectorConfiguration::fromXContent), Connector.CONFIGURATION_FIELD, ObjectParser.ValueType.OBJECT);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), VALUES_FIELD, ObjectParser.ValueType.VALUE_OBJECT_ARRAY);
        }
    }
}

