/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.analytics.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.application.analytics.AnalyticsCollection;

public class GetAnalyticsCollectionAction {
    public static final String NAME = "cluster:admin/xpack/application/analytics/get";
    public static final ActionType<Response> INSTANCE = new ActionType("cluster:admin/xpack/application/analytics/get");

    private GetAnalyticsCollectionAction() {
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final List<AnalyticsCollection> collections;
        public static final ParseField EVENT_DATA_STREAM_FIELD = new ParseField("event_data_stream", new String[0]);
        public static final ParseField EVENT_DATA_STREAM_NAME_FIELD = new ParseField("name", new String[0]);

        public Response(StreamInput in) throws IOException {
            super(in);
            this.collections = in.readCollectionAsList(AnalyticsCollection::new);
        }

        public Response(List<AnalyticsCollection> collections) {
            this.collections = collections;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            for (AnalyticsCollection collection : this.collections) {
                builder.startObject(collection.getName());
                builder.startObject(EVENT_DATA_STREAM_FIELD.getPreferredName());
                builder.field(EVENT_DATA_STREAM_NAME_FIELD.getPreferredName(), collection.getEventDataStream());
                builder.endObject();
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.collections);
        }

        public List<AnalyticsCollection> getAnalyticsCollections() {
            return this.collections;
        }

        public int hashCode() {
            return Objects.hash(this.collections);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.collections, response.collections);
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request>
    implements ToXContentObject {
        private final String[] names;
        public static ParseField NAMES_FIELD = new ParseField("names", new String[0]);

        public Request(TimeValue masterNodeTimeout, String[] names) {
            super(masterNodeTimeout);
            this.names = Objects.requireNonNull(names, "Collection names cannot be null");
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.names = in.readStringArray();
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.names);
        }

        public String[] getNames() {
            return this.names;
        }

        public int hashCode() {
            return Arrays.hashCode(this.names);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Arrays.equals(this.names, request.names);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(NAMES_FIELD.getPreferredName(), this.names);
            builder.endObject();
            return builder;
        }
    }
}

