/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.textstructure.structurefinder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.grok.Grok;
import org.elasticsearch.grok.GrokBuiltinPatterns;
import org.elasticsearch.grok.PatternBank;
import org.elasticsearch.xpack.core.textstructure.structurefinder.FieldStats;
import org.elasticsearch.xpack.textstructure.structurefinder.FieldStatsCalculator;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureOverrides;
import org.elasticsearch.xpack.textstructure.structurefinder.TimeoutChecker;
import org.elasticsearch.xpack.textstructure.structurefinder.TimestampFormatFinder;

public final class TextStructureUtils {
    private static final boolean DEFAULT_ECS_COMPATIBILITY = false;
    private static final Logger logger = LogManager.getLogger(TextStructureUtils.class);
    public static final String DEFAULT_TIMESTAMP_FIELD = "@timestamp";
    public static final String MAPPING_TYPE_SETTING = "type";
    public static final String MAPPING_FORMAT_SETTING = "format";
    public static final String MAPPING_PROPERTIES_SETTING = "properties";
    public static final Map<String, String> DATE_MAPPING_WITHOUT_FORMAT = Collections.singletonMap("type", "date");
    public static final String NANOSECOND_DATE_OUTPUT_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSSXXX";
    public static final Set<String> CONVERTIBLE_TYPES = Set.of("integer", "long", "float", "double", "boolean");
    public static final String NULL_TIMESTAMP_FORMAT = "null";
    private static final PatternBank EXTENDED_PATTERNS;
    private static final int NUM_TOP_HITS = 10;
    private static final Grok NUMBER_GROK;
    private static final Grok IP_GROK;
    private static final Grok GEO_POINT_WKT;
    private static final Grok GEO_WKT;
    private static final int KEYWORD_MAX_LEN = 256;
    private static final int KEYWORD_MAX_SPACES = 5;
    private static final String BEAT_TIMEZONE_FIELD = "event.timezone";

    private TextStructureUtils() {
    }

    static Tuple<String, TimestampFormatFinder> guessTimestampField(List<String> explanation, List<Map<String, ?>> sampleRecords, TextStructureOverrides overrides, TimeoutChecker timeoutChecker) {
        if (sampleRecords.isEmpty()) {
            return null;
        }
        if (NULL_TIMESTAMP_FORMAT.equals(overrides.getTimestampFormat())) {
            return null;
        }
        StringBuilder exceptionMsg = null;
        for (Tuple<String, TimestampFormatFinder> candidate : TextStructureUtils.findCandidates(explanation, sampleRecords, overrides, timeoutChecker)) {
            String fieldName = (String)candidate.v1();
            TimestampFormatFinder timestampFormatFinder = (TimestampFormatFinder)candidate.v2();
            boolean allGood = true;
            for (Map<String, ?> sampleRecord : sampleRecords.subList(1, sampleRecords.size())) {
                Object fieldValue = sampleRecord.get(fieldName);
                if (fieldValue == null) {
                    if (overrides.getTimestampField() != null) {
                        throw new IllegalArgumentException("Specified timestamp field [" + overrides.getTimestampField() + "] is not present in record [" + String.valueOf(sampleRecord) + "]");
                    }
                    explanation.add("First sample match [" + fieldName + "] ruled out because record [" + String.valueOf(sampleRecord) + "] doesn't have field");
                    allGood = false;
                    break;
                }
                timeoutChecker.check("timestamp field determination");
                try {
                    timestampFormatFinder.addSample(fieldValue.toString());
                }
                catch (IllegalArgumentException e) {
                    if (overrides.getTimestampFormat() != null) {
                        if (exceptionMsg == null) {
                            exceptionMsg = new StringBuilder("Specified timestamp format [" + overrides.getTimestampFormat() + "] does not match");
                        } else {
                            exceptionMsg.append(", nor");
                        }
                        exceptionMsg.append(" for record [").append(sampleRecord).append("] in field [").append(fieldName).append("]");
                    }
                    explanation.add("First sample match " + String.valueOf(timestampFormatFinder.getRawJavaTimestampFormats()) + " ruled out because record [" + String.valueOf(sampleRecord) + "] does not match");
                    allGood = false;
                    break;
                }
            }
            if (!allGood) continue;
            explanation.add((overrides.getTimestampField() == null ? "Guessing timestamp" : "Timestamp") + " field is [" + fieldName + "] with format " + String.valueOf(timestampFormatFinder.getJavaTimestampFormats()));
            return candidate;
        }
        if (exceptionMsg != null) {
            throw new IllegalArgumentException(exceptionMsg.toString());
        }
        return null;
    }

    private static List<Tuple<String, TimestampFormatFinder>> findCandidates(List<String> explanation, List<Map<String, ?>> sampleRecords, TextStructureOverrides overrides, TimeoutChecker timeoutChecker) {
        assert (!sampleRecords.isEmpty());
        Map<String, ?> firstRecord = sampleRecords.get(0);
        String onlyConsiderField = overrides.getTimestampField();
        if (onlyConsiderField != null && firstRecord.get(onlyConsiderField) == null) {
            throw new IllegalArgumentException("Specified timestamp field [" + overrides.getTimestampField() + "] is not present in record [" + String.valueOf(firstRecord) + "]");
        }
        ArrayList<Tuple<String, TimestampFormatFinder>> candidates = new ArrayList<Tuple<String, TimestampFormatFinder>>();
        for (Map.Entry<String, ?> field : firstRecord.entrySet()) {
            Object value;
            String fieldName = field.getKey();
            if (onlyConsiderField != null && !onlyConsiderField.equals(fieldName) || (value = field.getValue()) == null) continue;
            TimestampFormatFinder timestampFormatFinder = new TimestampFormatFinder(explanation, overrides.getTimestampFormat(), true, true, true, timeoutChecker, "v1".equals(overrides.getEcsCompatibility()));
            try {
                timestampFormatFinder.addSample(value.toString());
                candidates.add((Tuple<String, TimestampFormatFinder>)new Tuple((Object)fieldName, (Object)timestampFormatFinder));
                explanation.add("First sample timestamp match " + String.valueOf(timestampFormatFinder.getRawJavaTimestampFormats()) + " for field [" + fieldName + "]");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (candidates.isEmpty() && overrides.getTimestampFormat() != null) {
            throw new IllegalArgumentException("Specified timestamp format [" + overrides.getTimestampFormat() + "] does not match for record [" + String.valueOf(firstRecord) + "]");
        }
        return candidates;
    }

    static Tuple<SortedMap<String, Object>, SortedMap<String, FieldStats>> guessMappingsAndCalculateFieldStats(List<String> explanation, List<Map<String, ?>> sampleRecords, TimeoutChecker timeoutChecker, String timestampFormatOverride) {
        return TextStructureUtils.guessMappingsAndCalculateFieldStats(explanation, sampleRecords, timeoutChecker, false, timestampFormatOverride);
    }

    static Tuple<SortedMap<String, Object>, SortedMap<String, FieldStats>> guessMappingsAndCalculateFieldStats(List<String> explanation, List<Map<String, ?>> sampleRecords, TimeoutChecker timeoutChecker, boolean ecsCompatibility) {
        return TextStructureUtils.guessMappingsAndCalculateFieldStats(explanation, sampleRecords, timeoutChecker, ecsCompatibility, null);
    }

    static Tuple<SortedMap<String, Object>, SortedMap<String, FieldStats>> guessMappingsAndCalculateFieldStats(List<String> explanation, List<Map<String, ?>> sampleRecords, TimeoutChecker timeoutChecker, boolean ecsCompatibility, String timestampFormatOverride) {
        TreeMap<String, Object> mappings = new TreeMap<String, Object>();
        TreeMap<String, FieldStats> fieldStats = new TreeMap<String, FieldStats>();
        Set uniqueFieldNames = sampleRecords.stream().flatMap(record -> record.keySet().stream()).collect(Collectors.toSet());
        for (String fieldName : uniqueFieldNames) {
            List<Object> fieldValues;
            Tuple<Map<String, String>, FieldStats> mappingAndFieldStats = TextStructureUtils.guessMappingAndCalculateFieldStats(explanation, fieldName, fieldValues = sampleRecords.stream().map(record -> record.get(fieldName)).filter(fieldValue -> fieldValue != null).collect(Collectors.toList()), timeoutChecker, ecsCompatibility, timestampFormatOverride);
            if (mappingAndFieldStats == null) continue;
            if (mappingAndFieldStats.v1() != null) {
                mappings.put(fieldName, mappingAndFieldStats.v1());
            }
            if (mappingAndFieldStats.v2() == null) continue;
            fieldStats.put(fieldName, (FieldStats)mappingAndFieldStats.v2());
        }
        return new Tuple(mappings, fieldStats);
    }

    static Tuple<Map<String, String>, FieldStats> guessMappingAndCalculateFieldStats(List<String> explanation, String fieldName, List<Object> fieldValues, TimeoutChecker timeoutChecker, boolean ecsCompatibility) {
        return TextStructureUtils.guessMappingAndCalculateFieldStats(explanation, fieldName, fieldValues, timeoutChecker, ecsCompatibility, null);
    }

    static Tuple<Map<String, String>, FieldStats> guessMappingAndCalculateFieldStats(List<String> explanation, String fieldName, List<Object> fieldValues, TimeoutChecker timeoutChecker, boolean ecsCompatibility, String timestampFormatOverride) {
        if (fieldValues == null || fieldValues.isEmpty()) {
            return null;
        }
        if (fieldValues.stream().anyMatch(value -> value instanceof Map)) {
            if (fieldValues.stream().allMatch(value -> value instanceof Map)) {
                return new Tuple(Collections.singletonMap(MAPPING_TYPE_SETTING, "object"), null);
            }
            throw new IllegalArgumentException("Field [" + fieldName + "] has both object and non-object values - this is not supported by Elasticsearch");
        }
        if (fieldValues.stream().anyMatch(value -> value instanceof List || value instanceof Object[])) {
            return TextStructureUtils.guessMappingAndCalculateFieldStats(explanation, fieldName, fieldValues.stream().flatMap(TextStructureUtils::flatten).collect(Collectors.toList()), timeoutChecker, ecsCompatibility, timestampFormatOverride);
        }
        Collection fieldValuesAsStrings = fieldValues.stream().map(Object::toString).collect(Collectors.toList());
        Map<String, String> mapping = TextStructureUtils.guessScalarMapping(explanation, fieldName, fieldValuesAsStrings, timeoutChecker, ecsCompatibility, timestampFormatOverride);
        timeoutChecker.check("mapping determination");
        return new Tuple(mapping, (Object)TextStructureUtils.calculateFieldStats(mapping, fieldValuesAsStrings, timeoutChecker));
    }

    private static Stream<Object> flatten(Object value) {
        if (value instanceof List) {
            List objectList = (List)value;
            return objectList.stream();
        }
        if (value instanceof Object[]) {
            return Arrays.stream((Object[])value);
        }
        return Stream.of(value);
    }

    static Map<String, String> findTimestampMapping(List<String> explanation, Collection<String> fieldValues, TimeoutChecker timeoutChecker, boolean ecsCompatibility) {
        assert (!fieldValues.isEmpty());
        TimestampFormatFinder timestampFormatFinder = new TimestampFormatFinder(explanation, true, true, true, timeoutChecker, ecsCompatibility);
        fieldValues.forEach(timestampFormatFinder::addSample);
        return timestampFormatFinder.getEsDateMappingTypeWithFormat();
    }

    static Map<String, String> guessScalarMapping(List<String> explanation, String fieldName, Collection<String> fieldValues, TimeoutChecker timeoutChecker, boolean ecsCompatibility) {
        return TextStructureUtils.guessScalarMapping(explanation, fieldName, fieldValues, timeoutChecker, ecsCompatibility, null);
    }

    static Map<String, String> guessScalarMapping(List<String> explanation, String fieldName, Collection<String> fieldValues, TimeoutChecker timeoutChecker, boolean ecsCompatibility, String timestampFormatOverride) {
        assert (!fieldValues.isEmpty());
        if (fieldValues.stream().allMatch(value -> "true".equals(value) || "false".equals(value))) {
            return Collections.singletonMap(MAPPING_TYPE_SETTING, "boolean");
        }
        try {
            return TextStructureUtils.findTimestampMapping(explanation, fieldValues, timeoutChecker, ecsCompatibility);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (fieldValues.stream().allMatch(arg_0 -> ((Grok)NUMBER_GROK).match(arg_0))) {
                try {
                    fieldValues.forEach(Long::parseLong);
                    return Collections.singletonMap(MAPPING_TYPE_SETTING, "long");
                }
                catch (NumberFormatException e) {
                    explanation.add("Rejecting type 'long' for field [" + fieldName + "] due to parse failure: [" + e.getMessage() + "]");
                    try {
                        fieldValues.forEach(Double::parseDouble);
                        return Collections.singletonMap(MAPPING_TYPE_SETTING, "double");
                    }
                    catch (NumberFormatException e2) {
                        explanation.add("Rejecting type 'double' for field [" + fieldName + "] due to parse failure: [" + e2.getMessage() + "]");
                    }
                }
            } else {
                if (fieldValues.stream().allMatch(arg_0 -> ((Grok)IP_GROK).match(arg_0))) {
                    return Collections.singletonMap(MAPPING_TYPE_SETTING, "ip");
                }
                if (fieldValues.stream().allMatch(arg_0 -> ((Grok)GEO_POINT_WKT).match(arg_0))) {
                    return Collections.singletonMap(MAPPING_TYPE_SETTING, "geo_point");
                }
                if (fieldValues.stream().allMatch(arg_0 -> ((Grok)GEO_WKT).match(arg_0))) {
                    return Collections.singletonMap(MAPPING_TYPE_SETTING, "geo_shape");
                }
            }
            if (fieldValues.stream().anyMatch(TextStructureUtils::isMoreLikelyTextThanKeyword)) {
                return Collections.singletonMap(MAPPING_TYPE_SETTING, "text");
            }
            return Collections.singletonMap(MAPPING_TYPE_SETTING, "keyword");
        }
    }

    static FieldStats calculateFieldStats(Map<String, String> mapping, Collection<String> fieldValues, TimeoutChecker timeoutChecker) {
        FieldStatsCalculator calculator = new FieldStatsCalculator(mapping);
        calculator.accept(fieldValues);
        timeoutChecker.check("field stats calculation");
        return calculator.calculate(10);
    }

    static boolean isMoreLikelyTextThanKeyword(String str) {
        int length = str.length();
        return length > 256 || length - str.replaceAll("\\s", "").length() > 5;
    }

    public static Map<String, Object> makeIngestPipelineDefinition(String grokPattern, Map<String, String> customGrokPatternDefinitions, Map<String, Object> csvProcessorSettings, Map<String, Object> mappingsForConversions, String timestampField, List<String> timestampFormats, boolean needClientTimezone, boolean needNanosecondPrecision, String ecsCompatibility) {
        if (grokPattern == null && csvProcessorSettings == null && timestampField == null) {
            return null;
        }
        LinkedHashMap<String, Object> pipeline = new LinkedHashMap<String, Object>();
        pipeline.put("description", "Ingest pipeline created by text structure finder");
        ArrayList<Map<String, Object>> processors = new ArrayList<Map<String, Object>>();
        if (grokPattern != null) {
            LinkedHashMap<String, Object> grokProcessorSettings = new LinkedHashMap<String, Object>();
            grokProcessorSettings.put("field", "message");
            grokProcessorSettings.put("patterns", Collections.singletonList(grokPattern));
            if (!customGrokPatternDefinitions.isEmpty()) {
                grokProcessorSettings.put("pattern_definitions", customGrokPatternDefinitions);
            }
            grokProcessorSettings.put("ecs_compatibility", ecsCompatibility == null || ecsCompatibility.isEmpty() ? "disabled" : ecsCompatibility);
            processors.add(Collections.singletonMap("grok", grokProcessorSettings));
        } else assert (customGrokPatternDefinitions.isEmpty());
        if (csvProcessorSettings != null) {
            processors.add(Collections.singletonMap("csv", csvProcessorSettings));
        }
        if (timestampField != null) {
            LinkedHashMap dateProcessorSettings = new LinkedHashMap();
            dateProcessorSettings.put("field", timestampField);
            if (needClientTimezone) {
                dateProcessorSettings.put("timezone", "{{ event.timezone }}");
            }
            dateProcessorSettings.put("formats", timestampFormats);
            if (needNanosecondPrecision) {
                dateProcessorSettings.put("output_format", NANOSECOND_DATE_OUTPUT_FORMAT);
            }
            processors.add(Collections.singletonMap("date", dateProcessorSettings));
        }
        for (Map.Entry entry : mappingsForConversions.entrySet()) {
            Object type;
            String fieldName = (String)entry.getKey();
            Object values = entry.getValue();
            if (!(values instanceof Map) || !CONVERTIBLE_TYPES.contains(type = ((Map)values).get(MAPPING_TYPE_SETTING))) continue;
            LinkedHashMap<String, Object> convertProcessorSettings = new LinkedHashMap<String, Object>();
            convertProcessorSettings.put("field", fieldName);
            convertProcessorSettings.put(MAPPING_TYPE_SETTING, type);
            convertProcessorSettings.put("ignore_missing", true);
            processors.add(Collections.singletonMap("convert", convertProcessorSettings));
        }
        if (csvProcessorSettings != null) {
            Object field = csvProcessorSettings.get("field");
            assert (field != null);
            Object object = csvProcessorSettings.get("target_fields");
            assert (object instanceof List);
            if (!((List)object).contains(field)) {
                processors.add(Collections.singletonMap("remove", Collections.singletonMap("field", field)));
            }
        }
        if (grokPattern != null && timestampField != null) {
            processors.add(Collections.singletonMap("remove", Collections.singletonMap("field", timestampField)));
        }
        pipeline.put("processors", processors);
        return pipeline;
    }

    static {
        HashMap<String, String> patterns = new HashMap<String, String>();
        patterns.put("GEO_POINT", "%{NUMBER} %{NUMBER}");
        patterns.put("GEO_POINT_GROUP", "\\(%{GEO_POINT}, (?:%{GEO_POINT}, )*%{GEO_POINT}\\)");
        patterns.put("GEO_POINT_GROUP_GROUP", "\\(%{GEO_POINT_GROUP}(?:, %{GEO_POINT_GROUP})*\\)");
        patterns.put("WKT_POINT", "POINT \\(%{GEO_POINT}\\)");
        patterns.put("WKT_LINESTRING", "LINESTRING %{GEO_POINT_GROUP}");
        patterns.put("WKT_MULTIPOINT", "MULTIPOINT %{GEO_POINT_GROUP}");
        patterns.put("WKT_POLYGON", "POLYGON %{GEO_POINT_GROUP_GROUP}");
        patterns.put("WKT_MULTILINESTRING", "MULTILINESTRING %{GEO_POINT_GROUP_GROUP}");
        patterns.put("WKT_MULTIPOLYGON", "MULTIPOLYGON \\(%{GEO_POINT_GROUP_GROUP}(?:, %{GEO_POINT_GROUP_GROUP})*\\)");
        patterns.put("WKT_BBOX", "BBOX \\(%{NUMBER}, %{NUMBER}, %{NUMBER}, %{NUMBER}\\)");
        patterns.put("WKT_ANY", "(?:%{WKT_POINT}|%{WKT_LINESTRING}|%{WKT_MULTIPOINT}|%{WKT_POLYGON}|%{WKT_MULTILINESTRING}|%{WKT_MULTIPOLYGON}|%{WKT_BBOX})");
        patterns.put("WKT_GEOMETRYCOLLECTION", "GEOMETRYCOLLECTION \\(%{WKT_ANY}(?:, %{WKT_ANY})\\)");
        EXTENDED_PATTERNS = GrokBuiltinPatterns.legacyPatterns().extendWith(patterns);
        NUMBER_GROK = new Grok(GrokBuiltinPatterns.legacyPatterns(), "^%{NUMBER}(?:[eE][+-]?[0-3]?[0-9]{1,2})?$", TimeoutChecker.watchdog, arg_0 -> ((Logger)logger).warn(arg_0));
        IP_GROK = new Grok(GrokBuiltinPatterns.legacyPatterns(), "^%{IP}$", TimeoutChecker.watchdog, arg_0 -> ((Logger)logger).warn(arg_0));
        GEO_POINT_WKT = new Grok(EXTENDED_PATTERNS, "^%{WKT_POINT}$", TimeoutChecker.watchdog, arg_0 -> ((Logger)logger).warn(arg_0));
        GEO_WKT = new Grok(EXTENDED_PATTERNS, "^(?:%{WKT_ANY}|%{WKT_GEOMETRYCOLLECTION})$", TimeoutChecker.watchdog, arg_0 -> ((Logger)logger).warn(arg_0));
    }
}

