/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr;

import java.time.Instant;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.CCRInfoTransportAction;
import org.elasticsearch.xpack.core.XPackFeatureUsage;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.ccr.AutoFollowMetadata;
import org.elasticsearch.xpack.core.ccr.CcrConstants;

public class CCRUsageTransportAction
extends XPackUsageFeatureTransportAction {
    private final Settings settings;
    private final XPackLicenseState licenseState;

    @Inject
    public CCRUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Settings settings, XPackLicenseState licenseState) {
        super(XPackUsageFeatureAction.CCR.name(), transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver);
        this.settings = settings;
        this.licenseState = licenseState;
    }

    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        Metadata metadata = state.metadata();
        int numberOfFollowerIndices = 0;
        long lastFollowerIndexCreationDate = 0L;
        for (IndexMetadata imd : metadata) {
            if (imd.getCustomData("ccr") == null) continue;
            ++numberOfFollowerIndices;
            if (lastFollowerIndexCreationDate >= imd.getCreationDate()) continue;
            lastFollowerIndexCreationDate = imd.getCreationDate();
        }
        AutoFollowMetadata autoFollowMetadata = (AutoFollowMetadata)metadata.custom("ccr_auto_follow");
        int numberOfAutoFollowPatterns = autoFollowMetadata != null ? autoFollowMetadata.getPatterns().size() : 0;
        Long lastFollowTimeInMillis = numberOfFollowerIndices == 0 ? null : Long.valueOf(Math.max(0L, Instant.now().toEpochMilli() - lastFollowerIndexCreationDate));
        CCRInfoTransportAction.Usage usage = new CCRInfoTransportAction.Usage(CcrConstants.CCR_FEATURE.checkWithoutTracking(this.licenseState), (Boolean)XPackSettings.CCR_ENABLED_SETTING.get(this.settings), numberOfFollowerIndices, numberOfAutoFollowPatterns, lastFollowTimeInMillis);
        listener.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureUsage)usage));
    }
}

