/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.conditional;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;

public class IfConditional
extends Expression {
    private final Expression condition;
    private final Expression result;

    public IfConditional(Source source, Expression condition, Expression result) {
        super(source, Arrays.asList(condition, result));
        this.condition = condition;
        this.result = result;
    }

    public Expression condition() {
        return this.condition;
    }

    public Expression result() {
        return this.result;
    }

    public Nullability nullable() {
        return Nullability.UNKNOWN;
    }

    public DataType dataType() {
        return this.result.dataType();
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new IfConditional(this.source(), newChildren.get(0), newChildren.get(1));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, IfConditional::new, (Object)this.condition, (Object)this.result);
    }

    protected Expression.TypeResolution resolveType() {
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public int hashCode() {
        return Objects.hash(this.condition, this.result);
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            IfConditional that = (IfConditional)((Object)o);
            return Objects.equals(this.condition, that.condition) && Objects.equals(this.result, that.result);
        }
        return false;
    }
}

