/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function;

import org.elasticsearch.xpack.ql.ParsingException;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.expression.function.FunctionDefinition;
import org.elasticsearch.xpack.ql.expression.function.FunctionResolutionStrategy;
import org.elasticsearch.xpack.ql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.sql.expression.function.SqlFunctionDefinition;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SqlFunctionResolution implements FunctionResolutionStrategy
{
    DISTINCT{

        public Function buildResolved(UnresolvedFunction uf, Configuration cfg, FunctionDefinition def) {
            if (def instanceof SqlFunctionDefinition) {
                return ((SqlFunctionDefinition)def).builder().build(uf, cfg, new Object[]{true});
            }
            throw new ParsingException(uf.source(), "Cannot use {} on non-SQL function {}", new Object[]{this.name(), def});
        }

        public boolean isValidAlternative(FunctionDefinition def) {
            return false;
        }
    }
    ,
    EXTRACT{

        public Function buildResolved(UnresolvedFunction uf, Configuration cfg, FunctionDefinition def) {
            if (this.isValidAlternative(def)) {
                return ((SqlFunctionDefinition)def).builder().build(uf, cfg, new Object[0]);
            }
            return uf.withMessage("Invalid datetime field [" + uf.name() + "]. Use any datetime function.");
        }

        public boolean isValidAlternative(FunctionDefinition def) {
            return def instanceof SqlFunctionDefinition && ((SqlFunctionDefinition)def).extractViable();
        }

        public String kind() {
            return "datetime field";
        }
    };

}

