/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.runtime.policy;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.entitlement.runtime.policy.Entitlement;

public class Scope {
    public final String name;
    public final List<Entitlement> entitlements;

    public Scope(String name, List<Entitlement> entitlements) {
        this.name = Objects.requireNonNull(name);
        this.entitlements = Collections.unmodifiableList(Objects.requireNonNull(entitlements));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scope scope = (Scope)o;
        return Objects.equals(this.name, scope.name) && Objects.equals(this.entitlements, scope.entitlements);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.entitlements);
    }

    public String toString() {
        return "Scope{name='" + this.name + "', entitlements=" + String.valueOf(this.entitlements) + "}";
    }
}

