/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.logsdb.LogsDBInfoTransportAction;
import org.elasticsearch.xpack.logsdb.LogsDBUsageTransportAction;
import org.elasticsearch.xpack.logsdb.LogsdbIndexModeSettingsProvider;
import org.elasticsearch.xpack.logsdb.SyntheticSourceIndexSettingsProvider;
import org.elasticsearch.xpack.logsdb.SyntheticSourceLicenseService;

public class LogsDBPlugin
extends Plugin
implements ActionPlugin {
    private final Settings settings;
    private final SyntheticSourceLicenseService licenseService;
    public static final Setting<Boolean> CLUSTER_LOGSDB_ENABLED = Setting.boolSetting((String)"cluster.logsdb.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private final LogsdbIndexModeSettingsProvider logsdbIndexModeSettingsProvider;

    public LogsDBPlugin(Settings settings) {
        this.settings = settings;
        this.licenseService = new SyntheticSourceLicenseService(settings);
        this.logsdbIndexModeSettingsProvider = new LogsdbIndexModeSettingsProvider(settings);
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        this.licenseService.setLicenseService(this.getLicenseService());
        this.licenseService.setLicenseState(this.getLicenseState());
        ClusterSettings clusterSettings = services.clusterService().getClusterSettings();
        clusterSettings.addSettingsUpdateConsumer(SyntheticSourceLicenseService.FALLBACK_SETTING, this.licenseService::setSyntheticSourceFallback);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_LOGSDB_ENABLED, this.logsdbIndexModeSettingsProvider::updateClusterIndexModeLogsdbEnabled);
        return super.createComponents(services);
    }

    public Collection<IndexSettingProvider> getAdditionalIndexSettingProviders(IndexSettingProvider.Parameters parameters) {
        if (DiscoveryNode.isStateless((Settings)this.settings)) {
            return List.of(this.logsdbIndexModeSettingsProvider);
        }
        SyntheticSourceIndexSettingsProvider syntheticSettingProvider = new SyntheticSourceIndexSettingsProvider(this.licenseService, (CheckedFunction<IndexMetadata, MapperService, IOException>)parameters.mapperServiceFactory(), this.logsdbIndexModeSettingsProvider, () -> IndexVersion.min((IndexVersion)IndexVersion.current(), (IndexVersion)parameters.clusterService().state().nodes().getMaxDataNodeCompatibleIndexVersion()), () -> parameters.clusterService().state().nodes().getMinNodeVersion());
        return List.of(syntheticSettingProvider, this.logsdbIndexModeSettingsProvider);
    }

    public List<Setting<?>> getSettings() {
        return List.of(SyntheticSourceLicenseService.FALLBACK_SETTING, CLUSTER_LOGSDB_ENABLED);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> actions = new ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>>();
        actions.add(new ActionPlugin.ActionHandler(XPackUsageFeatureAction.LOGSDB, LogsDBUsageTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler(XPackInfoFeatureAction.LOGSDB, LogsDBInfoTransportAction.class));
        return actions;
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    protected LicenseService getLicenseService() {
        return XPackPlugin.getSharedLicenseService();
    }
}

