RabbitMQ `3.10.23` is a maintenance release in the `3.10.x` [release series](https://www.rabbitmq.com/versions.html).

This series [**reaches its end of community support** on July 31st, 2023](https://rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.10.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.10.0)
if upgrading from a version prior to 3.10.0.

This release **requires Erlang 24.3** and supports Erlang 25.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

Erlang versions older than 24.3 have reached [end of support](https://www.rabbitmq.com/which-erlang.html).

This release of RabbitMQ [requires Erlang 24.3.4.8](https://github.com/rabbitmq/rabbitmq-packaging/pull/35)
or later versions. Nodes **will fail to start** on older Erlang releases.

Erlang 25.3 is recommended: it offers much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.10.x/release-notes).


### Debian Package

#### Bug Fixes

 * Make-based source package builds were failing in an offline environment.

   GitHub issue: [#7869](https://github.com/rabbitmq/rabbitmq-server/issues/7869)


### RPM Package

#### Bug Fixes

 * Make-based source package builds were failing in an offline environment.

   GitHub issue: [#7869](https://github.com/rabbitmq/rabbitmq-server/issues/7869)


### Federation Plugin

#### Bug Fixes

 * URI parser incorrectly used the `password` query parameter to override the password
   value in authority (user info) part.

   The `password` query parameter can be used to specify private key password for
   upstream connections that use TLS.

   GitHub issue: [#8129](https://github.com/rabbitmq/rabbitmq-server/issues/8129)


### Shovel Plugin

#### Bug Fixes

 * URI parser incorrectly used the `password` query parameter to override the password
   value in authority (user info) part.

   The `password` query parameter can be used to specify private key password for Shovels
   that use TLS.

   GitHub issue: [#8129](https://github.com/rabbitmq/rabbitmq-server/issues/8129)


## Dependency Upgrades

None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.10.23.tar.xz`
instead of the source tarball produced by GitHub.
