/* original parser id follows */
/* yysccsid[] = "@(#)yaccpar	1.9 (Berkeley) 02/21/93" */
/* (use YYMAJOR/YYMINOR for ifdefs dependent on parser version) */

#define YYBYACC 1
#define YYMAJOR 2
#define YYMINOR 0
#define YYPATCH 20221106

#define YYEMPTY        (-1)
#define yyclearin      (yychar = YYEMPTY)
#define yyerrok        (yyerrflag = 0)
#define YYRECOVERING() (yyerrflag != 0)
#define YYENOMEM       (-2)
#define YYEOF          0
#undef YYBTYACC
#define YYBTYACC 0
#define YYDEBUGSTR YYPREFIX "debug"
#define YYPREFIX "yy"

#define YYPURE 0

#line 2 "mon_parse.y"
/* -*- C -*-
 *
 * mon_parse.y - Parser for the VICE built-in monitor.
 *
 * Written by
 *  Daniel Sladic <sladic@eecg.toronto.edu>
 *  Andreas Boose <viceteam@t-online.de>
 *  Thomas Giesel <skoe@directbox.com>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#include "vice.h"

#ifdef __GNUC__
#undef alloca
#define        alloca(n)       __builtin_alloca (n)
#else /* not __GNUC__ */
#ifdef HAVE_ALLOCA_H
#include <alloca.h>
#else  /* Not HAVE_ALLOCA_H  */
char *alloca();
#endif /* HAVE_ALLOCA_H.  */
#endif /* __GNUC__ */

#include <assert.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "asm.h"
#include "console.h"
#include "drive.h"
#include "interrupt.h"
#include "lib.h"
#include "machine.h"
#include "mon_breakpoint.h"
#include "mon_command.h"
#include "mon_disassemble.h"
#include "mon_drive.h"
#include "mon_file.h"
#include "mon_memmap.h"
#include "mon_memory.h"
#include "mon_register.h"
#include "mon_util.h"
#include "montypes.h"
#include "tapeport.h"
#include "resources.h"
#include "types.h"
#include "uimon.h"
#include "vsync.h"
#include "mon_profile.h"

#define join_ints(x,y) (LO16_TO_HI16(x)|y)
#define separate_int1(x) (HI16_TO_LO16(x))
#define separate_int2(x) (LO16(x))

static int yyerror(char *s);
static int temp;
static int resolve_datatype(unsigned guess_type, const char *num);
static int resolve_range(enum t_memspace memspace, MON_ADDR range[2],
                         const char *num);

/* Defined in the lexer */
extern int new_cmd, opt_asm;
extern int cur_len, last_len;

void free_buffer(void);
void make_buffer(char *str);
int yylex(void);

void set_yydebug(int val);

#define ERR_ILLEGAL_INPUT 1     /* Generic error as returned by yacc.  */
#define ERR_RANGE_BAD_START 2
#define ERR_RANGE_BAD_END 3
#define ERR_BAD_CMD 4
#define ERR_EXPECT_CHECKNUM 5
#define ERR_EXPECT_END_CMD 6
#define ERR_MISSING_CLOSE_PAREN 7
#define ERR_INCOMPLETE_COND_OP 8
#define ERR_EXPECT_FILENAME 9
#define ERR_ADDR_TOO_BIG 10
#define ERR_IMM_TOO_BIG 11
#define ERR_EXPECT_STRING 12
#define ERR_UNDEFINED_LABEL 13
#define ERR_EXPECT_DEVICE_NUM 14
#define ERR_EXPECT_ADDRESS 15
#define ERR_INVALID_REGISTER 16

#define BAD_ADDR (new_addr(e_invalid_space, 0))
#define CHECK_ADDR(x) ((x) == addr_mask(x))

/* set to YYDEBUG 1 to get parser debugging via "yydebug" command, requires to
   set_yydebug(1) in monitor.c:monitor_init */
#ifdef DEBUG
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

#ifdef YYSTYPE
#undef  YYSTYPE_IS_DECLARED
#define YYSTYPE_IS_DECLARED 1
#endif
#ifndef YYSTYPE_IS_DECLARED
#define YYSTYPE_IS_DECLARED 1
#line 123 "mon_parse.y"
typedef union YYSTYPE {
    MON_ADDR a;
    MON_ADDR range[2];
    int i;
    REG_ID reg;
    CONDITIONAL cond_op;
    cond_node_t *cond_node;
    RADIXTYPE rt;
    ACTION action;
    char *str;
    asm_mode_addr_info_t mode;
} YYSTYPE;
#endif /* !YYSTYPE_IS_DECLARED */
#line 164 "mon_parse.c"

/* compatibility with bison */
#ifdef YYPARSE_PARAM
/* compatibility with FreeBSD */
# ifdef YYPARSE_PARAM_TYPE
#  define YYPARSE_DECL() yyparse(YYPARSE_PARAM_TYPE YYPARSE_PARAM)
# else
#  define YYPARSE_DECL() yyparse(void *YYPARSE_PARAM)
# endif
#else
# define YYPARSE_DECL() yyparse(void)
#endif

/* Parameters sent to lex. */
#ifdef YYLEX_PARAM
# define YYLEX_DECL() yylex(void *YYLEX_PARAM)
# define YYLEX yylex(YYLEX_PARAM)
#else
# define YYLEX_DECL() yylex(void)
# define YYLEX yylex()
#endif

#if !(defined(yylex) || defined(YYSTATE))
int YYLEX_DECL();
#endif

/* Parameters sent to yyerror. */
#ifndef YYERROR_DECL
#define YYERROR_DECL() yyerror(const char *s)
#endif
#ifndef YYERROR_CALL
#define YYERROR_CALL(msg) yyerror(msg)
#endif

extern int YYPARSE_DECL();

#define H_NUMBER 257
#define D_NUMBER 258
#define O_NUMBER 259
#define B_NUMBER 260
#define CONVERT_OP 261
#define B_DATA 262
#define H_RANGE_GUESS 263
#define D_NUMBER_GUESS 264
#define O_NUMBER_GUESS 265
#define B_NUMBER_GUESS 266
#define BAD_CMD 267
#define MEM_OP 268
#define IF 269
#define MEM_COMP 270
#define MEM_DISK8 271
#define MEM_DISK9 272
#define MEM_DISK10 273
#define MEM_DISK11 274
#define EQUALS 275
#define TRAIL 276
#define CMD_SEP 277
#define LABEL_ASGN_COMMENT 278
#define CMD_LOG 279
#define CMD_LOGNAME 280
#define CMD_SIDEFX 281
#define CMD_DUMMY 282
#define CMD_RETURN 283
#define CMD_BLOCK_READ 284
#define CMD_BLOCK_WRITE 285
#define CMD_UP 286
#define CMD_DOWN 287
#define CMD_LOAD 288
#define CMD_BASICLOAD 289
#define CMD_SAVE 290
#define CMD_VERIFY 291
#define CMD_BVERIFY 292
#define CMD_IGNORE 293
#define CMD_HUNT 294
#define CMD_FILL 295
#define CMD_MOVE 296
#define CMD_GOTO 297
#define CMD_REGISTERS 298
#define CMD_READSPACE 299
#define CMD_WRITESPACE 300
#define CMD_RADIX 301
#define CMD_MEM_DISPLAY 302
#define CMD_BREAK 303
#define CMD_TRACE 304
#define CMD_IO 305
#define CMD_BRMON 306
#define CMD_COMPARE 307
#define CMD_DUMP 308
#define CMD_UNDUMP 309
#define CMD_EXIT 310
#define CMD_DELETE 311
#define CMD_CONDITION 312
#define CMD_COMMAND 313
#define CMD_ASSEMBLE 314
#define CMD_DISASSEMBLE 315
#define CMD_NEXT 316
#define CMD_STEP 317
#define CMD_PRINT 318
#define CMD_DEVICE 319
#define CMD_HELP 320
#define CMD_WATCH 321
#define CMD_DISK 322
#define CMD_QUIT 323
#define CMD_CHDIR 324
#define CMD_BANK 325
#define CMD_LOAD_LABELS 326
#define CMD_SAVE_LABELS 327
#define CMD_ADD_LABEL 328
#define CMD_DEL_LABEL 329
#define CMD_SHOW_LABELS 330
#define CMD_CLEAR_LABELS 331
#define CMD_RECORD 332
#define CMD_MON_STOP 333
#define CMD_PLAYBACK 334
#define CMD_CHAR_DISPLAY 335
#define CMD_SPRITE_DISPLAY 336
#define CMD_TEXT_DISPLAY 337
#define CMD_SCREENCODE_DISPLAY 338
#define CMD_ENTER_DATA 339
#define CMD_ENTER_BIN_DATA 340
#define CMD_KEYBUF 341
#define CMD_BLOAD 342
#define CMD_BSAVE 343
#define CMD_SCREEN 344
#define CMD_UNTIL 345
#define CMD_CPU 346
#define CMD_YYDEBUG 347
#define CMD_BACKTRACE 348
#define CMD_SCREENSHOT 349
#define CMD_PWD 350
#define CMD_DIR 351
#define CMD_MKDIR 352
#define CMD_RMDIR 353
#define CMD_RESOURCE_GET 354
#define CMD_RESOURCE_SET 355
#define CMD_LOAD_RESOURCES 356
#define CMD_SAVE_RESOURCES 357
#define CMD_ATTACH 358
#define CMD_DETACH 359
#define CMD_MON_RESET 360
#define CMD_TAPECTRL 361
#define CMD_TAPEOFFS 362
#define CMD_CARTFREEZE 363
#define CMD_UPDB 364
#define CMD_JPDB 365
#define CMD_CPUHISTORY 366
#define CMD_MEMMAPZAP 367
#define CMD_MEMMAPSHOW 368
#define CMD_MEMMAPSAVE 369
#define CMD_COMMENT 370
#define CMD_LIST 371
#define CMD_STOPWATCH 372
#define RESET 373
#define CMD_EXPORT 374
#define CMD_AUTOSTART 375
#define CMD_AUTOLOAD 376
#define CMD_MAINCPU_TRACE 377
#define CMD_WARP 378
#define CMD_PROFILE 379
#define FLAT 380
#define GRAPH 381
#define FUNC 382
#define DEPTH 383
#define DISASS 384
#define PROFILE_CONTEXT 385
#define CLEAR 386
#define CMD_LABEL_ASGN 387
#define L_PAREN 388
#define R_PAREN 389
#define ARG_IMMEDIATE 390
#define REG_A 391
#define REG_X 392
#define REG_Y 393
#define COMMA 394
#define INST_SEP 395
#define L_BRACKET 396
#define R_BRACKET 397
#define LESS_THAN 398
#define REG_U 399
#define REG_S 400
#define REG_PC 401
#define REG_PCR 402
#define REG_B 403
#define REG_C 404
#define REG_D 405
#define REG_E 406
#define REG_H 407
#define REG_L 408
#define REG_AF 409
#define REG_BC 410
#define REG_DE 411
#define REG_HL 412
#define REG_IX 413
#define REG_IY 414
#define REG_SP 415
#define REG_IXH 416
#define REG_IXL 417
#define REG_IYH 418
#define REG_IYL 419
#define PLUS 420
#define MINUS 421
#define STRING 422
#define FILENAME 423
#define R_O_L 424
#define R_O_L_Q 425
#define OPCODE 426
#define LABEL 427
#define BANKNAME 428
#define CPUTYPE 429
#define MON_REGISTER 430
#define COND_OP 431
#define RADIX_TYPE 432
#define INPUT_SPEC 433
#define CMD_CHECKPT_ON 434
#define CMD_CHECKPT_OFF 435
#define TOGGLE 436
#define MASK 437
#define YYERRCODE 256
typedef int YYINT;
static const YYINT yylhs[] = {                           -1,
    0,    0,    0,   35,   35,   37,   37,   37,   36,   36,
   36,   36,   36,   36,   36,   36,   36,   36,   36,   36,
   36,   38,   38,   38,   38,   38,   38,   38,   38,   38,
   38,   38,   38,   38,   38,   38,   38,   38,   38,   38,
   38,   38,   38,   38,   38,   38,   38,   38,   38,   38,
   38,   38,   38,   38,   38,   38,   38,   38,   38,   51,
   51,   51,   39,   39,   39,   39,   39,   39,   39,   39,
   39,   39,   39,   39,   39,   54,   41,   41,   41,   41,
   40,   40,   40,   40,   40,   40,   40,   40,   40,   40,
   40,   40,   40,   40,   40,   40,   40,   40,   40,   40,
   42,   42,   42,   42,   42,   42,   42,   42,   43,   43,
   43,   43,   43,   43,   43,   43,   43,   43,   43,   44,
   44,   44,   44,   44,   44,   44,   44,   44,   44,   44,
   44,   44,   44,   44,   44,   45,   45,   45,   45,   45,
   45,   45,   45,   45,   45,   45,   45,   45,   45,   45,
   45,   45,   45,   45,   45,   45,   45,   45,   45,   45,
   45,   45,   45,   45,   45,   45,   45,   45,   45,   45,
   45,   45,   45,   46,   46,   46,   46,   46,   46,   46,
   46,   46,   46,   46,   46,   46,   46,   46,   46,   46,
   46,   46,   46,   46,   46,   47,   47,   47,   48,   48,
   49,   24,   25,   25,   26,   29,   29,   14,   14,   19,
   19,   20,   20,   23,   23,   52,   52,   55,   18,   18,
   12,   12,    2,    2,    1,    1,    1,    4,    4,    3,
    3,    3,   50,   50,   15,   15,   15,   15,   15,   16,
   17,    9,    9,    9,    9,    9,    9,    9,    5,    5,
    6,    6,    6,    6,    6,    7,    7,    7,    7,   27,
   27,   28,   28,   30,   30,   31,   31,   31,   21,   21,
   10,   10,   10,   10,   11,   11,   13,   13,   13,    8,
    8,    8,    8,    8,   56,   56,   56,   22,   53,   53,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   33,   33,   33,   33,   34,
};
static const YYINT yylen[] = {                            2,
    1,    2,    1,    1,    2,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    2,    3,    3,    5,    3,    2,    2,    3,    2,
    3,    2,    4,    6,    8,   10,   12,    4,    6,    8,
   10,   12,   14,    2,    3,    3,    2,    4,    2,    4,
    2,    4,    2,    4,    2,    3,    2,    3,    1,    2,
    3,    3,    5,    3,    5,    3,    5,    3,    5,    3,
    2,    3,    2,    4,    5,    0,    5,    3,    3,    2,
    5,    5,    5,    5,    5,    3,    2,    3,    2,    3,
    2,    3,    2,    3,    2,    2,    2,    4,    5,    5,
    5,    2,    3,    2,    5,    2,    5,    2,    3,    2,
    3,    2,    3,    5,    3,    2,    5,    5,    4,    3,
    2,    3,    2,    3,    2,    3,    3,    2,    2,    3,
    2,    2,    2,    2,    3,    3,    3,    2,    3,    3,
    3,    3,    2,    3,    2,    3,    3,    3,    5,    3,
    4,    3,    3,    2,    4,    4,    2,    4,    2,    3,
    4,    3,    3,    2,    3,    2,    4,    4,    6,    4,
    4,    4,    4,    5,    5,    5,    4,    5,    3,    4,
    5,    4,    5,    5,    4,    5,    5,    2,    3,    4,
    3,    3,    5,    3,    5,    3,    2,    3,    4,    2,
    2,    1,    1,    0,    1,    1,    1,    1,    1,    2,
    1,    1,    0,    1,    2,    3,    1,    3,    1,    1,
    1,    0,    1,    1,    3,    1,    3,    2,    0,    1,
    3,    1,    1,    0,    1,    1,    1,    1,    1,    1,
    1,    3,    3,    3,    3,    3,    3,    1,    2,    0,
    3,    3,    3,    3,    1,    1,    1,    6,    4,    3,
    1,    1,    1,    2,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    0,    1,    1,    1,    1,
    1,    1,    1,    1,    3,    3,    2,    2,    1,    1,
    2,    1,    3,    3,    3,    3,    3,    5,    7,    5,
    3,    3,    3,    3,    3,    3,    5,    5,    5,    5,
    0,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    2,
    3,    3,    4,    3,    4,    2,    3,    3,    3,    3,
    5,    5,    6,    5,    6,    4,    5,    5,    5,    5,
    3,    5,    1,    1,    1,    1,    1,
};
static const YYINT yydefred[] = {                         0,
    0,   21,    3,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    4,    9,   10,
   11,   12,   13,   14,   15,   16,   17,   18,   19,   20,
   59,  280,  282,  283,  281,  278,  279,  277,  235,  236,
  237,  238,  239,  214,    0,  269,    0,  284,    0,  248,
  270,    8,    7,    6,    0,  125,  207,  206,    0,    0,
  121,    0,  123,   44,    0,    0,  233,   51,    0,   53,
    0,    0,    0,    0,    0,    0,  220,  271,  273,  274,
  272,  219,    0,  226,  232,    0,    0,  241,    0,  230,
  240,    0,    0,    0,    0,   27,    0,    0,   60,    0,
  217,    0,  128,    0,  223,    0,    0,   87,  211,    0,
    0,  102,    0,  108,    0,   28,    0,    0,    0,  133,
    0,    0,  116,    0,    0,    0,    0,   80,   49,    0,
   47,    0,    0,    0,  129,  202,    0,  138,    0,  106,
    0,  132,  205,    0,    0,    0,   22,    0,    0,    0,
    0,    0,    0,    0,    0,   71,    0,   73,    0,  197,
    0,    0,   89,    0,   91,    0,   93,    0,   95,    0,
  200,    0,    0,    0,    0,   55,    0,  104,    0,   30,
  201,  143,    0,  145,  203,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  154,    0,    0,  157,    0,  159,
    0,    0,   32,    0,   96,   97,    0,    0,    0,    0,
  208,    0,  188,    0,  164,  131,    0,    0,    0,  134,
    0,   57,    0,    0,    0,    0,    0,    0,    0,  166,
    0,    0,    0,    0,    0,    0,    0,    0,  314,    0,
  316,  317,  320,  323,  324,  325,  326,  327,  328,  329,
  318,  321,  319,  322,    0,  288,    0,  110,    0,  112,
    2,    5,    0,    0,    0,    0,    0,  140,  215,  124,
  126,  120,  122,    0,    0,    0,    0,  209,    0,    0,
    0,    0,    0,    0,  113,    0,    0,    0,    0,    0,
    0,   26,    0,   61,    0,    0,   62,  127,    0,   86,
  210,    0,    0,   29,    0,   45,   46,  115,    0,    0,
    0,   78,    0,   79,    0,    0,  137,  130,  139,    0,
  136,  141,   24,   23,    0,    0,   64,    0,   66,    0,
   68,    0,   70,   72,  196,  198,   88,   90,   92,   94,
  263,  262,    0,  261,  142,    0,    0,   56,  103,   31,
  148,    0,  144,  146,  147,  150,    0,  152,  153,    0,
  191,    0,    0,    0,  160,    0,    0,    0,    0,    0,
  162,  189,  163,  192,    0,  194,    0,  135,   58,  275,
    0,  221,    0,    0,    0,    0,    0,  165,    0,    0,
    0,    0,    0,    0,    0,    0,  291,    0,  353,  354,
  357,  356,    0,    0,  355,    0,    0,    0,    0,    0,
  330,    0,    0,    0,  109,  111,  247,  246,    0,    0,
  244,  245,    0,    0,    0,   52,   54,    0,    0,  180,
    0,    0,  185,    0,    0,  268,  267,  266,    0,  265,
  225,  227,  231,    0,    0,  218,  216,    0,    0,    0,
    0,    0,    0,    0,    0,  255,  257,  256,  119,    0,
    0,    0,    0,   50,   48,    0,    0,    0,    0,    0,
    0,  199,    0,  177,    0,  182,    0,    0,  151,  190,
  155,  156,  158,  161,   38,    0,   33,    0,    0,   98,
    0,    0,    0,  167,    0,  168,  170,  171,  173,  172,
    0,   74,  301,  302,  303,  304,  305,  306,    0,    0,
  338,    0,  334,    0,    0,    0,    0,    0,    0,    0,
    0,  337,  339,  293,  294,  295,  340,  296,  331,  186,
  228,  187,  174,  175,  178,  183,  184,  114,  264,   84,
   83,   81,   85,    0,  101,  107,   82,    0,    0,    0,
  117,  118,    0,   77,    0,  105,   25,   63,   65,   67,
   69,  260,  176,  181,  149,    0,    0,   99,  100,  193,
  195,    0,   75,    0,    0,    0,  335,  333,    0,    0,
    0,  346,    0,    0,    0,    0,    0,    0,  254,  253,
    0,  252,  251,  286,  285,   39,    0,   34,    0,  169,
  307,  300,  308,  309,  310,  298,    0,  348,    0,  344,
  342,    0,  347,  349,  350,  341,  352,    0,  259,    0,
    0,    0,  345,  343,    0,   40,    0,   35,    0,  299,
  258,    0,    0,   41,    0,   36,    0,    0,    0,   42,
    0,   37,    0,   43,
};
#if defined(YYDESTRUCT_CALL) || defined(YYSTYPE_TOSTRING)
static const YYINT yystos[] = {                           0,
  261,  267,  276,  279,  280,  281,  282,  283,  284,  285,
  286,  287,  288,  289,  290,  291,  292,  293,  294,  295,
  296,  297,  298,  301,  302,  303,  304,  305,  307,  308,
  309,  310,  311,  312,  313,  314,  315,  316,  317,  318,
  319,  320,  321,  322,  323,  324,  325,  326,  327,  328,
  329,  330,  331,  332,  333,  334,  335,  336,  337,  338,
  339,  340,  341,  342,  343,  344,  345,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,  357,  358,
  359,  360,  361,  362,  363,  364,  365,  366,  367,  368,
  369,  370,  371,  372,  374,  375,  376,  377,  378,  379,
  387,  426,  434,  435,  439,  461,  474,  475,  477,  478,
  479,  480,  481,  482,  483,  484,  485,  486,  487,  488,
  490,  257,  258,  259,  260,  264,  265,  266,  270,  271,
  272,  273,  274,  430,   40,  447,  448,  452,  454,  460,
  462,  256,  276,  277,  436,  476,  256,  423,  468,  436,
  476,  436,  476,  476,  448,  448,  394,  476,  489,  476,
  489,  468,  468,  468,  468,  468,  256,  258,  264,  265,
  266,  449,  457,  263,  427,  440,  442,  447,  454,  455,
  456,  440,  440,  442,  454,  476,  454,  462,  476,  491,
  494,  432,  476,  432,  440,  441,  442,  476,  268,  458,
  459,  476,  459,  476,  442,  476,  440,  468,  468,  476,
  256,  457,  476,  457,  457,  442,  441,  476,  476,  489,
  476,  489,  448,  454,  476,  424,  463,  476,  459,  476,
  463,  476,  425,  465,  428,  454,  476,  454,  468,  454,
  468,  442,  427,  454,  454,  476,  454,  476,  468,  476,
  468,  441,  476,  441,  476,  441,  476,  441,  476,  442,
  476,  463,  468,  468,  442,  476,  441,  476,  429,  476,
  476,  476,  468,  476,  424,  464,  465,  465,  422,  422,
  468,  468,  468,  448,  476,  489,  489,  476,  489,  476,
  447,  447,  476,  489,  476,  476,  489,  468,  464,  256,
  449,  453,  476,  373,  476,  476,  468,  468,  436,  476,
  436,  476,  380,  381,  382,  384,  385,  386,  436,  476,
  275,  388,  390,  391,  394,  396,  398,  403,  404,  405,
  406,  407,  408,  409,  410,  411,  412,  413,  414,  415,
  416,  417,  418,  419,  447,  471,  457,  476,  457,  476,
  276,  475,  448,   43,   45,   42,   47,  476,  430,  476,
  476,  476,  476,  448,  448,  448,  448,  256,  453,  453,
  256,  453,  453,  453,  476,  489,  489,  489,  489,  489,
  489,  476,  489,  476,  275,  394,  476,  476,  489,  476,
  268,  441,  441,  476,  489,  476,  476,  476,  269,  256,
  489,  476,  493,  476,  448,  448,  476,  476,  476,  441,
  476,  476,  476,  476,  489,  489,  476,  489,  476,  489,
  476,  489,  476,  476,  476,  476,  476,  476,  476,  476,
  422,  447,  466,  467,  476,  453,  453,  476,  476,  476,
  476,  489,  476,  476,  476,  476,  422,  476,  476,  448,
  476,  448,  448,  448,  476,  447,  449,  454,  448,  489,
  476,  476,  476,  476,  489,  476,  489,  476,  476,  449,
  450,  449,  451,  442,  442,  449,  442,  476,  442,  410,
  411,  412,  413,  414,  415,  447,  447,  394,  392,  393,
  399,  400,  421,  472,  473,  391,  394,  403,  405,  447,
  447,  394,  394,  394,  476,  476,  256,   41,  448,  448,
  448,  448,  443,  489,  442,  476,  476,  443,  443,  256,
  440,  443,  256,  442,  448,  422,  437,  447,  469,  470,
  442,  263,  455,  466,  442,  447,  494,  441,  269,  444,
  444,  442,  388,   64,  445,  446,  447,  462,  476,  422,
  461,  492,  495,  476,  476,  444,  428,  468,  468,  427,
  427,  476,  489,  256,  442,  256,  440,  448,  476,  476,
  476,  476,  476,  476,  476,  489,  476,  489,  441,  476,
  448,  447,  447,  476,  383,  476,  476,  476,  476,  476,
  278,  476,  389,  389,  389,  389,  389,  389,  389,  394,
  472,  421,  472,  420,  394,  421,  472,  394,  394,  394,
  397,  472,  472,  392,  393,  400,  401,  447,  473,  476,
  442,  476,  476,  476,  476,  476,  476,  476,  470,  476,
  476,  476,  476,  445,  476,  476,  476,  445,  428,  431,
  476,  476,  395,  476,  395,  476,  476,  476,  476,  476,
  476,  467,  476,  476,  476,  454,  454,  476,  476,  476,
  476,  449,  476,  394,  392,  400,  472,  420,  472,  421,
  472,  397,  420,  472,  472,  401,  472,  394,  256,  389,
   58,  256,  445,  461,  461,  476,  489,  476,  489,  476,
  391,  393,  412,  413,  414,  389,  389,  397,  472,  397,
  397,  420,  397,  397,  397,  397,  393,  388,  442,  454,
  454,  394,  397,  397,  445,  476,  489,  476,  489,  393,
  389,  454,  454,  476,  489,  476,  489,  454,  454,  476,
  489,  476,  454,  476,
};
#endif /* YYDESTRUCT_CALL || YYSTYPE_TOSTRING */
static const YYINT yydgoto[] = {                        105,
  195,  196,  197,  513,  540,  545,  546,  178,  137,  301,
  471,  473,  138,  302,  139,  180,  181,  173,  200,  201,
  140,  106,  141,  227,  276,  234,  433,  434,  149,  529,
  530,  346,  494,  495,  107,  108,  146,  109,  110,  111,
  112,  113,  114,  115,  116,  117,  118,  119,  120,  514,
  121,  190,  552,  403,  191,  553,
};
static const YYINT yysindex[] = {                      1610,
  149,    0,    0, -253, -248, -181, -128,  322,  149,  149,
  -64,  -64, -248, -248, -248, -248, -248,  653, 1933, 1933,
 1933, 1453,  160, -247, 1431,  468,  468, 1453, 1933, -248,
 -248,  322,  881,  653,  653, 2023, 1055,  -64,  -64,  149,
  692, -114,  468, -410,  322, -380,  225,  332,  332, 2023,
  118,  692,  692, -248,  322, -248, 1055, 1055, 1055, 1055,
 2023,  322, -410, -248, -248, 1453, 1055, -191,  322,  322,
 -248,  322, -381, -380, -380, -367, -341, -248, -248, -248,
  149,  -64, -304,  -64,  322, 1411, 1411,  -64,  322,  -64,
 -248, -381,  936, -116,  322, -248, -248, -105,  -83,  436,
 -168, 2066,  881,  881,    0, -165, 1767,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  149,    0,   82,    0, -317,    0,
    0,    0,    0,    0,  322,    0,    0,    0,  322,  322,
    0,  322,    0,    0,  110,  110,    0,    0,  149,    0,
  149,  716,  716,  845,  716,  716,    0,    0,    0,    0,
    0,    0,  -64,    0,    0, -304, -304,    0, -304,    0,
    0, -304, -304,  322, -304,    0, -156, -160,    0,   35,
    0,  322,    0, -304,    0,  322, -304,    0,    0, -146,
 1933,    0, 1933,    0,  322,    0, -304,  322,  322,    0,
    0,  322,    0, -122, -179,  322,  322,    0,    0,  149,
    0,  149,   82,  322,    0,    0,  322,    0, 1933,    0,
  322,    0,    0,  322,  322,  -64,    0, -304,  322, -304,
  322, -304,  322, -304,  322,    0,  322,    0,  322,    0,
  322,  322,    0,  322,    0,  322,    0,  322,    0,  306,
    0,  322,  716,  716,  322,    0,  322,    0,  322,    0,
    0,    0,  -64,    0,    0,  322,  322,  322,  322, -264,
  322,  322,  149,   82,    0,  149,  149,    0,  149,    0,
  322, 1411,    0,  976,    0,    0,  149, -304,  322,    0,
    0,  322,    0,  322,    0,    0,  -64,  -64,  322,    0,
  322,    0,  561,  561, 2023, 2023,  561, 2023,  322,    0,
 2023, 1250, 1411, -230, -195, 2097, 1411, -224,    0, -220,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, -203,    0,  322,    0,  322,    0,
    0,    0,   91,  149,  149,  149,  149,    0,    0,    0,
    0,    0,    0,   67,  747,   82,   82,    0, -304, -304,
    0, 1759, -304,  669,    0,  149,  220, 2023,  960,  306,
 2023,    0, 1411,    0, 1411,   78,    0,    0, 1933,    0,
    0,  -74,  -74,    0, 2023,    0,    0,    0,  801,  322,
 -226,    0, -219,    0,   82,   82,    0,    0,    0,  -74,
    0,    0,    0,    0, -228, -248,    0, -248,    0, -207,
    0, -205,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  -64,    0,    0, 1911, 1892,    0,    0,    0,
    0,  149,    0,    0,    0,    0,  322,    0,    0,   82,
    0,   82,   82,   82,    0,  322,  -64,  -64, 1227,  149,
    0,    0,    0,    0, 1411,    0, 1411,    0,    0,    0,
  322,    0,  -12,  322,  322,  322,  322,    0,  597, -170,
 -162, -158, -157, -155, -153, -259,    0,   12,    0,    0,
    0,    0,  287, -212,    0, -154,  378, -143, -141, -271,
    0,   12,   12, 2111,    0,    0,    0,    0,  112,  112,
    0,    0,  322, 2023,  322,    0,    0,  322,  322,    0,
  322,  322,    0,  322,   82,    0,    0,    0,   23,    0,
    0,    0,    0,  -64,  322,    0,    0,  322,  801,  322,
  322,  322,  801, -204, -208,    0,    0,    0,    0,  322,
 -137,  322, -135,    0,    0,  322,  322,  322,  322,  322,
  322,    0,  306,    0,  322,    0,  322,   82,    0,    0,
    0,    0,    0,    0,    0,  925,    0,  925,  322,    0,
   82,  322,  322,    0,  561,    0,    0,    0,    0,    0,
  322,    0,    0,    0,    0,    0,    0,    0, -140, -301,
    0,   12,    0, -152,   12,  449, -386,   12,   12,  894,
 -132,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, -139,    0,    0,    0, -252,  208,  912,
    0,    0, -219,    0, -219,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  -64,  -64,    0,    0,    0,
    0,  322,    0,  391, -120, -112,    0,    0, -107,   12,
 -103,    0, -382,  -93,  -88,  -55,  -52,  -96,    0,    0,
 1951,    0,    0,    0,    0,    0,  925,    0,  925,    0,
    0,    0,    0,    0,    0,    0,  -80,    0,  -43,    0,
    0,  -42,    0,    0,    0,    0,    0,  801,    0,  -64,
  -64,  -37,    0,    0, -315,    0,  925,    0,  925,    0,
    0,  -64,  -64,    0,  925,    0,  925,  -64,  322,    0,
  925,    0,  322,    0,
};
static const YYINT yyrindex[] = {                         0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  493,  493,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1969, 1969,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  493,  493,    0,
    0,    0, 1969,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  388,    0,    0,    0,    0,    0,    0,    0,
    0,  493,  493,  493,    0,    0,    0, 1408,    0,  493,
    0,  388,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -111,    0,    0,    0,    0,  363,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  493,    0,    0,  579, 2041,    0, 1018,    0,
    0,  785, 2041,    0, 1480,    0,    0,    0,    0,    0,
    0,    0,    0, 1987,    0,    0, 1079,    0,    0, 2005,
    0,    0,    0,    0,    0,    0, 2041,    0,    0,    0,
 1264,    0,    0,    0,  -56,  -54,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  -51,    0, -243,    0, -243,
    0,  -48,    0,  -48,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  493,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  493,    0, 1475,
    0,    0,    0,    0,    0,    0, 1480, 1480,    0,    0,
    0,    0,  532,  186,    0,    0,    0,    0,    0,    0,
    0,    0,    0, -100,    0,    0,    0,   30,    0,   88,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  162,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1734,    0,    0,    0,    0, 1734, 1734,
 1102,    0, 1734,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  574,  574,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  574,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  785,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  984,  984,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  179,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   63,  858,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  785,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  604,    0,  608,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  248,    0,
    0,    0,    0,  265,    0,    0,    0,    0,    0,    0,
  271,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  615,    0,    0,    0,    0,    0,    0,
    0,    0,  359,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  984,  984,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  984,
  984,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  984,  984,    0,    0,    0,    0,  984,    0,    0,
    0,    0,    0,    0,
};
#if YYBTYACC
static const YYINT yycindex[] = {                         0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,
};
#endif
static const YYINT yygindex[] = {                         0,
   38,   13,  296,  119, -368, -499,    0,  700,  751,   84,
    0,    0,    0,  483,  572, -278,    0,  665,    0,  -15,
    0, -396,  -13,  138,  293,   94,    7, -167,  798,    0,
 -136,    0,  482, -109,    0,  310,   -6,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  499,
    0,    0,    0,    0,   17,    0,
};
#define YYTABLESIZE 2512
static const YYINT yytable[] = {                        151,
  153,  154,  142,  679,  158,  160,  551,  147,  142,  188,
  672,  203,  234,  226,  701,  186,  189,  193,  198,  202,
  204,  206,  143,  144,  541,  210,  213,  229,  143,  144,
  218,  219,  221,  673,  225,  228,  230,  702,  232,  634,
  237,  556,  275,  638,  233,  246,  248,  142,  250,  217,
  253,  255,  257,  259,  279,  261,  176,  182,  183,  266,
  268,  270,  271,  272,  142,  274,  207,  143,  144,  252,
  254,  256,  258,  721,  142,  285,  400,  288,  290,  267,
  280,  293,  295,  296,  143,  144,  303,  305,  306,  157,
  665,  310,  312,  320,  143,  144,  348,  350,  666,  142,
  533,  172,  242,  242,  533,  242,  321,  242,  356,  354,
  351,  355,  359,  357,  385,  640,  172,  172,  172,  143,
  144,  391,  610,  356,  354,  611,  355,  142,  357,  599,
  358,  508,  356,  354,  600,  355,  680,  357,  360,  142,
  683,  142,  361,  362,  311,  363,  399,  143,  144,  135,
  142,  356,  354,  356,  355,  312,  357,  447,  357,  143,
  144,  143,  144,  488,  311,  311,  375,  277,  278,  502,
  143,  144,  142,  503,  148,  312,  312,  382,  640,  234,
  384,  231,  145,  387,  192,  388,  172,  172,  135,  390,
  504,  142,  143,  144,  539,  550,  489,  490,  394,  557,
  262,  396,  397,  491,  492,  398,  102,  604,  715,  402,
  404,  143,  144,  392,  157,  393,  407,  408,  593,  560,
  409,  561,  640,  639,  411,  493,  594,  412,  413,  414,
  595,  596,  417,  597,  419,  598,  421,  269,  423,  605,
  424,  410,  425,  142,  426,  427,  684,  428,  685,  429,
  608,  430,  609,  664,  150,  435,  304,  643,  438,  645,
  439,  678,  440,  143,  144,  681,  441,  668,  696,  443,
  444,  445,  446,  359,  448,  449,  697,  451,  142,  122,
  123,  124,  125,  311,  455,  313,  126,  127,  128,  698,
  142,  640,  461,  700,  312,  462,  707,  463,  143,  144,
  464,  466,  468,  703,  469,  313,  313,  152,  704,  226,
  143,  144,  478,  712,  177,  177,  177,  184,  242,  242,
  242,  242,  242,  205,  177,  242,  242,  242,  242,  157,
  309,  216,  242,  242,  242,  242,  242,  142,  242,  242,
  505,  705,  506,  315,  706,  242,  507,  129,  130,  131,
  132,  133,  311,  713,  714,  720,  260,  143,  144,  516,
  517,  265,    1,  315,  315,  234,  122,  123,  124,  125,
  585,   76,  188,  126,  127,  128,  234,  457,  234,  129,
  130,  131,  132,  133,  299,  548,  534,  129,  130,  131,
  132,  133,  629,  549,  619,  652,  470,  472,  554,  555,
  476,  538,  537,  489,  490,  122,  123,  124,  125,  521,
  491,  492,  126,  127,  128,  142,  352,  292,  129,  130,
  131,  132,  133,    0,  313,    0,  562,    0,  386,  129,
  130,  131,  132,  133,  336,  143,  144,  292,  292,    0,
  569,  222,    0,  570,  526,  571,  572,  573,    0,  574,
  575,  577,  580,    0,  336,  336,  242,    0,    0,  527,
  157,  222,  222,    0,  584,    0,  586,  587,  588,  589,
  590,  579,  592,    0,  567,    0,  122,  123,  124,  125,
  142,    0,  315,  126,  127,  128,    0,  518,  519,  242,
    0,  522,  242,    0,  129,  130,  131,  132,  133,    0,
  143,  144,    0,  297,    0,    0,  620,  134,  622,  159,
  161,  623,  624,    0,  625,  626,    0,  627,  628,    0,
  332,    0,  630,  297,  297,  548,  351,  631,  632,  548,
    0,  633,  234,  635,  636,  637,  220,  222,  641,  134,
  332,  332,    0,  642,  243,  644,  351,  351,    0,  646,
  647,  648,  649,  650,  651,    0,  292,    0,  653,    0,
  654,  655,  122,  123,  124,  125,    0,    0,  222,  126,
  127,  128,  658,  336,  659,  660,  661,  142,  134,    0,
  286,  287,  289,    0,  663,    0,  294,  147,  297,  134,
  179,  179,  179,  185,  187,    0,  179,  143,  144,  185,
  179,  129,  130,  131,  132,  133,    0,  185,  179,    0,
  474,  475,  224,  477,  287,    0,  479,    0,  236,  238,
  240,  185,  244,  245,  247,    0,  548,    0,  179,  179,
  179,  179,  185,    0,  287,  287,    0,  185,  179,    0,
    0,  526,  297,  204,  369,  370,  372,  373,  374,  686,
  688,    0,  235,    0,    0,  690,  527,    0,    0,  332,
  515,    0,    0,  204,  204,  351,    0,  177,  662,  524,
    0,  376,    0,  531,  377,  378,  535,  379,  489,  490,
  380,  381,    0,  383,    0,  491,  492,    0,    0,    0,
  542,  142,  389,    0,  548,  378,    0,  212,  214,  215,
  136,    0,    0,  716,  718,  395,    0,  602,  136,  136,
    0,  143,  144,  401,    0,  724,  726,    0,    0,    0,
    0,  730,  732,  142,    0,    0,  734,  431,    0,    0,
    0,  565,  177,    0,  415,  199,  416,    0,  418,  136,
  420,    0,  422,  143,  144,  436,  437,    0,    0,  234,
  234,  234,  234,  287,  148,    0,  234,  234,  234,  155,
  156,    0,  234,  234,  234,  234,  234,  347,  349,  489,
  490,  442,  179,    0,  179,    0,  491,  492,    0,    0,
  136,  691,    0,  692,    0,  291,  292,  276,  356,  354,
  223,  355,    0,  357,    0,    0,  460,    0,  606,    0,
  179,  345,  693,  694,  695,  465,  467,  276,  276,  621,
  162,  163,  164,  165,  166,  313,  314,  315,  168,  316,
  317,  318,    0,    0,  169,  170,  171,  208,  209,  250,
    0,  284,    0,    0,  136,  234,  234,  234,  234,    0,
  489,  490,  234,  234,  234,  239,  241,  491,  492,  250,
  250,  249,  142,  251,  136,  136,    0,    0,  136,  289,
  136,  263,  264,  290,  544,  458,    0,    0,  273,  670,
  249,  319,  143,  144,  591,  281,  282,  283,    0,  289,
  289,    0,    0,  290,  290,  353,  185,  185,  298,  185,
  249,  249,  185,  307,  308,    0,    0,  243,  243,    0,
  243,    0,  243,    0,    0,  364,  365,    0,  167,  366,
  168,  367,    0,    0,    0,    0,  169,  170,  171,  136,
    0,  136,  234,    0,  523,  122,  123,  124,  125,    0,
    0,  563,  126,  127,  128,    0,  185,    0,  129,  130,
  131,  132,  133,  179,    0,  185,    0,  142,    0,  185,
    0,    0,  185,    0,    0,  576,  578,    0,    0,  432,
  179,  129,  130,  131,  132,  133,  185,  143,  144,  601,
  405,  368,  406,  168,  603,  544,  709,    0,  607,  169,
  170,  171,  136,  612,  613,  136,  136,    0,  136,    0,
    0,  456,    0,    0,    0,    0,  136,    0,    0,    0,
  234,    0,    0,  122,  123,  124,  125,  185,  179,    0,
  126,  127,  128,    0,    0,  234,  129,  130,  131,  132,
  133,  486,  487,    0,    0,  500,  501,    0,    0,    0,
  179,    0,  563,  450,    0,    0,  452,  453,    0,  454,
    0,  234,  234,  234,  234,    0,    0,  459,  234,  234,
  234,    0,    0,  136,  136,  136,  136,  122,  123,  124,
  125,    0,    0,    0,  126,  127,  128,    0,    0,    0,
  129,  130,  131,  132,  133,  136,  528,    0,    0,  432,
    0,    0,    0,  667,  536,  185,  669,  671,    0,  674,
  675,  677,    0,    0,    0,  175,    0,    0,  547,    0,
  371,  179,  168,    0,  509,  510,  511,  512,  169,  170,
  171,    0,    0,  243,  243,  243,  243,  243,    0,    0,
  243,  243,  243,  243,    0,    0,  525,  243,  243,  243,
  243,  243,    0,  243,  243,    0,  211,    0,  168,    0,
    0,  136,    0,    0,  169,  170,  171,  656,    0,  657,
    0,  699,    0,    0,  687,  689,  143,  144,    0,  136,
    0,    0,    0,    0,  582,    0,  583,  682,  122,  123,
  124,  125,    0,  175,    0,  126,  127,  128,    0,    0,
    0,  129,  130,  131,  132,  133,    0,    0,  543,    0,
    0,  300,  568,  168,  129,  130,  131,  132,  133,  169,
  170,  171,    0,  618,    0,    0,  234,    0,  717,  719,
  581,  143,  144,  558,    0,  559,  122,  123,  124,  125,
  725,  727,  532,  126,  127,  128,  731,    0,  528,    0,
  134,    0,    0,  168,    0,    0,    0,    0,  547,  169,
  170,  171,  547,    0,    0,  129,  130,  131,  132,  133,
    0,  243,  185,  234,  234,  234,  234,  234,  710,    0,
  711,    0,  432,    8,    0,    0,    0,    0,  356,  354,
    0,  355,    0,  357,  234,  234,  234,  234,    0,    0,
  234,  234,  234,  234,  243,  489,  490,  243,  722,    0,
  723,    0,  491,  492,  676,    0,  728,    0,  729,  543,
    0,    0,  733,    0,    0,    0,    0,    0,    0,    0,
  142,  122,  123,  124,  125,    0,    0,  174,  126,  127,
  128,    0,    0,    0,  129,  130,  131,  132,  133,    0,
  143,  144,    0,    0,  224,  234,  234,  234,  234,  547,
    0,  134,  234,  234,  234,    0,    0,  224,  234,  234,
  234,  234,  234,    0,  224,  224,    0,  209,  209,  209,
  209,  209,  179,    0,  209,  209,  209,  209,  179,    0,
    0,  209,  209,  209,  209,  209,    0,    0,    0,    0,
  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,
  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,
    0,    0,  179,  179,  179,  179,  179,  547,  179,  179,
  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,
  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,
  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,
  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,
  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,
  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,
  179,  179,  179,  179,    8,  179,  179,  179,  179,  179,
  179,  175,  142,  122,  123,  124,  125,    0,  179,  174,
  126,  127,  128,    0,    0,    0,  129,  130,  131,  132,
  133,    0,  143,  144,    0,  234,  122,  123,  124,  125,
    0,    0,    0,  126,  127,  128,    0,    0,    0,  220,
    0,    0,    0,    0,    8,    0,    0,    0,  209,    0,
    8,    0,    0,    0,    0,  179,  179,    0,    0,  220,
  220,    0,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    0,    0,    8,    8,    8,    8,    8,    0,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    0,    8,    8,    8,
    8,    8,    8,    0,    0,    0,    0,    0,    0,    0,
    8,    0,    0,  175,    0,    0,    0,    0,    0,  480,
  481,  482,  483,  484,  485,  234,    0,  122,  123,  124,
  125,  234,  234,  234,  126,  127,  128,  234,  234,  234,
  234,  234,    0,    0,    0,    0,  142,  122,  123,  124,
  125,    0,    0,  174,  126,  127,  128,    8,    8,    0,
  129,  130,  131,  132,  133,    0,  143,  144,  142,  122,
  123,  124,  125,    0,    0,    0,  126,  127,  128,    0,
    0,    0,  129,  130,  131,  132,  133,    0,  143,  144,
  209,    0,    0,    0,    0,    8,  234,  234,  234,  234,
    0,    8,    0,  234,  234,  234,    0,    0,    0,    0,
  209,  209,    0,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    0,    0,    8,    8,    8,    8,    8,
    0,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    0,    8,    8,
    8,    8,    8,    8,    0,    0,    0,  175,    0,    0,
    0,    8,  194,    0,    0,    0,    0,    0,    0,    0,
    1,    0,    0,    0,    0,    0,    2,    0,    0,  175,
    0,    0,    0,    0,    0,    3,    0,    0,    4,    5,
    6,    7,    8,    9,   10,   11,   12,   13,   14,   15,
   16,   17,   18,   19,   20,   21,   22,   23,    8,    8,
   24,   25,   26,   27,   28,    0,   29,   30,   31,   32,
   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
   43,   44,   45,   46,   47,   48,   49,   50,   51,   52,
   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,
   63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
   73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
   83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
   93,   94,    0,   95,   96,   97,   98,   99,  100,  229,
  234,  234,  234,  234,    0,    0,  101,  234,  234,  234,
    0,    0,    0,  234,  234,  234,  234,  234,    0,  229,
  229,    0,    0,    0,  520,  122,  123,  124,  125,    0,
    0,  174,  126,  127,  128,    0,    0,    1,  129,  130,
  131,  132,  133,    2,    0,  102,    0,    0,    0,    0,
    0,    0,    0,  103,  104,    4,    5,    6,    7,    8,
    9,   10,   11,   12,   13,   14,   15,   16,   17,   18,
   19,   20,   21,   22,   23,    0,    0,   24,   25,   26,
   27,   28,    0,   29,   30,   31,   32,   33,   34,   35,
   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
   46,   47,   48,   49,   50,   51,   52,   53,   54,   55,
   56,   57,   58,   59,   60,   61,   62,   63,   64,   65,
   66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
   76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
   86,   87,   88,   89,   90,   91,   92,   93,   94,    0,
   95,   96,   97,   98,   99,  100,    0,  566,  122,  123,
  124,  125,    0,  101,  174,  126,  127,  128,    0,    0,
  234,  129,  130,  131,  132,  133,  564,  122,  123,  124,
  125,    0,    0,    0,  126,  127,  128,    0,    0,    0,
  129,  130,  131,  132,  133,  175,    0,    0,    0,  122,
  123,  124,  125,    0,    0,  174,  126,  127,  128,    0,
  103,  104,  129,  130,  131,  132,  133,  122,  123,  124,
  125,    0,    0,    0,  126,  127,  128,    0,    0,    0,
  129,  130,  131,  132,  133,  213,  213,  213,  213,    0,
    0,  213,  213,  213,  213,    0,    0,    0,  213,  213,
  213,  213,  213,  234,  234,  234,  234,    0,    0,  234,
  234,  234,  234,    0,    0,    0,  234,  234,  234,  234,
  234,  212,  212,  212,  212,    0,    0,  212,  212,  212,
  212,    0,    0,    0,  212,  212,  212,  212,  212,  122,
  123,  124,  125,    0,    0,    0,  126,  127,  128,    0,
    0,    0,  129,  130,  131,  132,  133,  234,  234,  234,
  234,    0,    0,    0,  234,  234,  234,    0,    0,    0,
  234,  234,  234,  234,  234,    0,    0,    0,  175,    0,
    0,    0,  122,  123,  124,  125,    0,    0,    0,  126,
  127,  128,    0,    0,    0,    0,    0,  175,  708,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  122,  123,  124,  125,    0,    0,  175,
  126,  127,  128,    0,    0,    0,    0,  122,  123,  124,
  125,    0,    0,    0,  126,  127,  128,  175,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  213,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  234,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  212,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  175,
    0,    0,    0,  322,    0,  323,  324,    0,    0,  325,
    0,  326,    0,  327,    0,    0,    0,  234,  328,  329,
  330,  331,  332,  333,  334,  335,  336,  337,  338,  339,
  340,  341,  342,  343,  344,    0,    0,  496,    0,    0,
  497,    0,    0,    0,    0,    0,    0,    0,    0,  498,
    0,  499,  614,  615,    0,    0,    0,    0,    0,  491,
  616,  617,
};
static const YYINT yycheck[] = {                          6,
    7,    8,  256,  256,   11,   12,  403,  256,  256,   23,
  397,   27,  256,  424,  397,   22,   23,   24,   25,   26,
   27,   28,  276,  277,  393,   32,   33,   43,  276,  277,
   37,   38,   39,  420,   41,   42,   43,  420,   45,  539,
   47,  410,  424,  543,  425,   52,   53,  256,   55,   37,
   57,   58,   59,   60,  422,   62,   19,   20,   21,   66,
   67,   68,   69,   70,  256,   72,   29,  276,  277,   57,
   58,   59,   60,  389,  256,   82,  256,   84,   85,   67,
  422,   88,   89,   90,  276,  277,   93,   94,   95,  394,
  392,   98,   99,  100,  276,  277,  103,  104,  400,  256,
  379,   18,   40,   41,  383,   43,  275,   45,   42,   43,
  276,   45,  430,   47,  275,  431,   33,   34,   35,  276,
  277,  268,  394,   42,   43,  397,   45,  256,   47,  389,
  137,   41,   42,   43,  394,   45,  389,   47,  145,  256,
  640,  256,  149,  150,  256,  152,  269,  276,  277,   40,
  256,   42,   43,   42,   45,  256,   47,  422,   47,  276,
  277,  276,  277,  394,  276,  277,  173,   74,   75,  394,
  276,  277,  256,  394,  423,  276,  277,  184,  431,  423,
  187,   44,  436,  190,  432,  192,  103,  104,   40,  196,
  394,  256,  276,  277,  269,  422,  392,  393,  205,  428,
   63,  208,  209,  399,  400,  212,  426,  420,  708,  216,
  217,  276,  277,  201,  394,  203,  223,  224,  389,  427,
  227,  427,  431,  428,  231,  421,  389,  234,  235,  236,
  389,  389,  239,  389,  241,  389,  243,  429,  245,  394,
  247,  229,  249,  256,  251,  252,  643,  254,  645,  256,
  394,  258,  394,  394,  436,  262,  373,  395,  265,  395,
  267,  394,  269,  276,  277,   58,  273,  420,  389,  276,
  277,  278,  279,  430,  281,  282,  389,  284,  256,  257,
  258,  259,  260,  395,  291,  256,  264,  265,  266,  397,
  256,  431,  299,  397,  395,  302,  393,  304,  276,  277,
  307,  308,  309,  397,  311,  276,  277,  436,  397,  424,
  276,  277,  319,  394,   19,   20,   21,   22,  256,  257,
  258,  259,  260,   28,   29,  263,  264,  265,  266,  394,
  436,   36,  270,  271,  272,  273,  274,  256,  276,  277,
  347,  397,  349,  256,  397,   50,  256,  270,  271,  272,
  273,  274,  436,  397,  397,  393,   61,  276,  277,  366,
  367,   66,    0,  276,  277,  422,  257,  258,  259,  260,
  383,  426,  386,  264,  265,  266,  428,  294,  427,  270,
  271,  272,  273,  274,   92,  399,  380,  270,  271,  272,
  273,  274,  529,  400,  504,  563,  313,  314,  405,  406,
  317,  389,  386,  392,  393,  257,  258,  259,  260,  372,
  399,  400,  264,  265,  266,  256,  107,  256,  270,  271,
  272,  273,  274,   -1,  395,   -1,  433,   -1,  394,  270,
  271,  272,  273,  274,  256,  276,  277,  276,  277,   -1,
  447,  256,   -1,  450,  422,  452,  453,  454,   -1,  456,
  457,  458,  459,   -1,  276,  277,  394,   -1,   -1,  437,
  394,  276,  277,   -1,  471,   -1,  473,  474,  475,  476,
  477,  459,  479,   -1,  437,   -1,  257,  258,  259,  260,
  256,   -1,  395,  264,  265,  266,   -1,  369,  370,  427,
   -1,  373,  430,   -1,  270,  271,  272,  273,  274,   -1,
  276,  277,   -1,  256,   -1,   -1,  513,  430,  515,   11,
   12,  518,  519,   -1,  521,  522,   -1,  524,  525,   -1,
  256,   -1,  529,  276,  277,  539,  256,  534,  535,  543,
   -1,  538,   40,  540,  541,  542,   38,   39,  545,  430,
  276,  277,   -1,  550,  427,  552,  276,  277,   -1,  556,
  557,  558,  559,  560,  561,   -1,  395,   -1,  565,   -1,
  567,  568,  257,  258,  259,  260,   -1,   -1,  383,  264,
  265,  266,  579,  395,  581,  582,  583,  256,  430,   -1,
   82,   83,   84,   -1,  591,   -1,   88,  256,   90,  430,
   19,   20,   21,   22,   23,   -1,   25,  276,  277,   28,
   29,  270,  271,  272,  273,  274,   -1,   36,   37,   -1,
  315,  316,   41,  318,  256,   -1,  321,   -1,   47,   48,
   49,   50,   51,   52,   53,   -1,  640,   -1,   57,   58,
   59,   60,   61,   -1,  276,  277,   -1,   66,   67,   -1,
   -1,  422,  395,  256,  162,  163,  164,  165,  166,  656,
  657,   -1,  428,   -1,   -1,  662,  437,   -1,   -1,  395,
  365,   -1,   -1,  276,  277,  395,   -1,  372,  585,  374,
   -1,  173,   -1,  378,  176,  177,  381,  179,  392,  393,
  182,  183,   -1,  185,   -1,  399,  400,   -1,   -1,   -1,
  395,  256,  194,   -1,  708,  197,   -1,   33,   34,   35,
    1,   -1,   -1,  710,  711,  207,   -1,  421,    9,   10,
   -1,  276,  277,  215,   -1,  722,  723,   -1,   -1,   -1,
   -1,  728,  729,  256,   -1,   -1,  733,  422,   -1,   -1,
   -1,  436,  437,   -1,  236,  268,  238,   -1,  240,   40,
  242,   -1,  244,  276,  277,  263,  264,   -1,   -1,  257,
  258,  259,  260,  395,  423,   -1,  264,  265,  266,    9,
   10,   -1,  270,  271,  272,  273,  274,  103,  104,  392,
  393,  273,  201,   -1,  203,   -1,  399,  400,   -1,   -1,
   81,  391,   -1,  393,   -1,   86,   87,  256,   42,   43,
   40,   45,   -1,   47,   -1,   -1,  298,   -1,  421,   -1,
  229,  102,  412,  413,  414,  307,  308,  276,  277,  514,
   13,   14,   15,   16,   17,  380,  381,  382,  258,  384,
  385,  386,   -1,   -1,  264,  265,  266,   30,   31,  256,
   -1,   81,   -1,   -1,  135,  257,  258,  259,  260,   -1,
  392,  393,  264,  265,  266,   48,   49,  399,  400,  276,
  277,   54,  256,   56,  155,  156,   -1,   -1,  159,  256,
  161,   64,   65,  256,   64,  294,   -1,   -1,   71,  421,
  256,  436,  276,  277,  278,   78,   79,   80,   -1,  276,
  277,   -1,   -1,  276,  277,  135,  315,  316,   91,  318,
  276,  277,  321,   96,   97,   -1,   -1,   40,   41,   -1,
   43,   -1,   45,   -1,   -1,  155,  156,   -1,  256,  159,
  258,  161,   -1,   -1,   -1,   -1,  264,  265,  266,  220,
   -1,  222,  430,   -1,  256,  257,  258,  259,  260,   -1,
   -1,  433,  264,  265,  266,   -1,  365,   -1,  270,  271,
  272,  273,  274,  372,   -1,  374,   -1,  256,   -1,  378,
   -1,   -1,  381,   -1,   -1,  457,  458,   -1,   -1,  260,
  389,  270,  271,  272,  273,  274,  395,  276,  277,  488,
  220,  256,  222,  258,  493,   64,  681,   -1,  497,  264,
  265,  266,  283,  502,  503,  286,  287,   -1,  289,   -1,
   -1,  292,   -1,   -1,   -1,   -1,  297,   -1,   -1,   -1,
  422,   -1,   -1,  257,  258,  259,  260,  436,  437,   -1,
  264,  265,  266,   -1,   -1,  437,  270,  271,  272,  273,
  274,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1,
  459,   -1,  534,  283,   -1,   -1,  286,  287,   -1,  289,
   -1,  257,  258,  259,  260,   -1,   -1,  297,  264,  265,
  266,   -1,   -1,  354,  355,  356,  357,  257,  258,  259,
  260,   -1,   -1,   -1,  264,  265,  266,   -1,   -1,   -1,
  270,  271,  272,  273,  274,  376,  377,   -1,   -1,  380,
   -1,   -1,   -1,  602,  385,  514,  605,  606,   -1,  608,
  609,  610,   -1,   -1,   -1,  427,   -1,   -1,  399,   -1,
  256,    0,  258,   -1,  354,  355,  356,  357,  264,  265,
  266,   -1,   -1,  256,  257,  258,  259,  260,   -1,   -1,
  263,  264,  265,  266,   -1,   -1,  376,  270,  271,  272,
  273,  274,   -1,  276,  277,   -1,  256,   -1,  258,   -1,
   -1,  442,   -1,   -1,  264,  265,  266,  576,   -1,  578,
   -1,  670,   -1,   -1,  656,  657,  276,  277,   -1,  460,
   -1,   -1,   -1,   -1,  465,   -1,  467,  256,  257,  258,
  259,  260,   -1,  427,   -1,  264,  265,  266,   -1,   -1,
   -1,  270,  271,  272,  273,  274,   -1,   -1,  388,   -1,
   -1,  256,  442,  258,  270,  271,  272,  273,  274,  264,
  265,  266,   -1,  504,   -1,   -1,  422,   -1,  710,  711,
  460,  276,  277,  416,   -1,  418,  257,  258,  259,  260,
  722,  723,  263,  264,  265,  266,  728,   -1,  529,   -1,
  430,   -1,   -1,  258,   -1,   -1,   -1,   -1,  539,  264,
  265,  266,  543,   -1,   -1,  270,  271,  272,  273,  274,
   -1,  394,  681,  270,  271,  272,  273,  274,  687,   -1,
  689,   -1,  563,    0,   -1,   -1,   -1,   -1,   42,   43,
   -1,   45,   -1,   47,  257,  258,  259,  260,   -1,   -1,
  263,  264,  265,  266,  427,  392,  393,  430,  717,   -1,
  719,   -1,  399,  400,  401,   -1,  725,   -1,  727,  388,
   -1,   -1,  731,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  256,  257,  258,  259,  260,   -1,   -1,  263,  264,  265,
  266,   -1,   -1,   -1,  270,  271,  272,  273,  274,   -1,
  276,  277,   -1,   -1,  256,  257,  258,  259,  260,  640,
   -1,  430,  264,  265,  266,   -1,   -1,  269,  270,  271,
  272,  273,  274,   -1,  276,  277,   -1,  256,  257,  258,
  259,  260,  261,   -1,  263,  264,  265,  266,  267,   -1,
   -1,  270,  271,  272,  273,  274,   -1,   -1,   -1,   -1,
  279,  280,  281,  282,  283,  284,  285,  286,  287,  288,
  289,  290,  291,  292,  293,  294,  295,  296,  297,  298,
   -1,   -1,  301,  302,  303,  304,  305,  708,  307,  308,
  309,  310,  311,  312,  313,  314,  315,  316,  317,  318,
  319,  320,  321,  322,  323,  324,  325,  326,  327,  328,
  329,  330,  331,  332,  333,  334,  335,  336,  337,  338,
  339,  340,  341,  342,  343,  344,  345,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,  357,  358,
  359,  360,  361,  362,  363,  364,  365,  366,  367,  368,
  369,  370,  371,  372,    0,  374,  375,  376,  377,  378,
  379,  427,  256,  257,  258,  259,  260,   -1,  387,  263,
  264,  265,  266,   -1,   -1,   -1,  270,  271,  272,  273,
  274,   -1,  276,  277,   -1,  427,  257,  258,  259,  260,
   -1,   -1,   -1,  264,  265,  266,   -1,   -1,   -1,  256,
   -1,   -1,   -1,   -1,  261,   -1,   -1,   -1,  427,   -1,
  267,   -1,   -1,   -1,   -1,  434,  435,   -1,   -1,  276,
  277,   -1,  279,  280,  281,  282,  283,  284,  285,  286,
  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,
  297,  298,   -1,   -1,  301,  302,  303,  304,  305,   -1,
  307,  308,  309,  310,  311,  312,  313,  314,  315,  316,
  317,  318,  319,  320,  321,  322,  323,  324,  325,  326,
  327,  328,  329,  330,  331,  332,  333,  334,  335,  336,
  337,  338,  339,  340,  341,  342,  343,  344,  345,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  357,  358,  359,  360,  361,  362,  363,  364,  365,  366,
  367,  368,  369,  370,  371,  372,   -1,  374,  375,  376,
  377,  378,  379,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  387,   -1,   -1,  427,   -1,   -1,   -1,   -1,   -1,  410,
  411,  412,  413,  414,  415,  258,   -1,  257,  258,  259,
  260,  264,  265,  266,  264,  265,  266,  270,  271,  272,
  273,  274,   -1,   -1,   -1,   -1,  256,  257,  258,  259,
  260,   -1,   -1,  263,  264,  265,  266,  434,  435,   -1,
  270,  271,  272,  273,  274,   -1,  276,  277,  256,  257,
  258,  259,  260,   -1,   -1,   -1,  264,  265,  266,   -1,
   -1,   -1,  270,  271,  272,  273,  274,   -1,  276,  277,
  256,   -1,   -1,   -1,   -1,  261,  257,  258,  259,  260,
   -1,  267,   -1,  264,  265,  266,   -1,   -1,   -1,   -1,
  276,  277,   -1,  279,  280,  281,  282,  283,  284,  285,
  286,  287,  288,  289,  290,  291,  292,  293,  294,  295,
  296,  297,  298,   -1,   -1,  301,  302,  303,  304,  305,
   -1,  307,  308,  309,  310,  311,  312,  313,  314,  315,
  316,  317,  318,  319,  320,  321,  322,  323,  324,  325,
  326,  327,  328,  329,  330,  331,  332,  333,  334,  335,
  336,  337,  338,  339,  340,  341,  342,  343,  344,  345,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,  357,  358,  359,  360,  361,  362,  363,  364,  365,
  366,  367,  368,  369,  370,  371,  372,   -1,  374,  375,
  376,  377,  378,  379,   -1,   -1,   -1,  427,   -1,   -1,
   -1,  387,  432,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  261,   -1,   -1,   -1,   -1,   -1,  267,   -1,   -1,  427,
   -1,   -1,   -1,   -1,   -1,  276,   -1,   -1,  279,  280,
  281,  282,  283,  284,  285,  286,  287,  288,  289,  290,
  291,  292,  293,  294,  295,  296,  297,  298,  434,  435,
  301,  302,  303,  304,  305,   -1,  307,  308,  309,  310,
  311,  312,  313,  314,  315,  316,  317,  318,  319,  320,
  321,  322,  323,  324,  325,  326,  327,  328,  329,  330,
  331,  332,  333,  334,  335,  336,  337,  338,  339,  340,
  341,  342,  343,  344,  345,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,  357,  358,  359,  360,
  361,  362,  363,  364,  365,  366,  367,  368,  369,  370,
  371,  372,   -1,  374,  375,  376,  377,  378,  379,  256,
  257,  258,  259,  260,   -1,   -1,  387,  264,  265,  266,
   -1,   -1,   -1,  270,  271,  272,  273,  274,   -1,  276,
  277,   -1,   -1,   -1,  256,  257,  258,  259,  260,   -1,
   -1,  263,  264,  265,  266,   -1,   -1,  261,  270,  271,
  272,  273,  274,  267,   -1,  426,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  434,  435,  279,  280,  281,  282,  283,
  284,  285,  286,  287,  288,  289,  290,  291,  292,  293,
  294,  295,  296,  297,  298,   -1,   -1,  301,  302,  303,
  304,  305,   -1,  307,  308,  309,  310,  311,  312,  313,
  314,  315,  316,  317,  318,  319,  320,  321,  322,  323,
  324,  325,  326,  327,  328,  329,  330,  331,  332,  333,
  334,  335,  336,  337,  338,  339,  340,  341,  342,  343,
  344,  345,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,  357,  358,  359,  360,  361,  362,  363,
  364,  365,  366,  367,  368,  369,  370,  371,  372,   -1,
  374,  375,  376,  377,  378,  379,   -1,  256,  257,  258,
  259,  260,   -1,  387,  263,  264,  265,  266,   -1,   -1,
  427,  270,  271,  272,  273,  274,  256,  257,  258,  259,
  260,   -1,   -1,   -1,  264,  265,  266,   -1,   -1,   -1,
  270,  271,  272,  273,  274,  427,   -1,   -1,   -1,  257,
  258,  259,  260,   -1,   -1,  263,  264,  265,  266,   -1,
  434,  435,  270,  271,  272,  273,  274,  257,  258,  259,
  260,   -1,   -1,   -1,  264,  265,  266,   -1,   -1,   -1,
  270,  271,  272,  273,  274,  257,  258,  259,  260,   -1,
   -1,  263,  264,  265,  266,   -1,   -1,   -1,  270,  271,
  272,  273,  274,  257,  258,  259,  260,   -1,   -1,  263,
  264,  265,  266,   -1,   -1,   -1,  270,  271,  272,  273,
  274,  257,  258,  259,  260,   -1,   -1,  263,  264,  265,
  266,   -1,   -1,   -1,  270,  271,  272,  273,  274,  257,
  258,  259,  260,   -1,   -1,   -1,  264,  265,  266,   -1,
   -1,   -1,  270,  271,  272,  273,  274,  257,  258,  259,
  260,   -1,   -1,   -1,  264,  265,  266,   -1,   -1,   -1,
  270,  271,  272,  273,  274,   -1,   -1,   -1,  427,   -1,
   -1,   -1,  257,  258,  259,  260,   -1,   -1,   -1,  264,
  265,  266,   -1,   -1,   -1,   -1,   -1,  427,  388,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  257,  258,  259,  260,   -1,   -1,  427,
  264,  265,  266,   -1,   -1,   -1,   -1,  257,  258,  259,
  260,   -1,   -1,   -1,  264,  265,  266,  427,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  427,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  427,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  427,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  427,
   -1,   -1,   -1,  388,   -1,  390,  391,   -1,   -1,  394,
   -1,  396,   -1,  398,   -1,   -1,   -1,  427,  403,  404,
  405,  406,  407,  408,  409,  410,  411,  412,  413,  414,
  415,  416,  417,  418,  419,   -1,   -1,  391,   -1,   -1,
  394,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  403,
   -1,  405,  392,  393,   -1,   -1,   -1,   -1,   -1,  399,
  400,  401,
};
#if YYBTYACC
static const YYINT yyctable[] = {                        -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,
};
#endif
#define YYFINAL 105
#ifndef YYDEBUG
#define YYDEBUG 1
#endif
#define YYMAXTOKEN 437
#define YYUNDFTOKEN 496
#define YYTRANSLATE(a) ((a) > YYMAXTOKEN ? YYUNDFTOKEN : (a))
#if YYDEBUG
static const char *const yyname[] = {

"$end",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,"'('","')'","'*'","'+'",0,"'-'",0,"'/'",0,0,0,0,0,0,0,0,0,0,"':'",0,0,0,0,
0,"'@'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"error",
"H_NUMBER","D_NUMBER","O_NUMBER","B_NUMBER","CONVERT_OP","B_DATA",
"H_RANGE_GUESS","D_NUMBER_GUESS","O_NUMBER_GUESS","B_NUMBER_GUESS","BAD_CMD",
"MEM_OP","IF","MEM_COMP","MEM_DISK8","MEM_DISK9","MEM_DISK10","MEM_DISK11",
"EQUALS","TRAIL","CMD_SEP","LABEL_ASGN_COMMENT","CMD_LOG","CMD_LOGNAME",
"CMD_SIDEFX","CMD_DUMMY","CMD_RETURN","CMD_BLOCK_READ","CMD_BLOCK_WRITE",
"CMD_UP","CMD_DOWN","CMD_LOAD","CMD_BASICLOAD","CMD_SAVE","CMD_VERIFY",
"CMD_BVERIFY","CMD_IGNORE","CMD_HUNT","CMD_FILL","CMD_MOVE","CMD_GOTO",
"CMD_REGISTERS","CMD_READSPACE","CMD_WRITESPACE","CMD_RADIX","CMD_MEM_DISPLAY",
"CMD_BREAK","CMD_TRACE","CMD_IO","CMD_BRMON","CMD_COMPARE","CMD_DUMP",
"CMD_UNDUMP","CMD_EXIT","CMD_DELETE","CMD_CONDITION","CMD_COMMAND",
"CMD_ASSEMBLE","CMD_DISASSEMBLE","CMD_NEXT","CMD_STEP","CMD_PRINT","CMD_DEVICE",
"CMD_HELP","CMD_WATCH","CMD_DISK","CMD_QUIT","CMD_CHDIR","CMD_BANK",
"CMD_LOAD_LABELS","CMD_SAVE_LABELS","CMD_ADD_LABEL","CMD_DEL_LABEL",
"CMD_SHOW_LABELS","CMD_CLEAR_LABELS","CMD_RECORD","CMD_MON_STOP","CMD_PLAYBACK",
"CMD_CHAR_DISPLAY","CMD_SPRITE_DISPLAY","CMD_TEXT_DISPLAY",
"CMD_SCREENCODE_DISPLAY","CMD_ENTER_DATA","CMD_ENTER_BIN_DATA","CMD_KEYBUF",
"CMD_BLOAD","CMD_BSAVE","CMD_SCREEN","CMD_UNTIL","CMD_CPU","CMD_YYDEBUG",
"CMD_BACKTRACE","CMD_SCREENSHOT","CMD_PWD","CMD_DIR","CMD_MKDIR","CMD_RMDIR",
"CMD_RESOURCE_GET","CMD_RESOURCE_SET","CMD_LOAD_RESOURCES","CMD_SAVE_RESOURCES",
"CMD_ATTACH","CMD_DETACH","CMD_MON_RESET","CMD_TAPECTRL","CMD_TAPEOFFS",
"CMD_CARTFREEZE","CMD_UPDB","CMD_JPDB","CMD_CPUHISTORY","CMD_MEMMAPZAP",
"CMD_MEMMAPSHOW","CMD_MEMMAPSAVE","CMD_COMMENT","CMD_LIST","CMD_STOPWATCH",
"RESET","CMD_EXPORT","CMD_AUTOSTART","CMD_AUTOLOAD","CMD_MAINCPU_TRACE",
"CMD_WARP","CMD_PROFILE","FLAT","GRAPH","FUNC","DEPTH","DISASS",
"PROFILE_CONTEXT","CLEAR","CMD_LABEL_ASGN","L_PAREN","R_PAREN","ARG_IMMEDIATE",
"REG_A","REG_X","REG_Y","COMMA","INST_SEP","L_BRACKET","R_BRACKET","LESS_THAN",
"REG_U","REG_S","REG_PC","REG_PCR","REG_B","REG_C","REG_D","REG_E","REG_H",
"REG_L","REG_AF","REG_BC","REG_DE","REG_HL","REG_IX","REG_IY","REG_SP",
"REG_IXH","REG_IXL","REG_IYH","REG_IYL","PLUS","MINUS","STRING","FILENAME",
"R_O_L","R_O_L_Q","OPCODE","LABEL","BANKNAME","CPUTYPE","MON_REGISTER",
"COND_OP","RADIX_TYPE","INPUT_SPEC","CMD_CHECKPT_ON","CMD_CHECKPT_OFF","TOGGLE",
"MASK","$accept","top_level","address_range","address_opt_range","address",
"opt_address","opt_if_cond_expr","cond_expr","cond_operand","number",
"expression","d_number","opt_d_number","opt_context_num","guess_default",
"device_num","memspace","memloc","memaddr","checkpt_num","mem_op","opt_mem_op",
"value","assembly_instruction","register","rest_of_line","opt_rest_of_line",
"rest_of_line_or_quoted","data_list","data_element","filename","hunt_list",
"hunt_element","asm_operand_mode","index_reg","index_ureg","command_list",
"command","end_cmd","machine_state_rules","symbol_table_rules","memory_rules",
"asm_rules","checkpoint_rules","checkpoint_control_rules","monitor_state_rules",
"monitor_misc_rules","disk_rules","cmd_file_rules","data_entry_rules",
"monitor_debug_rules","opt_sep","register_mod","reg_list","post_assemble","$$1",
"reg_asgn","assembly_instr_list","illegal-symbol",
};
static const char *const yyrule[] = {
"$accept : top_level",
"top_level : command_list",
"top_level : assembly_instruction TRAIL",
"top_level : TRAIL",
"command_list : command",
"command_list : command_list command",
"end_cmd : CMD_SEP",
"end_cmd : TRAIL",
"end_cmd : error",
"command : machine_state_rules",
"command : symbol_table_rules",
"command : memory_rules",
"command : asm_rules",
"command : checkpoint_rules",
"command : checkpoint_control_rules",
"command : monitor_state_rules",
"command : monitor_misc_rules",
"command : disk_rules",
"command : cmd_file_rules",
"command : data_entry_rules",
"command : monitor_debug_rules",
"command : BAD_CMD",
"machine_state_rules : CMD_BANK end_cmd",
"machine_state_rules : CMD_BANK memspace end_cmd",
"machine_state_rules : CMD_BANK BANKNAME end_cmd",
"machine_state_rules : CMD_BANK memspace opt_sep BANKNAME end_cmd",
"machine_state_rules : CMD_GOTO address end_cmd",
"machine_state_rules : CMD_GOTO end_cmd",
"machine_state_rules : CMD_IO end_cmd",
"machine_state_rules : CMD_IO address end_cmd",
"machine_state_rules : CMD_CPU end_cmd",
"machine_state_rules : CMD_CPU CPUTYPE end_cmd",
"machine_state_rules : CMD_CPUHISTORY end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep memspace opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep memspace opt_sep memspace opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep memspace opt_sep memspace opt_sep memspace opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep d_number end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep d_number opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep d_number opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep d_number opt_sep memspace opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep d_number opt_sep memspace opt_sep memspace opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep d_number opt_sep memspace opt_sep memspace opt_sep memspace opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_RETURN end_cmd",
"machine_state_rules : CMD_DUMP filename end_cmd",
"machine_state_rules : CMD_UNDUMP filename end_cmd",
"machine_state_rules : CMD_STEP end_cmd",
"machine_state_rules : CMD_STEP opt_sep expression end_cmd",
"machine_state_rules : CMD_NEXT end_cmd",
"machine_state_rules : CMD_NEXT opt_sep expression end_cmd",
"machine_state_rules : CMD_UP end_cmd",
"machine_state_rules : CMD_UP opt_sep expression end_cmd",
"machine_state_rules : CMD_DOWN end_cmd",
"machine_state_rules : CMD_DOWN opt_sep expression end_cmd",
"machine_state_rules : CMD_SCREEN end_cmd",
"machine_state_rules : CMD_SCREEN address end_cmd",
"machine_state_rules : CMD_WARP end_cmd",
"machine_state_rules : CMD_WARP TOGGLE end_cmd",
"machine_state_rules : register_mod",
"register_mod : CMD_REGISTERS end_cmd",
"register_mod : CMD_REGISTERS memspace end_cmd",
"register_mod : CMD_REGISTERS reg_list end_cmd",
"symbol_table_rules : CMD_LOAD_LABELS memspace opt_sep filename end_cmd",
"symbol_table_rules : CMD_LOAD_LABELS filename end_cmd",
"symbol_table_rules : CMD_SAVE_LABELS memspace opt_sep filename end_cmd",
"symbol_table_rules : CMD_SAVE_LABELS filename end_cmd",
"symbol_table_rules : CMD_ADD_LABEL address opt_sep LABEL end_cmd",
"symbol_table_rules : CMD_DEL_LABEL LABEL end_cmd",
"symbol_table_rules : CMD_DEL_LABEL memspace opt_sep LABEL end_cmd",
"symbol_table_rules : CMD_SHOW_LABELS memspace end_cmd",
"symbol_table_rules : CMD_SHOW_LABELS end_cmd",
"symbol_table_rules : CMD_CLEAR_LABELS memspace end_cmd",
"symbol_table_rules : CMD_CLEAR_LABELS end_cmd",
"symbol_table_rules : CMD_LABEL_ASGN EQUALS address end_cmd",
"symbol_table_rules : CMD_LABEL_ASGN EQUALS address LABEL_ASGN_COMMENT end_cmd",
"$$1 :",
"asm_rules : CMD_ASSEMBLE address $$1 post_assemble end_cmd",
"asm_rules : CMD_ASSEMBLE address end_cmd",
"asm_rules : CMD_DISASSEMBLE address_opt_range end_cmd",
"asm_rules : CMD_DISASSEMBLE end_cmd",
"memory_rules : CMD_MOVE address_range opt_sep address end_cmd",
"memory_rules : CMD_COMPARE address_range opt_sep address end_cmd",
"memory_rules : CMD_FILL address_range opt_sep data_list end_cmd",
"memory_rules : CMD_HUNT address_range opt_sep hunt_list end_cmd",
"memory_rules : CMD_MEM_DISPLAY RADIX_TYPE opt_sep address_opt_range end_cmd",
"memory_rules : CMD_MEM_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_MEM_DISPLAY end_cmd",
"memory_rules : CMD_CHAR_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_CHAR_DISPLAY end_cmd",
"memory_rules : CMD_SPRITE_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_SPRITE_DISPLAY end_cmd",
"memory_rules : CMD_TEXT_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_TEXT_DISPLAY end_cmd",
"memory_rules : CMD_SCREENCODE_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_SCREENCODE_DISPLAY end_cmd",
"memory_rules : CMD_MEMMAPZAP end_cmd",
"memory_rules : CMD_MEMMAPSHOW end_cmd",
"memory_rules : CMD_MEMMAPSHOW opt_sep expression end_cmd",
"memory_rules : CMD_MEMMAPSHOW opt_sep expression address_opt_range end_cmd",
"memory_rules : CMD_MEMMAPSAVE filename opt_sep expression end_cmd",
"checkpoint_rules : CMD_BREAK opt_mem_op address_opt_range opt_if_cond_expr end_cmd",
"checkpoint_rules : CMD_BREAK end_cmd",
"checkpoint_rules : CMD_UNTIL address_opt_range end_cmd",
"checkpoint_rules : CMD_UNTIL end_cmd",
"checkpoint_rules : CMD_WATCH opt_mem_op address_opt_range opt_if_cond_expr end_cmd",
"checkpoint_rules : CMD_WATCH end_cmd",
"checkpoint_rules : CMD_TRACE opt_mem_op address_opt_range opt_if_cond_expr end_cmd",
"checkpoint_rules : CMD_TRACE end_cmd",
"checkpoint_control_rules : CMD_CHECKPT_ON checkpt_num end_cmd",
"checkpoint_control_rules : CMD_CHECKPT_ON end_cmd",
"checkpoint_control_rules : CMD_CHECKPT_OFF checkpt_num end_cmd",
"checkpoint_control_rules : CMD_CHECKPT_OFF end_cmd",
"checkpoint_control_rules : CMD_IGNORE checkpt_num end_cmd",
"checkpoint_control_rules : CMD_IGNORE checkpt_num opt_sep expression end_cmd",
"checkpoint_control_rules : CMD_DELETE checkpt_num end_cmd",
"checkpoint_control_rules : CMD_DELETE end_cmd",
"checkpoint_control_rules : CMD_CONDITION checkpt_num IF cond_expr end_cmd",
"checkpoint_control_rules : CMD_COMMAND checkpt_num opt_sep STRING end_cmd",
"checkpoint_control_rules : CMD_COMMAND checkpt_num error end_cmd",
"monitor_state_rules : CMD_SIDEFX TOGGLE end_cmd",
"monitor_state_rules : CMD_SIDEFX end_cmd",
"monitor_state_rules : CMD_DUMMY TOGGLE end_cmd",
"monitor_state_rules : CMD_DUMMY end_cmd",
"monitor_state_rules : CMD_LOG TOGGLE end_cmd",
"monitor_state_rules : CMD_LOG end_cmd",
"monitor_state_rules : CMD_LOGNAME filename end_cmd",
"monitor_state_rules : CMD_RADIX RADIX_TYPE end_cmd",
"monitor_state_rules : CMD_RADIX end_cmd",
"monitor_state_rules : CMD_DEVICE end_cmd",
"monitor_state_rules : CMD_DEVICE memspace end_cmd",
"monitor_state_rules : CMD_EXPORT end_cmd",
"monitor_state_rules : CMD_QUIT end_cmd",
"monitor_state_rules : CMD_EXIT end_cmd",
"monitor_state_rules : CMD_MAINCPU_TRACE end_cmd",
"monitor_state_rules : CMD_MAINCPU_TRACE TOGGLE end_cmd",
"monitor_misc_rules : CMD_DISK rest_of_line end_cmd",
"monitor_misc_rules : CMD_PRINT expression end_cmd",
"monitor_misc_rules : CMD_HELP end_cmd",
"monitor_misc_rules : CMD_HELP rest_of_line end_cmd",
"monitor_misc_rules : CONVERT_OP expression end_cmd",
"monitor_misc_rules : CMD_CHDIR rest_of_line_or_quoted end_cmd",
"monitor_misc_rules : CMD_KEYBUF rest_of_line end_cmd",
"monitor_misc_rules : CMD_BACKTRACE end_cmd",
"monitor_misc_rules : CMD_DIR opt_rest_of_line end_cmd",
"monitor_misc_rules : CMD_PWD end_cmd",
"monitor_misc_rules : CMD_MKDIR rest_of_line_or_quoted end_cmd",
"monitor_misc_rules : CMD_RMDIR rest_of_line_or_quoted end_cmd",
"monitor_misc_rules : CMD_SCREENSHOT filename end_cmd",
"monitor_misc_rules : CMD_SCREENSHOT filename opt_sep expression end_cmd",
"monitor_misc_rules : CMD_RESOURCE_GET STRING end_cmd",
"monitor_misc_rules : CMD_RESOURCE_SET STRING STRING end_cmd",
"monitor_misc_rules : CMD_LOAD_RESOURCES filename end_cmd",
"monitor_misc_rules : CMD_SAVE_RESOURCES filename end_cmd",
"monitor_misc_rules : CMD_MON_RESET end_cmd",
"monitor_misc_rules : CMD_MON_RESET opt_sep expression end_cmd",
"monitor_misc_rules : CMD_TAPECTRL opt_sep expression end_cmd",
"monitor_misc_rules : CMD_TAPEOFFS end_cmd",
"monitor_misc_rules : CMD_TAPEOFFS opt_sep expression end_cmd",
"monitor_misc_rules : CMD_CARTFREEZE end_cmd",
"monitor_misc_rules : CMD_UPDB number end_cmd",
"monitor_misc_rules : CMD_JPDB number number end_cmd",
"monitor_misc_rules : CMD_COMMENT opt_rest_of_line end_cmd",
"monitor_misc_rules : CMD_STOPWATCH RESET end_cmd",
"monitor_misc_rules : CMD_STOPWATCH end_cmd",
"monitor_misc_rules : CMD_PROFILE TOGGLE end_cmd",
"monitor_misc_rules : CMD_PROFILE end_cmd",
"monitor_misc_rules : CMD_PROFILE FLAT opt_d_number end_cmd",
"monitor_misc_rules : CMD_PROFILE GRAPH opt_context_num end_cmd",
"monitor_misc_rules : CMD_PROFILE GRAPH opt_context_num DEPTH d_number end_cmd",
"monitor_misc_rules : CMD_PROFILE FUNC address end_cmd",
"monitor_misc_rules : CMD_PROFILE DISASS address end_cmd",
"monitor_misc_rules : CMD_PROFILE CLEAR address end_cmd",
"monitor_misc_rules : CMD_PROFILE PROFILE_CONTEXT d_number end_cmd",
"disk_rules : CMD_LOAD filename device_num opt_address end_cmd",
"disk_rules : CMD_BASICLOAD filename device_num opt_address end_cmd",
"disk_rules : CMD_BLOAD filename device_num address end_cmd",
"disk_rules : CMD_BLOAD filename device_num error",
"disk_rules : CMD_SAVE filename device_num address_range end_cmd",
"disk_rules : CMD_SAVE filename error",
"disk_rules : CMD_SAVE filename device_num error",
"disk_rules : CMD_BSAVE filename device_num address_range end_cmd",
"disk_rules : CMD_BSAVE filename device_num error",
"disk_rules : CMD_VERIFY filename device_num opt_address end_cmd",
"disk_rules : CMD_BVERIFY filename device_num address end_cmd",
"disk_rules : CMD_BVERIFY filename device_num error",
"disk_rules : CMD_BLOCK_READ expression expression opt_address end_cmd",
"disk_rules : CMD_BLOCK_WRITE expression expression address end_cmd",
"disk_rules : CMD_LIST end_cmd",
"disk_rules : CMD_LIST device_num end_cmd",
"disk_rules : CMD_ATTACH filename expression end_cmd",
"disk_rules : CMD_DETACH expression end_cmd",
"disk_rules : CMD_AUTOSTART filename end_cmd",
"disk_rules : CMD_AUTOSTART filename opt_sep number end_cmd",
"disk_rules : CMD_AUTOLOAD filename end_cmd",
"disk_rules : CMD_AUTOLOAD filename opt_sep number end_cmd",
"cmd_file_rules : CMD_RECORD filename end_cmd",
"cmd_file_rules : CMD_MON_STOP end_cmd",
"cmd_file_rules : CMD_PLAYBACK filename end_cmd",
"data_entry_rules : CMD_ENTER_DATA address data_list end_cmd",
"data_entry_rules : CMD_ENTER_BIN_DATA end_cmd",
"monitor_debug_rules : CMD_YYDEBUG end_cmd",
"rest_of_line : R_O_L",
"opt_rest_of_line : R_O_L",
"opt_rest_of_line :",
"rest_of_line_or_quoted : R_O_L_Q",
"filename : FILENAME",
"filename : error",
"device_num : d_number",
"device_num : error",
"mem_op : mem_op MEM_OP",
"mem_op : MEM_OP",
"opt_mem_op : mem_op",
"opt_mem_op :",
"register : MON_REGISTER",
"register : memspace MON_REGISTER",
"reg_list : reg_list COMMA reg_asgn",
"reg_list : reg_asgn",
"reg_asgn : register EQUALS number",
"checkpt_num : d_number",
"checkpt_num : error",
"opt_context_num : d_number",
"opt_context_num :",
"address_opt_range : address_range",
"address_opt_range : address",
"address_range : address opt_sep address",
"address_range : H_RANGE_GUESS",
"address_range : memspace opt_sep H_RANGE_GUESS",
"opt_address : opt_sep address",
"opt_address :",
"address : memloc",
"address : memspace opt_sep memloc",
"address : LABEL",
"opt_sep : COMMA",
"opt_sep :",
"memspace : MEM_COMP",
"memspace : MEM_DISK8",
"memspace : MEM_DISK9",
"memspace : MEM_DISK10",
"memspace : MEM_DISK11",
"memloc : memaddr",
"memaddr : number",
"expression : expression '+' expression",
"expression : expression '-' expression",
"expression : expression '*' expression",
"expression : expression '/' expression",
"expression : '(' expression ')'",
"expression : '(' expression error",
"expression : value",
"opt_if_cond_expr : IF cond_expr",
"opt_if_cond_expr :",
"cond_expr : cond_expr COND_OP cond_expr",
"cond_expr : cond_expr COND_OP error",
"cond_expr : L_PAREN cond_expr R_PAREN",
"cond_expr : L_PAREN cond_expr error",
"cond_expr : cond_operand",
"cond_operand : register",
"cond_operand : number",
"cond_operand : '@' BANKNAME ':' L_PAREN cond_expr R_PAREN",
"cond_operand : '@' BANKNAME ':' address",
"data_list : data_list opt_sep data_element",
"data_list : data_element",
"data_element : number",
"data_element : STRING",
"hunt_list : hunt_list hunt_element",
"hunt_list : hunt_element",
"hunt_element : number",
"hunt_element : MASK",
"hunt_element : STRING",
"value : number",
"value : register",
"d_number : D_NUMBER",
"d_number : B_NUMBER_GUESS",
"d_number : D_NUMBER_GUESS",
"d_number : O_NUMBER_GUESS",
"opt_d_number : d_number",
"opt_d_number :",
"guess_default : B_NUMBER_GUESS",
"guess_default : D_NUMBER_GUESS",
"guess_default : O_NUMBER_GUESS",
"number : H_NUMBER",
"number : B_NUMBER",
"number : D_NUMBER",
"number : O_NUMBER",
"number : guess_default",
"assembly_instr_list : assembly_instr_list INST_SEP assembly_instruction",
"assembly_instr_list : assembly_instruction INST_SEP assembly_instruction",
"assembly_instr_list : assembly_instruction INST_SEP",
"assembly_instruction : OPCODE asm_operand_mode",
"post_assemble : assembly_instruction",
"post_assemble : assembly_instr_list",
"asm_operand_mode : ARG_IMMEDIATE number",
"asm_operand_mode : number",
"asm_operand_mode : number COMMA REG_X",
"asm_operand_mode : number COMMA REG_Y",
"asm_operand_mode : number COMMA REG_S",
"asm_operand_mode : number COMMA number",
"asm_operand_mode : L_PAREN number R_PAREN",
"asm_operand_mode : L_PAREN number COMMA REG_X R_PAREN",
"asm_operand_mode : L_PAREN number COMMA REG_S R_PAREN COMMA REG_Y",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_Y",
"asm_operand_mode : L_PAREN REG_BC R_PAREN",
"asm_operand_mode : L_PAREN REG_DE R_PAREN",
"asm_operand_mode : L_PAREN REG_HL R_PAREN",
"asm_operand_mode : L_PAREN REG_IX R_PAREN",
"asm_operand_mode : L_PAREN REG_IY R_PAREN",
"asm_operand_mode : L_PAREN REG_SP R_PAREN",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_A",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_HL",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_IX",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_IY",
"asm_operand_mode :",
"asm_operand_mode : REG_A",
"asm_operand_mode : REG_B",
"asm_operand_mode : REG_C",
"asm_operand_mode : REG_D",
"asm_operand_mode : REG_E",
"asm_operand_mode : REG_H",
"asm_operand_mode : REG_IXH",
"asm_operand_mode : REG_IYH",
"asm_operand_mode : REG_L",
"asm_operand_mode : REG_IXL",
"asm_operand_mode : REG_IYL",
"asm_operand_mode : REG_AF",
"asm_operand_mode : REG_BC",
"asm_operand_mode : REG_DE",
"asm_operand_mode : REG_HL",
"asm_operand_mode : REG_IX",
"asm_operand_mode : REG_IY",
"asm_operand_mode : REG_SP",
"asm_operand_mode : LESS_THAN number",
"asm_operand_mode : number COMMA index_ureg",
"asm_operand_mode : COMMA index_reg PLUS",
"asm_operand_mode : COMMA index_reg PLUS PLUS",
"asm_operand_mode : COMMA MINUS index_reg",
"asm_operand_mode : COMMA MINUS MINUS index_reg",
"asm_operand_mode : COMMA index_reg",
"asm_operand_mode : REG_B COMMA index_reg",
"asm_operand_mode : REG_A COMMA index_reg",
"asm_operand_mode : REG_D COMMA index_reg",
"asm_operand_mode : number COMMA REG_PC",
"asm_operand_mode : L_BRACKET number COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA index_reg PLUS R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA index_reg PLUS PLUS R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA MINUS index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA MINUS MINUS index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET REG_B COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET REG_A COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET REG_D COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET number COMMA REG_PC R_BRACKET",
"asm_operand_mode : L_BRACKET number R_BRACKET",
"asm_operand_mode : L_BRACKET number R_BRACKET COMMA REG_Y",
"index_reg : REG_X",
"index_reg : REG_Y",
"index_reg : index_ureg",
"index_reg : REG_S",
"index_ureg : REG_U",

};
#endif

#if YYDEBUG
int      yydebug;
#endif

int      yyerrflag;
int      yychar;
YYSTYPE  yyval;
YYSTYPE  yylval;
int      yynerrs;

#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
YYLTYPE  yyloc; /* position returned by actions */
YYLTYPE  yylloc; /* position from the lexer */
#endif

#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
#ifndef YYLLOC_DEFAULT
#define YYLLOC_DEFAULT(loc, rhs, n) \
do \
{ \
    if (n == 0) \
    { \
        (loc).first_line   = YYRHSLOC(rhs, 0).last_line; \
        (loc).first_column = YYRHSLOC(rhs, 0).last_column; \
        (loc).last_line    = YYRHSLOC(rhs, 0).last_line; \
        (loc).last_column  = YYRHSLOC(rhs, 0).last_column; \
    } \
    else \
    { \
        (loc).first_line   = YYRHSLOC(rhs, 1).first_line; \
        (loc).first_column = YYRHSLOC(rhs, 1).first_column; \
        (loc).last_line    = YYRHSLOC(rhs, n).last_line; \
        (loc).last_column  = YYRHSLOC(rhs, n).last_column; \
    } \
} while (0)
#endif /* YYLLOC_DEFAULT */
#endif /* defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED) */
#if YYBTYACC

#ifndef YYLVQUEUEGROWTH
#define YYLVQUEUEGROWTH 32
#endif
#endif /* YYBTYACC */

/* define the initial stack-sizes */
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH  YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH  10000
#endif
#endif

#ifndef YYINITSTACKSIZE
#define YYINITSTACKSIZE 200
#endif

typedef struct {
    unsigned stacksize;
    YYINT    *s_base;
    YYINT    *s_mark;
    YYINT    *s_last;
    YYSTYPE  *l_base;
    YYSTYPE  *l_mark;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    YYLTYPE  *p_base;
    YYLTYPE  *p_mark;
#endif
} YYSTACKDATA;
#if YYBTYACC

struct YYParseState_s
{
    struct YYParseState_s *save;    /* Previously saved parser state */
    YYSTACKDATA            yystack; /* saved parser stack */
    int                    state;   /* saved parser state */
    int                    errflag; /* saved error recovery status */
    int                    lexeme;  /* saved index of the conflict lexeme in the lexical queue */
    YYINT                  ctry;    /* saved index in yyctable[] for this conflict */
};
typedef struct YYParseState_s YYParseState;
#endif /* YYBTYACC */
/* variables for the parser stack */
static YYSTACKDATA yystack;
#if YYBTYACC

/* Current parser state */
static YYParseState *yyps = 0;

/* yypath != NULL: do the full parse, starting at *yypath parser state. */
static YYParseState *yypath = 0;

/* Base of the lexical value queue */
static YYSTYPE *yylvals = 0;

/* Current position at lexical value queue */
static YYSTYPE *yylvp = 0;

/* End position of lexical value queue */
static YYSTYPE *yylve = 0;

/* The last allocated position at the lexical value queue */
static YYSTYPE *yylvlim = 0;

#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
/* Base of the lexical position queue */
static YYLTYPE *yylpsns = 0;

/* Current position at lexical position queue */
static YYLTYPE *yylpp = 0;

/* End position of lexical position queue */
static YYLTYPE *yylpe = 0;

/* The last allocated position at the lexical position queue */
static YYLTYPE *yylplim = 0;
#endif

/* Current position at lexical token queue */
static YYINT  *yylexp = 0;

static YYINT  *yylexemes = 0;
#endif /* YYBTYACC */
#line 1212 "mon_parse.y"

int parse_and_execute_line(char *input)
{
   char *temp_buf;
   int i, rc;

   if (default_memspace == e_comp_space) {
       /*
        * If the command is to be executed when the default address space is the main cpu,
        * Ensure drive CPU emulation is up to date with main cpu CLOCK.
        */
       drive_cpu_execute_all(maincpu_clk);
   }

   temp_buf = lib_malloc(strlen(input) + 3);
   strcpy(temp_buf,input);
   i = (int)strlen(input);
   temp_buf[i++] = '\n';
   temp_buf[i++] = '\0';
   temp_buf[i++] = '\0';

   make_buffer(temp_buf);
   mon_clear_buffer();
   if ( (rc =yyparse()) != 0) {
       mon_out("ERROR -- ");
       switch(rc) {
         case ERR_BAD_CMD:
           mon_out("Bad command:\n");
           break;
         case ERR_RANGE_BAD_START:
           mon_out("Bad first address in range:\n");
           break;
         case ERR_RANGE_BAD_END:
           mon_out("Bad second address in range:\n");
           break;
         case ERR_EXPECT_CHECKNUM:
           mon_out("Checkpoint number expected:\n");
           break;
         case ERR_EXPECT_END_CMD:
           mon_out("Unexpected token:\n");
           break;
         case ERR_MISSING_CLOSE_PAREN:
           mon_out("')' expected:\n");
           break;
         case ERR_INCOMPLETE_COND_OP:
           mon_out("Conditional operation missing an operand:\n");
           break;
         case ERR_EXPECT_FILENAME:
           mon_out("Expecting a filename:\n");
           break;
         case ERR_ADDR_TOO_BIG:
           mon_out("Address too large:\n");
           break;
         case ERR_IMM_TOO_BIG:
           mon_out("Immediate argument too large:\n");
           break;
         case ERR_EXPECT_STRING:
           mon_out("Expecting a string.\n");
           break;
         case ERR_UNDEFINED_LABEL:
           mon_out("Found an undefined label.\n");
           break;
         case ERR_EXPECT_DEVICE_NUM:
           mon_out("Expecting a device number.\n");
           break;
         case ERR_EXPECT_ADDRESS:
           mon_out("Expecting an address.\n");
           break;
         case ERR_INVALID_REGISTER:
           mon_out("Invalid register.\n");
           break;
         case ERR_ILLEGAL_INPUT:
         default:
           mon_out("Wrong syntax:\n");
       }
       mon_out("  %s\n", input);
       for (i = 0; i < last_len; i++)
           mon_out(" ");
       mon_out("  ^\n");
       asm_mode = 0;
       new_cmd = 1;
   }
   lib_free(temp_buf);
   free_buffer();

   return rc;
}

void set_yydebug(int val)
{
#if YYDEBUG
    yydebug = val;
#else
#endif
}

static int yyerror(char *s)
{
#if 0
   fprintf(stderr, "ERR:%s\n", s);
#endif
   return 0;
}

/* convert the string in "num" to a numeric value, depending on radix. this 
   function does some magic conversion on addresses when radix is not hex.
*/
static int resolve_datatype(unsigned guess_type, const char *num)
{
    int binary = 1, hex = 0, octal = 0, decimal = 1;
    const char *c;

    /* FIXME: Handle cases when default type is non-numerical */
    if (default_radix == e_hexadecimal) {
        return (int)strtol(num, NULL, 16);
    }

    /* we do some educated guessing on what type of number we have here */
    if (num[0] == '0') {
        /* might be octal with leading zero */
        octal = 1;
    }
    /* a string containing any digits not 0 or 1 can't be a binary number */
    c = num;
    while (*c) {
        if ((*c != '0') && (*c != '1')) {
            binary = 0;
            break;
        }
        c++;
    }
    /* a string containing 8 or 9 can't be an octal number */
    c = num;
    while (*c) {
        if ((*c == '8') && (*c == '9')) {
            octal = 0;
            break;
        }
        c++;
    }
    /* a string containing any of A-F can only be a hex number */
    c = num;
    while (*c) {
        if ((tolower((unsigned char)*c) >= 'a') && (tolower((unsigned char)*c) <= 'f')) {
            hex = 1;
            octal = 0;
            binary = 0;
            decimal = 0;
            break;
        }
        c++;
    }

    /* a hex number can only be hex no matter what */
    if (hex) {
        return (int)strtol(num, NULL, 16);
    }

    /* first, if default radix and detected number matches, just do it */
    if (binary && (default_radix == e_binary)) {
        return (int)strtol(num, NULL, 2);
    }
    if (decimal && (default_radix == e_decimal)) {
        return (int)strtol(num, NULL, 10);
    }
    if (octal && (default_radix == e_octal)) {
        return (int)strtol(num, NULL, 8);
    }

    /* second, if detected number matches guess type, do it */
    if (binary && (guess_type == B_NUMBER)) {
        return (int)strtol(num, NULL, 2);
    }
    if (decimal && (guess_type == D_NUMBER)) {
        return (int)strtol(num, NULL, 10);
    }
    if (octal && (guess_type == O_NUMBER)) {
        return (int)strtol(num, NULL, 8);
    }

    /* third only use the detected type */
    if (binary) {
        return (int)strtol(num, NULL, 2);
    }
    if (decimal) {
        return (int)strtol(num, NULL, 10);
    }
    if (octal) {
        return (int)strtol(num, NULL, 8);
    }

    /* use hex as default, should we ever come here */
    return (int)strtol(num, NULL, 16);
}

/*
 * Resolve a character sequence containing 8 hex digits like "08001000".
 * This could be a lazy version of "0800 1000". If the default radix is not
 * hexadecimal, we handle it like a ordinary number, in the latter case there
 * is only one number in the range.
 */
static int resolve_range(enum t_memspace memspace, MON_ADDR range[2],
                         const char *num)
{
    char start[5];
    char end[5];
    long sa;

    range[1] = BAD_ADDR;

    switch (default_radix)
    {
    case e_hexadecimal:
        /* checked twice, but as the code must have exactly 8 digits: */
        if (strlen(num) == 8) {
            memcpy(start, num, 4);
            start[4] = '\0';
            memcpy(end, num + 4, 4);
            end[4] = '\0';
            sa = strtol(start, NULL, 16);
            range[1] = (int)new_addr(memspace, strtol(end, NULL, 16));
        }
        else
            sa = strtol(num, NULL, 16);
        break;

    case e_decimal:
       sa = strtol(num, NULL, 10);
       break;

    case e_octal:
       sa = strtol(num, NULL, 8);
       break;

    default:
       sa = strtol(num, NULL, 2);
    }

    if (!CHECK_ADDR(sa))
        return ERR_ADDR_TOO_BIG;

    range[0] = (int)new_addr(memspace, sa);
    return 0;
}
#line 2421 "mon_parse.c"

/* For use in generated program */
#define yydepth (int)(yystack.s_mark - yystack.s_base)
#if YYBTYACC
#define yytrial (yyps->save)
#endif /* YYBTYACC */

#if YYDEBUG
#include <stdio.h>	/* needed for printf */
#endif

#include <stdlib.h>	/* needed for malloc, etc */
#include <string.h>	/* needed for memset */

/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack(YYSTACKDATA *data)
{
    int i;
    unsigned newsize;
    YYINT *newss;
    YYSTYPE *newvs;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    YYLTYPE *newps;
#endif

    if ((newsize = data->stacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return YYENOMEM;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;

    i = (int) (data->s_mark - data->s_base);
    newss = (YYINT *)realloc(data->s_base, newsize * sizeof(*newss));
    if (newss == 0)
        return YYENOMEM;

    data->s_base = newss;
    data->s_mark = newss + i;

    newvs = (YYSTYPE *)realloc(data->l_base, newsize * sizeof(*newvs));
    if (newvs == 0)
        return YYENOMEM;

    data->l_base = newvs;
    data->l_mark = newvs + i;

#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    newps = (YYLTYPE *)realloc(data->p_base, newsize * sizeof(*newps));
    if (newps == 0)
        return YYENOMEM;

    data->p_base = newps;
    data->p_mark = newps + i;
#endif

    data->stacksize = newsize;
    data->s_last = data->s_base + newsize - 1;

#if YYDEBUG
    if (yydebug)
        fprintf(stderr, "%sdebug: stack size increased to %d\n", YYPREFIX, newsize);
#endif
    return 0;
}

#if YYPURE || defined(YY_NO_LEAKS)
static void yyfreestack(YYSTACKDATA *data)
{
    free(data->s_base);
    free(data->l_base);
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    free(data->p_base);
#endif
    memset(data, 0, sizeof(*data));
}
#else
#define yyfreestack(data) /* nothing */
#endif /* YYPURE || defined(YY_NO_LEAKS) */
#if YYBTYACC

static YYParseState *
yyNewState(unsigned size)
{
    YYParseState *p = (YYParseState *) malloc(sizeof(YYParseState));
    if (p == NULL) return NULL;

    p->yystack.stacksize = size;
    if (size == 0)
    {
        p->yystack.s_base = NULL;
        p->yystack.l_base = NULL;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
        p->yystack.p_base = NULL;
#endif
        return p;
    }
    p->yystack.s_base    = (YYINT *) malloc(size * sizeof(YYINT));
    if (p->yystack.s_base == NULL) return NULL;
    p->yystack.l_base    = (YYSTYPE *) malloc(size * sizeof(YYSTYPE));
    if (p->yystack.l_base == NULL) return NULL;
    memset(p->yystack.l_base, 0, size * sizeof(YYSTYPE));
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    p->yystack.p_base    = (YYLTYPE *) malloc(size * sizeof(YYLTYPE));
    if (p->yystack.p_base == NULL) return NULL;
    memset(p->yystack.p_base, 0, size * sizeof(YYLTYPE));
#endif

    return p;
}

static void
yyFreeState(YYParseState *p)
{
    yyfreestack(&p->yystack);
    free(p);
}
#endif /* YYBTYACC */

#define YYABORT  goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR  goto yyerrlab
#if YYBTYACC
#define YYVALID        do { if (yyps->save)            goto yyvalid; } while(0)
#define YYVALID_NESTED do { if (yyps->save && \
                                yyps->save->save == 0) goto yyvalid; } while(0)
#endif /* YYBTYACC */

int
YYPARSE_DECL()
{
    int yym, yyn, yystate, yyresult;
#if YYBTYACC
    int yynewerrflag;
    YYParseState *yyerrctx = NULL;
#endif /* YYBTYACC */
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    YYLTYPE  yyerror_loc_range[3]; /* position of error start/end (0 unused) */
#endif
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")) != 0)
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
    if (yydebug)
        fprintf(stderr, "%sdebug[<# of symbols on state stack>]\n", YYPREFIX);
#endif
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    memset(yyerror_loc_range, 0, sizeof(yyerror_loc_range));
#endif

#if YYBTYACC
    yyps = yyNewState(0); if (yyps == 0) goto yyenomem;
    yyps->save = 0;
#endif /* YYBTYACC */
    yym = 0;
    /* yyn is set below */
    yynerrs = 0;
    yyerrflag = 0;
    yychar = YYEMPTY;
    yystate = 0;

#if YYPURE
    memset(&yystack, 0, sizeof(yystack));
#endif

    if (yystack.s_base == NULL && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
    yystack.s_mark = yystack.s_base;
    yystack.l_mark = yystack.l_base;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    yystack.p_mark = yystack.p_base;
#endif
    yystate = 0;
    *yystack.s_mark = 0;

yyloop:
    if ((yyn = yydefred[yystate]) != 0) goto yyreduce;
    if (yychar < 0)
    {
#if YYBTYACC
        do {
        if (yylvp < yylve)
        {
            /* we're currently re-reading tokens */
            yylval = *yylvp++;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            yylloc = *yylpp++;
#endif
            yychar = *yylexp++;
            break;
        }
        if (yyps->save)
        {
            /* in trial mode; save scanner results for future parse attempts */
            if (yylvp == yylvlim)
            {   /* Enlarge lexical value queue */
                size_t p = (size_t) (yylvp - yylvals);
                size_t s = (size_t) (yylvlim - yylvals);

                s += YYLVQUEUEGROWTH;
                if ((yylexemes = (YYINT *)realloc(yylexemes, s * sizeof(YYINT))) == NULL) goto yyenomem;
                if ((yylvals   = (YYSTYPE *)realloc(yylvals, s * sizeof(YYSTYPE))) == NULL) goto yyenomem;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                if ((yylpsns   = (YYLTYPE *)realloc(yylpsns, s * sizeof(YYLTYPE))) == NULL) goto yyenomem;
#endif
                yylvp   = yylve = yylvals + p;
                yylvlim = yylvals + s;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                yylpp   = yylpe = yylpsns + p;
                yylplim = yylpsns + s;
#endif
                yylexp  = yylexemes + p;
            }
            *yylexp = (YYINT) YYLEX;
            *yylvp++ = yylval;
            yylve++;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            *yylpp++ = yylloc;
            yylpe++;
#endif
            yychar = *yylexp++;
            break;
        }
        /* normal operation, no conflict encountered */
#endif /* YYBTYACC */
        yychar = YYLEX;
#if YYBTYACC
        } while (0);
#endif /* YYBTYACC */
        if (yychar < 0) yychar = YYEOF;
#if YYDEBUG
        if (yydebug)
        {
            if ((yys = yyname[YYTRANSLATE(yychar)]) == NULL) yys = yyname[YYUNDFTOKEN];
            fprintf(stderr, "%s[%d]: state %d, reading token %d (%s)",
                            YYDEBUGSTR, yydepth, yystate, yychar, yys);
#ifdef YYSTYPE_TOSTRING
#if YYBTYACC
            if (!yytrial)
#endif /* YYBTYACC */
                fprintf(stderr, " <%s>", YYSTYPE_TOSTRING(yychar, yylval));
#endif
            fputc('\n', stderr);
        }
#endif
    }
#if YYBTYACC

    /* Do we have a conflict? */
    if (((yyn = yycindex[yystate]) != 0) && (yyn += yychar) >= 0 &&
        yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yychar)
    {
        YYINT ctry;

        if (yypath)
        {
            YYParseState *save;
#if YYDEBUG
            if (yydebug)
                fprintf(stderr, "%s[%d]: CONFLICT in state %d: following successful trial parse\n",
                                YYDEBUGSTR, yydepth, yystate);
#endif
            /* Switch to the next conflict context */
            save = yypath;
            yypath = save->save;
            save->save = NULL;
            ctry = save->ctry;
            if (save->state != yystate) YYABORT;
            yyFreeState(save);

        }
        else
        {

            /* Unresolved conflict - start/continue trial parse */
            YYParseState *save;
#if YYDEBUG
            if (yydebug)
            {
                fprintf(stderr, "%s[%d]: CONFLICT in state %d. ", YYDEBUGSTR, yydepth, yystate);
                if (yyps->save)
                    fputs("ALREADY in conflict, continuing trial parse.\n", stderr);
                else
                    fputs("Starting trial parse.\n", stderr);
            }
#endif
            save                  = yyNewState((unsigned)(yystack.s_mark - yystack.s_base + 1));
            if (save == NULL) goto yyenomem;
            save->save            = yyps->save;
            save->state           = yystate;
            save->errflag         = yyerrflag;
            save->yystack.s_mark  = save->yystack.s_base + (yystack.s_mark - yystack.s_base);
            memcpy (save->yystack.s_base, yystack.s_base, (size_t) (yystack.s_mark - yystack.s_base + 1) * sizeof(YYINT));
            save->yystack.l_mark  = save->yystack.l_base + (yystack.l_mark - yystack.l_base);
            memcpy (save->yystack.l_base, yystack.l_base, (size_t) (yystack.l_mark - yystack.l_base + 1) * sizeof(YYSTYPE));
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            save->yystack.p_mark  = save->yystack.p_base + (yystack.p_mark - yystack.p_base);
            memcpy (save->yystack.p_base, yystack.p_base, (size_t) (yystack.p_mark - yystack.p_base + 1) * sizeof(YYLTYPE));
#endif
            ctry                  = yytable[yyn];
            if (yyctable[ctry] == -1)
            {
#if YYDEBUG
                if (yydebug && yychar >= YYEOF)
                    fprintf(stderr, "%s[%d]: backtracking 1 token\n", YYDEBUGSTR, yydepth);
#endif
                ctry++;
            }
            save->ctry = ctry;
            if (yyps->save == NULL)
            {
                /* If this is a first conflict in the stack, start saving lexemes */
                if (!yylexemes)
                {
                    yylexemes = (YYINT *) malloc((YYLVQUEUEGROWTH) * sizeof(YYINT));
                    if (yylexemes == NULL) goto yyenomem;
                    yylvals   = (YYSTYPE *) malloc((YYLVQUEUEGROWTH) * sizeof(YYSTYPE));
                    if (yylvals == NULL) goto yyenomem;
                    yylvlim   = yylvals + YYLVQUEUEGROWTH;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                    yylpsns   = (YYLTYPE *) malloc((YYLVQUEUEGROWTH) * sizeof(YYLTYPE));
                    if (yylpsns == NULL) goto yyenomem;
                    yylplim   = yylpsns + YYLVQUEUEGROWTH;
#endif
                }
                if (yylvp == yylve)
                {
                    yylvp  = yylve = yylvals;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                    yylpp  = yylpe = yylpsns;
#endif
                    yylexp = yylexemes;
                    if (yychar >= YYEOF)
                    {
                        *yylve++ = yylval;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                        *yylpe++ = yylloc;
#endif
                        *yylexp  = (YYINT) yychar;
                        yychar   = YYEMPTY;
                    }
                }
            }
            if (yychar >= YYEOF)
            {
                yylvp--;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                yylpp--;
#endif
                yylexp--;
                yychar = YYEMPTY;
            }
            save->lexeme = (int) (yylvp - yylvals);
            yyps->save   = save;
        }
        if (yytable[yyn] == ctry)
        {
#if YYDEBUG
            if (yydebug)
                fprintf(stderr, "%s[%d]: state %d, shifting to state %d\n",
                                YYDEBUGSTR, yydepth, yystate, yyctable[ctry]);
#endif
            if (yychar < 0)
            {
                yylvp++;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                yylpp++;
#endif
                yylexp++;
            }
            if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM)
                goto yyoverflow;
            yystate = yyctable[ctry];
            *++yystack.s_mark = (YYINT) yystate;
            *++yystack.l_mark = yylval;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            *++yystack.p_mark = yylloc;
#endif
            yychar  = YYEMPTY;
            if (yyerrflag > 0) --yyerrflag;
            goto yyloop;
        }
        else
        {
            yyn = yyctable[ctry];
            goto yyreduce;
        }
    } /* End of code dealing with conflicts */
#endif /* YYBTYACC */
    if (((yyn = yysindex[yystate]) != 0) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yychar)
    {
#if YYDEBUG
        if (yydebug)
            fprintf(stderr, "%s[%d]: state %d, shifting to state %d\n",
                            YYDEBUGSTR, yydepth, yystate, yytable[yyn]);
#endif
        if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
        yystate = yytable[yyn];
        *++yystack.s_mark = yytable[yyn];
        *++yystack.l_mark = yylval;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
        *++yystack.p_mark = yylloc;
#endif
        yychar = YYEMPTY;
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if (((yyn = yyrindex[yystate]) != 0) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag != 0) goto yyinrecovery;
#if YYBTYACC

    yynewerrflag = 1;
    goto yyerrhandler;
    goto yyerrlab; /* redundant goto avoids 'unused label' warning */

yyerrlab:
    /* explicit YYERROR from an action -- pop the rhs of the rule reduced
     * before looking for error recovery */
    yystack.s_mark -= yym;
    yystate = *yystack.s_mark;
    yystack.l_mark -= yym;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    yystack.p_mark -= yym;
#endif

    yynewerrflag = 0;
yyerrhandler:
    while (yyps->save)
    {
        int ctry;
        YYParseState *save = yyps->save;
#if YYDEBUG
        if (yydebug)
            fprintf(stderr, "%s[%d]: ERROR in state %d, CONFLICT BACKTRACKING to state %d, %d tokens\n",
                            YYDEBUGSTR, yydepth, yystate, yyps->save->state,
                    (int)(yylvp - yylvals - yyps->save->lexeme));
#endif
        /* Memorize most forward-looking error state in case it's really an error. */
        if (yyerrctx == NULL || yyerrctx->lexeme < yylvp - yylvals)
        {
            /* Free old saved error context state */
            if (yyerrctx) yyFreeState(yyerrctx);
            /* Create and fill out new saved error context state */
            yyerrctx                 = yyNewState((unsigned)(yystack.s_mark - yystack.s_base + 1));
            if (yyerrctx == NULL) goto yyenomem;
            yyerrctx->save           = yyps->save;
            yyerrctx->state          = yystate;
            yyerrctx->errflag        = yyerrflag;
            yyerrctx->yystack.s_mark = yyerrctx->yystack.s_base + (yystack.s_mark - yystack.s_base);
            memcpy (yyerrctx->yystack.s_base, yystack.s_base, (size_t) (yystack.s_mark - yystack.s_base + 1) * sizeof(YYINT));
            yyerrctx->yystack.l_mark = yyerrctx->yystack.l_base + (yystack.l_mark - yystack.l_base);
            memcpy (yyerrctx->yystack.l_base, yystack.l_base, (size_t) (yystack.l_mark - yystack.l_base + 1) * sizeof(YYSTYPE));
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            yyerrctx->yystack.p_mark = yyerrctx->yystack.p_base + (yystack.p_mark - yystack.p_base);
            memcpy (yyerrctx->yystack.p_base, yystack.p_base, (size_t) (yystack.p_mark - yystack.p_base + 1) * sizeof(YYLTYPE));
#endif
            yyerrctx->lexeme         = (int) (yylvp - yylvals);
        }
        yylvp          = yylvals   + save->lexeme;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
        yylpp          = yylpsns   + save->lexeme;
#endif
        yylexp         = yylexemes + save->lexeme;
        yychar         = YYEMPTY;
        yystack.s_mark = yystack.s_base + (save->yystack.s_mark - save->yystack.s_base);
        memcpy (yystack.s_base, save->yystack.s_base, (size_t) (yystack.s_mark - yystack.s_base + 1) * sizeof(YYINT));
        yystack.l_mark = yystack.l_base + (save->yystack.l_mark - save->yystack.l_base);
        memcpy (yystack.l_base, save->yystack.l_base, (size_t) (yystack.l_mark - yystack.l_base + 1) * sizeof(YYSTYPE));
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
        yystack.p_mark = yystack.p_base + (save->yystack.p_mark - save->yystack.p_base);
        memcpy (yystack.p_base, save->yystack.p_base, (size_t) (yystack.p_mark - yystack.p_base + 1) * sizeof(YYLTYPE));
#endif
        ctry           = ++save->ctry;
        yystate        = save->state;
        /* We tried shift, try reduce now */
        if ((yyn = yyctable[ctry]) >= 0) goto yyreduce;
        yyps->save     = save->save;
        save->save     = NULL;
        yyFreeState(save);

        /* Nothing left on the stack -- error */
        if (!yyps->save)
        {
#if YYDEBUG
            if (yydebug)
                fprintf(stderr, "%sdebug[%d,trial]: trial parse FAILED, entering ERROR mode\n",
                                YYPREFIX, yydepth);
#endif
            /* Restore state as it was in the most forward-advanced error */
            yylvp          = yylvals   + yyerrctx->lexeme;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            yylpp          = yylpsns   + yyerrctx->lexeme;
#endif
            yylexp         = yylexemes + yyerrctx->lexeme;
            yychar         = yylexp[-1];
            yylval         = yylvp[-1];
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            yylloc         = yylpp[-1];
#endif
            yystack.s_mark = yystack.s_base + (yyerrctx->yystack.s_mark - yyerrctx->yystack.s_base);
            memcpy (yystack.s_base, yyerrctx->yystack.s_base, (size_t) (yystack.s_mark - yystack.s_base + 1) * sizeof(YYINT));
            yystack.l_mark = yystack.l_base + (yyerrctx->yystack.l_mark - yyerrctx->yystack.l_base);
            memcpy (yystack.l_base, yyerrctx->yystack.l_base, (size_t) (yystack.l_mark - yystack.l_base + 1) * sizeof(YYSTYPE));
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            yystack.p_mark = yystack.p_base + (yyerrctx->yystack.p_mark - yyerrctx->yystack.p_base);
            memcpy (yystack.p_base, yyerrctx->yystack.p_base, (size_t) (yystack.p_mark - yystack.p_base + 1) * sizeof(YYLTYPE));
#endif
            yystate        = yyerrctx->state;
            yyFreeState(yyerrctx);
            yyerrctx       = NULL;
        }
        yynewerrflag = 1;
    }
    if (yynewerrflag == 0) goto yyinrecovery;
#endif /* YYBTYACC */

    YYERROR_CALL("syntax error");
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    yyerror_loc_range[1] = yylloc; /* lookahead position is error start position */
#endif

#if !YYBTYACC
    goto yyerrlab; /* redundant goto avoids 'unused label' warning */
yyerrlab:
#endif
    ++yynerrs;

yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if (((yyn = yysindex[*yystack.s_mark]) != 0) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    fprintf(stderr, "%s[%d]: state %d, error recovery shifting to state %d\n",
                                    YYDEBUGSTR, yydepth, *yystack.s_mark, yytable[yyn]);
#endif
                if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
                yystate = yytable[yyn];
                *++yystack.s_mark = yytable[yyn];
                *++yystack.l_mark = yylval;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                /* lookahead position is error end position */
                yyerror_loc_range[2] = yylloc;
                YYLLOC_DEFAULT(yyloc, yyerror_loc_range, 2); /* position of error span */
                *++yystack.p_mark = yyloc;
#endif
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    fprintf(stderr, "%s[%d]: error recovery discarding state %d\n",
                                    YYDEBUGSTR, yydepth, *yystack.s_mark);
#endif
                if (yystack.s_mark <= yystack.s_base) goto yyabort;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                /* the current TOS position is the error start position */
                yyerror_loc_range[1] = *yystack.p_mark;
#endif
#if defined(YYDESTRUCT_CALL)
#if YYBTYACC
                if (!yytrial)
#endif /* YYBTYACC */
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                    YYDESTRUCT_CALL("error: discarding state",
                                    yystos[*yystack.s_mark], yystack.l_mark, yystack.p_mark);
#else
                    YYDESTRUCT_CALL("error: discarding state",
                                    yystos[*yystack.s_mark], yystack.l_mark);
#endif /* defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED) */
#endif /* defined(YYDESTRUCT_CALL) */
                --yystack.s_mark;
                --yystack.l_mark;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                --yystack.p_mark;
#endif
            }
        }
    }
    else
    {
        if (yychar == YYEOF) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            if ((yys = yyname[YYTRANSLATE(yychar)]) == NULL) yys = yyname[YYUNDFTOKEN];
            fprintf(stderr, "%s[%d]: state %d, error recovery discarding token %d (%s)\n",
                            YYDEBUGSTR, yydepth, yystate, yychar, yys);
        }
#endif
#if defined(YYDESTRUCT_CALL)
#if YYBTYACC
        if (!yytrial)
#endif /* YYBTYACC */
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            YYDESTRUCT_CALL("error: discarding token", yychar, &yylval, &yylloc);
#else
            YYDESTRUCT_CALL("error: discarding token", yychar, &yylval);
#endif /* defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED) */
#endif /* defined(YYDESTRUCT_CALL) */
        yychar = YYEMPTY;
        goto yyloop;
    }

yyreduce:
    yym = yylen[yyn];
#if YYDEBUG
    if (yydebug)
    {
        fprintf(stderr, "%s[%d]: state %d, reducing by rule %d (%s)",
                        YYDEBUGSTR, yydepth, yystate, yyn, yyrule[yyn]);
#ifdef YYSTYPE_TOSTRING
#if YYBTYACC
        if (!yytrial)
#endif /* YYBTYACC */
            if (yym > 0)
            {
                int i;
                fputc('<', stderr);
                for (i = yym; i > 0; i--)
                {
                    if (i != yym) fputs(", ", stderr);
                    fputs(YYSTYPE_TOSTRING(yystos[yystack.s_mark[1-i]],
                                           yystack.l_mark[1-i]), stderr);
                }
                fputc('>', stderr);
            }
#endif
        fputc('\n', stderr);
    }
#endif
    if (yym > 0)
        yyval = yystack.l_mark[1-yym];
    else
        memset(&yyval, 0, sizeof yyval);
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)

    /* Perform position reduction */
    memset(&yyloc, 0, sizeof(yyloc));
#if YYBTYACC
    if (!yytrial)
#endif /* YYBTYACC */
    {
        YYLLOC_DEFAULT(yyloc, &yystack.p_mark[-yym], yym);
        /* just in case YYERROR is invoked within the action, save
           the start of the rhs as the error start position */
        yyerror_loc_range[1] = yystack.p_mark[1-yym];
    }
#endif

    switch (yyn)
    {
case 1:
#line 189 "mon_parse.y"
	{ yyval.i = 0; }
#line 3094 "mon_parse.c"
break;
case 2:
#line 190 "mon_parse.y"
	{ yyval.i = 0; }
#line 3099 "mon_parse.c"
break;
case 3:
#line 191 "mon_parse.y"
	{ new_cmd = 1; asm_mode = 0;  yyval.i = 0; }
#line 3104 "mon_parse.c"
break;
case 8:
#line 200 "mon_parse.y"
	{ return ERR_EXPECT_END_CMD; }
#line 3109 "mon_parse.c"
break;
case 21:
#line 215 "mon_parse.y"
	{ return ERR_BAD_CMD; }
#line 3114 "mon_parse.c"
break;
case 22:
#line 219 "mon_parse.y"
	{ mon_bank(e_default_space, NULL); }
#line 3119 "mon_parse.c"
break;
case 23:
#line 221 "mon_parse.y"
	{ mon_bank(yystack.l_mark[-1].i, NULL); }
#line 3124 "mon_parse.c"
break;
case 24:
#line 223 "mon_parse.y"
	{ mon_bank(e_default_space, yystack.l_mark[-1].str); }
#line 3129 "mon_parse.c"
break;
case 25:
#line 225 "mon_parse.y"
	{ mon_bank(yystack.l_mark[-3].i, yystack.l_mark[-1].str); }
#line 3134 "mon_parse.c"
break;
case 26:
#line 227 "mon_parse.y"
	{ mon_jump(yystack.l_mark[-1].a); }
#line 3139 "mon_parse.c"
break;
case 27:
#line 229 "mon_parse.y"
	{ mon_go(); }
#line 3144 "mon_parse.c"
break;
case 28:
#line 231 "mon_parse.y"
	{ mon_display_io_regs(0); }
#line 3149 "mon_parse.c"
break;
case 29:
#line 233 "mon_parse.y"
	{ mon_display_io_regs(yystack.l_mark[-1].a); }
#line 3154 "mon_parse.c"
break;
case 30:
#line 235 "mon_parse.y"
	{ monitor_cpu_type_set(""); }
#line 3159 "mon_parse.c"
break;
case 31:
#line 237 "mon_parse.y"
	{ monitor_cpu_type_set(yystack.l_mark[-1].str); }
#line 3164 "mon_parse.c"
break;
case 32:
#line 239 "mon_parse.y"
	{ mon_cpuhistory(-1, e_invalid_space,  e_invalid_space, e_invalid_space, e_invalid_space, e_invalid_space); }
#line 3169 "mon_parse.c"
break;
case 33:
#line 241 "mon_parse.y"
	{ mon_cpuhistory(-1, yystack.l_mark[-1].i, e_invalid_space, e_invalid_space, e_invalid_space, e_invalid_space); }
#line 3174 "mon_parse.c"
break;
case 34:
#line 243 "mon_parse.y"
	{ mon_cpuhistory(-1, yystack.l_mark[-3].i, yystack.l_mark[-1].i, e_invalid_space, e_invalid_space, e_invalid_space); }
#line 3179 "mon_parse.c"
break;
case 35:
#line 245 "mon_parse.y"
	{ mon_cpuhistory(-1, yystack.l_mark[-5].i, yystack.l_mark[-3].i, yystack.l_mark[-1].i, e_invalid_space, e_invalid_space); }
#line 3184 "mon_parse.c"
break;
case 36:
#line 247 "mon_parse.y"
	{ mon_cpuhistory(-1, yystack.l_mark[-7].i, yystack.l_mark[-5].i, yystack.l_mark[-3].i,  yystack.l_mark[-1].i, e_invalid_space); }
#line 3189 "mon_parse.c"
break;
case 37:
#line 249 "mon_parse.y"
	{ mon_cpuhistory(-1, yystack.l_mark[-9].i, yystack.l_mark[-7].i, yystack.l_mark[-5].i,  yystack.l_mark[-3].i, yystack.l_mark[-1].i); }
#line 3194 "mon_parse.c"
break;
case 38:
#line 251 "mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-1].i, e_invalid_space, e_invalid_space, e_invalid_space, e_invalid_space, e_invalid_space); }
#line 3199 "mon_parse.c"
break;
case 39:
#line 253 "mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-3].i, yystack.l_mark[-1].i, e_invalid_space, e_invalid_space, e_invalid_space, e_invalid_space); }
#line 3204 "mon_parse.c"
break;
case 40:
#line 255 "mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-5].i, yystack.l_mark[-3].i, yystack.l_mark[-1].i, e_invalid_space, e_invalid_space, e_invalid_space); }
#line 3209 "mon_parse.c"
break;
case 41:
#line 257 "mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-7].i, yystack.l_mark[-5].i, yystack.l_mark[-3].i, yystack.l_mark[-1].i, e_invalid_space, e_invalid_space); }
#line 3214 "mon_parse.c"
break;
case 42:
#line 259 "mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-9].i, yystack.l_mark[-7].i, yystack.l_mark[-5].i, yystack.l_mark[-3].i, yystack.l_mark[-1].i, e_invalid_space); }
#line 3219 "mon_parse.c"
break;
case 43:
#line 261 "mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-11].i, yystack.l_mark[-9].i, yystack.l_mark[-7].i, yystack.l_mark[-5].i, yystack.l_mark[-3].i, yystack.l_mark[-1].i); }
#line 3224 "mon_parse.c"
break;
case 44:
#line 263 "mon_parse.y"
	{ mon_instruction_return(); }
#line 3229 "mon_parse.c"
break;
case 45:
#line 265 "mon_parse.y"
	{ mon_write_snapshot(yystack.l_mark[-1].str,0,0,0); /* FIXME */ }
#line 3234 "mon_parse.c"
break;
case 46:
#line 267 "mon_parse.y"
	{ mon_read_snapshot(yystack.l_mark[-1].str, 0); }
#line 3239 "mon_parse.c"
break;
case 47:
#line 269 "mon_parse.y"
	{ mon_instructions_step(-1); }
#line 3244 "mon_parse.c"
break;
case 48:
#line 271 "mon_parse.y"
	{ mon_instructions_step(yystack.l_mark[-1].i); }
#line 3249 "mon_parse.c"
break;
case 49:
#line 273 "mon_parse.y"
	{ mon_instructions_next(-1); }
#line 3254 "mon_parse.c"
break;
case 50:
#line 275 "mon_parse.y"
	{ mon_instructions_next(yystack.l_mark[-1].i); }
#line 3259 "mon_parse.c"
break;
case 51:
#line 277 "mon_parse.y"
	{ mon_stack_up(-1); }
#line 3264 "mon_parse.c"
break;
case 52:
#line 279 "mon_parse.y"
	{ mon_stack_up(yystack.l_mark[-1].i); }
#line 3269 "mon_parse.c"
break;
case 53:
#line 281 "mon_parse.y"
	{ mon_stack_down(-1); }
#line 3274 "mon_parse.c"
break;
case 54:
#line 283 "mon_parse.y"
	{ mon_stack_down(yystack.l_mark[-1].i); }
#line 3279 "mon_parse.c"
break;
case 55:
#line 285 "mon_parse.y"
	{ mon_display_screen(-1); }
#line 3284 "mon_parse.c"
break;
case 56:
#line 287 "mon_parse.y"
	{ mon_display_screen(yystack.l_mark[-1].a); }
#line 3289 "mon_parse.c"
break;
case 57:
#line 289 "mon_parse.y"
	{
                        mon_out("Warp mode is %s.\n",
                                vsync_get_warp_mode() ? "on" : "off");
                     }
#line 3297 "mon_parse.c"
break;
case 58:
#line 294 "mon_parse.y"
	{
                        vsync_set_warp_mode(((yystack.l_mark[-1].action == e_TOGGLE) ? (vsync_get_warp_mode() ^ 1) : yystack.l_mark[-1].action));
                     }
#line 3304 "mon_parse.c"
break;
case 60:
#line 301 "mon_parse.y"
	{ (monitor_cpu_for_memspace[default_memspace]->mon_register_print)(default_memspace); }
#line 3309 "mon_parse.c"
break;
case 61:
#line 303 "mon_parse.y"
	{ (monitor_cpu_for_memspace[yystack.l_mark[-1].i]->mon_register_print)(yystack.l_mark[-1].i); }
#line 3314 "mon_parse.c"
break;
case 63:
#line 308 "mon_parse.y"
	{
                        /* What about the memspace? */
                        mon_playback_commands(yystack.l_mark[-1].str,true);
                    }
#line 3322 "mon_parse.c"
break;
case 64:
#line 313 "mon_parse.y"
	{
                        /* What about the memspace? */
                        mon_playback_commands(yystack.l_mark[-1].str,true);
                    }
#line 3330 "mon_parse.c"
break;
case 65:
#line 318 "mon_parse.y"
	{ mon_save_symbols(yystack.l_mark[-3].i, yystack.l_mark[-1].str); }
#line 3335 "mon_parse.c"
break;
case 66:
#line 320 "mon_parse.y"
	{ mon_save_symbols(e_default_space, yystack.l_mark[-1].str); }
#line 3340 "mon_parse.c"
break;
case 67:
#line 322 "mon_parse.y"
	{ mon_add_name_to_symbol_table(yystack.l_mark[-3].a, yystack.l_mark[-1].str); }
#line 3345 "mon_parse.c"
break;
case 68:
#line 324 "mon_parse.y"
	{ mon_remove_name_from_symbol_table(e_default_space, yystack.l_mark[-1].str); }
#line 3350 "mon_parse.c"
break;
case 69:
#line 326 "mon_parse.y"
	{ mon_remove_name_from_symbol_table(yystack.l_mark[-3].i, yystack.l_mark[-1].str); }
#line 3355 "mon_parse.c"
break;
case 70:
#line 328 "mon_parse.y"
	{ mon_print_symbol_table(yystack.l_mark[-1].i); }
#line 3360 "mon_parse.c"
break;
case 71:
#line 330 "mon_parse.y"
	{ mon_print_symbol_table(e_default_space); }
#line 3365 "mon_parse.c"
break;
case 72:
#line 332 "mon_parse.y"
	{ mon_clear_symbol_table(yystack.l_mark[-1].i); }
#line 3370 "mon_parse.c"
break;
case 73:
#line 334 "mon_parse.y"
	{ mon_clear_symbol_table(e_default_space); }
#line 3375 "mon_parse.c"
break;
case 74:
#line 336 "mon_parse.y"
	{
                        mon_add_name_to_symbol_table(yystack.l_mark[-1].a, mon_prepend_dot_to_name(yystack.l_mark[-3].str));
                    }
#line 3382 "mon_parse.c"
break;
case 75:
#line 340 "mon_parse.y"
	{
                        mon_add_name_to_symbol_table(yystack.l_mark[-2].a, mon_prepend_dot_to_name(yystack.l_mark[-4].str));
                    }
#line 3389 "mon_parse.c"
break;
case 76:
#line 346 "mon_parse.y"
	{ mon_start_assemble_mode(yystack.l_mark[0].a, NULL); }
#line 3394 "mon_parse.c"
break;
case 77:
#line 347 "mon_parse.y"
	{ }
#line 3399 "mon_parse.c"
break;
case 78:
#line 349 "mon_parse.y"
	{ mon_start_assemble_mode(yystack.l_mark[-1].a, NULL); }
#line 3404 "mon_parse.c"
break;
case 79:
#line 351 "mon_parse.y"
	{ mon_disassemble_lines(yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1]); }
#line 3409 "mon_parse.c"
break;
case 80:
#line 353 "mon_parse.y"
	{ mon_disassemble_lines(BAD_ADDR, BAD_ADDR); }
#line 3414 "mon_parse.c"
break;
case 81:
#line 357 "mon_parse.y"
	{ mon_memory_move(yystack.l_mark[-3].range[0], yystack.l_mark[-3].range[1], yystack.l_mark[-1].a); }
#line 3419 "mon_parse.c"
break;
case 82:
#line 359 "mon_parse.y"
	{ mon_memory_compare(yystack.l_mark[-3].range[0], yystack.l_mark[-3].range[1], yystack.l_mark[-1].a); }
#line 3424 "mon_parse.c"
break;
case 83:
#line 361 "mon_parse.y"
	{ mon_memory_fill(yystack.l_mark[-3].range[0], yystack.l_mark[-3].range[1],(unsigned char *)yystack.l_mark[-1].str); }
#line 3429 "mon_parse.c"
break;
case 84:
#line 363 "mon_parse.y"
	{ mon_memory_hunt(yystack.l_mark[-3].range[0], yystack.l_mark[-3].range[1],(unsigned char *)yystack.l_mark[-1].str); }
#line 3434 "mon_parse.c"
break;
case 85:
#line 365 "mon_parse.y"
	{ mon_memory_display(yystack.l_mark[-3].rt, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], DF_PETSCII); }
#line 3439 "mon_parse.c"
break;
case 86:
#line 367 "mon_parse.y"
	{ mon_memory_display(default_radix, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], DF_PETSCII); }
#line 3444 "mon_parse.c"
break;
case 87:
#line 369 "mon_parse.y"
	{ mon_memory_display(default_radix, BAD_ADDR, BAD_ADDR, DF_PETSCII); }
#line 3449 "mon_parse.c"
break;
case 88:
#line 371 "mon_parse.y"
	{ mon_memory_display_data(yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], 8, 8); }
#line 3454 "mon_parse.c"
break;
case 89:
#line 373 "mon_parse.y"
	{ mon_memory_display_data(BAD_ADDR, BAD_ADDR, 8, 8); }
#line 3459 "mon_parse.c"
break;
case 90:
#line 375 "mon_parse.y"
	{ mon_memory_display_data(yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], 24, 21); }
#line 3464 "mon_parse.c"
break;
case 91:
#line 377 "mon_parse.y"
	{ mon_memory_display_data(BAD_ADDR, BAD_ADDR, 24, 21); }
#line 3469 "mon_parse.c"
break;
case 92:
#line 379 "mon_parse.y"
	{ mon_memory_display(e_text, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], DF_PETSCII); }
#line 3474 "mon_parse.c"
break;
case 93:
#line 381 "mon_parse.y"
	{ mon_memory_display(e_text, BAD_ADDR, BAD_ADDR, DF_PETSCII); }
#line 3479 "mon_parse.c"
break;
case 94:
#line 383 "mon_parse.y"
	{ mon_memory_display(e_text, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], DF_SCREEN_CODE); }
#line 3484 "mon_parse.c"
break;
case 95:
#line 385 "mon_parse.y"
	{ mon_memory_display(e_text, BAD_ADDR, BAD_ADDR, DF_SCREEN_CODE); }
#line 3489 "mon_parse.c"
break;
case 96:
#line 387 "mon_parse.y"
	{ mon_memmap_zap(); }
#line 3494 "mon_parse.c"
break;
case 97:
#line 389 "mon_parse.y"
	{ mon_memmap_show(-1,BAD_ADDR,BAD_ADDR); }
#line 3499 "mon_parse.c"
break;
case 98:
#line 391 "mon_parse.y"
	{ mon_memmap_show(yystack.l_mark[-1].i,BAD_ADDR,BAD_ADDR); }
#line 3504 "mon_parse.c"
break;
case 99:
#line 393 "mon_parse.y"
	{ mon_memmap_show(yystack.l_mark[-2].i,yystack.l_mark[-1].range[0],yystack.l_mark[-1].range[1]); }
#line 3509 "mon_parse.c"
break;
case 100:
#line 395 "mon_parse.y"
	{ mon_memmap_save(yystack.l_mark[-3].str,yystack.l_mark[-1].i); }
#line 3514 "mon_parse.c"
break;
case 101:
#line 399 "mon_parse.y"
	{
                      if (yystack.l_mark[-3].i) {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], TRUE, yystack.l_mark[-3].i, FALSE, TRUE);
                      } else {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], TRUE, e_exec, FALSE, TRUE);
                      }
                      mon_breakpoint_set_checkpoint_condition(temp, yystack.l_mark[-1].cond_node);
                  }
#line 3526 "mon_parse.c"
break;
case 102:
#line 408 "mon_parse.y"
	{ mon_breakpoint_print_checkpoints(); }
#line 3531 "mon_parse.c"
break;
case 103:
#line 411 "mon_parse.y"
	{
                      mon_breakpoint_add_checkpoint(yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], TRUE, e_exec, TRUE, TRUE);
                  }
#line 3538 "mon_parse.c"
break;
case 104:
#line 415 "mon_parse.y"
	{ mon_breakpoint_print_checkpoints(); }
#line 3543 "mon_parse.c"
break;
case 105:
#line 418 "mon_parse.y"
	{
                      if (yystack.l_mark[-3].i) {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], TRUE, yystack.l_mark[-3].i, FALSE, TRUE);
                      } else {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], TRUE, e_load | e_store, FALSE, TRUE);
                      }
                      mon_breakpoint_set_checkpoint_condition(temp, yystack.l_mark[-1].cond_node);
                  }
#line 3555 "mon_parse.c"
break;
case 106:
#line 427 "mon_parse.y"
	{ mon_breakpoint_print_checkpoints(); }
#line 3560 "mon_parse.c"
break;
case 107:
#line 430 "mon_parse.y"
	{
                      if (yystack.l_mark[-3].i) {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], FALSE, yystack.l_mark[-3].i, FALSE, TRUE);
                      } else {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], FALSE, e_exec | e_load | e_store, FALSE, TRUE);
                      }
                      mon_breakpoint_set_checkpoint_condition(temp, yystack.l_mark[-1].cond_node);
                  }
#line 3572 "mon_parse.c"
break;
case 108:
#line 439 "mon_parse.y"
	{ mon_breakpoint_print_checkpoints(); }
#line 3577 "mon_parse.c"
break;
case 109:
#line 444 "mon_parse.y"
	{ mon_breakpoint_switch_checkpoint(e_ON, yystack.l_mark[-1].i); }
#line 3582 "mon_parse.c"
break;
case 110:
#line 446 "mon_parse.y"
	{ mon_breakpoint_switch_checkpoint(e_ON, -1); }
#line 3587 "mon_parse.c"
break;
case 111:
#line 448 "mon_parse.y"
	{ mon_breakpoint_switch_checkpoint(e_OFF, yystack.l_mark[-1].i); }
#line 3592 "mon_parse.c"
break;
case 112:
#line 450 "mon_parse.y"
	{ mon_breakpoint_switch_checkpoint(e_OFF, -1); }
#line 3597 "mon_parse.c"
break;
case 113:
#line 452 "mon_parse.y"
	{ mon_breakpoint_set_ignore_count(yystack.l_mark[-1].i, -1); }
#line 3602 "mon_parse.c"
break;
case 114:
#line 454 "mon_parse.y"
	{ mon_breakpoint_set_ignore_count(yystack.l_mark[-3].i, yystack.l_mark[-1].i); }
#line 3607 "mon_parse.c"
break;
case 115:
#line 456 "mon_parse.y"
	{ mon_breakpoint_delete_checkpoint(yystack.l_mark[-1].i); }
#line 3612 "mon_parse.c"
break;
case 116:
#line 458 "mon_parse.y"
	{ mon_breakpoint_delete_checkpoint(-1); }
#line 3617 "mon_parse.c"
break;
case 117:
#line 460 "mon_parse.y"
	{ mon_breakpoint_set_checkpoint_condition(yystack.l_mark[-3].i, yystack.l_mark[-1].cond_node); }
#line 3622 "mon_parse.c"
break;
case 118:
#line 462 "mon_parse.y"
	{ mon_breakpoint_set_checkpoint_command(yystack.l_mark[-3].i, yystack.l_mark[-1].str); }
#line 3627 "mon_parse.c"
break;
case 119:
#line 464 "mon_parse.y"
	{ return ERR_EXPECT_STRING; }
#line 3632 "mon_parse.c"
break;
case 120:
#line 468 "mon_parse.y"
	{ sidefx = ((yystack.l_mark[-1].action == e_TOGGLE) ? (sidefx ^ 1) : yystack.l_mark[-1].action); }
#line 3637 "mon_parse.c"
break;
case 121:
#line 470 "mon_parse.y"
	{
                         mon_out("I/O side effects are %s\n",
                                   sidefx ? "enabled" : "disabled");
                     }
#line 3645 "mon_parse.c"
break;
case 122:
#line 475 "mon_parse.y"
	{ 
                         break_on_dummy_access = ((yystack.l_mark[-1].action == e_TOGGLE) ? (break_on_dummy_access ^ 1) : yystack.l_mark[-1].action); 
                         /* FIXME: some day we might want to toggle the break-on-dummy-access 
                                   per MEMSPACE, for now its a global option */                         
                         mon_breakpoint_set_dummy_state(e_default_space, break_on_dummy_access);
                     }
#line 3655 "mon_parse.c"
break;
case 123:
#line 482 "mon_parse.y"
	{
                         mon_out("Checkpoints will %strigger on dummy accesses.\n",
                                   break_on_dummy_access ? "" : "not ");
                         /* FIXME: some day we might want to toggle the break-on-dummy-access 
                                   per MEMSPACE, for now its a global option */                         
                         mon_breakpoint_set_dummy_state(e_default_space, break_on_dummy_access);
                     }
#line 3666 "mon_parse.c"
break;
case 124:
#line 490 "mon_parse.y"
	{ 
                        int logenabled;
                        resources_get_int("MonitorLogEnabled", &logenabled);
                        logenabled = ((yystack.l_mark[-1].action == e_TOGGLE) ? (logenabled ^ 1) : yystack.l_mark[-1].action);
                        resources_set_int("MonitorLogEnabled", logenabled);
                     }
#line 3676 "mon_parse.c"
break;
case 125:
#line 497 "mon_parse.y"
	{
                         int logenabled;
                         const char *logfilename;
                         resources_get_int("MonitorLogEnabled", &logenabled);
                         resources_get_string("MonitorLogFileName", &logfilename);
                         if (logenabled) {
                            mon_out("Logging to '%s' is enabled.\n", logfilename);
                         } else {
                            mon_out("Logging is disabled.\n");
                         }
                     }
#line 3691 "mon_parse.c"
break;
case 126:
#line 509 "mon_parse.y"
	{ 
                        resources_set_string("MonitorLogFileName", yystack.l_mark[-1].str);
                     }
#line 3698 "mon_parse.c"
break;
case 127:
#line 513 "mon_parse.y"
	{ default_radix = yystack.l_mark[-1].rt; }
#line 3703 "mon_parse.c"
break;
case 128:
#line 515 "mon_parse.y"
	{
                         const char *p;

                         if (default_radix == e_hexadecimal)
                             p = "Hexadecimal";
                         else if (default_radix == e_decimal)
                             p = "Decimal";
                         else if (default_radix == e_octal)
                             p = "Octal";
                         else if (default_radix == e_binary)
                             p = "Binary";
                         else
                             p = "Unknown";

                         mon_out("Default radix is %s\n", p);
                     }
#line 3723 "mon_parse.c"
break;
case 129:
#line 533 "mon_parse.y"
	{ monitor_change_device(e_default_space); }
#line 3728 "mon_parse.c"
break;
case 130:
#line 535 "mon_parse.y"
	{ monitor_change_device(yystack.l_mark[-1].i); }
#line 3733 "mon_parse.c"
break;
case 131:
#line 537 "mon_parse.y"
	{ mon_export(); }
#line 3738 "mon_parse.c"
break;
case 132:
#line 539 "mon_parse.y"
	{ mon_quit(); YYACCEPT; }
#line 3743 "mon_parse.c"
break;
case 133:
#line 541 "mon_parse.y"
	{ mon_exit(); YYACCEPT; }
#line 3748 "mon_parse.c"
break;
case 134:
#line 543 "mon_parse.y"
	{ mon_maincpu_trace(); }
#line 3753 "mon_parse.c"
break;
case 135:
#line 545 "mon_parse.y"
	{ mon_maincpu_toggle_trace(yystack.l_mark[-1].action); }
#line 3758 "mon_parse.c"
break;
case 136:
#line 549 "mon_parse.y"
	{ mon_drive_execute_disk_cmd(yystack.l_mark[-1].str); }
#line 3763 "mon_parse.c"
break;
case 137:
#line 551 "mon_parse.y"
	{ mon_out("\t%d\n",yystack.l_mark[-1].i); }
#line 3768 "mon_parse.c"
break;
case 138:
#line 553 "mon_parse.y"
	{ mon_command_print_help(NULL); }
#line 3773 "mon_parse.c"
break;
case 139:
#line 555 "mon_parse.y"
	{ mon_command_print_help(yystack.l_mark[-1].str); }
#line 3778 "mon_parse.c"
break;
case 140:
#line 557 "mon_parse.y"
	{ mon_print_convert(yystack.l_mark[-1].i); }
#line 3783 "mon_parse.c"
break;
case 141:
#line 559 "mon_parse.y"
	{ mon_change_dir(yystack.l_mark[-1].str); }
#line 3788 "mon_parse.c"
break;
case 142:
#line 561 "mon_parse.y"
	{ mon_keyboard_feed(yystack.l_mark[-1].str); }
#line 3793 "mon_parse.c"
break;
case 143:
#line 563 "mon_parse.y"
	{ mon_backtrace(); }
#line 3798 "mon_parse.c"
break;
case 144:
#line 565 "mon_parse.y"
	{ mon_show_dir(yystack.l_mark[-1].str); }
#line 3803 "mon_parse.c"
break;
case 145:
#line 567 "mon_parse.y"
	{ mon_show_pwd(); }
#line 3808 "mon_parse.c"
break;
case 146:
#line 569 "mon_parse.y"
	{ mon_make_dir(yystack.l_mark[-1].str); }
#line 3813 "mon_parse.c"
break;
case 147:
#line 571 "mon_parse.y"
	{ mon_remove_dir(yystack.l_mark[-1].str); }
#line 3818 "mon_parse.c"
break;
case 148:
#line 573 "mon_parse.y"
	{ mon_screenshot_save(yystack.l_mark[-1].str,-1); }
#line 3823 "mon_parse.c"
break;
case 149:
#line 575 "mon_parse.y"
	{ mon_screenshot_save(yystack.l_mark[-3].str,yystack.l_mark[-1].i); }
#line 3828 "mon_parse.c"
break;
case 150:
#line 577 "mon_parse.y"
	{ mon_resource_get(yystack.l_mark[-1].str); }
#line 3833 "mon_parse.c"
break;
case 151:
#line 579 "mon_parse.y"
	{ mon_resource_set(yystack.l_mark[-2].str,yystack.l_mark[-1].str); }
#line 3838 "mon_parse.c"
break;
case 152:
#line 581 "mon_parse.y"
	{ resources_load(yystack.l_mark[-1].str); }
#line 3843 "mon_parse.c"
break;
case 153:
#line 583 "mon_parse.y"
	{ resources_save(yystack.l_mark[-1].str); }
#line 3848 "mon_parse.c"
break;
case 154:
#line 585 "mon_parse.y"
	{ mon_reset_machine(-1); }
#line 3853 "mon_parse.c"
break;
case 155:
#line 587 "mon_parse.y"
	{ mon_reset_machine(yystack.l_mark[-1].i); }
#line 3858 "mon_parse.c"
break;
case 156:
#line 589 "mon_parse.y"
	{ mon_tape_ctrl(TAPEPORT_PORT_1, yystack.l_mark[-1].i); }
#line 3863 "mon_parse.c"
break;
case 157:
#line 591 "mon_parse.y"
	{ mon_tape_offs(TAPEPORT_PORT_1, -1); }
#line 3868 "mon_parse.c"
break;
case 158:
#line 593 "mon_parse.y"
	{ mon_tape_offs(TAPEPORT_PORT_1, yystack.l_mark[-1].i); }
#line 3873 "mon_parse.c"
break;
case 159:
#line 595 "mon_parse.y"
	{ mon_cart_freeze(); }
#line 3878 "mon_parse.c"
break;
case 160:
#line 597 "mon_parse.y"
	{ mon_userport_set_output(yystack.l_mark[-1].i); }
#line 3883 "mon_parse.c"
break;
case 161:
#line 599 "mon_parse.y"
	{ mon_joyport_set_output(yystack.l_mark[-2].i, yystack.l_mark[-1].i); }
#line 3888 "mon_parse.c"
break;
case 162:
#line 601 "mon_parse.y"
	{ }
#line 3893 "mon_parse.c"
break;
case 163:
#line 603 "mon_parse.y"
	{ mon_stopwatch_reset(); }
#line 3898 "mon_parse.c"
break;
case 164:
#line 605 "mon_parse.y"
	{ mon_stopwatch_show("Stopwatch: ", "\n"); }
#line 3903 "mon_parse.c"
break;
case 165:
#line 607 "mon_parse.y"
	{ mon_profile_action(yystack.l_mark[-1].action); }
#line 3908 "mon_parse.c"
break;
case 166:
#line 609 "mon_parse.y"
	{ mon_profile(); }
#line 3913 "mon_parse.c"
break;
case 167:
#line 611 "mon_parse.y"
	{ mon_profile_flat(yystack.l_mark[-1].i); }
#line 3918 "mon_parse.c"
break;
case 168:
#line 613 "mon_parse.y"
	{ mon_profile_graph(yystack.l_mark[-1].i, -1); }
#line 3923 "mon_parse.c"
break;
case 169:
#line 615 "mon_parse.y"
	{ mon_profile_graph(yystack.l_mark[-3].i, yystack.l_mark[-1].i); }
#line 3928 "mon_parse.c"
break;
case 170:
#line 617 "mon_parse.y"
	{ mon_profile_func(yystack.l_mark[-1].a); }
#line 3933 "mon_parse.c"
break;
case 171:
#line 619 "mon_parse.y"
	{ mon_profile_disass(yystack.l_mark[-1].a); }
#line 3938 "mon_parse.c"
break;
case 172:
#line 621 "mon_parse.y"
	{ mon_profile_clear(yystack.l_mark[-1].a); }
#line 3943 "mon_parse.c"
break;
case 173:
#line 623 "mon_parse.y"
	{ mon_profile_disass_context(yystack.l_mark[-1].i); }
#line 3948 "mon_parse.c"
break;
case 174:
#line 627 "mon_parse.y"
	{ mon_file_load(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].a, FALSE, FALSE); }
#line 3953 "mon_parse.c"
break;
case 175:
#line 629 "mon_parse.y"
	{ mon_file_load(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].a, FALSE, TRUE); }
#line 3958 "mon_parse.c"
break;
case 176:
#line 631 "mon_parse.y"
	{ mon_file_load(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].a, TRUE, FALSE); }
#line 3963 "mon_parse.c"
break;
case 177:
#line 633 "mon_parse.y"
	{ return ERR_EXPECT_ADDRESS; }
#line 3968 "mon_parse.c"
break;
case 178:
#line 635 "mon_parse.y"
	{ mon_file_save(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], FALSE); }
#line 3973 "mon_parse.c"
break;
case 179:
#line 637 "mon_parse.y"
	{ return ERR_EXPECT_DEVICE_NUM; }
#line 3978 "mon_parse.c"
break;
case 180:
#line 639 "mon_parse.y"
	{ return ERR_EXPECT_ADDRESS; }
#line 3983 "mon_parse.c"
break;
case 181:
#line 641 "mon_parse.y"
	{ mon_file_save(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], TRUE); }
#line 3988 "mon_parse.c"
break;
case 182:
#line 643 "mon_parse.y"
	{ return ERR_EXPECT_ADDRESS; }
#line 3993 "mon_parse.c"
break;
case 183:
#line 645 "mon_parse.y"
	{ mon_file_verify(yystack.l_mark[-3].str,yystack.l_mark[-2].i,yystack.l_mark[-1].a,FALSE); }
#line 3998 "mon_parse.c"
break;
case 184:
#line 647 "mon_parse.y"
	{ mon_file_verify(yystack.l_mark[-3].str,yystack.l_mark[-2].i,yystack.l_mark[-1].a,TRUE); }
#line 4003 "mon_parse.c"
break;
case 185:
#line 649 "mon_parse.y"
	{ return ERR_EXPECT_ADDRESS; }
#line 4008 "mon_parse.c"
break;
case 186:
#line 651 "mon_parse.y"
	{ mon_drive_block_cmd(0,yystack.l_mark[-3].i,yystack.l_mark[-2].i,yystack.l_mark[-1].a); }
#line 4013 "mon_parse.c"
break;
case 187:
#line 653 "mon_parse.y"
	{ mon_drive_block_cmd(1,yystack.l_mark[-3].i,yystack.l_mark[-2].i,yystack.l_mark[-1].a); }
#line 4018 "mon_parse.c"
break;
case 188:
#line 655 "mon_parse.y"
	{ mon_drive_list(-1); }
#line 4023 "mon_parse.c"
break;
case 189:
#line 657 "mon_parse.y"
	{ mon_drive_list(yystack.l_mark[-1].i); }
#line 4028 "mon_parse.c"
break;
case 190:
#line 659 "mon_parse.y"
	{ mon_attach(yystack.l_mark[-2].str,yystack.l_mark[-1].i); }
#line 4033 "mon_parse.c"
break;
case 191:
#line 661 "mon_parse.y"
	{ mon_detach(yystack.l_mark[-1].i); }
#line 4038 "mon_parse.c"
break;
case 192:
#line 663 "mon_parse.y"
	{ mon_autostart(yystack.l_mark[-1].str,0,1); }
#line 4043 "mon_parse.c"
break;
case 193:
#line 665 "mon_parse.y"
	{ mon_autostart(yystack.l_mark[-3].str,yystack.l_mark[-1].i,1); }
#line 4048 "mon_parse.c"
break;
case 194:
#line 667 "mon_parse.y"
	{ mon_autostart(yystack.l_mark[-1].str,0,0); }
#line 4053 "mon_parse.c"
break;
case 195:
#line 669 "mon_parse.y"
	{ mon_autostart(yystack.l_mark[-3].str,yystack.l_mark[-1].i,0); }
#line 4058 "mon_parse.c"
break;
case 196:
#line 673 "mon_parse.y"
	{ mon_record_commands(yystack.l_mark[-1].str); }
#line 4063 "mon_parse.c"
break;
case 197:
#line 675 "mon_parse.y"
	{ mon_end_recording(); }
#line 4068 "mon_parse.c"
break;
case 198:
#line 677 "mon_parse.y"
	{ mon_playback_commands(yystack.l_mark[-1].str,true); }
#line 4073 "mon_parse.c"
break;
case 199:
#line 681 "mon_parse.y"
	{ mon_memory_fill(yystack.l_mark[-2].a, BAD_ADDR, (unsigned char *)yystack.l_mark[-1].str); }
#line 4078 "mon_parse.c"
break;
case 200:
#line 683 "mon_parse.y"
	{ printf("Not yet.\n"); }
#line 4083 "mon_parse.c"
break;
case 201:
#line 687 "mon_parse.y"
	{
#if YYDEBUG
                     yydebug = 1;
#endif
                     }
#line 4092 "mon_parse.c"
break;
case 202:
#line 694 "mon_parse.y"
	{ yyval.str = yystack.l_mark[0].str; }
#line 4097 "mon_parse.c"
break;
case 203:
#line 697 "mon_parse.y"
	{ yyval.str = yystack.l_mark[0].str; }
#line 4102 "mon_parse.c"
break;
case 204:
#line 698 "mon_parse.y"
	{ yyval.str = NULL; }
#line 4107 "mon_parse.c"
break;
case 205:
#line 701 "mon_parse.y"
	{ yyval.str = yystack.l_mark[0].str; }
#line 4112 "mon_parse.c"
break;
case 207:
#line 705 "mon_parse.y"
	{ return ERR_EXPECT_FILENAME; }
#line 4117 "mon_parse.c"
break;
case 209:
#line 709 "mon_parse.y"
	{ return ERR_EXPECT_DEVICE_NUM; }
#line 4122 "mon_parse.c"
break;
case 210:
#line 712 "mon_parse.y"
	{ yyval.i = yystack.l_mark[-1].i | yystack.l_mark[0].i; }
#line 4127 "mon_parse.c"
break;
case 211:
#line 713 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4132 "mon_parse.c"
break;
case 212:
#line 716 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4137 "mon_parse.c"
break;
case 213:
#line 717 "mon_parse.y"
	{ yyval.i = 0; }
#line 4142 "mon_parse.c"
break;
case 214:
#line 720 "mon_parse.y"
	{
                                    if (!mon_register_valid(default_memspace, yystack.l_mark[0].reg)) {
                                        return ERR_INVALID_REGISTER;
                                    }
                                    yyval.i = new_reg(default_memspace, yystack.l_mark[0].reg);
                                }
#line 4152 "mon_parse.c"
break;
case 215:
#line 726 "mon_parse.y"
	{
                                    if (!mon_register_valid(yystack.l_mark[-1].i, yystack.l_mark[0].reg)) {
                                        return ERR_INVALID_REGISTER;
                                    }
                                    yyval.i = new_reg(yystack.l_mark[-1].i, yystack.l_mark[0].reg);
                                }
#line 4162 "mon_parse.c"
break;
case 218:
#line 739 "mon_parse.y"
	{ (monitor_cpu_for_memspace[reg_memspace(yystack.l_mark[-2].i)]->mon_register_set_val)(reg_memspace(yystack.l_mark[-2].i), reg_regid(yystack.l_mark[-2].i), (uint16_t) yystack.l_mark[0].i); }
#line 4167 "mon_parse.c"
break;
case 219:
#line 742 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4172 "mon_parse.c"
break;
case 220:
#line 743 "mon_parse.y"
	{ return ERR_EXPECT_CHECKNUM; }
#line 4177 "mon_parse.c"
break;
case 221:
#line 746 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4182 "mon_parse.c"
break;
case 222:
#line 747 "mon_parse.y"
	{ yyval.i = -1; }
#line 4187 "mon_parse.c"
break;
case 224:
#line 751 "mon_parse.y"
	{ yyval.range[0] = yystack.l_mark[0].a; yyval.range[1] = BAD_ADDR; }
#line 4192 "mon_parse.c"
break;
case 225:
#line 754 "mon_parse.y"
	{ yyval.range[0] = yystack.l_mark[-2].a; yyval.range[1] = yystack.l_mark[0].a; }
#line 4197 "mon_parse.c"
break;
case 226:
#line 756 "mon_parse.y"
	{ if (resolve_range(e_default_space, yyval.range, yystack.l_mark[0].str)) return ERR_ADDR_TOO_BIG; }
#line 4202 "mon_parse.c"
break;
case 227:
#line 758 "mon_parse.y"
	{ if (resolve_range(yystack.l_mark[-2].i, yyval.range, yystack.l_mark[0].str)) return ERR_ADDR_TOO_BIG; }
#line 4207 "mon_parse.c"
break;
case 228:
#line 761 "mon_parse.y"
	{ yyval.a = yystack.l_mark[0].a; }
#line 4212 "mon_parse.c"
break;
case 229:
#line 762 "mon_parse.y"
	{ yyval.a = BAD_ADDR; }
#line 4217 "mon_parse.c"
break;
case 230:
#line 766 "mon_parse.y"
	{
             yyval.a = new_addr(e_default_space,yystack.l_mark[0].i);
             if (opt_asm) new_cmd = asm_mode = 1;
         }
#line 4225 "mon_parse.c"
break;
case 231:
#line 771 "mon_parse.y"
	{
             yyval.a = new_addr(yystack.l_mark[-2].i, yystack.l_mark[0].i);
             if (opt_asm) new_cmd = asm_mode = 1;
         }
#line 4233 "mon_parse.c"
break;
case 232:
#line 776 "mon_parse.y"
	{
             temp = mon_symbol_table_lookup_addr(e_default_space, yystack.l_mark[0].str);
             if (temp >= 0)
                 yyval.a = new_addr(e_default_space, temp);
             else
                 return ERR_UNDEFINED_LABEL;
         }
#line 4244 "mon_parse.c"
break;
case 235:
#line 789 "mon_parse.y"
	{ yyval.i = e_comp_space; }
#line 4249 "mon_parse.c"
break;
case 236:
#line 790 "mon_parse.y"
	{ yyval.i = e_disk8_space; }
#line 4254 "mon_parse.c"
break;
case 237:
#line 791 "mon_parse.y"
	{ yyval.i = e_disk9_space; }
#line 4259 "mon_parse.c"
break;
case 238:
#line 792 "mon_parse.y"
	{ yyval.i = e_disk10_space; }
#line 4264 "mon_parse.c"
break;
case 239:
#line 793 "mon_parse.y"
	{ yyval.i = e_disk11_space; }
#line 4269 "mon_parse.c"
break;
case 240:
#line 796 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; if (!CHECK_ADDR(yystack.l_mark[0].i)) return ERR_ADDR_TOO_BIG; }
#line 4274 "mon_parse.c"
break;
case 241:
#line 798 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4279 "mon_parse.c"
break;
case 242:
#line 823 "mon_parse.y"
	{ yyval.i = yystack.l_mark[-2].i + yystack.l_mark[0].i; }
#line 4284 "mon_parse.c"
break;
case 243:
#line 824 "mon_parse.y"
	{ yyval.i = yystack.l_mark[-2].i - yystack.l_mark[0].i; }
#line 4289 "mon_parse.c"
break;
case 244:
#line 825 "mon_parse.y"
	{ yyval.i = yystack.l_mark[-2].i * yystack.l_mark[0].i; }
#line 4294 "mon_parse.c"
break;
case 245:
#line 826 "mon_parse.y"
	{ yyval.i = (yystack.l_mark[0].i) ? (yystack.l_mark[-2].i / yystack.l_mark[0].i) : 1; }
#line 4299 "mon_parse.c"
break;
case 246:
#line 827 "mon_parse.y"
	{ yyval.i = yystack.l_mark[-1].i; }
#line 4304 "mon_parse.c"
break;
case 247:
#line 828 "mon_parse.y"
	{ return ERR_MISSING_CLOSE_PAREN; }
#line 4309 "mon_parse.c"
break;
case 248:
#line 829 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4314 "mon_parse.c"
break;
case 249:
#line 832 "mon_parse.y"
	{ yyval.cond_node = yystack.l_mark[0].cond_node; }
#line 4319 "mon_parse.c"
break;
case 250:
#line 833 "mon_parse.y"
	{ yyval.cond_node = 0; }
#line 4324 "mon_parse.c"
break;
case 251:
#line 836 "mon_parse.y"
	{
               yyval.cond_node = new_cond; yyval.cond_node->is_parenthized = FALSE;
               yyval.cond_node->child1 = yystack.l_mark[-2].cond_node; yyval.cond_node->child2 = yystack.l_mark[0].cond_node; yyval.cond_node->operation = yystack.l_mark[-1].cond_op;
           }
#line 4332 "mon_parse.c"
break;
case 252:
#line 841 "mon_parse.y"
	{ return ERR_INCOMPLETE_COND_OP; }
#line 4337 "mon_parse.c"
break;
case 253:
#line 843 "mon_parse.y"
	{ yyval.cond_node = yystack.l_mark[-1].cond_node; yyval.cond_node->is_parenthized = TRUE; }
#line 4342 "mon_parse.c"
break;
case 254:
#line 845 "mon_parse.y"
	{ return ERR_MISSING_CLOSE_PAREN; }
#line 4347 "mon_parse.c"
break;
case 255:
#line 847 "mon_parse.y"
	{ yyval.cond_node = yystack.l_mark[0].cond_node; }
#line 4352 "mon_parse.c"
break;
case 256:
#line 850 "mon_parse.y"
	{ yyval.cond_node = new_cond;
                            yyval.cond_node->operation = e_INV;
                            yyval.cond_node->is_parenthized = FALSE;
                            yyval.cond_node->reg_num = yystack.l_mark[0].i; yyval.cond_node->is_reg = TRUE; yyval.cond_node->banknum=-1;
                            yyval.cond_node->child1 = NULL; yyval.cond_node->child2 = NULL;
                          }
#line 4362 "mon_parse.c"
break;
case 257:
#line 856 "mon_parse.y"
	{ yyval.cond_node = new_cond;
                            yyval.cond_node->operation = e_INV;
                            yyval.cond_node->is_parenthized = FALSE;
                            yyval.cond_node->value = yystack.l_mark[0].i; yyval.cond_node->is_reg = FALSE; yyval.cond_node->banknum=-1;
                            yyval.cond_node->child1 = NULL; yyval.cond_node->child2 = NULL;
                          }
#line 4372 "mon_parse.c"
break;
case 258:
#line 863 "mon_parse.y"
	{
                            yyval.cond_node = new_cond;
                            yyval.cond_node->operation = e_INV;
                            yyval.cond_node->is_parenthized = FALSE;
                            yyval.cond_node->banknum = mon_banknum_from_bank(e_default_space, yystack.l_mark[-4].str);
                            if (yyval.cond_node->banknum < 0) {
                                return ERR_ILLEGAL_INPUT;
                            }
                            yyval.cond_node->value = 0;
                            yyval.cond_node->is_reg = FALSE;
                            yyval.cond_node->child1 = yystack.l_mark[-1].cond_node;
                            yyval.cond_node->child2 = NULL;
                        }
#line 4389 "mon_parse.c"
break;
case 259:
#line 876 "mon_parse.y"
	{
                            yyval.cond_node = new_cond;
                            yyval.cond_node->operation = e_INV;
                            yyval.cond_node->is_parenthized = FALSE;
                            yyval.cond_node->banknum = mon_banknum_from_bank(e_default_space, yystack.l_mark[-2].str);
                            if (yyval.cond_node->banknum < 0) {
                                return ERR_ILLEGAL_INPUT;
                            }
                            yyval.cond_node->value = yystack.l_mark[0].a;
                            yyval.cond_node->is_reg = FALSE;
                            yyval.cond_node->child1 = NULL; yyval.cond_node->child2 = NULL;  
                        }
#line 4405 "mon_parse.c"
break;
case 262:
#line 894 "mon_parse.y"
	{ mon_add_number_to_buffer(yystack.l_mark[0].i); }
#line 4410 "mon_parse.c"
break;
case 263:
#line 895 "mon_parse.y"
	{ mon_add_string_to_buffer(yystack.l_mark[0].str); }
#line 4415 "mon_parse.c"
break;
case 266:
#line 902 "mon_parse.y"
	{ mon_add_number_to_buffer(yystack.l_mark[0].i); }
#line 4420 "mon_parse.c"
break;
case 267:
#line 903 "mon_parse.y"
	{ mon_add_number_masked_to_buffer(yystack.l_mark[0].i, 0x00); }
#line 4425 "mon_parse.c"
break;
case 268:
#line 904 "mon_parse.y"
	{ mon_add_string_to_buffer(yystack.l_mark[0].str); }
#line 4430 "mon_parse.c"
break;
case 269:
#line 907 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4435 "mon_parse.c"
break;
case 270:
#line 908 "mon_parse.y"
	{ yyval.i = (monitor_cpu_for_memspace[reg_memspace(yystack.l_mark[0].i)]->mon_register_get_val)(reg_memspace(yystack.l_mark[0].i), reg_regid(yystack.l_mark[0].i)); }
#line 4440 "mon_parse.c"
break;
case 271:
#line 911 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4445 "mon_parse.c"
break;
case 272:
#line 912 "mon_parse.y"
	{ yyval.i = (int)strtol(yystack.l_mark[0].str, NULL, 10); }
#line 4450 "mon_parse.c"
break;
case 273:
#line 913 "mon_parse.y"
	{ yyval.i = (int)strtol(yystack.l_mark[0].str, NULL, 10); }
#line 4455 "mon_parse.c"
break;
case 274:
#line 914 "mon_parse.y"
	{ yyval.i = (int)strtol(yystack.l_mark[0].str, NULL, 10); }
#line 4460 "mon_parse.c"
break;
case 275:
#line 917 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4465 "mon_parse.c"
break;
case 276:
#line 918 "mon_parse.y"
	{ yyval.i = -1; }
#line 4470 "mon_parse.c"
break;
case 277:
#line 921 "mon_parse.y"
	{ yyval.i = resolve_datatype(B_NUMBER,yystack.l_mark[0].str); }
#line 4475 "mon_parse.c"
break;
case 278:
#line 922 "mon_parse.y"
	{ yyval.i = resolve_datatype(D_NUMBER,yystack.l_mark[0].str); }
#line 4480 "mon_parse.c"
break;
case 279:
#line 923 "mon_parse.y"
	{ yyval.i = resolve_datatype(O_NUMBER,yystack.l_mark[0].str); }
#line 4485 "mon_parse.c"
break;
case 280:
#line 926 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4490 "mon_parse.c"
break;
case 281:
#line 927 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4495 "mon_parse.c"
break;
case 282:
#line 928 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4500 "mon_parse.c"
break;
case 283:
#line 929 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4505 "mon_parse.c"
break;
case 284:
#line 930 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4510 "mon_parse.c"
break;
case 288:
#line 938 "mon_parse.y"
	{ yyval.i = 0;
                                                if (yystack.l_mark[-1].str) {
                                                    (monitor_cpu_for_memspace[default_memspace]->mon_assemble_instr)(yystack.l_mark[-1].str, yystack.l_mark[0].mode);
                                                } else {
                                                    new_cmd = 1;
                                                    asm_mode = 0;
                                                }
                                                opt_asm = 0;
                                              }
#line 4523 "mon_parse.c"
break;
case 290:
#line 949 "mon_parse.y"
	{ asm_mode = 0; }
#line 4528 "mon_parse.c"
break;
case 291:
#line 952 "mon_parse.y"
	{ if (yystack.l_mark[0].i > 0xff) {
                          yyval.mode.addr_mode = ASM_ADDR_MODE_IMMEDIATE_16;
                          yyval.mode.param = yystack.l_mark[0].i;
                        } else {
                          yyval.mode.addr_mode = ASM_ADDR_MODE_IMMEDIATE;
                          yyval.mode.param = yystack.l_mark[0].i;
                        } }
#line 4539 "mon_parse.c"
break;
case 292:
#line 959 "mon_parse.y"
	{ if (yystack.l_mark[0].i >= 0x10000) {
               yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_LONG;
               yyval.mode.param = yystack.l_mark[0].i;
             } else if (yystack.l_mark[0].i < 0x100) {
               yyval.mode.addr_mode = ASM_ADDR_MODE_ZERO_PAGE;
               yyval.mode.param = yystack.l_mark[0].i;
             } else {
               yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE;
               yyval.mode.param = yystack.l_mark[0].i;
             }
           }
#line 4554 "mon_parse.c"
break;
case 293:
#line 970 "mon_parse.y"
	{ if (yystack.l_mark[-2].i >= 0x10000) {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_LONG_X;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          } else if (yystack.l_mark[-2].i < 0x100) { 
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ZERO_PAGE_X;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          } else {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_X;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          }
                        }
#line 4569 "mon_parse.c"
break;
case 294:
#line 981 "mon_parse.y"
	{ if (yystack.l_mark[-2].i < 0x100) {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ZERO_PAGE_Y;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          } else {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_Y;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          }
                        }
#line 4581 "mon_parse.c"
break;
case 295:
#line 989 "mon_parse.y"
	{ if (yystack.l_mark[-2].i < 0x100) {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_STACK_RELATIVE;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          } else { /* 6809 */
                            yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
                            if (yystack.l_mark[-2].i >= -16 && yystack.l_mark[-2].i < 16) {
                                yyval.mode.addr_submode = yystack.l_mark[0].i | (yystack.l_mark[-2].i & 0x1F);
                            } else if (yystack.l_mark[-2].i >= -128 && yystack.l_mark[-2].i < 128) {
                                yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_OFF8;
                                yyval.mode.param = yystack.l_mark[-2].i;
                            } else if (yystack.l_mark[-2].i >= -32768 && yystack.l_mark[-2].i < 32768) {
                                yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_OFF16;
                                yyval.mode.param = yystack.l_mark[-2].i;
                            } else {
                                yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
                                mon_out("offset too large even for 16 bits (signed)\n");
                            }
                          }
                        }
#line 4604 "mon_parse.c"
break;
case 296:
#line 1008 "mon_parse.y"
	{ if (yystack.l_mark[-2].i < 0x100) {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_DOUBLE;
                            yyval.mode.param = yystack.l_mark[0].i;
                            yyval.mode.addr_submode = yystack.l_mark[-2].i;
                          }
                        }
#line 4614 "mon_parse.c"
break;
case 297:
#line 1014 "mon_parse.y"
	{ if (yystack.l_mark[-1].i < 0x100) {
                               yyval.mode.addr_mode = ASM_ADDR_MODE_INDIRECT;
                               yyval.mode.param = yystack.l_mark[-1].i;
                             } else {
                               yyval.mode.addr_mode = ASM_ADDR_MODE_ABS_INDIRECT;
                               yyval.mode.param = yystack.l_mark[-1].i;
                             }
                           }
#line 4626 "mon_parse.c"
break;
case 298:
#line 1022 "mon_parse.y"
	{ if (yystack.l_mark[-3].i < 0x100) {
                                           yyval.mode.addr_mode = ASM_ADDR_MODE_INDIRECT_X;
                                           yyval.mode.param = yystack.l_mark[-3].i;
                                         } else {
                                           yyval.mode.addr_mode = ASM_ADDR_MODE_ABS_INDIRECT_X;
                                           yyval.mode.param = yystack.l_mark[-3].i;
                                         }
                                       }
#line 4638 "mon_parse.c"
break;
case 299:
#line 1031 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_STACK_RELATIVE_Y; yyval.mode.param = yystack.l_mark[-5].i; }
#line 4643 "mon_parse.c"
break;
case 300:
#line 1033 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_INDIRECT_Y; yyval.mode.param = yystack.l_mark[-3].i; }
#line 4648 "mon_parse.c"
break;
case 301:
#line 1034 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_BC; }
#line 4653 "mon_parse.c"
break;
case 302:
#line 1035 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_DE; }
#line 4658 "mon_parse.c"
break;
case 303:
#line 1036 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_HL; }
#line 4663 "mon_parse.c"
break;
case 304:
#line 1037 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_IX; }
#line 4668 "mon_parse.c"
break;
case 305:
#line 1038 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_IY; }
#line 4673 "mon_parse.c"
break;
case 306:
#line 1039 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_SP; }
#line 4678 "mon_parse.c"
break;
case 307:
#line 1041 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_A; yyval.mode.param = yystack.l_mark[-3].i; }
#line 4683 "mon_parse.c"
break;
case 308:
#line 1043 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_HL; yyval.mode.param = yystack.l_mark[-3].i; }
#line 4688 "mon_parse.c"
break;
case 309:
#line 1045 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_IX; yyval.mode.param = yystack.l_mark[-3].i; }
#line 4693 "mon_parse.c"
break;
case 310:
#line 1047 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_IY; yyval.mode.param = yystack.l_mark[-3].i; }
#line 4698 "mon_parse.c"
break;
case 311:
#line 1048 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_IMPLIED; }
#line 4703 "mon_parse.c"
break;
case 312:
#line 1049 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ACCUMULATOR; }
#line 4708 "mon_parse.c"
break;
case 313:
#line 1050 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_B; }
#line 4713 "mon_parse.c"
break;
case 314:
#line 1051 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_C; }
#line 4718 "mon_parse.c"
break;
case 315:
#line 1052 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_D; }
#line 4723 "mon_parse.c"
break;
case 316:
#line 1053 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_E; }
#line 4728 "mon_parse.c"
break;
case 317:
#line 1054 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_H; }
#line 4733 "mon_parse.c"
break;
case 318:
#line 1055 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IXH; }
#line 4738 "mon_parse.c"
break;
case 319:
#line 1056 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IYH; }
#line 4743 "mon_parse.c"
break;
case 320:
#line 1057 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_L; }
#line 4748 "mon_parse.c"
break;
case 321:
#line 1058 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IXL; }
#line 4753 "mon_parse.c"
break;
case 322:
#line 1059 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IYL; }
#line 4758 "mon_parse.c"
break;
case 323:
#line 1060 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_AF; }
#line 4763 "mon_parse.c"
break;
case 324:
#line 1061 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_BC; }
#line 4768 "mon_parse.c"
break;
case 325:
#line 1062 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_DE; }
#line 4773 "mon_parse.c"
break;
case 326:
#line 1063 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_HL; }
#line 4778 "mon_parse.c"
break;
case 327:
#line 1064 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IX; }
#line 4783 "mon_parse.c"
break;
case 328:
#line 1065 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IY; }
#line 4788 "mon_parse.c"
break;
case 329:
#line 1066 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_SP; }
#line 4793 "mon_parse.c"
break;
case 330:
#line 1068 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_DIRECT; yyval.mode.param = yystack.l_mark[0].i; }
#line 4798 "mon_parse.c"
break;
case 331:
#line 1069 "mon_parse.y"
	{    /* Clash with addr,x addr,y addr,s modes! */
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        if (yystack.l_mark[-2].i >= -16 && yystack.l_mark[-2].i < 16) {
            yyval.mode.addr_submode = (3 << 5) | (yystack.l_mark[-2].i & 0x1F);
        } else if (yystack.l_mark[-2].i >= -128 && yystack.l_mark[-2].i < 128) {
            yyval.mode.addr_submode = 0x80 | (3 << 5) | ASM_ADDR_MODE_INDEXED_OFF8;
            yyval.mode.param = yystack.l_mark[-2].i;
        } else if (yystack.l_mark[-2].i >= -32768 && yystack.l_mark[-2].i < 32768) {
            yyval.mode.addr_submode = 0x80 | (3 << 5) | ASM_ADDR_MODE_INDEXED_OFF16;
            yyval.mode.param = yystack.l_mark[-2].i;
        } else {
            yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
            mon_out("offset too large even for 16 bits (signed)\n");
        }
    }
#line 4817 "mon_parse.c"
break;
case 332:
#line 1084 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_INC1;
        }
#line 4825 "mon_parse.c"
break;
case 333:
#line 1088 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_INC2;
        }
#line 4833 "mon_parse.c"
break;
case 334:
#line 1092 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_DEC1;
        }
#line 4841 "mon_parse.c"
break;
case 335:
#line 1096 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_DEC2;
        }
#line 4849 "mon_parse.c"
break;
case 336:
#line 1100 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_OFF0;
        }
#line 4857 "mon_parse.c"
break;
case 337:
#line 1104 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_OFFB;
        }
#line 4865 "mon_parse.c"
break;
case 338:
#line 1108 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_OFFA;
        }
#line 4873 "mon_parse.c"
break;
case 339:
#line 1112 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_OFFD;
        }
#line 4881 "mon_parse.c"
break;
case 340:
#line 1116 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.param = yystack.l_mark[-2].i;
        if (yystack.l_mark[-2].i >= -128 && yystack.l_mark[-2].i < 128) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFFPC8;
        } else if (yystack.l_mark[-2].i >= -32768 && yystack.l_mark[-2].i < 32768) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFFPC16;
        } else {
            yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
            mon_out("offset too large even for 16 bits (signed)\n");
        }
    }
#line 4897 "mon_parse.c"
break;
case 341:
#line 1128 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        if (yystack.l_mark[-3].i >= -16 && yystack.l_mark[-3].i < 16) {
            yyval.mode.addr_submode = yystack.l_mark[-3].i & 0x1F;
        } else if (yystack.l_mark[-4].i >= -128 && yystack.l_mark[-4].i < 128) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFF8;
            yyval.mode.param = yystack.l_mark[-3].i;
        } else if (yystack.l_mark[-3].i >= -32768 && yystack.l_mark[-3].i < 32768) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFF16;
            yyval.mode.param = yystack.l_mark[-3].i;
        } else {
            yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
            mon_out("offset too large even for 16 bits (signed)\n");
        }
    }
#line 4916 "mon_parse.c"
break;
case 342:
#line 1143 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_INC1;
        }
#line 4924 "mon_parse.c"
break;
case 343:
#line 1147 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-3].i | ASM_ADDR_MODE_INDEXED_INC2;
        }
#line 4932 "mon_parse.c"
break;
case 344:
#line 1151 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_DEC1;
        }
#line 4940 "mon_parse.c"
break;
case 345:
#line 1155 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_DEC2;
        }
#line 4948 "mon_parse.c"
break;
case 346:
#line 1159 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_OFF0;
        }
#line 4956 "mon_parse.c"
break;
case 347:
#line 1163 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_OFFB;
        }
#line 4964 "mon_parse.c"
break;
case 348:
#line 1167 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_OFFA;
        }
#line 4972 "mon_parse.c"
break;
case 349:
#line 1171 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_OFFD;
        }
#line 4980 "mon_parse.c"
break;
case 350:
#line 1175 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.param = yystack.l_mark[-3].i;
        if (yystack.l_mark[-3].i >= -128 && yystack.l_mark[-3].i < 128) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFFPC8_IND;
        } else if (yystack.l_mark[-3].i >= -32768 && yystack.l_mark[-3].i < 32768) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFFPC16_IND;
        } else {
            yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
            mon_out("offset too large even for 16 bits (signed)\n");
        }
    }
#line 4996 "mon_parse.c"
break;
case 351:
#line 1187 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | ASM_ADDR_MODE_EXTENDED_INDIRECT;
        yyval.mode.param = yystack.l_mark[-1].i;
        }
#line 5005 "mon_parse.c"
break;
case 352:
#line 1192 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDIRECT_LONG_Y;
        yyval.mode.param = yystack.l_mark[-3].i;
        }
#line 5013 "mon_parse.c"
break;
case 353:
#line 1200 "mon_parse.y"
	{ yyval.i = (0 << 5); printf("reg_x\n"); }
#line 5018 "mon_parse.c"
break;
case 354:
#line 1201 "mon_parse.y"
	{ yyval.i = (1 << 5); printf("reg_y\n"); }
#line 5023 "mon_parse.c"
break;
case 355:
#line 1202 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 5028 "mon_parse.c"
break;
case 356:
#line 1203 "mon_parse.y"
	{ yyval.i = (3 << 5); printf("reg_s\n"); }
#line 5033 "mon_parse.c"
break;
case 357:
#line 1207 "mon_parse.y"
	{ yyval.i = (2 << 5); printf("reg_u\n"); }
#line 5038 "mon_parse.c"
break;
#line 5040 "mon_parse.c"
    default:
        break;
    }
    yystack.s_mark -= yym;
    yystate = *yystack.s_mark;
    yystack.l_mark -= yym;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    yystack.p_mark -= yym;
#endif
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
        {
            fprintf(stderr, "%s[%d]: after reduction, ", YYDEBUGSTR, yydepth);
#ifdef YYSTYPE_TOSTRING
#if YYBTYACC
            if (!yytrial)
#endif /* YYBTYACC */
                fprintf(stderr, "result is <%s>, ", YYSTYPE_TOSTRING(yystos[YYFINAL], yyval));
#endif
            fprintf(stderr, "shifting from state 0 to final state %d\n", YYFINAL);
        }
#endif
        yystate = YYFINAL;
        *++yystack.s_mark = YYFINAL;
        *++yystack.l_mark = yyval;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
        *++yystack.p_mark = yyloc;
#endif
        if (yychar < 0)
        {
#if YYBTYACC
            do {
            if (yylvp < yylve)
            {
                /* we're currently re-reading tokens */
                yylval = *yylvp++;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                yylloc = *yylpp++;
#endif
                yychar = *yylexp++;
                break;
            }
            if (yyps->save)
            {
                /* in trial mode; save scanner results for future parse attempts */
                if (yylvp == yylvlim)
                {   /* Enlarge lexical value queue */
                    size_t p = (size_t) (yylvp - yylvals);
                    size_t s = (size_t) (yylvlim - yylvals);

                    s += YYLVQUEUEGROWTH;
                    if ((yylexemes = (YYINT *)realloc(yylexemes, s * sizeof(YYINT))) == NULL)
                        goto yyenomem;
                    if ((yylvals   = (YYSTYPE *)realloc(yylvals, s * sizeof(YYSTYPE))) == NULL)
                        goto yyenomem;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                    if ((yylpsns   = (YYLTYPE *)realloc(yylpsns, s * sizeof(YYLTYPE))) == NULL)
                        goto yyenomem;
#endif
                    yylvp   = yylve = yylvals + p;
                    yylvlim = yylvals + s;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                    yylpp   = yylpe = yylpsns + p;
                    yylplim = yylpsns + s;
#endif
                    yylexp  = yylexemes + p;
                }
                *yylexp = (YYINT) YYLEX;
                *yylvp++ = yylval;
                yylve++;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                *yylpp++ = yylloc;
                yylpe++;
#endif
                yychar = *yylexp++;
                break;
            }
            /* normal operation, no conflict encountered */
#endif /* YYBTYACC */
            yychar = YYLEX;
#if YYBTYACC
            } while (0);
#endif /* YYBTYACC */
            if (yychar < 0) yychar = YYEOF;
#if YYDEBUG
            if (yydebug)
            {
                if ((yys = yyname[YYTRANSLATE(yychar)]) == NULL) yys = yyname[YYUNDFTOKEN];
                fprintf(stderr, "%s[%d]: state %d, reading token %d (%s)\n",
                                YYDEBUGSTR, yydepth, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == YYEOF) goto yyaccept;
        goto yyloop;
    }
    if (((yyn = yygindex[yym]) != 0) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
    {
        fprintf(stderr, "%s[%d]: after reduction, ", YYDEBUGSTR, yydepth);
#ifdef YYSTYPE_TOSTRING
#if YYBTYACC
        if (!yytrial)
#endif /* YYBTYACC */
            fprintf(stderr, "result is <%s>, ", YYSTYPE_TOSTRING(yystos[yystate], yyval));
#endif
        fprintf(stderr, "shifting from state %d to state %d\n", *yystack.s_mark, yystate);
    }
#endif
    if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
    *++yystack.s_mark = (YYINT) yystate;
    *++yystack.l_mark = yyval;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    *++yystack.p_mark = yyloc;
#endif
    goto yyloop;
#if YYBTYACC

    /* Reduction declares that this path is valid. Set yypath and do a full parse */
yyvalid:
    if (yypath) YYABORT;
    while (yyps->save)
    {
        YYParseState *save = yyps->save;
        yyps->save = save->save;
        save->save = yypath;
        yypath = save;
    }
#if YYDEBUG
    if (yydebug)
        fprintf(stderr, "%s[%d]: state %d, CONFLICT trial successful, backtracking to state %d, %d tokens\n",
                        YYDEBUGSTR, yydepth, yystate, yypath->state, (int)(yylvp - yylvals - yypath->lexeme));
#endif
    if (yyerrctx)
    {
        yyFreeState(yyerrctx);
        yyerrctx = NULL;
    }
    yylvp          = yylvals + yypath->lexeme;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    yylpp          = yylpsns + yypath->lexeme;
#endif
    yylexp         = yylexemes + yypath->lexeme;
    yychar         = YYEMPTY;
    yystack.s_mark = yystack.s_base + (yypath->yystack.s_mark - yypath->yystack.s_base);
    memcpy (yystack.s_base, yypath->yystack.s_base, (size_t) (yystack.s_mark - yystack.s_base + 1) * sizeof(YYINT));
    yystack.l_mark = yystack.l_base + (yypath->yystack.l_mark - yypath->yystack.l_base);
    memcpy (yystack.l_base, yypath->yystack.l_base, (size_t) (yystack.l_mark - yystack.l_base + 1) * sizeof(YYSTYPE));
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    yystack.p_mark = yystack.p_base + (yypath->yystack.p_mark - yypath->yystack.p_base);
    memcpy (yystack.p_base, yypath->yystack.p_base, (size_t) (yystack.p_mark - yystack.p_base + 1) * sizeof(YYLTYPE));
#endif
    yystate        = yypath->state;
    goto yyloop;
#endif /* YYBTYACC */

yyoverflow:
    YYERROR_CALL("yacc stack overflow");
#if YYBTYACC
    goto yyabort_nomem;
yyenomem:
    YYERROR_CALL("memory exhausted");
yyabort_nomem:
#endif /* YYBTYACC */
    yyresult = 2;
    goto yyreturn;

yyabort:
    yyresult = 1;
    goto yyreturn;

yyaccept:
#if YYBTYACC
    if (yyps->save) goto yyvalid;
#endif /* YYBTYACC */
    yyresult = 0;

yyreturn:
#if defined(YYDESTRUCT_CALL)
    if (yychar != YYEOF && yychar != YYEMPTY)
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
        YYDESTRUCT_CALL("cleanup: discarding token", yychar, &yylval, &yylloc);
#else
        YYDESTRUCT_CALL("cleanup: discarding token", yychar, &yylval);
#endif /* defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED) */

    {
        YYSTYPE *pv;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
        YYLTYPE *pp;

        for (pv = yystack.l_base, pp = yystack.p_base; pv <= yystack.l_mark; ++pv, ++pp)
             YYDESTRUCT_CALL("cleanup: discarding state",
                             yystos[*(yystack.s_base + (pv - yystack.l_base))], pv, pp);
#else
        for (pv = yystack.l_base; pv <= yystack.l_mark; ++pv)
             YYDESTRUCT_CALL("cleanup: discarding state",
                             yystos[*(yystack.s_base + (pv - yystack.l_base))], pv);
#endif /* defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED) */
    }
#endif /* defined(YYDESTRUCT_CALL) */

#if YYBTYACC
    if (yyerrctx)
    {
        yyFreeState(yyerrctx);
        yyerrctx = NULL;
    }
    while (yyps)
    {
        YYParseState *save = yyps;
        yyps = save->save;
        save->save = NULL;
        yyFreeState(save);
    }
    while (yypath)
    {
        YYParseState *save = yypath;
        yypath = save->save;
        save->save = NULL;
        yyFreeState(save);
    }
#endif /* YYBTYACC */
    yyfreestack(&yystack);
    return (yyresult);
}
