import React from 'react';
import { Schema } from './Schema';
import { useConfig, useSpec } from '../../contexts';
import { CommonHelpers } from '../../helpers';
import { SCHEMAS_TEXT } from '../../constants';
export var Schemas = function () {
    var asyncapi = useSpec();
    var config = useConfig();
    var schemas = asyncapi.hasComponents() && asyncapi.components().schemas();
    if (!schemas || Object.keys(schemas).length === 0) {
        return null;
    }
    return (React.createElement("section", { id: "".concat(CommonHelpers.getIdentifier('schemas', config)), className: "mt-16" },
        React.createElement("h2", { className: "2xl:w-7/12 text-3xl font-light mb-4 px-8" }, SCHEMAS_TEXT),
        React.createElement("ul", null, Object.entries(schemas).map(function (_a) {
            var schemaName = _a[0], schema = _a[1];
            return (React.createElement("li", { className: "mb-4", key: schemaName, id: CommonHelpers.getIdentifier("schema-".concat(schemaName), config) },
                React.createElement(Schema, { schemaName: schemaName, schema: schema })));
        }))));
};
//# sourceMappingURL=Schemas.js.map