/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.usageView.UsageInfo;
import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public final class ReplacementPreviewDialog
extends DialogWrapper {
    private final LanguageFileType myFileType;
    private Editor replacement;
    private final Project project;
    private RangeHighlighter myHighlighter;
    private Editor editor;

    public ReplacementPreviewDialog(@NotNull Project project2, @NotNull UsageInfo info, String replacementString) {
        if (project2 == null) {
            ReplacementPreviewDialog.$$$reportNull$$$0(0);
        }
        if (info == null) {
            ReplacementPreviewDialog.$$$reportNull$$$0(1);
        }
        super(project2, true);
        this.setTitle(SSRBundle.message("structural.replace.preview.dialog.title", new Object[0]));
        this.setOKButtonText(SSRBundle.message("replace.preview.oktext", new Object[0]));
        this.project = project2;
        PsiElement element = info.getElement();
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        this.myFileType = virtualFile != null ? (LanguageFileType)virtualFile.getFileType() : FileTypes.PLAIN_TEXT;
        this.init();
        Segment range = info.getSegment();
        assert (range != null);
        this.highlight(virtualFile, range.getStartOffset(), range.getEndOffset());
        UIUtil.setContent(this.replacement, replacementString);
    }

    private void highlight(VirtualFile file, int start2, int end) {
        this.removeHighlighter();
        this.editor = FileEditorManager.getInstance((Project)this.project).openTextEditor(new OpenFileDescriptor(this.project, file), false);
        if (this.editor == null) {
            return;
        }
        this.myHighlighter = this.editor.getMarkupModel().addRangeHighlighter(EditorColors.SEARCH_RESULT_ATTRIBUTES, start2, end, 5900, HighlighterTargetArea.EXACT_RANGE);
    }

    private void removeHighlighter() {
        if (this.myHighlighter != null && this.myHighlighter.isValid()) {
            this.myHighlighter.dispose();
            this.myHighlighter = null;
            this.editor = null;
        }
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.strucuturalsearch.plugin.replace.ReplacementPreviewDialog";
    }

    protected JComponent createCenterPanel() {
        JPanel centerPanel2 = new JPanel(new BorderLayout());
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        assert (profile != null);
        this.replacement = UIUtil.createEditor(this.project, this.myFileType, null, "", false, profile);
        centerPanel2.add("North", new JLabel(SSRBundle.message("replacement.code", new Object[0])));
        centerPanel2.add("Center", this.replacement.getComponent());
        centerPanel2.setMaximumSize(new Dimension(640, 480));
        return centerPanel2;
    }

    public void dispose() {
        PsiFile file = PsiDocumentManager.getInstance((Project)this.project).getPsiFile(this.replacement.getDocument());
        if (file != null) {
            DaemonCodeAnalyzer.getInstance((Project)this.project).setHighlightingEnabled(file, true);
        }
        EditorFactory.getInstance().releaseEditor(this.replacement);
        this.removeHighlighter();
        super.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
        }
        objectArray[1] = "com/intellij/structuralsearch/plugin/replace/ui/ReplacementPreviewDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

