/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template.inspection.incompatible;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.django.lang.template.inspection.incompatible.DjangoCompatibilityInfo;
import com.intellij.python.django.util.DjangoUtil;
import com.jetbrains.django.lang.template.DjangoTemplateElementGenerator;
import com.jetbrains.django.lang.template.psi.impl.Jinja2UrlViewImpl;
import com.jetbrains.django.lang.template.tags.Jinja2UrlTag;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.psi.PyUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DjangoUrlParamCompatibilityInfo
extends DjangoCompatibilityInfo<Jinja2UrlTag> {
    DjangoUrlParamCompatibilityInfo() {
        super(DjangoUtil.createRequirementAtLeast((int)1, (int)5), null, Jinja2UrlTag.class);
    }

    @Override
    @Nullable
    public ProblemDescriptor processVersion(boolean isVersionGreater, @NotNull Jinja2UrlTag tag, @NotNull InspectionManager inspectionManager) {
        Jinja2UrlViewImpl view;
        if (tag == null) {
            DjangoUrlParamCompatibilityInfo.$$$reportNull$$$0(0);
        }
        if (inspectionManager == null) {
            DjangoUrlParamCompatibilityInfo.$$$reportNull$$$0(1);
        }
        if ((view = tag.getUrlView()) != null) {
            boolean correct;
            boolean bl = correct = isVersionGreater == view.isInQuotes();
            if (!correct) {
                return inspectionManager.createProblemDescriptor((PsiElement)view, (PsiElement)view, DjangoUrlParamCompatibilityInfo.getMessageText(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[]{new AddQuotesFix(isVersionGreater)});
            }
        }
        return null;
    }

    @InspectionMessage
    private static String getMessageText() {
        return DjangoBundle.message((String)"inspection.incompatible.url_tag.error", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "tag";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "inspectionManager";
                break;
            }
        }
        objectArray[1] = "com/intellij/python/django/lang/template/inspection/incompatible/DjangoUrlParamCompatibilityInfo";
        objectArray[2] = "processVersion";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class AddQuotesFix
    implements LocalQuickFix {
        private static final Pattern QUOTE = Pattern.compile("\"");
        private final boolean myIsDjango5orMore;
        @NotNull
        @Nls
        private final String myMessage;

        private AddQuotesFix(boolean isDjango5orMore) {
            this.myIsDjango5orMore = isDjango5orMore;
            this.myMessage = isDjango5orMore ? DjangoBundle.message((String)"inspection.incompatible.fix.url_tag.add_quotes", (Object[])new Object[0]) : DjangoBundle.message((String)"inspection.incompatible.fix.url_tag.remove_quotes", (Object[])new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myMessage;
            if (string == null) {
                AddQuotesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Jinja2UrlViewImpl viewToChange;
            if (project == null) {
                AddQuotesFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                AddQuotesFix.$$$reportNull$$$0(2);
            }
            if ((viewToChange = (Jinja2UrlViewImpl)PyUtil.as((Object)descriptor.getPsiElement(), Jinja2UrlViewImpl.class)) == null) {
                return;
            }
            String currentText = viewToChange.getText();
            String text = this.myIsDjango5orMore ? "'" + currentText + "'" : QUOTE.matcher(currentText).replaceAll("");
            DjangoTemplateElementGenerator generator = DjangoTemplateElementGenerator.getInstance((Project)project);
            Jinja2UrlViewImpl newView = (Jinja2UrlViewImpl)PsiTreeUtil.findChildOfType((PsiElement)generator.createTag("url", text), Jinja2UrlViewImpl.class);
            assert (newView != null) : "No url view generated!";
            viewToChange.replace((PsiElement)newView);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/python/django/lang/template/inspection/incompatible/DjangoUrlParamCompatibilityInfo$AddQuotesFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/python/django/lang/template/inspection/incompatible/DjangoUrlParamCompatibilityInfo$AddQuotesFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

