/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import com.oracle.truffle.js.builtins.temporal.TemporalInstantPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.EnumerableOwnPropertyNamesNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.ToLimitedTemporalDurationNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalInstantNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalTimeZoneNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPrecisionRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.math.BigInteger;
import java.util.EnumSet;

public class TemporalInstantPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalInstantPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new TemporalInstantPrototypeBuiltins();

    protected TemporalInstantPrototypeBuiltins() {
        super(JSTemporalInstant.PROTOTYPE_NAME, TemporalInstantPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalInstantPrototype builtinEnum) {
        switch (builtinEnum) {
            case epochSeconds: 
            case epochMilliseconds: 
            case epochMicroseconds: 
            case epochNanoseconds: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantGetterNodeGen.create(context, builtin, builtinEnum, TemporalInstantPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case add: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantAddNodeGen.create(context, builtin, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case subtract: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantSubtractNodeGen.create(context, builtin, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case until: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantUntilSinceNodeGen.create(context, builtin, true, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case since: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantUntilSinceNodeGen.create(context, builtin, false, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case round: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantRoundNodeGen.create(context, builtin, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case equals: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantEqualsNodeGen.create(context, builtin, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case toString: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantToStringNodeGen.create(context, builtin, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case toLocaleString: 
            case toJSON: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantToLocaleStringNodeGen.create(context, builtin, TemporalInstantPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case valueOf: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantValueOfNodeGen.create(context, builtin, TemporalInstantPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case toZonedDateTime: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantToZonedDateTimeNodeGen.create(context, builtin, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case toZonedDateTimeISO: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantToZonedDateTimeISONodeGen.create(context, builtin, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum TemporalInstantPrototype implements BuiltinEnum<TemporalInstantPrototype>
    {
        epochSeconds(0),
        epochMilliseconds(0),
        epochMicroseconds(0),
        epochNanoseconds(0),
        add(1),
        subtract(1),
        until(1),
        since(1),
        round(1),
        equals(1),
        toString(0),
        toLocaleString(0),
        toJSON(0),
        valueOf(0),
        toZonedDateTime(1),
        toZonedDateTimeISO(1);

        private final int length;

        private TemporalInstantPrototype(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return EnumSet.of(epochSeconds, epochMilliseconds, epochMicroseconds, epochNanoseconds).contains(this);
        }
    }

    public static abstract class JSTemporalInstantGetterNode
    extends JSBuiltinNode {
        protected final TemporalInstantPrototype property;

        protected JSTemporalInstantGetterNode(JSContext context, JSBuiltin builtin, TemporalInstantPrototype property) {
            super(context, builtin);
            this.property = property;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected Object instantGetter(JSTemporalInstantObject instant) {
            BigInteger ns = instant.getNanoseconds().bigIntegerValue();
            switch (this.property) {
                case epochSeconds: {
                    return ns.divide(TemporalUtil.BI_10_POW_9).doubleValue();
                }
                case epochMilliseconds: {
                    return ns.divide(TemporalUtil.BI_10_POW_6).doubleValue();
                }
                case epochMicroseconds: {
                    return new BigInt(ns.divide(TemporalUtil.BI_1000));
                }
                case epochNanoseconds: {
                    return instant.getNanoseconds();
                }
            }
            throw Errors.shouldNotReachHere();
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }

    public static abstract class JSTemporalInstantAdd
    extends InstantOperation {
        protected JSTemporalInstantAdd(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalInstantObject add(JSTemporalInstantObject instant, Object temporalDurationLike, @Cached ToLimitedTemporalDurationNode toLimitedTemporalDurationNode) {
            return this.addDurationToOrSubtractDurationFromInstant(1, instant, temporalDurationLike, toLimitedTemporalDurationNode);
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDurationLike) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }

    public static abstract class JSTemporalInstantSubtract
    extends InstantOperation {
        protected JSTemporalInstantSubtract(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalInstantObject subtract(JSTemporalInstantObject instant, Object temporalDurationLike, @Cached ToLimitedTemporalDurationNode toLimitedTemporalDurationNode) {
            return this.addDurationToOrSubtractDurationFromInstant(-1, instant, temporalDurationLike, toLimitedTemporalDurationNode);
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDurationLike) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }

    public static abstract class JSTemporalInstantUntilSinceNode
    extends JSTemporalBuiltinOperation {
        private final boolean isUntil;

        protected JSTemporalInstantUntilSinceNode(JSContext context, JSBuiltin builtin, boolean isUntil) {
            super(context, builtin);
            this.isUntil = isUntil;
        }

        @Specialization
        protected JSTemporalDurationObject untilOrSince(JSTemporalInstantObject instant, Object otherObj, Object optionsParam, @Cached JSToNumberNode toNumber, @Cached(value="createKeys(getContext())") EnumerableOwnPropertyNamesNode namesNode, @Cached TruffleString.EqualNode equalNode, @Cached(value="create(getContext())") ToTemporalInstantNode toTemporalInstantNode, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSTemporalInstantObject other = toTemporalInstantNode.execute(otherObj);
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            TemporalUtil.Unit smallestUnit = JSTemporalInstantUntilSinceNode.toSmallestTemporalUnit(options, TemporalUtil.listYMWD, TemporalConstants.NANOSECOND, equalNode, getOptionNode, this, errorBranch);
            TemporalUtil.Unit defaultLargestUnit = TemporalUtil.largerOfTwoTemporalUnits(TemporalUtil.Unit.SECOND, smallestUnit);
            TemporalUtil.Unit largestUnit = JSTemporalInstantUntilSinceNode.toLargestTemporalUnit(options, TemporalUtil.listYMWD, TemporalConstants.AUTO, defaultLargestUnit, equalNode, getOptionNode, this, errorBranch);
            TemporalUtil.validateTemporalUnitRange(largestUnit, smallestUnit);
            TemporalUtil.RoundingMode roundingMode = JSTemporalInstantUntilSinceNode.toTemporalRoundingMode(options, TemporalConstants.TRUNC, equalNode, getOptionNode);
            Double maximum = TemporalUtil.maximumTemporalDurationRoundingIncrement(smallestUnit);
            double roundingIncrement = TemporalUtil.toTemporalRoundingIncrement(options, maximum, false, this.isObjectNode, toNumber);
            BigInt one = this.isUntil ? instant.getNanoseconds() : other.getNanoseconds();
            BigInt two = this.isUntil ? other.getNanoseconds() : instant.getNanoseconds();
            BigInteger roundedNs = TemporalUtil.differenceInstant(one, two, roundingIncrement, smallestUnit, roundingMode);
            JSTemporalDurationRecord result2 = TemporalUtil.balanceDuration(this.getContext(), namesNode, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, roundedNs, largestUnit, Undefined.instance);
            return JSTemporalDuration.createTemporalDuration(this.getContext(), 0.0, 0.0, 0.0, 0.0, result2.getHours(), result2.getMinutes(), result2.getSeconds(), result2.getMilliseconds(), result2.getMicroseconds(), result2.getNanoseconds(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object otherObj, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }

    public static abstract class JSTemporalInstantRound
    extends JSTemporalBuiltinOperation {
        protected JSTemporalInstantRound(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalInstantObject round(JSTemporalInstantObject instant, Object roundToParam, @Cached JSToNumberNode toNumber, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            double maximum;
            JSDynamicObject roundTo;
            if (roundToParam == Undefined.instance) {
                errorBranch.enter(this);
                throw TemporalErrors.createTypeErrorOptionsUndefined();
            }
            if (Strings.isTString(roundToParam)) {
                roundTo = JSOrdinary.createWithNullPrototype(this.getContext());
                JSRuntime.createDataPropertyOrThrow(roundTo, TemporalConstants.SMALLEST_UNIT, JSRuntime.toStringIsString(roundToParam));
            } else {
                roundTo = this.getOptionsObject(roundToParam, this, errorBranch, optionUndefined);
            }
            TemporalUtil.Unit smallestUnit = JSTemporalInstantRound.toSmallestTemporalUnit(roundTo, TemporalUtil.listYMWD, null, equalNode, getOptionNode, this, errorBranch);
            if (smallestUnit == TemporalUtil.Unit.EMPTY) {
                errorBranch.enter(this);
                throw TemporalErrors.createRangeErrorSmallestUnitExpected();
            }
            TemporalUtil.RoundingMode roundingMode = JSTemporalInstantRound.toTemporalRoundingMode(roundTo, TemporalConstants.HALF_EXPAND, equalNode, getOptionNode);
            if (TemporalUtil.Unit.HOUR == smallestUnit) {
                maximum = 24.0;
            } else if (TemporalUtil.Unit.MINUTE == smallestUnit) {
                maximum = 1440.0;
            } else if (TemporalUtil.Unit.SECOND == smallestUnit) {
                maximum = 86400.0;
            } else if (TemporalUtil.Unit.MILLISECOND == smallestUnit) {
                maximum = 8.64E7;
            } else if (TemporalUtil.Unit.MICROSECOND == smallestUnit) {
                maximum = 8.64E10;
            } else {
                assert (TemporalUtil.Unit.NANOSECOND == smallestUnit);
                maximum = 8.64E13;
            }
            double roundingIncrement = TemporalUtil.toTemporalRoundingIncrement(roundTo, maximum, true, this.isObjectNode, toNumber);
            BigInteger roundedNs = TemporalUtil.roundTemporalInstant(instant.getNanoseconds(), (double)((long)roundingIncrement), smallestUnit, roundingMode);
            return JSTemporalInstant.create(this.getContext(), this.getRealm(), new BigInt(roundedNs));
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object roundToParam) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }

    public static abstract class JSTemporalInstantEquals
    extends JSTemporalBuiltinOperation {
        protected JSTemporalInstantEquals(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean equals(JSTemporalInstantObject instant, Object otherObj, @Cached(value="create(getContext())") ToTemporalInstantNode toTemporalInstantNode) {
            JSTemporalInstantObject other = toTemporalInstantNode.execute(otherObj);
            return instant.getNanoseconds().compareTo(other.getNanoseconds()) == 0;
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object otherObj) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }

    public static abstract class JSTemporalInstantToString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalInstantToString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString toString(JSTemporalInstantObject instant, Object optionsParam, @Cached(value="create(getContext())") ToTemporalTimeZoneNode toTemporalTimeZone, @Cached JSToStringNode toStringNode, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            Object timeZoneRaw = JSObject.get(options, TemporalConstants.TIME_ZONE);
            JSDynamicObject timeZone = Undefined.instance;
            if (timeZoneRaw != Undefined.instance) {
                timeZone = toTemporalTimeZone.execute(timeZoneRaw);
            }
            JSTemporalPrecisionRecord precision = TemporalUtil.toSecondsStringPrecision(options, toStringNode, getOptionNode, equalNode);
            TemporalUtil.RoundingMode roundingMode = JSTemporalInstantToString.toTemporalRoundingMode(options, TemporalConstants.TRUNC, equalNode, getOptionNode);
            BigInt ns = instant.getNanoseconds();
            BigInteger roundedNs = TemporalUtil.roundTemporalInstant(ns, (double)((long)precision.getIncrement()), precision.getUnit(), roundingMode);
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject roundedInstant = JSTemporalInstant.create(this.getContext(), realm, new BigInt(roundedNs));
            return TemporalUtil.temporalInstantToString(this.getContext(), realm, roundedInstant, timeZone, precision.getPrecision());
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }

    public static abstract class JSTemporalInstantToLocaleString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalInstantToLocaleString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString toLocaleString(JSTemporalInstantObject instant) {
            return TemporalUtil.temporalInstantToString(this.getContext(), this.getRealm(), instant, Undefined.instance, TemporalConstants.AUTO);
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }

    public static abstract class JSTemporalInstantValueOf
    extends JSTemporalBuiltinOperation {
        protected JSTemporalInstantValueOf(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object valueOf(Object thisObj) {
            throw Errors.createTypeError("Not supported.");
        }
    }

    public static abstract class JSTemporalInstantToZonedDateTimeNode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalInstantToZonedDateTimeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalZonedDateTimeObject toZonedDateTime(JSTemporalInstantObject instant, Object item, @Cached(value="create(getContext())") ToTemporalCalendarNode toTemporalCalendar, @Cached(value="create(getContext())") ToTemporalTimeZoneNode toTemporalTimeZone, @Cached InlinedBranchProfile errorBranch) {
            if (!this.isObject(item)) {
                errorBranch.enter(this);
                throw Errors.createTypeError("object expected");
            }
            JSDynamicObject itemObj = TemporalUtil.toJSDynamicObject(item, this, errorBranch);
            Object calendarLike = JSObject.get(itemObj, TemporalConstants.CALENDAR);
            if (calendarLike == Undefined.instance) {
                errorBranch.enter(this);
                throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
            }
            JSDynamicObject calendar = toTemporalCalendar.execute(calendarLike);
            Object timeZoneLike = JSObject.get(itemObj, TemporalConstants.TIME_ZONE);
            if (timeZoneLike == Undefined.instance) {
                errorBranch.enter(this);
                throw TemporalErrors.createTypeErrorTemporalTimeZoneExpected();
            }
            JSDynamicObject timeZone = toTemporalTimeZone.execute(timeZoneLike);
            return JSTemporalZonedDateTime.create(this.getContext(), this.getRealm(), instant.getNanoseconds(), timeZone, calendar);
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object item) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }

    public static abstract class JSTemporalInstantToZonedDateTimeISONode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalInstantToZonedDateTimeISONode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalZonedDateTimeObject toZonedDateTimeISO(JSTemporalInstantObject instant, Object itemParam, @Cached(value="create(getContext())") ToTemporalTimeZoneNode toTemporalTimeZone, @Cached InlinedBranchProfile errorBranch) {
            JSDynamicObject itemObj;
            Object timeZoneProperty;
            Object item = itemParam;
            if (this.isObject(item) && (timeZoneProperty = JSObject.get(itemObj = TemporalUtil.toJSDynamicObject(item, this, errorBranch), TemporalConstants.TIME_ZONE)) != Undefined.instance) {
                item = timeZoneProperty;
            }
            JSDynamicObject timeZone = toTemporalTimeZone.execute(item);
            JSRealm realm = this.getRealm();
            JSTemporalCalendarObject calendar = TemporalUtil.getISO8601Calendar(this.getContext(), realm, this, errorBranch);
            return JSTemporalZonedDateTime.create(this.getContext(), realm, instant.getNanoseconds(), timeZone, calendar);
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object item) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }

    public static abstract class InstantOperation
    extends JSTemporalBuiltinOperation {
        protected InstantOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected JSTemporalInstantObject addDurationToOrSubtractDurationFromInstant(int sign, JSTemporalInstantObject instant, Object temporalDurationLike, ToLimitedTemporalDurationNode toLimitedTemporalDurationNode) {
            JSTemporalDurationRecord duration = toLimitedTemporalDurationNode.execute(temporalDurationLike, TemporalUtil.listPluralYMWD);
            BigInt ns = TemporalUtil.addInstant(instant.getNanoseconds(), (double)sign * duration.getHours(), (double)sign * duration.getMinutes(), (double)sign * duration.getSeconds(), (double)sign * duration.getMilliseconds(), (double)sign * duration.getMicroseconds(), (double)sign * duration.getNanoseconds());
            return JSTemporalInstant.create(this.getContext(), this.getRealm(), ns);
        }
    }
}

