/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.diagnostics;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.LazyExtension;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.util.ApplicationKt;
import com.intellij.util.SingleAlarm;
import com.intellij.util.xmlb.annotations.Attribute;
import com.jetbrains.rd.platform.diagnostics.LogTraceCategoriesListener;
import com.jetbrains.rd.platform.diagnostics.LogTraceScenarioBase;
import com.jetbrains.rd.util.PlatformDependentKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u0000  2\u00020\u0001:\u0003\u001f !B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011J\u0014\u0010\u0012\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00130\u0011J\u0010\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\tH\u0002J\u0016\u0010\u001d\u001a\u00020\t2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0014\u001a\"\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0015j\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0017`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "registerAndSaveScenario", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "traceScenario", "Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenarioBase;", "syncAlarm", "Lcom/intellij/util/SingleAlarm;", "enabledScenarios", "", "save", "", "categoriesOldLevels", "Ljava/util/HashMap;", "Ljava/util/logging/Logger;", "Ljava/util/logging/Level;", "Lkotlin/collections/HashMap;", "synchronizeToLogger", "immediately", "", "synchronizeToLoggerImmediately", "updateTraceCategories", "traceCategories", "HolderEpBean", "Companion", "LogTraceScenariosInitializer", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nLogTraceScenarioRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogTraceScenarioRegistry.kt\ncom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,234:1\n1611#2,9:235\n1863#2:244\n1864#2:246\n1620#2:247\n1368#2:248\n1454#2,5:249\n1557#2:255\n1628#2,3:256\n1557#2:259\n1628#2,3:260\n1#3:245\n1#3:254\n14#4:263\n*S KotlinDebug\n*F\n+ 1 LogTraceScenarioRegistry.kt\ncom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry\n*L\n94#1:235,9\n94#1:244\n94#1:246\n94#1:247\n118#1:248\n118#1:249,5\n73#1:255\n73#1:256,3\n83#1:259\n83#1:260,3\n94#1:245\n35#1:263\n*E\n"})
public final class LogTraceScenariosRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final SingleAlarm syncAlarm;
    @NotNull
    private final HashMap<java.util.logging.Logger, Level> categoriesOldLevels;
    @NotNull
    private static final ExtensionPointName<HolderEpBean> HOLDER_EP_NAME = ExtensionPointName.Companion.create("com.intellij.rd.platform.traceScenarioHolder");
    @NotNull
    private static final ExtensionPointName<LogTraceCategoriesListener> TRACE_CATEGORIES_LISTENER_EP_NAME = new ExtensionPointName("com.intellij.rd.platform.logTraceCategoriesListener");
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Map<String, LogTraceScenarioBase> allValues;
    @NotNull
    private static final String TRACE_SCENARIOS_KEY = "rider.trace.scenarios";
    @NotNull
    private static final String TRACE_SCENARIOS_REGISTRY_KEY = "rd.forced.trace.scenarios";
    @NotNull
    private static final String delimiter = ",";

    public LogTraceScenariosRegistry(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.scope = scope;
        this.syncAlarm = new SingleAlarm(() -> LogTraceScenariosRegistry.syncAlarm$lambda$8(this), 100);
        this.categoriesOldLevels = new HashMap();
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @TestOnly
    public final void registerAndSaveScenario(@NotNull Lifetime lifetime, @NotNull LogTraceScenarioBase traceScenario) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)traceScenario, (String)"traceScenario");
        lifetime.bracketOrThrowEx(() -> LogTraceScenariosRegistry.registerAndSaveScenario$lambda$3(traceScenario, this), arg_0 -> LogTraceScenariosRegistry.registerAndSaveScenario$lambda$7(traceScenario, this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LogTraceScenarioBase> enabledScenarios() {
        void $this$mapNotNullTo$iv$iv;
        String systemPropertyScenario = System.getProperty(TRACE_SCENARIOS_REGISTRY_KEY, "") + delimiter;
        String string = PropertiesComponent.getInstance().getValue(TRACE_SCENARIOS_KEY, "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        String savedScenarios = string;
        String all = systemPropertyScenario + savedScenarios;
        String[] stringArray = new String[]{delimiter};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)all, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            LogTraceScenarioBase it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String name = (String)element$iv$iv;
            boolean bl2 = false;
            if (allValues.get(name) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
    }

    public final void save(@NotNull List<String> enabledScenarios) {
        Intrinsics.checkNotNullParameter(enabledScenarios, (String)"enabledScenarios");
        String newEnabledScenarios = CollectionsKt.joinToString$default((Iterable)enabledScenarios, (CharSequence)delimiter, null, null, (int)0, null, null, (int)62, null);
        logger.info("save trace enabled scenarios: " + newEnabledScenarios);
        PropertiesComponent.getInstance().setValue(TRACE_SCENARIOS_KEY, newEnabledScenarios);
        this.synchronizeToLogger(true);
    }

    public final void synchronizeToLogger(boolean immediately) {
        if (immediately) {
            this.syncAlarm.cancelAllRequests();
            this.synchronizeToLoggerImmediately();
        } else {
            this.syncAlarm.request();
        }
    }

    public static /* synthetic */ void synchronizeToLogger$default(LogTraceScenariosRegistry logTraceScenariosRegistry, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        logTraceScenariosRegistry.synchronizeToLogger(bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void synchronizeToLoggerImmediately() {
        java.util.logging.Logger logger;
        void $this$flatMapTo$iv$iv;
        List<LogTraceScenarioBase> enabledScenarios = this.enabledScenarios();
        Iterable $this$flatMap$iv = enabledScenarios;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            LogTraceScenarioBase it = (LogTraceScenarioBase)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getCategories();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List traceCategories = CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
        this.updateTraceCategories(traceCategories);
        Iterator<Map.Entry<java.util.logging.Logger, Level>> iterator = this.categoriesOldLevels.entrySet().iterator();
        while (iterator.hasNext()) {
            Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$flatMap.getKey(), (String)"component1(...)");
            Level level = $i$f$flatMap.getValue();
            logger.setLevel(level);
        }
        this.categoriesOldLevels.clear();
        for (String category : traceCategories) {
            logger = java.util.logging.Logger.getLogger(category);
            ((Map)this.categoriesOldLevels).put(logger, logger.getLevel());
            logger.setLevel(Level.FINER);
        }
    }

    private final void updateTraceCategories(List<String> traceCategories) {
        for (LogTraceCategoriesListener listener2 : (LogTraceCategoriesListener[])TRACE_CATEGORIES_LISTENER_EP_NAME.getExtensions()) {
            listener2.traceCategoriesUpdated(traceCategories);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List registerAndSaveScenario$lambda$3(LogTraceScenarioBase $traceScenario, LogTraceScenariosRegistry this$0) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        boolean bl;
        LogTraceScenarioBase prevValue = allValues.putIfAbsent($traceScenario.getName(), $traceScenario);
        boolean bl2 = bl = prevValue == null;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-LogTraceScenariosRegistry$registerAndSaveScenario$1$22 = false;
            String $i$a$-assert-LogTraceScenariosRegistry$registerAndSaveScenario$1$22 = $traceScenario + " already set: " + prevValue;
            throw new AssertionError((Object)$i$a$-assert-LogTraceScenariosRegistry$registerAndSaveScenario$1$22);
        }
        List<LogTraceScenarioBase> current = this$0.enabledScenarios();
        Iterable $i$a$-assert-LogTraceScenariosRegistry$registerAndSaveScenario$1$22 = CollectionsKt.plus((Collection)current, (Object)$traceScenario);
        LogTraceScenariosRegistry logTraceScenariosRegistry = this$0;
        boolean $i$f$map = false;
        void var6_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LogTraceScenarioBase logTraceScenarioBase = (LogTraceScenarioBase)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(it.getName());
        }
        logTraceScenariosRegistry.save((List)destination$iv$iv);
        boolean bl4 = this$0.enabledScenarios().contains($traceScenario);
        if (_Assertions.ENABLED && !bl4) {
            boolean bl5 = false;
            String string = "enabledScenarios do not contain " + $traceScenario + " after manual installation";
            throw new AssertionError((Object)string);
        }
        return current;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit registerAndSaveScenario$lambda$7(LogTraceScenarioBase $traceScenario, LogTraceScenariosRegistry this$0, List it) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean success = allValues.remove($traceScenario.getName(), $traceScenario);
        if (_Assertions.ENABLED && !success) {
            boolean $i$a$-assert-LogTraceScenariosRegistry$registerAndSaveScenario$2$32 = false;
            String $i$a$-assert-LogTraceScenariosRegistry$registerAndSaveScenario$2$32 = "Failed to remove trace scenario: " + $traceScenario + " from the map";
            throw new AssertionError((Object)$i$a$-assert-LogTraceScenariosRegistry$registerAndSaveScenario$2$32);
        }
        List<LogTraceScenarioBase> enabledScenarios = this$0.enabledScenarios();
        boolean bl2 = bl = !enabledScenarios.contains($traceScenario);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-LogTraceScenariosRegistry$registerAndSaveScenario$2$42 = false;
            String $i$a$-assert-LogTraceScenariosRegistry$registerAndSaveScenario$2$42 = "enabledScenarios still contain " + $traceScenario + " after removing";
            throw new AssertionError((Object)$i$a$-assert-LogTraceScenariosRegistry$registerAndSaveScenario$2$42);
        }
        Iterable iterable = enabledScenarios;
        LogTraceScenariosRegistry logTraceScenariosRegistry = this$0;
        boolean $i$f$map = false;
        void var7_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            LogTraceScenarioBase logTraceScenarioBase = (LogTraceScenarioBase)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(it2.getName());
        }
        logTraceScenariosRegistry.save((List)destination$iv$iv);
        return Unit.INSTANCE;
    }

    private static final void syncAlarm$lambda$8(LogTraceScenariosRegistry this$0) {
        this$0.synchronizeToLogger(true);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LogTraceScenariosRegistry.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LogTraceScenariosRegistry.logger = logger;
        allValues = PlatformDependentKt.concurrentMapOf();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry$Companion;", "", "<init>", "()V", "HOLDER_EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry$HolderEpBean;", "TRACE_CATEGORIES_LISTENER_EP_NAME", "Lcom/jetbrains/rd/platform/diagnostics/LogTraceCategoriesListener;", "getTRACE_CATEGORIES_LISTENER_EP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry;", "loadTraceScenarioHolders", "", "allValues", "", "", "Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenarioBase;", "getAllValues", "()Ljava/util/Map;", "TRACE_SCENARIOS_KEY", "TRACE_SCENARIOS_REGISTRY_KEY", "delimiter", "intellij.rd.platform"})
    @SourceDebugExtension(value={"SMAP\nLogTraceScenarioRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogTraceScenarioRegistry.kt\ncom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n1557#2:235\n1628#2,3:236\n*S KotlinDebug\n*F\n+ 1 LogTraceScenarioRegistry.kt\ncom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry$Companion\n*L\n49#1:235\n49#1:236,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<LogTraceCategoriesListener> getTRACE_CATEGORIES_LISTENER_EP_NAME() {
            return TRACE_CATEGORIES_LISTENER_EP_NAME;
        }

        @NotNull
        public final LogTraceScenariosRegistry getInstance() {
            Object object = ApplicationKt.getApplication().getService(LogTraceScenariosRegistry.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (LogTraceScenariosRegistry)object;
        }

        /*
         * WARNING - void declaration
         */
        public final void loadTraceScenarioHolders() {
            for (LazyExtension item : HOLDER_EP_NAME.filterableLazySequence()) {
                try {
                    void $this$mapTo$iv$iv;
                    HolderEpBean holder;
                    if ((HolderEpBean)item.getInstance() == null) continue;
                    Class<?> clazz = Class.forName(holder.getImplementation(), true, item.getPluginDescriptor().getPluginClassLoader());
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(...)");
                    KClass holderClass = JvmClassMappingKt.getKotlinClass(clazz);
                    Object object = holderClass.getObjectInstance();
                    if (object == null) {
                        KFunction kFunction = (KFunction)CollectionsKt.firstOrNull((Iterable)holderClass.getConstructors());
                        object = kFunction != null ? kFunction.call(new Object[0]) : null;
                    }
                    Iterable $this$map$iv = holderClass.getNestedClasses();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        KClass kClass = (KClass)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getObjectInstance());
                    }
                    List cfr_ignored_0 = (List)destination$iv$iv;
                }
                catch (Throwable t) {
                    logger.error("Failed to load trace category " + item.getImplementationClassName(), t);
                }
            }
        }

        @NotNull
        public final Map<String, LogTraceScenarioBase> getAllValues() {
            return allValues;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry$HolderEpBean;", "", "<init>", "()V", "implementation", "", "getImplementation", "()Ljava/lang/String;", "setImplementation", "(Ljava/lang/String;)V", "intellij.rd.platform"})
    public static final class HolderEpBean {
        @Attribute
        @RequiredElement
        @NotNull
        private String implementation = "";

        @NotNull
        public final String getImplementation() {
            return this.implementation;
        }

        public final void setImplementation(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.implementation = string;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry$LogTraceScenariosInitializer;", "Lcom/intellij/ide/AppLifecycleListener;", "<init>", "()V", "appFrameCreated", "", "commandLineArgs", "", "", "intellij.rd.platform"})
    public static final class LogTraceScenariosInitializer
    implements AppLifecycleListener {
        public void appFrameCreated(@NotNull List<String> commandLineArgs) {
            Intrinsics.checkNotNullParameter(commandLineArgs, (String)"commandLineArgs");
            CoroutineScope scope = Companion.getInstance().getScope();
            BuildersKt.launch$default((CoroutineScope)scope, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                int label;

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            LogTraceScenariosRegistry.Companion.loadTraceScenarioHolders();
                            this.label = 1;
                            Object object3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                                int label;

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            LogTraceScenariosRegistry.Companion.getInstance().synchronizeToLogger(true);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }
}

