/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.core.jupyter.remote.vfs;

import com.intellij.notebooks.core.jupyter.JupyterRemotePath;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteFileStrategy;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteFileSystem;
import com.intellij.notebooks.core.jupyter.remote.vfs.UploadingOutputStream;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 I2\u00020\u00012\u00020\u0002:\u0001IB9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000b2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u000bH\u0016J\b\u0010*\u001a\u00020$H\u0016J\b\u0010+\u001a\u00020(H\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u000bH\u0016J\b\u0010/\u001a\u000200H\u0016J\n\u00101\u001a\u0004\u0018\u00010\u0001H\u0016J\u0013\u00102\u001a\b\u0012\u0004\u0012\u00020\u000103H\u0016\u00a2\u0006\u0002\u00104J\b\u00105\u001a\u00020\u000bH\u0016J\"\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u0001092\u0006\u0010:\u001a\u00020$2\u0006\u0010;\u001a\u00020$H\u0016J\b\u0010<\u001a\u00020$H\u0016J\b\u0010=\u001a\u00020$H\u0016J\b\u0010>\u001a\u00020?H\u0016J\u0013\u0010@\u001a\u00020\u000b2\b\u0010A\u001a\u0004\u0018\u000109H\u0096\u0002J\b\u0010B\u001a\u00020?H\u0016J1\u0010C\u001a\u00020\u001e\"\n\b\u0000\u0010D*\u0004\u0018\u0001092\f\u0010E\u001a\b\u0012\u0004\u0012\u0002HD0F2\b\u0010G\u001a\u0004\u0018\u0001HDH\u0016\u00a2\u0006\u0002\u0010HR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006J"}, d2={"Lcom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFileWithId;", "jupyterRemoteFileSystem", "Lcom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteFileSystem;", "jupyterRemoteParent", "remotePath", "Lcom/intellij/notebooks/core/jupyter/JupyterRemotePath;", "localFile", "Lcom/intellij/openapi/vfs/newvfs/NewVirtualFile;", "createdOnServer", "", "strategy", "Lcom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteFileStrategy;", "<init>", "(Lcom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteFileSystem;Lcom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteVirtualFile;Lcom/intellij/notebooks/core/jupyter/JupyterRemotePath;Lcom/intellij/openapi/vfs/newvfs/NewVirtualFile;ZLcom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteFileStrategy;)V", "getJupyterRemoteFileSystem", "()Lcom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteFileSystem;", "getJupyterRemoteParent", "()Lcom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteVirtualFile;", "getRemotePath", "()Lcom/intellij/notebooks/core/jupyter/JupyterRemotePath;", "setRemotePath", "(Lcom/intellij/notebooks/core/jupyter/JupyterRemotePath;)V", "getLocalFile", "()Lcom/intellij/openapi/vfs/newvfs/NewVirtualFile;", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isCreatedOnServer", "()Z", "refresh", "", "asynchronous", "recursive", "postRunnable", "Ljava/lang/Runnable;", "getLength", "", "getFileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "getPath", "", "isDirectory", "getTimeStamp", "getName", "contentsToByteArray", "", "isValid", "getInputStream", "Ljava/io/InputStream;", "getParent", "getChildren", "", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "isWritable", "getOutputStream", "Ljava/io/OutputStream;", "requestor", "", "newModificationStamp", "newTimeStamp", "getModificationStamp", "getModificationCount", "getId", "", "equals", "other", "hashCode", "putUserData", "T", "key", "Lcom/intellij/openapi/util/Key;", "value", "(Lcom/intellij/openapi/util/Key;Ljava/lang/Object;)V", "Companion", "intellij.notebooks.core"})
@SourceDebugExtension(value={"SMAP\nJupyterRemoteVirtualFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRemoteVirtualFile.kt\ncom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteVirtualFile\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n37#2,2:111\n1#3:113\n*S KotlinDebug\n*F\n+ 1 JupyterRemoteVirtualFile.kt\ncom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteVirtualFile\n*L\n73#1:111,2\n*E\n"})
public final class JupyterRemoteVirtualFile
extends VirtualFile
implements VirtualFileWithId {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JupyterRemoteFileSystem jupyterRemoteFileSystem;
    @Nullable
    private final JupyterRemoteVirtualFile jupyterRemoteParent;
    @NotNull
    private JupyterRemotePath remotePath;
    @NotNull
    private final NewVirtualFile localFile;
    @NotNull
    private final JupyterRemoteFileStrategy strategy;
    @NotNull
    private final AtomicBoolean createdOnServer;
    @NotNull
    private static final Key<JupyterRemoteVirtualFile> JUPYTER_REMOTE_VIRTUAL_FILE_KEY;

    public JupyterRemoteVirtualFile(@NotNull JupyterRemoteFileSystem jupyterRemoteFileSystem, @Nullable JupyterRemoteVirtualFile jupyterRemoteParent, @NotNull JupyterRemotePath remotePath, @NotNull NewVirtualFile localFile, boolean createdOnServer, @NotNull JupyterRemoteFileStrategy strategy) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)jupyterRemoteFileSystem), (String)"jupyterRemoteFileSystem");
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        Intrinsics.checkNotNullParameter((Object)localFile, (String)"localFile");
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        this.jupyterRemoteFileSystem = jupyterRemoteFileSystem;
        this.jupyterRemoteParent = jupyterRemoteParent;
        this.remotePath = remotePath;
        this.localFile = localFile;
        this.strategy = strategy;
        this.createdOnServer = new AtomicBoolean(createdOnServer);
        boolean bl2 = bl = this.jupyterRemoteParent == null == (this.remotePath.getName() == null);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-JupyterRemoteVirtualFile$32 = false;
            String $i$a$-assert-JupyterRemoteVirtualFile$32 = "Every " + ((Object)((Object)this)).getClass().getName() + " can be either an authority node (without a parent and with empty file name, means root of some server) or a regular file node (with a parent and with non-empty file name)";
            throw new AssertionError((Object)$i$a$-assert-JupyterRemoteVirtualFile$32);
        }
        JupyterRemoteVirtualFile jupyterRemoteVirtualFile = this.jupyterRemoteParent;
        bl = Intrinsics.areEqual((Object)(jupyterRemoteVirtualFile != null ? jupyterRemoteVirtualFile.remotePath : null), (Object)this.remotePath.getParent());
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            JupyterRemoteVirtualFile jupyterRemoteVirtualFile2 = this.jupyterRemoteParent;
            String string = "jupyterRemoteParent?.remotePath (\"" + (jupyterRemoteVirtualFile2 != null ? jupyterRemoteVirtualFile2.remotePath : null) + "\") != remotePath.parent (\"" + this.remotePath.getParent() + "\")";
            throw new AssertionError((Object)string);
        }
        this.localFile.putUserData(JUPYTER_REMOTE_VIRTUAL_FILE_KEY, (Object)this);
    }

    @NotNull
    public final JupyterRemoteFileSystem getJupyterRemoteFileSystem() {
        return this.jupyterRemoteFileSystem;
    }

    @Nullable
    public final JupyterRemoteVirtualFile getJupyterRemoteParent() {
        return this.jupyterRemoteParent;
    }

    @NotNull
    public final JupyterRemotePath getRemotePath() {
        return this.remotePath;
    }

    public final void setRemotePath(@NotNull JupyterRemotePath jupyterRemotePath) {
        Intrinsics.checkNotNullParameter((Object)jupyterRemotePath, (String)"<set-?>");
        this.remotePath = jupyterRemotePath;
    }

    @NotNull
    public final NewVirtualFile getLocalFile() {
        return this.localFile;
    }

    public final boolean isCreatedOnServer() {
        return this.createdOnServer.get();
    }

    public void refresh(boolean asynchronous, boolean recursive, @Nullable Runnable postRunnable) {
        this.localFile.refresh(asynchronous, recursive, postRunnable);
    }

    public long getLength() {
        return this.localFile.getLength();
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this.jupyterRemoteFileSystem;
    }

    @NotNull
    public String getPath() {
        return this.remotePath.getFullPath();
    }

    public boolean isDirectory() {
        return this.localFile.isDirectory();
    }

    public long getTimeStamp() {
        return this.localFile.getTimeStamp();
    }

    @NotNull
    public String getName() {
        return (String)CollectionsKt.last(this.remotePath.getFullPathParts());
    }

    @NotNull
    public byte[] contentsToByteArray() {
        byte[] byArray = this.localFile.contentsToByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
        return byArray;
    }

    public boolean isValid() {
        return this.localFile.isValid();
    }

    @NotNull
    public InputStream getInputStream() {
        InputStream inputStream = this.localFile.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        return inputStream;
    }

    @Nullable
    public VirtualFile getParent() {
        return this.jupyterRemoteParent;
    }

    @NotNull
    public VirtualFile[] getChildren() {
        Collection $this$toTypedArray$iv = this.jupyterRemoteFileSystem.getChildren$intellij_notebooks_core(this.remotePath);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new VirtualFile[0]);
    }

    public boolean isWritable() {
        return this.localFile.isWritable();
    }

    @NotNull
    public OutputStream getOutputStream(@Nullable Object requestor, long newModificationStamp, long newTimeStamp) {
        OutputStream outputStream = this.localFile.getOutputStream(requestor, newModificationStamp, newTimeStamp);
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
        return new UploadingOutputStream(requestor, this, outputStream, this.createdOnServer, this.strategy);
    }

    public long getModificationStamp() {
        return this.localFile.getModificationStamp();
    }

    public long getModificationCount() {
        return this.localFile.getModificationCount();
    }

    public int getId() {
        return this.localFile.getId();
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof JupyterRemoteVirtualFile && this.getId() == ((JupyterRemoteVirtualFile)((Object)other)).getId();
    }

    public int hashCode() {
        return this.getId();
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        block0: {
            String string;
            Intrinsics.checkNotNullParameter(key, (String)"key");
            super.putUserData(key, value);
            String it = string = key.toString();
            boolean bl = false;
            String string2 = Intrinsics.areEqual((Object)it, (Object)"JUPYTER_EDITOR_KEY") || Intrinsics.areEqual((Object)it, (Object)"NOTEBOOK_VIRTUAL_FILE_KEY") ? string : null;
            if (string2 == null) break block0;
            it = string2;
            boolean bl2 = false;
            this.localFile.putUserData(key, value);
        }
    }

    static {
        Key key = Key.create((String)"JUPYTER_REMOTE_VIRTUAL_FILE");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        JUPYTER_REMOTE_VIRTUAL_FILE_KEY = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteVirtualFile$Companion;", "", "<init>", "()V", "JUPYTER_REMOTE_VIRTUAL_FILE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteVirtualFile;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getJUPYTER_REMOTE_VIRTUAL_FILE_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.notebooks.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<JupyterRemoteVirtualFile> getJUPYTER_REMOTE_VIRTUAL_FILE_KEY() {
            return JUPYTER_REMOTE_VIRTUAL_FILE_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

