/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.raster;

import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.NotebookGraphicsConfigurationManager;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.raster.JcefOffScreenComponentController;
import com.intellij.notebooks.visualization.outputs.NotebookOutputInlayShowable;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018J\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffscreenViewPort;", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputInlayShowable;", "bounds", "Ljava/awt/Rectangle;", "viewPortComponentController", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenComponentController;", "graphicsConfigurationManager", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookGraphicsConfigurationManager;", "<init>", "(Ljava/awt/Rectangle;Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenComponentController;Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookGraphicsConfigurationManager;)V", "getBounds", "()Ljava/awt/Rectangle;", "getViewPortComponentController", "()Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenComponentController;", "getGraphicsConfigurationManager", "()Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookGraphicsConfigurationManager;", "value", "", "shown", "getShown", "()Z", "setShown", "(Z)V", "buffer", "Ljava/awt/image/BufferedImage;", "getOrCreateBuffer", "recreateBufferIfNeeded", "", "setBounds", "newValue", "draw", "graphics", "Ljava/awt/Graphics2D;", "Companion", "intellij.jupyter.core"})
public final class JcefOffscreenViewPort
implements NotebookOutputInlayShowable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Rectangle bounds;
    @NotNull
    private final JcefOffScreenComponentController viewPortComponentController;
    @NotNull
    private final NotebookGraphicsConfigurationManager graphicsConfigurationManager;
    private boolean shown;
    @Nullable
    private BufferedImage buffer;

    public JcefOffscreenViewPort(@NotNull Rectangle bounds, @NotNull JcefOffScreenComponentController viewPortComponentController, @NotNull NotebookGraphicsConfigurationManager graphicsConfigurationManager) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)viewPortComponentController, (String)"viewPortComponentController");
        Intrinsics.checkNotNullParameter((Object)graphicsConfigurationManager, (String)"graphicsConfigurationManager");
        this.bounds = bounds;
        this.viewPortComponentController = viewPortComponentController;
        this.graphicsConfigurationManager = graphicsConfigurationManager;
    }

    @NotNull
    public final Rectangle getBounds() {
        return this.bounds;
    }

    @NotNull
    public final JcefOffScreenComponentController getViewPortComponentController() {
        return this.viewPortComponentController;
    }

    @NotNull
    public final NotebookGraphicsConfigurationManager getGraphicsConfigurationManager() {
        return this.graphicsConfigurationManager;
    }

    public boolean getShown() {
        return this.shown;
    }

    public void setShown(boolean value) {
        if (this.shown == value) {
            return;
        }
        this.shown = value;
        if (value) {
            this.recreateBufferIfNeeded();
        } else {
            this.buffer = null;
        }
    }

    @Nullable
    public final BufferedImage getOrCreateBuffer() {
        if (this.buffer == null) {
            this.recreateBufferIfNeeded();
        }
        return this.buffer;
    }

    public final void recreateBufferIfNeeded() {
        BufferedImage oldBufferedImage = this.buffer;
        if (oldBufferedImage != null && oldBufferedImage.getWidth() == this.graphicsConfigurationManager.scaleUp(this.bounds.width) && oldBufferedImage.getHeight() == this.graphicsConfigurationManager.scaleUp(this.bounds.height)) {
            return;
        }
        BufferedImage buffer = new BufferedImage(Math.max(1, this.graphicsConfigurationManager.scaleUp(this.bounds.width)), Math.max(1, this.graphicsConfigurationManager.scaleUp(this.bounds.height)), 1);
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getActiveVisibleScheme();
        if (editorColorsScheme == null) {
            EditorColorsScheme editorColorsScheme2 = EditorColorsManager.getInstance().getSchemeForCurrentUITheme();
            editorColorsScheme = editorColorsScheme2;
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme2, (String)"getSchemeForCurrentUITheme(...)");
        }
        EditorColorsScheme scheme = editorColorsScheme;
        Color color = scheme.getDefaultBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultBackground(...)");
        JcefOffscreenViewPort.Companion.fillBufferedImage(buffer, color);
        if (oldBufferedImage != null) {
            JcefOffscreenViewPort.Companion.copyFromBuffer(oldBufferedImage, buffer);
        }
        this.buffer = buffer;
    }

    public final void setBounds(@NotNull Rectangle newValue) {
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        if (Intrinsics.areEqual((Object)this.bounds, (Object)newValue)) {
            return;
        }
        this.bounds.setRect(newValue);
        if (this.getShown()) {
            this.recreateBufferIfNeeded();
        }
        this.viewPortComponentController.sizeChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void draw(@NotNull Graphics2D graphics) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        BufferedImage bufferedImage = this.buffer;
        if (bufferedImage == null) {
            return;
        }
        BufferedImage buffer = bufferedImage;
        Graphics graphics2 = graphics.create();
        Intrinsics.checkNotNull((Object)graphics2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics2;
        try {
            boolean bl = this.graphicsConfigurationManager.getHiDpi() ? g2.drawImage(buffer, 0, 0, this.graphicsConfigurationManager.scaleDown(buffer.getWidth()), this.graphicsConfigurationManager.scaleDown(buffer.getHeight()), null) : g2.drawImage((Image)buffer, 0, 0, null);
        }
        finally {
            g2.dispose();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffscreenViewPort$Companion;", "", "<init>", "()V", "fillBufferedImage", "", "buffer", "Ljava/awt/image/BufferedImage;", "color", "Ljava/awt/Color;", "copyFromBuffer", "sourceBuffer", "targetBuffer", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void fillBufferedImage(BufferedImage buffer, Color color) {
            Graphics g = buffer.getGraphics().create();
            try {
                g.setColor(color);
                g.fillRect(0, 0, buffer.getWidth(), buffer.getHeight());
            }
            finally {
                g.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void copyFromBuffer(BufferedImage sourceBuffer, BufferedImage targetBuffer) {
            Graphics g = targetBuffer.getGraphics().create();
            try {
                g.drawImage(sourceBuffer, 0, 0, null);
            }
            finally {
                g.dispose();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

