/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.option;

import com.google.common.collect.ImmutableList;
import com.intellij.lang.javascript.linter.option.Option;
import com.intellij.lang.javascript.linter.option.OptionEnumVariant;
import com.intellij.lang.javascript.linter.option.OptionType;
import com.intellij.lang.javascript.linter.option.OptionTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionEnumType
implements OptionType<Object> {
    private final List<OptionEnumVariant> myVariants;
    private final Map<String, OptionEnumVariant> myVariantByValueStr;

    public OptionEnumType(@NotNull List<OptionEnumVariant> variants) {
        if (variants == null) {
            OptionEnumType.$$$reportNull$$$0(0);
        }
        this.myVariants = ImmutableList.copyOf(variants);
        this.myVariantByValueStr = ContainerUtil.newMapFromValues(variants.iterator(), o -> o.getValue().toString());
    }

    @NotNull
    public List<OptionEnumVariant> getVariants() {
        List<OptionEnumVariant> list = this.myVariants;
        if (list == null) {
            OptionEnumType.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @Nullable
    public Object fromString(@NotNull String valueStr) {
        OptionEnumVariant variant;
        if (valueStr == null) {
            OptionEnumType.$$$reportNull$$$0(2);
        }
        return (variant = this.myVariantByValueStr.get(StringUtil.stripQuotesAroundValue((String)valueStr))) == null ? null : variant.getValue();
    }

    @Override
    public boolean isValidValue(@NotNull Object value) {
        OptionEnumVariant variant;
        if (value == null) {
            OptionEnumType.$$$reportNull$$$0(3);
        }
        return (variant = this.getVariantByValue(value)) != null;
    }

    @Nullable
    public OptionEnumVariant getVariantByValue(@Nullable Object value) {
        for (OptionEnumVariant variant : this.myVariants) {
            if (!variant.getValue().equals(value)) continue;
            return variant;
        }
        return null;
    }

    public String toString() {
        List values = ContainerUtil.map(this.myVariants, variant -> variant.toString());
        return "enum (" + StringUtil.join((Collection)values, (String)",") + ")";
    }

    @NotNull
    public static OptionEnumVariant findVariantByValueOrFail(@NotNull Option option, @Nullable Object value) {
        if (option == null) {
            OptionEnumType.$$$reportNull$$$0(4);
        }
        if (!OptionTypes.isEnumOption(option)) {
            throw new RuntimeException("Option " + option + " has " + option.getType() + " type, but enum type was expected.");
        }
        OptionEnumType enumType = OptionTypes.getOptionEnumType(option);
        OptionEnumVariant variant = enumType.getVariantByValue(value);
        if (variant == null) {
            throw new RuntimeException("[option '" + option.getKey() + "'] Enum variant not found for " + value);
        }
        OptionEnumVariant optionEnumVariant = variant;
        if (optionEnumVariant == null) {
            OptionEnumType.$$$reportNull$$$0(5);
        }
        return optionEnumVariant;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/option/OptionEnumType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueStr";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/option/OptionEnumType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findVariantByValueOrFail";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findVariantByValueOrFail";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5 -> new IllegalStateException(string);
        };
    }
}

