/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections.quickfixes;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/angular2/inspections/quickfixes/CreateAttributeQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "myAttributeName", "", "<init>", "(Ljava/lang/String;)V", "getName", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "preferNoValue", "", "tag", "Lcom/intellij/psi/xml/XmlTag;", "attributeDescriptor", "Lcom/intellij/xml/XmlAttributeDescriptor;", "intellij.angular"})
@SourceDebugExtension(value={"SMAP\nCreateAttributeQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateAttributeQuickFix.kt\norg/angular2/inspections/quickfixes/CreateAttributeQuickFix\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,62:1\n67#2:63\n12574#3,2:64\n*S KotlinDebug\n*F\n+ 1 CreateAttributeQuickFix.kt\norg/angular2/inspections/quickfixes/CreateAttributeQuickFix\n*L\n30#1:63\n59#1:64,2\n*E\n"})
public final class CreateAttributeQuickFix
implements LocalQuickFix {
    @NotNull
    private final String myAttributeName;

    public CreateAttributeQuickFix(@NotNull String myAttributeName) {
        Intrinsics.checkNotNullParameter((Object)myAttributeName, (String)"myAttributeName");
        this.myAttributeName = myAttributeName;
    }

    @Nls
    @NotNull
    public String getName() {
        Object[] objectArray = new Object[]{this.myAttributeName};
        return Angular2Bundle.Companion.message("angular.quickfix.template.create-attribute.name", objectArray);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return Angular2Bundle.Companion.message("angular.quickfix.template.create-attribute.family", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        XmlAttributeValue value;
        XmlAttribute attribute;
        void $this$parentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
        PsiElement psiElement2 = psiElement;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, XmlTag.class, (boolean)false);
        if (tag == null || tag.getAttribute(this.myAttributeName) != null) {
            return;
        }
        XmlElementDescriptor xmlElementDescriptor = tag.getDescriptor();
        XmlAttributeDescriptor attributeDescriptor = xmlElementDescriptor != null ? xmlElementDescriptor.getAttributeDescriptor(this.myAttributeName, tag) : null;
        boolean insertQuotes = WebEditorOptions.getInstance().isInsertQuotesForAttributeValue() && !this.preferNoValue(tag, attributeDescriptor);
        XmlAttribute xmlAttribute = attribute = tag.setAttribute(this.myAttributeName, "");
        Object object = value = xmlAttribute != null ? xmlAttribute.getValueElement() : null;
        if (value != null) {
            if (!insertQuotes) {
                value.getPrevSibling().delete();
                value.delete();
            } else {
                VirtualFile virtualFile = attribute.getContainingFile().getVirtualFile();
                if (virtualFile == null) {
                    return;
                }
                PsiNavigationSupport.getInstance().createNavigatable(project, virtualFile, value.getTextRange().getStartOffset() + 1).navigate(true);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean preferNoValue(XmlTag tag, XmlAttributeDescriptor attributeDescriptor) {
        if (!(tag instanceof HtmlTag)) return false;
        if (attributeDescriptor == null) return false;
        if (!HtmlUtil.isShortNotationOfBooleanAttributePreferred()) return false;
        if (HtmlUtil.isBooleanAttribute((XmlAttributeDescriptor)attributeDescriptor, (PsiElement)((PsiElement)tag))) return true;
        if (!attributeDescriptor.isEnumerated()) return false;
        String[] stringArray = attributeDescriptor.getEnumeratedValues();
        if (stringArray == null) return false;
        String[] $this$any$iv = stringArray;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            String element$iv;
            String it = element$iv = $this$any$iv[n];
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (((CharSequence)it).length() == 0) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

