/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.preferences;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;

public final class TextMateTextAttributes {
    private final String foreground;
    private final String background;
    private final FontStyle fontStyle;

    public TextMateTextAttributes(@Nullable String foreground, @Nullable String background, @NotNull FontStyle style) {
        if (style == null) {
            TextMateTextAttributes.$$$reportNull$$$0(0);
        }
        this.foreground = foreground;
        this.background = background;
        this.fontStyle = style;
    }

    @Nullable
    public String getForeground() {
        return this.foreground;
    }

    @Nullable
    public String getBackground() {
        return this.background;
    }

    @NotNull
    public FontStyle getFontStyle() {
        FontStyle fontStyle = this.fontStyle;
        if (fontStyle == null) {
            TextMateTextAttributes.$$$reportNull$$$0(1);
        }
        return fontStyle;
    }

    @Nullable
    public static TextMateTextAttributes fromPlist(@NotNull Plist settingsPlist) {
        if (settingsPlist == null) {
            TextMateTextAttributes.$$$reportNull$$$0(2);
        }
        boolean empty = true;
        String foreground = null;
        String background = null;
        FontStyle fontStyle = FontStyle.PLAIN;
        for (Map.Entry<String, PListValue> entry : settingsPlist.entries()) {
            String propertyName = entry.getKey();
            String value = entry.getValue().getString();
            if ("foreground".equalsIgnoreCase(propertyName)) {
                foreground = value;
                empty = false;
                continue;
            }
            if ("fontStyle".equalsIgnoreCase(propertyName)) {
                if ("italic".equalsIgnoreCase(value)) {
                    fontStyle = FontStyle.ITALIC;
                    empty = false;
                    continue;
                }
                if ("bold".equalsIgnoreCase(value)) {
                    fontStyle = FontStyle.BOLD;
                    empty = false;
                    continue;
                }
                if ("underline".equalsIgnoreCase(value)) {
                    fontStyle = FontStyle.UNDERLINE;
                    empty = false;
                    continue;
                }
                fontStyle = FontStyle.PLAIN;
                empty = false;
                continue;
            }
            if (!"background".equalsIgnoreCase(propertyName)) continue;
            background = value;
            empty = false;
        }
        return empty ? null : new TextMateTextAttributes(foreground, background, fontStyle);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/preferences/TextMateTextAttributes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsPlist";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/preferences/TextMateTextAttributes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontStyle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromPlist";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static enum FontStyle {
        PLAIN,
        ITALIC,
        BOLD,
        UNDERLINE;

    }
}

