/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.mime;

import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.icons.AllIcons;
import com.intellij.microservices.MicroservicesBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.awt.RelativePoint;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0006H\u0016J\b\u0010\u001b\u001a\u00020\bH\u0016J\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u001f\u001a\u00020\u001dH\u0016J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u001dH\u0016J\u0013\u0010\"\u001a\u00020\u001d2\b\u0010#\u001a\u0004\u0018\u00010$H\u0096\u0002J\b\u0010%\u001a\u00020&H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/microservices/mime/MimeTypePsiElement;", "Lcom/intellij/psi/impl/FakePsiElement;", "Lcom/intellij/psi/SyntheticElement;", "Lcom/intellij/psi/meta/PsiMetaOwner;", "Lcom/intellij/psi/meta/PsiPresentableMetaData;", "parent", "Lcom/intellij/psi/PsiElement;", "mimeTypeName", "", "MimeTypePsiElement", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;)V", "getName", "getParent", "context", "getDeclaration", "getUseScope", "Lcom/intellij/psi/search/SearchScope;", "getResolveScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "init", "", "element", "getIcon", "Ljavax/swing/Icon;", "getMetaData", "Lcom/intellij/psi/meta/PsiMetaData;", "getNavigationElement", "getTypeName", "isEquivalentTo", "", "another", "canNavigate", "navigate", "requestFocus", "equals", "other", "", "hashCode", "", "intellij.microservices"})
public final class MimeTypePsiElement
extends FakePsiElement
implements SyntheticElement,
PsiMetaOwner,
PsiPresentableMetaData {
    @NotNull
    private final PsiElement parent;
    @NotNull
    private final String mimeTypeName;

    public MimeTypePsiElement(@NotNull PsiElement parent, @NotNull String mimeTypeName) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)mimeTypeName, (String)"mimeTypeName");
        this.parent = parent;
        this.mimeTypeName = mimeTypeName;
    }

    @NotNull
    public String getName() {
        return this.mimeTypeName;
    }

    @NotNull
    public PsiElement getParent() {
        return this.parent;
    }

    @NotNull
    public String getName(@NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getName();
    }

    @NotNull
    public PsiElement getDeclaration() {
        return (PsiElement)this;
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        return (SearchScope)globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        return globalSearchScope;
    }

    public void init(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Nodes.Type;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Type");
        return icon;
    }

    @NotNull
    public PsiMetaData getMetaData() {
        return (PsiMetaData)this;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        return (PsiElement)this;
    }

    @NotNull
    public String getTypeName() {
        return MicroservicesBundle.message("mime.type.element", new Object[0]);
    }

    public boolean isEquivalentTo(@Nullable PsiElement another) {
        return another instanceof MimeTypePsiElement && Intrinsics.areEqual((Object)((MimeTypePsiElement)another).mimeTypeName, (Object)this.mimeTypeName);
    }

    public boolean canNavigate() {
        return true;
    }

    public void navigate(boolean requestFocus) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.getInstance(project).isDumb()) {
            return;
        }
        Editor editor = FileEditorManager.getInstance((Project)this.getProject()).getSelectedTextEditor();
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(editor2);
        Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"guessBestPopupLocation(...)");
        RelativePoint relativePoint2 = relativePoint;
        ShowUsagesAction.startFindUsages((PsiElement)((PsiElement)this), (RelativePoint)relativePoint2, (Editor)editor2);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.microservices.mime.MimeTypePsiElement");
        MimeTypePsiElement cfr_ignored_0 = (MimeTypePsiElement)((Object)other);
        return Intrinsics.areEqual((Object)this.mimeTypeName, (Object)((MimeTypePsiElement)((Object)other)).mimeTypeName);
    }

    public int hashCode() {
        return this.mimeTypeName.hashCode();
    }
}

