/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.callusage;

import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.CommonProfilerUISettings;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.HtmlWrappingValueMetricPrinter;
import com.intellij.profiler.api.ValueMetric;
import com.intellij.profiler.api.ValueMetricPrinter;
import com.intellij.profiler.api.ValueMetricPrinterWithUnits;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.model.CallWithValue;
import com.intellij.profiler.ui.BaseCallStackElementRenderer;
import com.intellij.profiler.ui.callusage.UIVisibleCallTreeNode;
import com.intellij.profiler.ui.callusage.UIVisibleCallTreeNodeInfo;
import com.intellij.profiler.ui.flamechart.ColorType;
import com.intellij.profiler.ui.flamechart.FlameChartColorScheme;
import com.intellij.profiler.ui.flamechart.FlameChartColors;
import com.intellij.profiler.ui.flamegraph.CallUsageNodeFlameGraphModel;
import com.intellij.profiler.ui.flamegraph.DefaultFlameGraphRenderer;
import com.intellij.profiler.ui.flamegraph.FlameGraphModel;
import com.intellij.profiler.ui.flamegraph.FlameGraphNode;
import com.intellij.profiler.ui.flamegraph.FlameGraphPanel;
import com.intellij.profiler.ui.flamegraph.FlameGraphTooltipColors;
import com.intellij.profiler.ui.flamegraph.GroupRootFlameGraphNode;
import com.intellij.profiler.ui.grouping.FoldingNodesGroup;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0010\u0018\u0000 V2\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u0001:\u0003TUVB\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ4\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0016\u0010\u001b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u001c2\u0010\u0010\u001d\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004H\u0017J(\u0010\u001e\u001a\u00020\u001f2\u0016\u0010 \u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040!2\u0006\u0010\"\u001a\u00020#H\u0016JH\u0010$\u001a\u00020\u001f2\u0016\u0010 \u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040!2\u0006\u0010\"\u001a\u00020#2\u0016\u0010%\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040&2\u0006\u0010'\u001a\u00020(H\u0014J?\u0010)\u001a\u0004\u0018\u00010\u00142\u0006\u0010\"\u001a\u00020#2\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u00142\u0006\u0010/\u001a\u000200H\u0002\u00a2\u0006\u0002\u00101J8\u00102\u001a\u0004\u0018\u0001002\u0016\u0010\u001d\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040&2\u0014\u00103\u001a\u0010\u0012\u0004\u0012\u000205\u0012\u0006\u0012\u0004\u0018\u00010004H\u0014J\u001c\u00106\u001a\u000200*\u0004\u0018\u0001002\f\u00107\u001a\b\u0012\u0004\u0012\u00020008H\u0002J2\u00109\u001a\u0004\u0018\u00010\u001a2\u0016\u0010\u001b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u001c2\u0010\u0010\u001d\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004J\u0015\u00109\u001a\u00070\u001a\u00a2\u0006\u0002\b:2\u0006\u0010;\u001a\u00020<H\u0014J2\u0010=\u001a\u0004\u0018\u00010>2\u0016\u0010\u001b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u001c2\u0010\u0010\u001d\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004J\u0010\u0010?\u001a\u00020>2\u0006\u0010@\u001a\u00020\u0003H\u0002J\u0010\u0010A\u001a\u00020>2\u0006\u0010;\u001a\u00020<H\u0016J8\u0010B\u001a\u0002002\u0016\u0010 \u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040!2\u0016\u0010%\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040&H\u0014J8\u0010C\u001a\u00020D2\u0016\u0010 \u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040!2\u0016\u0010%\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040&H\u0004J8\u0010E\u001a\u00020\u000e2\u0016\u0010 \u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040!2\u0016\u0010\u001d\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040&H\u0002J:\u0010F\u001a\u0004\u0018\u0001002\u0016\u0010 \u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040!2\u0016\u0010%\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040&H\u0014J8\u0010G\u001a\u00020H2\u0016\u0010 \u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040!2\u0016\u0010%\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040&H\u0002J8\u0010I\u001a\u00020H2\u0016\u0010 \u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040!2\u0016\u0010%\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040&H\u0004J8\u0010J\u001a\u00020D2\u0016\u0010 \u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040!2\u0016\u0010%\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040&H\u0002J\u0015\u0010K\u001a\u00020L2\u000b\u0010M\u001a\u00070\u001a\u00a2\u0006\u0002\bNH\u0004J-\u0010O\u001a\u0002HP\"\b\b\u0000\u0010P*\u00020>2\u0006\u0010Q\u001a\u00020\u00142\f\u00107\u001a\b\u0012\u0004\u0012\u0002HP08H\u0002\u00a2\u0006\u0002\u0010RJ\u0011\u0010S\u001a\u00070\u001a\u00a2\u0006\u0002\b:*\u00020\u001aH\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lcom/intellij/profiler/ui/callusage/FlameChartColorsRenderer;", "Lcom/intellij/profiler/ui/flamegraph/DefaultFlameGraphRenderer;", "Lcom/intellij/profiler/model/CallTreeNode;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Lcom/intellij/profiler/ui/callusage/CallUsageNode;", "baseRenderer", "Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "<init>", "(Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;Lcom/intellij/profiler/api/ValueMetric;)V", "getMetric", "()Lcom/intellij/profiler/api/ValueMetric;", "filterValue", "", "getFilterValue", "()D", "setFilterValue", "(D)V", "ellipsisStringWidth", "", "metricPrinter", "Lcom/intellij/profiler/api/ValueMetricPrinterWithUnits;", "htmlMetricPrinter", "Lcom/intellij/profiler/api/ValueMetricPrinter;", "getDisplayableText", "", "model", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphModel;", "node", "beforePaint", "", "component", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;", "g", "Ljava/awt/Graphics2D;", "paintText", "bounds", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphNode;", "realShape", "Ljava/awt/geom/RectangularShape;", "drawAdditionalString", "str", "r", "Ljava/awt/Rectangle;", "offsetX", "offsetY", "color", "Ljava/awt/Color;", "(Ljava/awt/Graphics2D;Ljava/lang/String;Ljava/awt/Rectangle;IILjava/awt/Color;)Ljava/lang/Integer;", "getColor", "colorFunction", "Lkotlin/Function1;", "Lcom/intellij/profiler/ui/flamechart/FlameChartColorScheme;", "orDefault", "producer", "Lkotlin/Function0;", "getTooltipText", "Lorg/jetbrains/annotations/Nls;", "uiInfo", "Lcom/intellij/profiler/ui/callusage/UIVisibleCallTreeNodeInfo;", "getTooltipComponent", "Ljavax/swing/JComponent;", "createFrameMainInfoComponent", "call", "createFrameMetricsComponent", "getBackgroundColor", "shouldBeFilteredOut", "", "fractionOfAllCallsForGraphNode", "getBorderColor", "foregroundType", "Lcom/intellij/profiler/ui/flamechart/ColorType;", "backgroundType", "isShadowed", "label", "Lcom/intellij/ui/components/JBLabel;", "text", "Lcom/intellij/openapi/util/NlsContexts$Label;", "componentWithBorder", "T", "rightBorder", "(ILkotlin/jvm/functions/Function0;)Ljavax/swing/JComponent;", "toHtml", "HtmlValueMetricPrinter", "FractionBar", "Companion", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nFlameChartColorsRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlameChartColorsRenderer.kt\ncom/intellij/profiler/ui/callusage/FlameChartColorsRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,316:1\n1#2:317\n*E\n"})
public class FlameChartColorsRenderer
extends DefaultFlameGraphRenderer<CallTreeNode<? extends BaseCallStackElement>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BaseCallStackElementRenderer baseRenderer;
    @NotNull
    private final ValueMetric metric;
    private double filterValue;
    private int ellipsisStringWidth;
    @NotNull
    private final ValueMetricPrinterWithUnits metricPrinter;
    @NotNull
    private final ValueMetricPrinter htmlMetricPrinter;
    @NotNull
    private static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private static final int VERTICAL_GAP = 6;

    public FlameChartColorsRenderer(@NotNull BaseCallStackElementRenderer baseRenderer, @NotNull ValueMetric metric) {
        Intrinsics.checkNotNullParameter((Object)baseRenderer, (String)"baseRenderer");
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.baseRenderer = baseRenderer;
        this.metric = metric;
        this.metricPrinter = new ValueMetricPrinterWithUnits(ValueMetricPrinter.Default.INSTANCE);
        this.htmlMetricPrinter = new HtmlWrappingValueMetricPrinter(new ValueMetricPrinterWithUnits(new HtmlValueMetricPrinter()));
    }

    @NotNull
    protected final ValueMetric getMetric() {
        return this.metric;
    }

    public final double getFilterValue() {
        return this.filterValue;
    }

    public final void setFilterValue(double d) {
        this.filterValue = d;
    }

    @Override
    @Nls
    @Nullable
    public String getDisplayableText(@NotNull FlameGraphModel<CallTreeNode<BaseCallStackElement>> model2, @NotNull CallTreeNode<? extends BaseCallStackElement> node) {
        String string;
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Object object = (CallWithValue)node.getData();
        if (object != null && (object = (BaseCallStackElement)object.getCall()) != null) {
            Object object2 = object;
            BaseCallStackElementRenderer baseCallStackElementRenderer = this.baseRenderer;
            Object p0 = object2;
            boolean $i$f$getDisplayableText$stub_for_inlining = false;
            boolean bl = false;
            string = baseCallStackElementRenderer.getText((BaseCallStackElement)p0);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    public void beforePaint(@NotNull FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component, @NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.beforePaint(component, g);
        this.ellipsisStringWidth = g.getFontMetrics().stringWidth("...");
    }

    @Override
    protected void paintText(@NotNull FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component, @NotNull Graphics2D g, @NotNull FlameGraphNode<CallTreeNode<BaseCallStackElement>> bounds, @NotNull RectangularShape realShape) {
        boolean shouldDrawContent;
        Object object;
        Rectangle r;
        int y;
        int x;
        int contentStart;
        BaseCallStackElement callStackElement;
        int boundsHeight;
        block15: {
            block14: {
                Intrinsics.checkNotNullParameter(component, (String)"component");
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter(bounds, (String)"bounds");
                Intrinsics.checkNotNullParameter((Object)realShape, (String)"realShape");
                int boundsWidth = FlameGraphPanel.calculateWidth$default(component, bounds, 0, 2, null);
                boundsHeight = component.calculateHeight(bounds);
                if (boundsWidth < this.ellipsisStringWidth) {
                    return;
                }
                ColorType foregroundType = this.foregroundType(component, bounds);
                g.setColor(this.shouldBeFilteredOut(component, bounds) ? (Color)FlameChartColors.PALE.INSTANCE.color(foregroundType) : this.orDefault(this.getColor(bounds, (Function1<? super FlameChartColorScheme, ? extends Color>)((Function1)arg_0 -> FlameChartColorsRenderer.paintText$lambda$0(foregroundType, arg_0))), (Function0<? extends Color>)((Function0)() -> FlameChartColorsRenderer.paintText$lambda$1(foregroundType))));
                CallWithValue callWithValue = (CallWithValue)bounds.getContent().getData();
                BaseCallStackElement baseCallStackElement = callStackElement = callWithValue != null ? (BaseCallStackElement)callWithValue.getCall() : null;
                if (component.getSearchResultNode() == bounds) {
                    g.setFont(g.getFont().deriveFont(1));
                }
                FontMetrics fm = g.getFontMetrics(g.getFont());
                x = contentStart = (((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getFlameGraphState().getStickyText() ? g.getClipBounds().x + 1 : 0) + 6;
                y = boundsHeight / 2 + fm.getAscent() * 2 / 5;
                if (bounds instanceof GroupRootFlameGraphNode) {
                    x += ((GroupRootFlameGraphNode)bounds).getIconWidth() + 4;
                }
                r = new Rectangle(x, y, boundsWidth - x, component.getHeight());
                object = callStackElement;
                if (object == null) break block14;
                BaseCallStackElement it = object;
                boolean bl = false;
                Rectangle2D rectangle2D = r;
                FontMetrics fontMetrics = g.getFontMetrics();
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
                String string = this.baseRenderer.fillTextInsideNode(it, rectangle2D, fontMetrics);
                object = string;
                if (string != null) break block15;
            }
            object = bounds.getDepth() <= 1 ? "all" : "";
        }
        Object str = object;
        g.clip(realShape);
        g.drawString((String)str, x, y);
        boolean bl = shouldDrawContent = !StringsKt.isBlank((CharSequence)((CharSequence)str)) && ((String)str).length() >= 3;
        if (bounds instanceof GroupRootFlameGraphNode) {
            ((GroupRootFlameGraphNode)bounds).setIconVisible(shouldDrawContent);
        }
        if (shouldDrawContent) {
            String comment;
            int offset = x + g.getFontMetrics().stringWidth((String)str);
            if (bounds instanceof GroupRootFlameGraphNode) {
                ((GroupRootFlameGraphNode)bounds).drawIcon(component, g, contentStart, boundsHeight);
                if (((GroupRootFlameGraphNode)bounds).getGroup().isFolded()) {
                    Object object2 = ((GroupRootFlameGraphNode)bounds).getContent();
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.profiler.ui.grouping.FoldingNodesGroup<*>");
                    String string = ((FoldingNodesGroup)object2).getExpandLabelText();
                    Color color = g.getColor();
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getColor(...)");
                    Integer stringWidth = this.drawAdditionalString(g, string, r, offset + 5, y, color);
                    if (stringWidth != null) {
                        offset += stringWidth + 5;
                    }
                }
            }
            BaseCallStackElement baseCallStackElement = callStackElement;
            if (baseCallStackElement != null) {
                BaseCallStackElement baseCallStackElement2 = baseCallStackElement;
                BaseCallStackElementRenderer baseCallStackElementRenderer = this.baseRenderer;
                BaseCallStackElement p0 = baseCallStackElement2;
                boolean $i$f$paintText$stub_for_inlining$3 = false;
                boolean bl2 = false;
                v11 = baseCallStackElementRenderer.getCommentInfo(p0);
            } else {
                v11 = comment = null;
            }
            if (comment != null) {
                Color color = g.getColor().brighter().brighter();
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"brighter(...)");
                this.drawAdditionalString(g, comment, r, offset + 5, y, color);
            }
        }
    }

    private final Integer drawAdditionalString(Graphics2D g, String str, Rectangle r, int offsetX, int offsetY, Color color) {
        int width = g.getFontMetrics().stringWidth(str);
        if (offsetX + width < r.width) {
            Color oldColor = g.getColor();
            g.setColor(color);
            g.drawString(str, offsetX, offsetY);
            g.setColor(oldColor);
            return width;
        }
        return null;
    }

    @Nullable
    protected Color getColor(@NotNull FlameGraphNode<CallTreeNode<BaseCallStackElement>> node, @NotNull Function1<? super FlameChartColorScheme, ? extends Color> colorFunction) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Intrinsics.checkNotNullParameter(colorFunction, (String)"colorFunction");
        CallWithValue data = (CallWithValue)node.getContent().getData();
        if (data == null) {
            return (Color)colorFunction.invoke((Object)this.baseRenderer.getRootColorScheme());
        }
        return (Color)colorFunction.invoke((Object)this.baseRenderer.getColorScheme((BaseCallStackElement)data.getCall()));
    }

    private final Color orDefault(Color $this$orDefault, Function0<? extends Color> producer) {
        Color color = $this$orDefault;
        if (color == null) {
            color = (Color)producer.invoke();
        }
        return color;
    }

    @Override
    @Nullable
    public final String getTooltipText(@NotNull FlameGraphModel<CallTreeNode<BaseCallStackElement>> model2, @NotNull CallTreeNode<? extends BaseCallStackElement> node) {
        String string;
        HtmlChunk[] htmlChunkArray;
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        String string2 = this.getDisplayableText(model2, node);
        if (string2 == null) {
            return null;
        }
        String text = string2;
        HtmlChunk[] htmlChunkArray2 = (HtmlChunk[])node.getData();
        if (htmlChunkArray2 != null && (htmlChunkArray2 = (HtmlChunk[])htmlChunkArray2.getCall()) != null) {
            htmlChunkArray = htmlChunkArray2;
            BaseCallStackElementRenderer baseCallStackElementRenderer = this.baseRenderer;
            HtmlChunk[] p0 = htmlChunkArray;
            boolean $i$f$getTooltipText$stub_for_inlining$4 = false;
            boolean bl = false;
            string = baseCallStackElementRenderer.getCommentInfo((BaseCallStackElement)p0);
        } else {
            string = null;
        }
        String comment = string;
        UIVisibleCallTreeNode<? extends BaseCallStackElement> uiVisibleNode = ((CallUsageNodeFlameGraphModel)model2).getUIVisibleNode(node);
        HtmlChunk.Element element = HtmlChunk.div().child((HtmlChunk)HtmlChunk.text((String)text).bold());
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"child(...)");
        HtmlChunk.Element firstLine = element;
        if (comment != null) {
            htmlChunkArray = new HtmlChunk[]{HtmlChunk.nbsp((int)2), HtmlChunk.text((String)comment)};
            firstLine = firstLine.children(htmlChunkArray);
        }
        return new HtmlBuilder().append((HtmlChunk)firstLine).append((HtmlChunk)HtmlChunk.div().addText(this.getTooltipText(uiVisibleNode.getUiInfo()))).wrapWithHtmlBody().toString();
    }

    @NotNull
    protected String getTooltipText(@NotNull UIVisibleCallTreeNodeInfo uiInfo) {
        Intrinsics.checkNotNullParameter((Object)uiInfo, (String)"uiInfo");
        Object[] objectArray = new Object[]{this.metricPrinter.print(this.metric, uiInfo.getValue()), Float.valueOf((float)((int)(uiInfo.getFractionOfParentCall().asDouble() * (double)10000)) / 100.0f), Float.valueOf((float)((int)(uiInfo.getFractionOfAllCalls().asDouble() * (double)10000)) / 100.0f)};
        return CommonProfilerBundleKt.profilerMessage("ui.flamechart.tooltip.parentAndAll", objectArray);
    }

    @Override
    @Nullable
    public final JComponent getTooltipComponent(@NotNull FlameGraphModel<CallTreeNode<BaseCallStackElement>> model2, @NotNull CallTreeNode<? extends BaseCallStackElement> node) {
        FoldingNodesGroup group2;
        BorderLayoutPanel borderLayoutPanel;
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Object object = (CallWithValue)node.getData();
        if (object == null || (object = (BaseCallStackElement)object.getCall()) == null) {
            return null;
        }
        Object call = object;
        BorderLayoutPanel $this$getTooltipComponent_u24lambda_u245 = borderLayoutPanel = new BorderLayoutPanel(0, 8);
        boolean bl = false;
        $this$getTooltipComponent_u24lambda_u245.addToTop((Component)this.createFrameMainInfoComponent((BaseCallStackElement)call));
        $this$getTooltipComponent_u24lambda_u245.addToCenter((Component)this.createFrameMetricsComponent(((CallUsageNodeFlameGraphModel)model2).getUIVisibleNode(node).getUiInfo()));
        BorderLayoutPanel result2 = borderLayoutPanel;
        FoldingNodesGroup foldingNodesGroup = group2 = node instanceof FoldingNodesGroup ? (FoldingNodesGroup)node : null;
        if (group2 != null) {
            Object[] objectArray = new Object[]{group2.getSize()};
            Object[] $this$getTooltipComponent_u24lambda_u246 = objectArray = new JBLabel(CommonProfilerBundleKt.profilerMessage("ui.flamechart.tooltip.calls.grouped", objectArray));
            boolean bl2 = false;
            $this$getTooltipComponent_u24lambda_u246.setFont((Font)JBFont.medium());
            $this$getTooltipComponent_u24lambda_u246.setForeground(JBUI.CurrentTheme.ContextHelp.FOREGROUND);
            Object[] groupLabel = objectArray;
            result2.addToBottom((Component)groupLabel);
        }
        return (JComponent)result2;
    }

    private final JComponent createFrameMainInfoComponent(BaseCallStackElement call) {
        SimpleColoredComponent simpleColoredComponent;
        SimpleColoredComponent $this$createFrameMainInfoComponent_u24lambda_u247 = simpleColoredComponent = new SimpleColoredComponent();
        boolean bl = false;
        $this$createFrameMainInfoComponent_u24lambda_u247.setMyBorder(null);
        $this$createFrameMainInfoComponent_u24lambda_u247.setIpad((Insets)JBInsets.emptyInsets());
        $this$createFrameMainInfoComponent_u24lambda_u247.append(this.baseRenderer.getText(call));
        String comment = this.baseRenderer.getCommentInfo(call);
        if (comment != null) {
            $this$createFrameMainInfoComponent_u24lambda_u247.append("  ");
            $this$createFrameMainInfoComponent_u24lambda_u247.append(comment, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        return (JComponent)simpleColoredComponent;
    }

    @NotNull
    public JComponent createFrameMetricsComponent(@NotNull UIVisibleCallTreeNodeInfo uiInfo) {
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)uiInfo, (String)"uiInfo");
        JPanel $this$createFrameMetricsComponent_u24lambda_u2413 = jPanel = new JPanel(new FlowLayout(0, 0, 0));
        boolean bl = false;
        double fractionOfAllCalls = uiInfo.getFractionOfAllCalls().asDouble();
        float fractionOfAll = (float)((int)(fractionOfAllCalls * (double)10000)) / 100.0f;
        Object t = this.componentWithBorder(16, FlameChartColorsRenderer::createFrameMetricsComponent$lambda$13$lambda$8);
        BorderLayoutPanel $this$createFrameMetricsComponent_u24lambda_u2413_u24lambda_u2410 = (BorderLayoutPanel)t;
        boolean bl2 = false;
        $this$createFrameMetricsComponent_u24lambda_u2413_u24lambda_u2410.addToCenter((Component)((Object)new FractionBar((JBLabel)this.componentWithBorder(0, () -> FlameChartColorsRenderer.createFrameMetricsComponent$lambda$13$lambda$10$lambda$9(this, fractionOfAll)), fractionOfAllCalls)));
        BorderLayoutPanel fractionBar = (BorderLayoutPanel)t;
        $this$createFrameMetricsComponent_u24lambda_u2413.add((Component)fractionBar);
        $this$createFrameMetricsComponent_u24lambda_u2413.add((Component)this.componentWithBorder(16, () -> FlameChartColorsRenderer.createFrameMetricsComponent$lambda$13$lambda$11(this, uiInfo)));
        $this$createFrameMetricsComponent_u24lambda_u2413.add((Component)this.componentWithBorder(0, () -> FlameChartColorsRenderer.createFrameMetricsComponent$lambda$13$lambda$12(this, uiInfo)));
        return jPanel;
    }

    @Override
    @NotNull
    protected Color getBackgroundColor(@NotNull FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component, @NotNull FlameGraphNode<CallTreeNode<BaseCallStackElement>> bounds) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter(bounds, (String)"bounds");
        ColorType backgroundType = this.backgroundType(component, bounds);
        return this.shouldBeFilteredOut(component, bounds) ? (Color)FlameChartColors.PALE.INSTANCE.color(backgroundType) : this.orDefault(this.getColor(bounds, (Function1<? super FlameChartColorScheme, ? extends Color>)((Function1)arg_0 -> FlameChartColorsRenderer.getBackgroundColor$lambda$14(backgroundType, arg_0))), (Function0<? extends Color>)((Function0)() -> FlameChartColorsRenderer.getBackgroundColor$lambda$15(backgroundType)));
    }

    protected final boolean shouldBeFilteredOut(@NotNull FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component, @NotNull FlameGraphNode<CallTreeNode<BaseCallStackElement>> bounds) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter(bounds, (String)"bounds");
        return this.filterValue > 0.0 && this.fractionOfAllCallsForGraphNode(component, bounds) <= this.filterValue;
    }

    private final double fractionOfAllCallsForGraphNode(FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component, FlameGraphNode<CallTreeNode<BaseCallStackElement>> node) {
        FlameGraphModel<CallTreeNode<BaseCallStackElement>> flameGraphModel = component.getModel();
        Intrinsics.checkNotNull(flameGraphModel, (String)"null cannot be cast to non-null type com.intellij.profiler.ui.flamegraph.CallUsageNodeFlameGraphModel<com.intellij.profiler.api.BaseCallStackElement>");
        UIVisibleCallTreeNode<BaseCallStackElement> uiVisibleNode = ((CallUsageNodeFlameGraphModel)flameGraphModel).getUIVisibleNode(node.getContent());
        return uiVisibleNode.getFractionOfAllCallsDouble();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    protected Color getBorderColor(@NotNull FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component, @NotNull FlameGraphNode<CallTreeNode<BaseCallStackElement>> bounds) {
        Color color;
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter(bounds, (String)"bounds");
        Color color2 = this.getColor(bounds, (Function1<? super FlameChartColorScheme, ? extends Color>)((Function1)arg_0 -> FlameChartColorsRenderer.getBorderColor$lambda$16(component, bounds, arg_0)));
        if (color2 != null) {
            Color color3;
            Color color4;
            Color it = color4 = color2;
            boolean bl = false;
            Color color5 = color3 = it != TRANSPARENT ? color4 : null;
            if (color3 != null) {
                color = color3;
                return color;
            }
        }
        color = super.getBorderColor(component, bounds);
        return color;
    }

    private final ColorType foregroundType(FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component, FlameGraphNode<CallTreeNode<BaseCallStackElement>> bounds) {
        boolean search2 = component.isSearchActive();
        boolean search_ok = search2 && component.isMatchingSearch(bounds);
        return ColorType.Companion.findForegroundType(component.getHighlightedNode() == bounds, this.isShadowed(component, bounds), search2, search_ok);
    }

    @NotNull
    protected final ColorType backgroundType(@NotNull FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component, @NotNull FlameGraphNode<CallTreeNode<BaseCallStackElement>> bounds) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter(bounds, (String)"bounds");
        boolean search2 = component.isSearchActive();
        boolean search_ok = search2 && component.isMatchingSearch(bounds);
        boolean focus = component.getHighlightedNode() == bounds;
        boolean focusGroup = ArraysKt.contains((Object[])component.getHighlightedGroup(), bounds);
        boolean shadow = this.isShadowed(component, bounds);
        return ColorType.Companion.findBackgroundType(search2, search_ok, focus, focusGroup, shadow);
    }

    private final boolean isShadowed(FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component, FlameGraphNode<CallTreeNode<BaseCallStackElement>> bounds) {
        FlameGraphNode<CallTreeNode<BaseCallStackElement>> flameGraphNode = component.getSelectedNode();
        if (flameGraphNode == null) {
            return false;
        }
        FlameGraphNode<CallTreeNode<BaseCallStackElement>> selectedNode = flameGraphNode;
        boolean isDepthIsNotLess = selectedNode.getDepth() <= bounds.getDepth();
        boolean isBoundsAreInIt = bounds.getStart() >= selectedNode.getStart() && bounds.getEnd() <= selectedNode.getEnd();
        return !isDepthIsNotLess || !isBoundsAreInIt;
    }

    @NotNull
    protected final JBLabel label(@NotNull String text) {
        JBLabel jBLabel;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        JBLabel $this$label_u24lambda_u2418 = jBLabel = new JBLabel(text);
        boolean bl = false;
        $this$label_u24lambda_u2418.setForeground((Color)FlameGraphTooltipColors.INSTANCE.getForeground());
        return jBLabel;
    }

    private final <T extends JComponent> T componentWithBorder(int rightBorder, Function0<? extends T> producer) {
        Object object = producer.invoke();
        JComponent $this$componentWithBorder_u24lambda_u2419 = (JComponent)object;
        boolean bl = false;
        $this$componentWithBorder_u24lambda_u2419.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)0, (int)rightBorder));
        return (T)((JComponent)object);
    }

    @NotNull
    protected final String toHtml(@NotNull String $this$toHtml) {
        Intrinsics.checkNotNullParameter((Object)$this$toHtml, (String)"<this>");
        String string = new HtmlBuilder().appendRaw($this$toHtml).wrapWithHtmlBody().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final Color paintText$lambda$0(ColorType $foregroundType, FlameChartColorScheme it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Color)it.color($foregroundType);
    }

    private static final Color paintText$lambda$1(ColorType $foregroundType) {
        return (Color)FlameChartColors.PARENT.INSTANCE.color($foregroundType);
    }

    private static final BorderLayoutPanel createFrameMetricsComponent$lambda$13$lambda$8() {
        return new BorderLayoutPanel();
    }

    private static final JBLabel createFrameMetricsComponent$lambda$13$lambda$10$lambda$9(FlameChartColorsRenderer this$0, float $fractionOfAll) {
        Object[] objectArray = new Object[]{Float.valueOf($fractionOfAll)};
        return this$0.label(this$0.toHtml(CommonProfilerBundleKt.profilerMessage("ui.flamechart.tooltip.all", objectArray)));
    }

    private static final JBLabel createFrameMetricsComponent$lambda$13$lambda$11(FlameChartColorsRenderer this$0, UIVisibleCallTreeNodeInfo $uiInfo) {
        Object[] objectArray = new Object[]{Float.valueOf((float)((int)($uiInfo.getFractionOfParentCall().asDouble() * (double)10000)) / 100.0f)};
        return this$0.label(this$0.toHtml(CommonProfilerBundleKt.profilerMessage("ui.flamechart.tooltip.parent", objectArray)));
    }

    private static final JBLabel createFrameMetricsComponent$lambda$13$lambda$12(FlameChartColorsRenderer this$0, UIVisibleCallTreeNodeInfo $uiInfo) {
        return this$0.label(this$0.htmlMetricPrinter.print(this$0.metric, $uiInfo.getValue()));
    }

    private static final Color getBackgroundColor$lambda$14(ColorType $backgroundType, FlameChartColorScheme it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Color)it.color($backgroundType);
    }

    private static final Color getBackgroundColor$lambda$15(ColorType $backgroundType) {
        return (Color)FlameChartColors.PARENT.INSTANCE.color($backgroundType);
    }

    private static final Color getBorderColor$lambda$16(FlameGraphPanel $component, FlameGraphNode $bounds, FlameChartColorScheme it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ColorType colorType = $component.getSearchResultNode() == $bounds ? ColorType.SEARCH_FOCUSED_BORDER : ColorType.BORDER;
        return (Color)it.color(colorType);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ui/callusage/FlameChartColorsRenderer$Companion;", "", "<init>", "()V", "TRANSPARENT", "Ljava/awt/Color;", "VERTICAL_GAP", "", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/profiler/ui/callusage/FlameChartColorsRenderer$FractionBar;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "label", "Lcom/intellij/ui/components/JBLabel;", "fraction", "", "<init>", "(Lcom/intellij/ui/components/JBLabel;D)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "Companion", "intellij.profiler.common"})
    private static final class FractionBar
    extends BorderLayoutPanel {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final double fraction;
        private static final int SCALE_TOTAL_WIDTH = 100;
        private static final int MIN_SCALE_WIDTH = 3;

        public FractionBar(@NotNull JBLabel label, double fraction) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            this.fraction = fraction;
            this.addToCenter((Component)label);
            this.setBorder((Border)JBUI.Borders.empty((int)3, (int)5, (int)3, (int)0));
            this.setPreferredSize(new Dimension(JBUI.scale((int)100), this.getPreferredSize().height));
        }

        protected void paintComponent(@Nullable Graphics g) {
            super.paintComponent(g);
            Intrinsics.checkNotNull((Object)g, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D g2d = (Graphics2D)g;
            Rectangle clipBounds = g2d.getClipBounds();
            int fractionWidth = Math.max((int)((double)clipBounds.width * this.fraction), JBUI.scale((int)3));
            Color oldColor = g2d.getColor();
            g2d.setColor((Color)FlameGraphTooltipColors.INSTANCE.getScaleColor());
            g2d.fillRect(clipBounds.x, clipBounds.y, fractionWidth, clipBounds.height);
            g2d.setColor((Color)FlameGraphTooltipColors.INSTANCE.getScaleBackground());
            g2d.fillRect(clipBounds.x + fractionWidth, clipBounds.y, clipBounds.width - fractionWidth, clipBounds.height);
            g2d.setColor(oldColor);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profiler/ui/callusage/FlameChartColorsRenderer$FractionBar$Companion;", "", "<init>", "()V", "SCALE_TOTAL_WIDTH", "", "MIN_SCALE_WIDTH", "intellij.profiler.common"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/profiler/ui/callusage/FlameChartColorsRenderer$HtmlValueMetricPrinter;", "Lcom/intellij/profiler/api/ValueMetricPrinter;", "<init>", "()V", "print", "", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "value", "", "intellij.profiler.common"})
    private static final class HtmlValueMetricPrinter
    implements ValueMetricPrinter {
        @Override
        @NotNull
        public String print(@NotNull ValueMetric metric, long value) {
            Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
            String string = ValueMetricPrinter.Default.INSTANCE.print(metric, value);
            return "<b>" + string + "</b>";
        }
    }
}

