/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.sudo;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.profiler.ProcessUtilKt;
import com.intellij.profiler.sudo.ExecSudoCommandKt;
import com.intellij.profiler.sudo.SendResult;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$BX\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0006\u0012#\b\u0002\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001c\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00042\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0016J\b\u0010\u001b\u001a\u00020\bH\u0014J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0006\u0010\u001f\u001a\u00020\bJ\u0018\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0016\u0010\"\u001a\u00020\b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0\u0006H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/profiler/sudo/SudoProcessHandler;", "Lcom/intellij/execution/process/OSProcessHandler;", "commandWithParameters", "", "", "sudoPasswordSupplier", "Lkotlin/Function0;", "onWrongSudoPassword", "", "onCantSendSudoSignal", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "signal", "<init>", "(Ljava/util/List;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "value", "", "wrongSudoPassword", "getWrongSudoPassword", "()Z", "consumeRest", "notifyTextAvailable", "text", "outputType", "Lcom/intellij/openapi/util/Key;", "doDestroyProcess", "killSudoProcessTree", "process", "Ljava/lang/Process;", "sendSIGINT", "notifyIfCant", "result", "runSyncIfTestOtherwiseExecute", "body", "Companion", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nSudoProcessHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SudoProcessHandler.kt\ncom/intellij/profiler/sudo/SudoProcessHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,83:1\n14#2:84\n*S KotlinDebug\n*F\n+ 1 SudoProcessHandler.kt\ncom/intellij/profiler/sudo/SudoProcessHandler\n*L\n21#1:84\n*E\n"})
public final class SudoProcessHandler
extends OSProcessHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<String> sudoPasswordSupplier;
    @NotNull
    private final Function0<Unit> onWrongSudoPassword;
    @NotNull
    private final Function1<Integer, Unit> onCantSendSudoSignal;
    private volatile boolean wrongSudoPassword;
    private boolean consumeRest;
    @NotNull
    private static final Logger logger;

    public SudoProcessHandler(@NotNull List<String> commandWithParameters, @NotNull Function0<String> sudoPasswordSupplier, @NotNull Function0<Unit> onWrongSudoPassword, @NotNull Function1<? super Integer, Unit> onCantSendSudoSignal) {
        block0: {
            OutputStream outputStream;
            Intrinsics.checkNotNullParameter(commandWithParameters, (String)"commandWithParameters");
            Intrinsics.checkNotNullParameter(sudoPasswordSupplier, (String)"sudoPasswordSupplier");
            Intrinsics.checkNotNullParameter(onWrongSudoPassword, (String)"onWrongSudoPassword");
            Intrinsics.checkNotNullParameter(onCantSendSudoSignal, (String)"onCantSendSudoSignal");
            super(ExecSudoCommandKt.sudoCmd().withParameters(commandWithParameters));
            this.sudoPasswordSupplier = sudoPasswordSupplier;
            this.onWrongSudoPassword = onWrongSudoPassword;
            this.onCantSendSudoSignal = onCantSendSudoSignal;
            OutputStream outputStream2 = this.getProcessInput();
            if (outputStream2 == null) break block0;
            OutputStream $this$_init__u24lambda_u242 = outputStream = outputStream2;
            boolean bl = false;
            byte[] byArray = (this.sudoPasswordSupplier.invoke() + "\n").getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            $this$_init__u24lambda_u242.write(byArray);
            $this$_init__u24lambda_u242.flush();
        }
    }

    public /* synthetic */ SudoProcessHandler(List list, Function0 function0, Function0 function02, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function02 = SudoProcessHandler::_init_$lambda$0;
        }
        if ((n & 8) != 0) {
            function1 = SudoProcessHandler::_init_$lambda$1;
        }
        this(list, (Function0<String>)function0, (Function0<Unit>)function02, (Function1<? super Integer, Unit>)function1);
    }

    public final boolean getWrongSudoPassword() {
        return this.wrongSudoPassword;
    }

    public void notifyTextAvailable(@NotNull String text, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        logger.debug("sudo text available from " + outputType + ": " + text);
        if (this.consumeRest) {
            super.notifyTextAvailable(text, outputType);
            return;
        }
        if (this.wrongSudoPassword) {
            return;
        }
        if (outputType == ProcessOutputTypes.SYSTEM) {
            super.notifyTextAvailable(text, outputType);
            return;
        }
        if (ProcessOutputType.isStderr(outputType) && StringsKt.contains$default((CharSequence)text, (CharSequence)"Sorry, try again.", (boolean)false, (int)2, null)) {
            this.wrongSudoPassword = true;
            this.destroyProcess();
            this.onWrongSudoPassword.invoke();
            return;
        }
        this.consumeRest = true;
        super.notifyTextAvailable(text, outputType);
    }

    protected void doDestroyProcess() {
        if (this.wrongSudoPassword) {
            super.doDestroyProcess();
            return;
        }
        if (this.shouldDestroyProcessRecursively() && OSProcessHandler.processCanBeKilledByOS((Process)this.getProcess())) {
            Process process = this.getProcess();
            Intrinsics.checkNotNullExpressionValue((Object)process, (String)"getProcess(...)");
            this.killSudoProcessTree(process);
        } else {
            this.runSyncIfTestOtherwiseExecute((Function0<Unit>)((Function0)() -> SudoProcessHandler.doDestroyProcess$lambda$3(this)));
        }
    }

    private final void killSudoProcessTree(Process process) {
        this.runSyncIfTestOtherwiseExecute((Function0<Unit>)((Function0)() -> SudoProcessHandler.killSudoProcessTree$lambda$4(this, process)));
    }

    public final void sendSIGINT() {
        this.runSyncIfTestOtherwiseExecute((Function0<Unit>)((Function0)() -> SudoProcessHandler.sendSIGINT$lambda$5(this)));
    }

    private final void notifyIfCant(boolean result2, int signal) {
        if (!result2) {
            this.onCantSendSudoSignal.invoke((Object)signal);
        }
    }

    private final void runSyncIfTestOtherwiseExecute(Function0<Unit> body) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            body.invoke();
            v0 = Unit.INSTANCE;
        } else {
            Future future = this.executeTask(() -> SudoProcessHandler.runSyncIfTestOtherwiseExecute$lambda$6(body));
            v0 = future;
            Intrinsics.checkNotNullExpressionValue((Object)future, (String)"executeTask(...)");
        }
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(int it) {
        return Unit.INSTANCE;
    }

    private static final Unit doDestroyProcess$lambda$3(SudoProcessHandler this$0) {
        Process process = this$0.getProcess();
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"getProcess(...)");
        this$0.notifyIfCant(ExecSudoCommandKt.sudoSendSIGKILL(process, (String)this$0.sudoPasswordSupplier.invoke()) == SendResult.FAILED, 9);
        return Unit.INSTANCE;
    }

    private static final Unit killSudoProcessTree$lambda$4(SudoProcessHandler this$0, Process $process) {
        this$0.notifyIfCant(ProcessUtilKt.killSudoProcessTreeSync$default($process, (String)this$0.sudoPasswordSupplier.invoke(), 0, 4, null), 9);
        return Unit.INSTANCE;
    }

    private static final Unit sendSIGINT$lambda$5(SudoProcessHandler this$0) {
        Process process = this$0.getProcess();
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"getProcess(...)");
        this$0.notifyIfCant(ProcessUtilKt.killSudoProcessTreeSync(process, (String)this$0.sudoPasswordSupplier.invoke(), 2), 2);
        return Unit.INSTANCE;
    }

    private static final void runSyncIfTestOtherwiseExecute$lambda$6(Function0 $tmp0) {
        $tmp0.invoke();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SudoProcessHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SudoProcessHandler.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profiler/sudo/SudoProcessHandler$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

