/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.AseJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.MsBaseJdbcHelper;
import java.sql.Connection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AzureJdbcHelper
extends MsBaseJdbcHelper {
    public AzureJdbcHelper(String dbmsName, @Nullable String version, @Nullable Connection connection) {
        super(dbmsName, version, connection);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection) {
        return new AseJdbcHelper(version, connection);
    }

    public AzureJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        this("AZURE", version, connection);
    }

    public AzureJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return AzureJdbcHelper.extractVersion(version);
    }

    @NotNull
    static AzureJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) {
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        return new AzureJdbcHelper(AzureJdbcHelper.extractVersion(productVer), delegate);
    }

    @NotNull
    static AzureJdbcHelper createSynapse(@Nullable Connection delegate, @Nullable String productVer, String dbmsName) {
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        return new AzureJdbcHelper(dbmsName, AzureJdbcHelper.extractVersion(productVer), delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }
}

