/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.java.features;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.ml.inline.completion.features.autoimport.ImportFixer;
import com.intellij.ml.inline.completion.java.features.correctness.JavaCorrectnessImportClassFix;
import com.intellij.ml.inline.completion.java.features.correctness.JavaSuggestionEnricherKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J(\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J6\u0010\u0011\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010\u0018\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J.\u0010\u001d\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J.\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/inline/completion/java/features/JavaImportFixer;", "Lcom/intellij/ml/inline/completion/features/autoimport/ImportFixer;", "<init>", "()V", "fix", "", "file", "Lcom/intellij/psi/PsiFile;", "suggestionRange", "Lcom/intellij/openapi/util/TextRange;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "runAutoImport", "context", "Lcom/intellij/ml/inline/completion/features/autoimport/ImportFixer$ImportContext;", "applyFixesAndFormat", "importFixes", "", "Lcom/intellij/ml/inline/completion/java/features/correctness/JavaCorrectnessImportClassFix;", "pointer", "Lcom/intellij/psi/SmartPsiFileRange;", "format", "moveCaretBetweenBraces", "lineNumber", "", "fileDocument", "Lcom/intellij/openapi/editor/Document;", "applyImports", "myImportClassFix", "intellij.ml.inline.completion.java"})
@SourceDebugExtension(value={"SMAP\nJavaImportFixer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaImportFixer.kt\ncom/intellij/ml/inline/completion/java/features/JavaImportFixer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n3193#2,10:171\n1863#2,2:181\n1368#2:183\n1454#2,2:184\n808#2,11:186\n1557#2:197\n1628#2,3:198\n1456#2,3:201\n774#2:204\n865#2,2:205\n*S KotlinDebug\n*F\n+ 1 JavaImportFixer.kt\ncom/intellij/ml/inline/completion/java/features/JavaImportFixer\n*L\n148#1:171,10\n149#1:181,2\n161#1:183\n161#1:184,2\n164#1:186,11\n165#1:197\n165#1:198,3\n161#1:201,3\n167#1:204\n167#1:205,2\n*E\n"})
public final class JavaImportFixer
implements ImportFixer {
    @TestOnly
    public final void fix(@NotNull PsiFile file, @NotNull TextRange suggestionRange, @NotNull Project project, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)suggestionRange, (String)"suggestionRange");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        List fixes = (List)ApplicationManager.getApplication().executeOnPooledThread(() -> JavaImportFixer.fix$lambda$1(this, file, suggestionRange, project, editor)).get();
        SmartPsiFileRange smartPsiFileRange = SmartPointerManager.getInstance((Project)project).createSmartPsiFileRangePointer(file, suggestionRange);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiFileRange, (String)"createSmartPsiFileRangePointer(...)");
        SmartPsiFileRange pointer = smartPsiFileRange;
        ImportFixer.ImportContext importContext = new ImportFixer.ImportContext(null, null);
        Intrinsics.checkNotNull((Object)fixes);
        this.applyFixesAndFormat(project, editor, importContext, fixes, pointer);
    }

    @Override
    public void runAutoImport(@NotNull PsiFile file, @NotNull Editor editor, @NotNull TextRange suggestionRange, @NotNull ImportFixer.ImportContext context) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)suggestionRange, (String)"suggestionRange");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(file instanceof PsiJavaFile)) {
            return;
        }
        Project project = ((PsiJavaFile)file).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Document fileDocument = file.getViewProvider().getDocument();
        long initialStamp = fileDocument.getModificationStamp();
        SmartPsiFileRange smartPsiFileRange = SmartPointerManager.getInstance((Project)project2).createSmartPsiFileRangePointer(file, suggestionRange);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiFileRange, (String)"createSmartPsiFileRangePointer(...)");
        SmartPsiFileRange pointer = smartPsiFileRange;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.applyFixesAndFormat(project2, editor, context, CollectionsKt.emptyList(), pointer);
            return;
        }
        ReadAction.nonBlocking(() -> JavaImportFixer.runAutoImport$lambda$2(this, file, suggestionRange, project2, editor)).finishOnUiThread(ModalityState.defaultModalityState(), arg_0 -> JavaImportFixer.runAutoImport$lambda$4(arg_0 -> JavaImportFixer.runAutoImport$lambda$3(this, project2, editor, context, pointer, arg_0), arg_0)).expireWhen(() -> JavaImportFixer.runAutoImport$lambda$5(fileDocument, initialStamp)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private final void applyFixesAndFormat(Project project, Editor editor, ImportFixer.ImportContext context, List<JavaCorrectnessImportClassFix> importFixes, SmartPsiFileRange pointer) {
        PsiFile psiFile = pointer.getContainingFile();
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        CommandProcessor.getInstance().executeCommand(project, () -> JavaImportFixer.applyFixesAndFormat$lambda$6(this, project, file, editor, importFixes, pointer), context.getCommandName(), context.getCommandGroup());
    }

    private final void format(Project project, Editor editor, SmartPsiFileRange pointer) {
        ApplicationManager.getApplication().runWriteAction(() -> JavaImportFixer.format$lambda$7(pointer, project, editor, this));
    }

    private final void moveCaretBetweenBraces(Editor editor, SmartPsiFileRange pointer, int lineNumber, Document fileDocument) {
        PsiElement nextElement;
        PsiElement psiElement;
        PsiElement previousElement;
        int offset = editor.getCaretModel().getOffset();
        PsiFile psiFile = pointer.getContainingFile();
        Object element = psiFile != null ? psiFile.findElementAt(offset) : null;
        PsiElement psiElement2 = element;
        IElementType elementType = psiElement2 != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : null;
        PsiElement psiElement3 = previousElement = Intrinsics.areEqual((Object)elementType, (Object)JavaTokenType.LBRACE) ? element : PsiTreeUtil.skipWhitespacesBackward((PsiElement)element);
        if (previousElement != null) {
            previousElement = PsiTreeUtil.getDeepestLast((PsiElement)previousElement);
            ASTNode aSTNode = previousElement.getNode();
            Object object = elementType = aSTNode != null ? aSTNode.getElementType() : null;
            if (Intrinsics.areEqual((Object)elementType, (Object)JavaTokenType.RBRACE) && lineNumber != fileDocument.getLineNumber(previousElement.getTextRange().getEndOffset())) {
                ASTNode aSTNode2 = previousElement.getNode();
                elementType = aSTNode2 != null ? aSTNode2.getElementType() : null;
                PsiElement psiElement4 = previousElement = Intrinsics.areEqual((Object)elementType, (Object)JavaTokenType.LBRACE) ? previousElement : PsiTreeUtil.skipWhitespacesBackward((PsiElement)previousElement);
                if (previousElement != null) {
                    previousElement = PsiTreeUtil.getDeepestLast((PsiElement)previousElement);
                    ASTNode aSTNode3 = previousElement.getNode();
                    Object object2 = elementType = aSTNode3 != null ? aSTNode3.getElementType() : null;
                    if (Intrinsics.areEqual((Object)elementType, (Object)JavaTokenType.LBRACE) && lineNumber == fileDocument.getLineNumber(previousElement.getTextRange().getEndOffset())) {
                        TextRange textRange = previousElement.getTextRange();
                        editor.getCaretModel().moveToOffset(textRange != null ? textRange.getEndOffset() : offset);
                        return;
                    }
                }
            }
        }
        IElementType iElementType = (psiElement = (nextElement = element)) != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : (elementType = null);
        if (!Intrinsics.areEqual((Object)elementType, (Object)JavaTokenType.LBRACE)) {
            nextElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)element);
        }
        if (nextElement == null) {
            return;
        }
        nextElement = PsiTreeUtil.getDeepestFirst((PsiElement)nextElement);
        ASTNode aSTNode = nextElement.getNode();
        Object object = elementType = aSTNode != null ? aSTNode.getElementType() : null;
        if (Intrinsics.areEqual((Object)elementType, (Object)JavaTokenType.LBRACE) && lineNumber == fileDocument.getLineNumber(nextElement.getTextRange().getEndOffset())) {
            TextRange textRange = nextElement.getTextRange();
            editor.getCaretModel().moveToOffset(textRange != null ? textRange.getEndOffset() : offset);
        }
    }

    private final void applyImports(Project project, PsiFile file, Editor editor, List<JavaCorrectnessImportClassFix> importFixes) {
        block3: {
            JavaCorrectnessImportClassFix it;
            Iterable $this$partition$iv = importFixes;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                it = (JavaCorrectnessImportClassFix)((Object)element$iv);
                boolean bl = false;
                if (it.getClassesToImport(true).size() == 1) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List autoImports = (List)pair.component1();
            List ambiguousImports = (List)pair.component2();
            Iterable $this$forEach$iv = autoImports;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (JavaCorrectnessImportClassFix)((Object)element$iv);
                boolean bl = false;
                it.invoke(project, editor, file);
            }
            JavaCorrectnessImportClassFix javaCorrectnessImportClassFix = (JavaCorrectnessImportClassFix)((Object)CollectionsKt.firstOrNull((List)ambiguousImports));
            if (javaCorrectnessImportClassFix == null) break block3;
            javaCorrectnessImportClassFix.invoke(project, editor, file);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<JavaCorrectnessImportClassFix> myImportClassFix(PsiFile file, TextRange suggestionRange, Project project, Editor editor) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$flatMapTo$iv$iv;
        List<PsiElement> targetElements = JavaSuggestionEnricherKt.findTargetElements(file, suggestionRange);
        Iterable $this$flatMap$iv = targetElements;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            PsiElement element = (PsiElement)element$iv$iv;
            boolean bl = false;
            SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)file)).onRange(JavaSuggestionEnricherKt.createExtendedTextRange(suggestionRange, file));
            Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"onRange(...)");
            Iterable iterable2 = (Iterable)syntaxTraverser;
            boolean $i$f$filterIsInstance = false;
            void var17_17 = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv2 instanceof PsiJavaCodeReferenceElement)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = (PsiJavaCodeReferenceElement)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(new JavaCorrectnessImportClassFix((PsiJavaCodeReferenceElement)it));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JavaCorrectnessImportClassFix it = (JavaCorrectnessImportClassFix)((Object)element$iv$iv);
            boolean bl = false;
            if (!it.isAvailable(project, editor, file)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List fix$lambda$1$lambda$0(JavaImportFixer this$0, PsiFile $file, TextRange $suggestionRange, Project $project, Editor $editor) {
        return this$0.myImportClassFix($file, $suggestionRange, $project, $editor);
    }

    private static final List fix$lambda$1(JavaImportFixer this$0, PsiFile $file, TextRange $suggestionRange, Project $project, Editor $editor) {
        return (List)ReadAction.compute(() -> JavaImportFixer.fix$lambda$1$lambda$0(this$0, $file, $suggestionRange, $project, $editor));
    }

    private static final List runAutoImport$lambda$2(JavaImportFixer this$0, PsiFile $file, TextRange $suggestionRange, Project $project, Editor $editor) {
        return this$0.myImportClassFix($file, $suggestionRange, $project, $editor);
    }

    private static final Unit runAutoImport$lambda$3(JavaImportFixer this$0, Project $project, Editor $editor, ImportFixer.ImportContext $context, SmartPsiFileRange $pointer, List fixes) {
        Intrinsics.checkNotNullParameter((Object)fixes, (String)"fixes");
        this$0.applyFixesAndFormat($project, $editor, $context, fixes, $pointer);
        return Unit.INSTANCE;
    }

    private static final void runAutoImport$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean runAutoImport$lambda$5(Document $fileDocument, long $initialStamp) {
        return $fileDocument.getModificationStamp() != $initialStamp;
    }

    private static final void applyFixesAndFormat$lambda$6(JavaImportFixer this$0, Project $project, PsiFile $file, Editor $editor, List $importFixes, SmartPsiFileRange $pointer) {
        this$0.applyImports($project, $file, $editor, $importFixes);
        this$0.format($project, $editor, $pointer);
    }

    private static final void format$lambda$7(SmartPsiFileRange $pointer, Project $project, Editor $editor, JavaImportFixer this$0) {
        PsiFile psiFile = $pointer.getContainingFile();
        if (psiFile == null || (psiFile = psiFile.getFileDocument()) == null) {
            return;
        }
        PsiFile fileDocument = psiFile;
        PsiDocumentManager.getInstance((Project)$project).commitDocument((Document)fileDocument);
        PsiFile psiFile2 = $pointer.getContainingFile();
        if (psiFile2 == null) {
            return;
        }
        PsiFile file = psiFile2;
        int lineNumber = fileDocument.getLineNumber($editor.getCaretModel().getOffset());
        Segment segment = $pointer.getRange();
        if (segment == null) {
            return;
        }
        Segment segment2 = segment;
        List<PsiElement> psiElements = JavaSuggestionEnricherKt.findTargetElements(file, new TextRange(segment2.getStartOffset(), segment2.getEndOffset()));
        CommonCodeStyleSettings commonCodeStyleSettings = CodeStyle.getSettings((Project)$project).getCommonSettings((Language)JavaLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)commonCodeStyleSettings, (String)"getCommonSettings(...)");
        CommonCodeStyleSettings commonSettings = commonCodeStyleSettings;
        for (PsiElement psiElement : psiElements) {
            if (!Registry.Companion.is("full.line.java.force.format") && (commonSettings.CLASS_BRACE_STYLE == 1 || !(psiElement instanceof PsiClass)) && (commonSettings.METHOD_BRACE_STYLE == 1 || !(psiElement instanceof PsiMethod))) continue;
            CodeStyleManager.getInstance((Project)$project).reformat(psiElement);
        }
        this$0.moveCaretBetweenBraces($editor, $pointer, lineNumber, (Document)fileDocument);
    }
}

