/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.chunks;

import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.OutputPngStream;
import org.jetbrains.letsPlot.util.pngj.PngjExceptionInternal;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkHelper;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkRaw;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000 :2\u00020\u0001:\u00029:B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010+\u001a\u00020\u000eH&J\u0018\u0010,\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010-\u001a\u00020\u000eH\u0004J\b\u0010.\u001a\u00020$H&J\u0006\u0010/\u001a\u00020\u000eJ\u0006\u00100\u001a\u000201J\u0010\u00102\u001a\u0002012\u0006\u00103\u001a\u00020$H&J\u000e\u00104\u001a\u0002012\u0006\u0010 \u001a\u00020\u000eJ\b\u00105\u001a\u00020\u0003H\u0016J\u000e\u00106\u001a\u0002012\u0006\u00107\u001a\u000208R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00058DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\nR\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0010R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0010\u00a8\u0006;"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk;", "", "id", "", "imageInfo", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "(Ljava/lang/String;Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;)V", "chunkGroup", "", "getChunkGroup", "()I", "setChunkGroup", "(I)V", "crit", "", "getCrit", "()Z", "getId", "()Ljava/lang/String;", "imgInfo", "getImgInfo", "()Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "len", "getLen", "offset", "", "getOffset", "()J", "orderingConstraint", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "getOrderingConstraint", "()Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "priority", "pub", "getPub", "raw", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkRaw;", "getRaw", "()Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkRaw;", "setRaw", "(Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkRaw;)V", "safe", "getSafe", "allowsMultiple", "createEmptyChunk", "alloc", "createRawChunk", "hasPriority", "invalidateRawData", "", "parseFromRaw", "chunk", "setPriority", "toString", "write", "os", "Lorg/jetbrains/letsPlot/util/pngj/OutputPngStream;", "ChunkOrderingConstraint", "Companion", "plot-api"})
public abstract class PngChunk {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @Nullable
    private final ImageInfo imageInfo;
    private final boolean crit;
    private final boolean pub;
    private final boolean safe;
    @Nullable
    private ChunkRaw raw;
    private boolean priority;
    private int chunkGroup;
    @NotNull
    public static final String ID_FDAT = "fdAT";
    @NotNull
    public static final String ID_FCTL = "fcTL";

    public PngChunk(@NotNull String id, @Nullable ImageInfo imageInfo) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
        this.imageInfo = imageInfo;
        this.chunkGroup = -1;
        this.crit = ChunkHelper.INSTANCE.isCritical(this.id);
        this.pub = ChunkHelper.INSTANCE.isPublic(this.id);
        this.safe = ChunkHelper.INSTANCE.isSafeToCopy(this.id);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final boolean getCrit() {
        return this.crit;
    }

    public final boolean getPub() {
        return this.pub;
    }

    public final boolean getSafe() {
        return this.safe;
    }

    @NotNull
    protected final ImageInfo getImgInfo() {
        ImageInfo imageInfo = this.imageInfo;
        Intrinsics.checkNotNull((Object)imageInfo);
        return imageInfo;
    }

    @Nullable
    public final ChunkRaw getRaw() {
        return this.raw;
    }

    public final void setRaw(@Nullable ChunkRaw chunkRaw) {
        this.raw = chunkRaw;
    }

    public final int getChunkGroup() {
        return this.chunkGroup;
    }

    public final void setChunkGroup(int n) {
        this.chunkGroup = n;
    }

    @NotNull
    protected final ChunkRaw createEmptyChunk(int len, boolean alloc) {
        return new ChunkRaw(len, ChunkHelper.INSTANCE.toBytesLatin1(this.id), alloc);
    }

    public final boolean hasPriority() {
        return this.priority;
    }

    public final void setPriority(boolean priority) {
        this.priority = priority;
    }

    public final void write(@NotNull OutputPngStream os) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)os, (String)"os");
                if (this.raw == null) break block4;
                ChunkRaw chunkRaw = this.raw;
                if ((byte[])(chunkRaw != null ? chunkRaw.getData() : null) != null) break block5;
            }
            this.raw = this.createRawChunk();
        }
        if (this.raw == null) {
            throw new PngjExceptionInternal("null chunk ! creation failed for " + this);
        }
        ChunkRaw chunkRaw = this.raw;
        Intrinsics.checkNotNull((Object)chunkRaw);
        chunkRaw.writeChunk(os);
    }

    @NotNull
    public abstract ChunkRaw createRawChunk();

    public abstract void parseFromRaw(@NotNull ChunkRaw var1);

    public abstract boolean allowsMultiple();

    public final int getLen() {
        ChunkRaw chunkRaw = this.raw;
        return chunkRaw != null ? chunkRaw.getLen() : -1;
    }

    public final long getOffset() {
        ChunkRaw chunkRaw = this.raw;
        return chunkRaw != null ? chunkRaw.getOffset() : -1L;
    }

    public final void invalidateRawData() {
        this.raw = null;
    }

    @NotNull
    public abstract ChunkOrderingConstraint getOrderingConstraint();

    @NotNull
    public String toString() {
        return "chunk id= " + this.id + " (len=" + this.getLen() + " offset=" + this.getOffset() + ')';
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u0006\u0010\b\u001a\u00020\u0004J\u0006\u0010\t\u001a\u00020\u0004J\u0006\u0010\n\u001a\u00020\u0004J\u0006\u0010\u000b\u001a\u00020\u0004j\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "", "(Ljava/lang/String;I)V", "isOk", "", "currentChunkGroup", "", "hasplte", "mustGoAfterIDAT", "mustGoAfterPLTE", "mustGoBeforeIDAT", "mustGoBeforePLTE", "NONE", "BEFORE_PLTE_AND_IDAT", "AFTER_PLTE_BEFORE_IDAT", "AFTER_PLTE_BEFORE_IDAT_PLTE_REQUIRED", "BEFORE_IDAT", "AFTER_IDAT", "NA", "plot-api"})
    public static final class ChunkOrderingConstraint
    extends Enum<ChunkOrderingConstraint> {
        public static final /* enum */ ChunkOrderingConstraint NONE = new ChunkOrderingConstraint();
        public static final /* enum */ ChunkOrderingConstraint BEFORE_PLTE_AND_IDAT = new ChunkOrderingConstraint();
        public static final /* enum */ ChunkOrderingConstraint AFTER_PLTE_BEFORE_IDAT = new ChunkOrderingConstraint();
        public static final /* enum */ ChunkOrderingConstraint AFTER_PLTE_BEFORE_IDAT_PLTE_REQUIRED = new ChunkOrderingConstraint();
        public static final /* enum */ ChunkOrderingConstraint BEFORE_IDAT = new ChunkOrderingConstraint();
        public static final /* enum */ ChunkOrderingConstraint AFTER_IDAT = new ChunkOrderingConstraint();
        public static final /* enum */ ChunkOrderingConstraint NA = new ChunkOrderingConstraint();
        private static final /* synthetic */ ChunkOrderingConstraint[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public final boolean mustGoBeforePLTE() {
            return this == BEFORE_PLTE_AND_IDAT;
        }

        public final boolean mustGoBeforeIDAT() {
            return this == BEFORE_IDAT || this == BEFORE_PLTE_AND_IDAT || this == AFTER_PLTE_BEFORE_IDAT;
        }

        public final boolean mustGoAfterPLTE() {
            return this == AFTER_PLTE_BEFORE_IDAT || this == AFTER_PLTE_BEFORE_IDAT_PLTE_REQUIRED;
        }

        public final boolean mustGoAfterIDAT() {
            return this == AFTER_IDAT;
        }

        public final boolean isOk(int currentChunkGroup, boolean hasplte) {
            if (this == NONE) {
                return true;
            }
            if (this == BEFORE_IDAT) {
                return currentChunkGroup < 4;
            }
            if (this == BEFORE_PLTE_AND_IDAT) {
                return currentChunkGroup < 2;
            }
            if (this == AFTER_PLTE_BEFORE_IDAT) {
                return hasplte ? currentChunkGroup < 4 : currentChunkGroup < 4 && currentChunkGroup > 2;
            }
            if (this == AFTER_IDAT) {
                return currentChunkGroup > 4;
            }
            return false;
        }

        public static ChunkOrderingConstraint[] values() {
            return (ChunkOrderingConstraint[])$VALUES.clone();
        }

        public static ChunkOrderingConstraint valueOf(String value2) {
            return Enum.valueOf(ChunkOrderingConstraint.class, value2);
        }

        @NotNull
        public static EnumEntries<ChunkOrderingConstraint> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = chunkOrderingConstraintArray = new ChunkOrderingConstraint[]{ChunkOrderingConstraint.NONE, ChunkOrderingConstraint.BEFORE_PLTE_AND_IDAT, ChunkOrderingConstraint.AFTER_PLTE_BEFORE_IDAT, ChunkOrderingConstraint.AFTER_PLTE_BEFORE_IDAT_PLTE_REQUIRED, ChunkOrderingConstraint.BEFORE_IDAT, ChunkOrderingConstraint.AFTER_IDAT, ChunkOrderingConstraint.NA};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$Companion;", "", "()V", "ID_FCTL", "", "ID_FDAT", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

