/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.util.Hashtable;
import org.apache.xmlrpc.AuthenticatedXmlRpcHandler;
import org.apache.xmlrpc.ContextXmlRpcHandler;
import org.apache.xmlrpc.Invoker;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.XmlRpcHandlerMapping;

public class DefaultHandlerMapping
implements XmlRpcHandlerMapping {
    private Hashtable handlers = new Hashtable();

    public void addHandler(String handlerName, Object handler2) {
        if (handler2 instanceof XmlRpcHandler || handler2 instanceof AuthenticatedXmlRpcHandler || handler2 instanceof ContextXmlRpcHandler) {
            this.handlers.put(handlerName, handler2);
        } else if (handler2 != null) {
            this.handlers.put(handlerName, new Invoker(handler2));
        }
    }

    public void removeHandler(String handlerName) {
        this.handlers.remove(handlerName);
    }

    public Object getHandler(String methodName) throws Exception {
        Object handler2 = null;
        String handlerName = null;
        int dot = methodName.lastIndexOf(46);
        if (dot > -1) {
            handlerName = methodName.substring(0, dot);
            handler2 = this.handlers.get(handlerName);
        }
        if (handler2 == null && (handler2 = this.handlers.get("$default")) == null) {
            if (dot > -1) {
                throw new Exception("RPC handler object \"" + handlerName + "\" not found and no " + "default handler registered");
            }
            throw new Exception("RPC handler object not found for \"" + methodName + "\": No default handler registered");
        }
        return handler2;
    }
}

