/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.figures.interactive;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.scientific.PyScientificBundle;
import com.intellij.python.scientific.figures.interactive.BasicCefDownloadHandler;
import com.intellij.python.scientific.figures.interactive.InteractiveFigureVirtualFile;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.cef.handler.CefDownloadHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u0016H\u0016J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020$H\u0016J\u0010\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006+"}, d2={"Lcom/intellij/python/scientific/figures/interactive/InteractiveFileEditor;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "project", "Lcom/intellij/openapi/project/Project;", "previewFile", "Lcom/intellij/python/scientific/figures/interactive/InteractiveFigureVirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/python/scientific/figures/interactive/InteractiveFigureVirtualFile;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "myCefBrowser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "panel", "Ljavax/swing/JPanel;", "mpld3DrawFigureCallRegex", "Lkotlin/text/Regex;", "getMpld3DrawFigureCallRegex", "()Lkotlin/text/Regex;", "mpld3DrawFigureCallRegex$delegate", "Lkotlin/Lazy;", "processMpld3", "", "data", "dispose", "", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "getName", "setState", "state", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "isModified", "", "isValid", "addPropertyChangeListener", "listener", "Ljava/beans/PropertyChangeListener;", "removePropertyChangeListener", "Companion", "intellij.python.scientific"})
@SourceDebugExtension(value={"SMAP\nInteractiveFileEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InteractiveFileEditor.kt\ncom/intellij/python/scientific/figures/interactive/InteractiveFileEditor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1317#2:95\n1318#2:97\n1#3:96\n*S KotlinDebug\n*F\n+ 1 InteractiveFileEditor.kt\ncom/intellij/python/scientific/figures/interactive/InteractiveFileEditor\n*L\n50#1:95\n50#1:97\n*E\n"})
public final class InteractiveFileEditor
extends UserDataHolderBase
implements FileEditor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final InteractiveFigureVirtualFile previewFile;
    @NotNull
    private final JBCefBrowser myCefBrowser;
    @NotNull
    private final JPanel panel;
    @NotNull
    private final Lazy mpld3DrawFigureCallRegex$delegate;
    @NotNull
    private static final Lazy<String> mpld3PatcherJs$delegate = LazyKt.lazy(InteractiveFileEditor::mpld3PatcherJs_delegate$lambda$4);

    public InteractiveFileEditor(@NotNull Project project, @NotNull InteractiveFigureVirtualFile previewFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)previewFile), (String)"previewFile");
        this.project = project;
        this.previewFile = previewFile;
        JBCefBrowser jBCefBrowser = JBCefBrowser.createBuilder().setUrl("about:blank").setClient(JBCefApp.getInstance().createClient()).setEnableOpenDevToolsMenuItem(false).build();
        Intrinsics.checkNotNullExpressionValue((Object)jBCefBrowser, (String)"build(...)");
        this.myCefBrowser = jBCefBrowser;
        this.panel = new JPanel(new BorderLayout());
        this.mpld3DrawFigureCallRegex$delegate = LazyKt.lazy(InteractiveFileEditor::mpld3DrawFigureCallRegex_delegate$lambda$0);
        this.myCefBrowser.getCefBrowser().getClient().addDownloadHandler((CefDownloadHandler)new BasicCefDownloadHandler(this.project));
        this.myCefBrowser.setPageBackgroundColor("white");
        String string = VfsUtil.loadText((VirtualFile)this.getFile());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadText(...)");
        this.myCefBrowser.loadHTML(this.processMpld3(string));
        this.panel.add((Component)this.myCefBrowser.getComponent(), "Center");
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final Regex getMpld3DrawFigureCallRegex() {
        Lazy lazy = this.mpld3DrawFigureCallRegex$delegate;
        return (Regex)lazy.getValue();
    }

    private final String processMpld3(String data) {
        if (!StringsKt.contains$default((CharSequence)data, (CharSequence)"mpld3_load_lib", (boolean)false, (int)2, null)) {
            return data;
        }
        String withZoomByDefaultEnabled = StringsKt.replace$default((String)data, (String)"{\"type\": \"zoom\", \"button\": true, \"enabled\": false}", (String)"{\"type\": \"zoom\", \"button\": true, \"enabled\": true}", (boolean)false, (int)4, null);
        List endIndexes = new ArrayList();
        Sequence $this$forEach$iv = SequencesKt.flatMapIterable((Sequence)Regex.findAll$default((Regex)this.getMpld3DrawFigureCallRegex(), (CharSequence)withZoomByDefaultEnabled, (int)0, (int)2, null), InteractiveFileEditor::processMpld3$lambda$1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchGroup it;
            MatchGroup it2 = (MatchGroup)element$iv;
            boolean bl = false;
            if (it2 == null) continue;
            boolean bl2 = false;
            endIndexes.add(it.getRange().getLast());
        }
        StringBuilder stringBuilder = new StringBuilder("<script>" + Companion.getMpld3PatcherJs() + "</script>");
        int lastPos = 0;
        Iterator iterator2 = endIndexes.iterator();
        while (iterator2.hasNext()) {
            int value2 = ((Number)iterator2.next()).intValue();
            String string = withZoomByDefaultEnabled.substring(lastPos, value2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            stringBuilder.append(string);
            stringBuilder.append("\nwindow.__IntelliJTools.patchWrongSizedMpld3Svg();");
            lastPos = value2;
        }
        String string = withZoomByDefaultEnabled.substring(lastPos);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        stringBuilder.append(string);
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    public void dispose() {
        Disposer.dispose((Disposable)((Disposable)this.myCefBrowser));
    }

    @NotNull
    public VirtualFile getFile() {
        return (VirtualFile)this.previewFile;
    }

    @NotNull
    public JComponent getComponent() {
        return this.panel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        String string = PyScientificBundle.message("python.sci.view.interactive.plots.editor.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void setState(@NotNull FileEditorState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    private static final Regex mpld3DrawFigureCallRegex_delegate$lambda$0() {
        return new Regex("mpld3.draw_figure.*[\\r\\n]");
    }

    private static final Iterable processMpld3$lambda$1(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Iterable)it.getGroups();
    }

    private static final String mpld3PatcherJs_delegate$lambda$4() {
        String string;
        InputStream inputStream = Companion.getClass().getResourceAsStream("mpld3patcher.js");
        if (inputStream != null) {
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            string = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
        } else {
            string = null;
        }
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u0004\u0018\u00010\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/python/scientific/figures/interactive/InteractiveFileEditor$Companion;", "", "<init>", "()V", "mpld3PatcherJs", "", "getMpld3PatcherJs", "()Ljava/lang/String;", "mpld3PatcherJs$delegate", "Lkotlin/Lazy;", "intellij.python.scientific"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getMpld3PatcherJs() {
            Lazy lazy = mpld3PatcherJs$delegate;
            return (String)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

