/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific;

import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.python.scientific.DisplayMessageHandler;
import com.intellij.python.scientific.PySciProjectComponent;
import com.intellij.python.scientific.figures.DisplayMessage;
import com.intellij.python.scientific.figures.DisplayMessageKt;
import com.intellij.python.scientific.figures.Figure;
import com.intellij.python.scientific.figures.PlotsBackend;
import com.intellij.python.scientific.figures.base.FigureBase;
import com.intellij.python.scientific.figures.display.DisplayMessageHandlerEP;
import com.intellij.python.scientific.figures.display.PlotsType;
import com.intellij.python.scientific.statistics.PyPlotsCollector;
import com.intellij.python.scientific.ui.PyPlotToolWindow;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.ide.RestService;
import org.jetbrains.io.NettyUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0014J\"\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\u001aH\u0014\u00a8\u0006\u001b"}, d2={"Lcom/intellij/python/scientific/PySciRestService;", "Lorg/jetbrains/ide/RestService;", "<init>", "()V", "getServiceName", "", "isMethodSupported", "", "method", "Lio/netty/handler/codec/http/HttpMethod;", "isSupported", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "getMaxRequestsPerMinute", "", "execute", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "showFigure", "", "project", "Lcom/intellij/openapi/project/Project;", "isOriginAllowed", "Lorg/jetbrains/ide/HttpRequestHandler$OriginCheckResult;", "Lio/netty/handler/codec/http/HttpRequest;", "intellij.python.scientific"})
@SourceDebugExtension(value={"SMAP\nPySciRestService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PySciRestService.kt\ncom/intellij/python/scientific/PySciRestService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1310#2,2:90\n24#3:92\n295#4,2:93\n*S KotlinDebug\n*F\n+ 1 PySciRestService.kt\ncom/intellij/python/scientific/PySciRestService\n*L\n53#1:90,2\n70#1:92\n75#1:93,2\n*E\n"})
public final class PySciRestService
extends RestService {
    @NotNull
    protected String getServiceName() {
        return "python.scientific";
    }

    protected boolean isMethodSupported(@NotNull HttpMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return method == HttpMethod.POST;
    }

    public boolean isSupported(@NotNull FullHttpRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        FullHttpRequest fullHttpRequest = NettyUtil.ensureRequestUriIsRelative((FullHttpRequest)request2);
        Intrinsics.checkNotNullExpressionValue((Object)fullHttpRequest, (String)"ensureRequestUriIsRelative(...)");
        return super.isSupported(fullHttpRequest);
    }

    protected int getMaxRequestsPerMinute() {
        return Integer.MAX_VALUE;
    }

    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request2, @NotNull ChannelHandlerContext context) {
        Object object;
        block3: {
            String token;
            Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
            Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Map parameters2 = new QueryStringDecoder(request2.uri()).parameters();
            List list2 = (List)parameters2.get("token");
            String string = token = list2 != null ? (String)CollectionsKt.firstOrNull((List)list2) : null;
            if (!Intrinsics.areEqual((Object)token, (Object)PlotsBackend.GENERATED_UUID)) {
                RestService.Companion.sendOk(request2, context);
                RestService.LOG.error("Wrong auth token. Someone try to request Pycharm externally! " + request2);
                throw new IllegalStateException(("Wrong auth token. Someone try to request Pycharm externally! " + request2).toString());
            }
            List list3 = (List)parameters2.get("project");
            String projectHash = list3 != null ? (String)CollectionsKt.firstOrNull((List)list3) : null;
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            Object[] $this$firstOrNull$iv = projectArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Project it = (Project)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getLocationHash(), (Object)projectHash)) continue;
                object = element$iv;
                break block3;
            }
            object = null;
        }
        Project project = (Project)object;
        if (project == null) {
            RestService.LOG.error("Failed to find opened project");
            RestService.Companion.sendOk(request2, context);
            return null;
        }
        this.showFigure(request2, project);
        RestService.Companion.sendOk(request2, context);
        return null;
    }

    private final void showFigure(FullHttpRequest request2, Project project) {
        PlotsType plotsType;
        Object v2;
        FigureBase figure;
        block4: {
            JsonReader reader = RestService.Companion.createJsonReader(request2);
            DisplayMessage displayMessage = DisplayMessageKt.parse(reader);
            JsonObject messageBody = displayMessage.getBody();
            DisplayMessageHandler displayMessageHandler = DisplayMessageHandlerEP.INSTANCE.getHandler(displayMessage.getType());
            if (displayMessageHandler == null) {
                PySciRestService it = this;
                boolean bl = false;
                PySciRestService $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger2 = Logger.getInstance(PySciRestService.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                logger2.warn("Couldn't find handler for display message type '" + displayMessage + ".type'");
                return;
            }
            DisplayMessageHandler displayMessageHandler2 = displayMessageHandler;
            Figure figure2 = displayMessageHandler2.createFigure(messageBody, project);
            figure = figure2 instanceof FigureBase ? (FigureBase)figure2 : null;
            String applicableMessageType = displayMessageHandler2.getApplicableMessageType();
            Iterable $this$firstOrNull$iv = (Iterable)PlotsType.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PlotsType it = (PlotsType)((Object)element$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)applicableMessageType)) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        if ((plotsType = (PlotsType)v2) == null) {
            plotsType = PlotsType.OTHER;
        }
        PlotsType plotsType2 = plotsType;
        PyPlotsCollector.INSTANCE.onPlotAdded(figure != null, plotsType2);
        if (figure != null) {
            ApplicationManager.getApplication().invokeLater(() -> PySciRestService.showFigure$lambda$3(project, figure));
        }
    }

    @NotNull
    protected HttpRequestHandler.OriginCheckResult isOriginAllowed(@NotNull HttpRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Project project = RestService.Companion.getLastFocusedOrOpenedProject();
        if (project == null) {
            return HttpRequestHandler.OriginCheckResult.FORBID;
        }
        Project project2 = project;
        return PySciProjectComponent.getInstance(project2).isMatplotlibInToolwindow() ? HttpRequestHandler.OriginCheckResult.ALLOW : HttpRequestHandler.OriginCheckResult.FORBID;
    }

    private static final void showFigure$lambda$3(Project $project, FigureBase $figure) {
        PyPlotToolWindow.Companion.getInstance($project).addFigure($figure);
        PyPlotToolWindow.Companion.getInstance($project).focusLastFigure();
    }
}

