/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pyramid.templates.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.XmlAttributeInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.python.pyramid.templates.ChameleonLanguage;
import com.intellij.python.pyramid.templates.file.ChameleonFileViewProvider;
import com.intellij.python.pyramid.templates.lexer.ChameleonTokenTypes;
import com.intellij.python.pyramid.templates.psi.ChameleonAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ChameleonNamespaceCompletionContributor
extends CompletionContributor
implements DumbAware {
    @NonNls
    private static final String[] PREDEFINED_ELEMENTS = new String[]{"tal:define", "tal:switch", "tal:condition", "tal:repeat", "tal:case", "tal:content", "tal:replace", "tal:omit-tag", "tal:attributes", "tal:on-error", "metal:define-macro", "metal:use-macro", "metal:use-macro", "metal:extend-macro", "metal:define-slot", "metal:fill-slot", "i18n:translate", "i18n:domain", "i18n:source", "i18n:target", "i18n:name", "i18n:attributes", "i18n:data"};
    @NonNls
    private static final String PYTHON_TAG = "<?python";
    public static final Set<String> PREDEFINED = new HashSet<String>();
    private static final int KEYWORD_PRIORITY = 1;

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        PsiFile file;
        FileViewProvider provider;
        if (parameters2 == null) {
            ChameleonNamespaceCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            ChameleonNamespaceCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((provider = (file = parameters2.getOriginalFile()).getViewProvider()) instanceof ChameleonFileViewProvider) {
            PsiElement chameleonElement = provider.findElementAt(parameters2.getOffset() - 1, ChameleonLanguage.class);
            PsiElement xmlElement = provider.findElementAt(parameters2.getOffset() - 1, XMLLanguage.class);
            PsiElement xmlAnchor = PsiTreeUtil.getParentOfType((PsiElement)xmlElement, (Class[])new Class[]{XmlAttribute.class, XmlTag.class, ChameleonAttribute.class});
            int offset2 = parameters2.getOffset();
            result2 = result2.withPrefixMatcher(ChameleonNamespaceCompletionContributor.getPrefix(offset2, file));
            if (!(chameleonElement != null && chameleonElement.getNode().getElementType() != ChameleonTokenTypes.TEMPLATE_CHARACTERS || xmlElement != null && !(xmlElement.getParent() instanceof XmlText) && xmlElement.getNode().getElementType() != XmlTokenType.XML_PI_TARGET)) {
                ChameleonNamespaceCompletionContributor.addPythonOpenTag(result2);
            }
            if (chameleonElement != null) {
                IElementType elementType = chameleonElement.getNode().getElementType();
                if (xmlAnchor == null) {
                    PsiElement psiElement = xmlAnchor = elementType == ChameleonTokenTypes.TEMPLATE_CHARACTERS ? chameleonElement.getPrevSibling() : chameleonElement.getParent();
                }
            }
            if (xmlAnchor instanceof XmlTag || xmlAnchor instanceof XmlAttribute || xmlAnchor instanceof ChameleonAttribute) {
                for (String tag : PREDEFINED) {
                    result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)tag).withInsertHandler((InsertHandler)new XmlAttributeInsertHandler()), (double)1.0));
                }
            }
        }
    }

    private static void addPythonOpenTag(CompletionResultSet result2) {
        result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)PYTHON_TAG), (double)1.0));
    }

    private static String getPrefix(int offset2, PsiFile file) {
        if (offset2 > 0) {
            --offset2;
        }
        String text2 = file.getText();
        StringBuilder prefixBuilder = new StringBuilder();
        while (offset2 > 0 && (text2.charAt(offset2) == ':' || text2.charAt(offset2) == '-' || text2.charAt(offset2) == '?' || text2.charAt(offset2) == '<' || Character.isLetterOrDigit(text2.charAt(offset2)))) {
            prefixBuilder.insert(0, text2.charAt(offset2));
            --offset2;
        }
        return prefixBuilder.toString();
    }

    static {
        PREDEFINED.addAll(Arrays.asList(PREDEFINED_ELEMENTS));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/python/pyramid/templates/completion/ChameleonNamespaceCompletionContributor";
        objectArray[2] = "fillCompletionVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

